UNIT FuncSrvr;
{ ͻ }
{  FUNCSRVR.PAS - Function server routines      Last changed: 20.04.96  SA  }
{                                                                           }
{  (C) Copyright 1989-92 by D. Wulff & S. Ager                              }
{                                                                           }
{  This source may not be given to anybody, without the written permission  }
{  from The Portal Team.                                                    }
{ ͼ }
{ͻ}
{                                                                          }
{                        (C) Copyright 1998-2000 by                        }
{                          The German Portal Team                          }
{          Carsten Brandt, Michael Kleefeld and Marcus Roeckrath           }
{                                                                          }
{                                                                          }
{ Changes made                                                             }
{                                                                          }
{ By                : Marcus Roeckrath                                     }
{ First Modification: 11 May 1999                                          }
{ Last Modification : 11 May 1999                                          }
{                                                                          }
{ Look at HISTORY.TXT for exact information about all changes made to      }
{ the original P063B9 source!                                              }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32;

CONST
  fsForwardFiles     = 1;
  fsCompileNodelist  = 2;
  fsProcessTicks     = 3;
  fsExit             = 4;

PROCEDURE RequestFunction(w:WORD);
PROCEDURE InitFunctionServer;
PROCEDURE FunctionServer;
PROCEDURE FinishFunctionServer;   { <--- HVORFOR BLIVER DEN IKKE KALDT }

IMPLEMENTATION

USES APTimer,
     Globals, NetFile, MTask, FileFwd, NLComp, Tick, Util;

TYPE
  FunctionServerType=RECORD
    f    : TNetFile;
    t    : EventTimer;
  END;
VAR
  Fs:^FunctionServerType;

PROCEDURE RequestFunction(w:WORD);
BEGIN
  IF Fs=NIL THEN InitFunctionServer;
  Fs^.f.Lock(0,wait);
  Fs^.f.SEEK(Fs^.f.FILESIZE);
  Fs^.f.WRITE(w);
  Fs^.f.Unlock(0);
END;

PROCEDURE InitFunctionServer;
BEGIN
  IF Fs=NIL THEN
  BEGIN
    NEW(Fs);
    Fs^.f.Open(StartPath+'PORTAL.FRQ',2,TRUE);
    NewTimerSecs(Fs^.t,15);
  END;
END;

PROCEDURE FunctionServer;
VAR
  Buf:ARRAY[1..256] OF WORD;
  Action,i,Num:WORD;
  sp:LONGINT;
BEGIN
  IF Fs=NIL THEN InitFunctionServer;
  IF TimerExpired(Fs^.t) THEN
  BEGIN
    IF Fs^.f.FileSize>0 THEN
    BEGIN
      Fs^.f.Lock(0,Wait);
      Fs^.f.SEEK(0);
      Action:=0;
      WHILE (NOT Fs^.f.EOF) DO
      BEGIN
        sp:=Fs^.f.FILEPOS;
        Fs^.f.BLOCKREADNum(Buf,256,Num);
        FOR i:=1 TO Num DO
          IF Buf[i]<>0 THEN
          BEGIN
            IF Action=0 THEN Action:=Buf[i];
            IF Buf[i]=Action THEN Buf[i]:=0;
          END;
        Fs^.f.SEEK(sp);
        Fs^.f.BLOCKWRITE(Buf,Num);
      END;
      IF Action=0 THEN
      BEGIN
        Fs^.f.SEEK(0);
        Fs^.f.TRUNCATE;
      END;
      Fs^.f.Unlock(0);
      CASE Lo(Action) OF
        fsForwardFiles    : ForwardFiles(False);
        fsCompileNodelist : CompileNodelist(FALSE);
        fsProcessTicks    : ProcessTicks;
        fsExit            : SpawnWithErrorLevel(Hi(Action),'Exit', True, TRUE);
      END;
    END;
    NewTimerSecs(Fs^.t,15);
  END ELSE
    GiveUpTime;
END;

PROCEDURE FinishFunctionServer;
BEGIN
  IF Fs<>NIL THEN
  BEGIN
    Fs^.f.Close;
    DISPOSE(Fs);
    Fs:=NIL;
  END;
END;

BEGIN
  Fs:=NIL;
END.
