#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <signal.h>
#include <io.h>
#if defined(__OS2__) || defined(__MSDOS__)
#include <stdlib.h>
#include <process.h>
#include <sys\stat.h>
#include <dos.h>
#elif defined(__TOS__)
#include <osbind.h>
#include "stat.h"
#endif
#include "2types.h"
#include "request.h"


#define PRGNAME "Xenia ReqComp"
#if defined(__OS2__)
#define VERSION "1.98.04+ OS/2"
#elif defined(__MSDOS__)
#define VERSION "1.98.04+ DOS"
#elif defined(__TOS__)
#define VERSION "1.98.04+ ST"
#else
#error Unknown platform!
#endif

#define BREAD	"r+b"
#define BWRITE	"w+b"

void  prepfname (char *dst, char *src);
char *ffirst	(char *filespec);
char *fnext	(void);
void  fnclose	(void);
void  getfinfo	(struct stat *statbuf);
char *strip	(char *s);
void  splitpath (char *filepath, char *path, char *file);
void  mergepath (char *filepath, char *path, char *file);

char *reqcfgname = "REQUEST.CFG";
char *reqidxname = "REQUEST.IDX";
char *reqdirname = "REQUEST.DIR";
char *reqidxtemp = "REQUEST.I$$";
char *reqdirtemp = "REQUEST.D$$";


#define MAXLINE 256

char	buffer[MAXLINE+1], work[MAXLINE+1];
char	rsp_buffer[MAXLINE+1];
FILE   *dirfp;
int	verbose = 0;
int	do_break = 0;


/* ------------------------------------------------------------------------- */
char *stripdir (char *s)			/* Strip possible trailing \ */
{
	register int len;

	len = (int) strlen(s);
	if (len && s[len - 1] == '\\')
	   s[len - 1] = '\0';

	return (s);
}/*stripdir()*/


/* ------------------------------------------------------------------------- */
char *timestr (long timestamp)
{
	static char *mon[12]={"Jan","Feb","Mar","Apr","May","Jun",
			      "Jul","Aug","Sep","Oct","Nov","Dec"};
	static char s[20];
	struct tm *t;

	t = localtime(&timestamp);
	sprintf(s,"%2d %3s %02d  %02d:%02d",
		t->tm_mday, mon[t->tm_mon], t->tm_year%100, t->tm_hour, t->tm_min);
	return (s);
}/*timestr()*/


/* ------------------------------------------------------------------------- */
int scandirs (char *filespec, boolean onlylatest)
{
	register int hits;
	register char *p;
	char workstr[MAXLINE+1], workpath[MAXLINE+1];
	struct _reqdir reqdir;
	struct stat f;

	reqdir.fstamp = 0L;
	splitpath(filespec,workpath,workstr);
	for (hits = 0, p = ffirst(filespec); p; hits++, p = fnext()) {
	    getfinfo(&f);
	    if (onlylatest && f.st_mtime < reqdir.fstamp)
	       continue;
	    strupr(p);
	    prepfname(reqdir.fname,p);
	    reqdir.fsize  = f.st_size;
	    reqdir.fstamp = f.st_mtime;
	    if (verbose)
	       fprintf(stderr,"  %05d: %-8.8s %-3s  %8ld  %s\r",
		       hits,reqdir.fname,reqdir.fname+8,
		       reqdir.fsize,timestr(reqdir.fstamp));
	    if (!onlylatest)
	       fwrite(&reqdir,sizeof (struct _reqdir),1,dirfp);
	}
	fnclose();

	if (onlylatest && hits) {
	   fwrite(&reqdir,sizeof (struct _reqdir),1,dirfp);
	   hits = 1;
	}

	return (hits);
}/*scandirs()*/


/* ------------------------------------------------------------------------- */
#if defined(__MSDOS__)
static int critical_handler (void)
{
	return (3);	/* FAIL */
}/*critical_handler()*/
#endif


/* ------------------------------------------------------------------------- */
void break_handler (int sig)
{
	sig = sig;

	signal(SIGINT,SIG_IGN);
	do_break = 1;
	signal(SIGINT,break_handler);
}/*break_handler()*/


/* ------------------------------------------------------------------------- */
void main (int argc, char *argv[])
{
	FILE *cfgfp, *idxfp;
	char *keyword, *parm, *p;
	word flags, minlevel, maxlevel;
	word reqlevel;
	boolean latest;
	int dummy, i;
	long filepos;
	struct _reqhdr reqhdr;
	struct _reqidx reqidx;
	char **rsp_textptr;
	char *rsp_header, *rsp_footer, *rsp_fileinfo, *rsp_codestr[NUMRSPCODES];

	signal(SIGINT,break_handler);

#if defined(__MSDOS__)
	harderr(critical_handler);
#endif

	fprintf(stderr,"%s; Version %s, compiles REQUEST.CFG -> IDX/DIR\n",PRGNAME,VERSION);
	fprintf(stderr,"Design & COPYRIGHT (C) 1989-1996 by Arjen G. Lentz; ALL RIGHTS RESERVED\n");
	fprintf(stderr,"(this utility is part of Xenia Mailer version 1.97.14 & up)\n");
	fprintf(stderr,"A ShareWare project of LENTZ SOFTWARE-DEVELOPMENT, Amersfoort, The Netherlands\n");
	fprintf(stderr,"Use -v (verbose) on command line to show disk-scan (slower)\n\n");

#if defined(__OS2__) || defined(__MSDOS__)
	putenv("TZ=GMT0");
	tzset();
#endif
	if (argc==2 && !stricmp(argv[1],"-v"))
	   verbose=1;

	if ((p = getenv("MAILER")) != NULL)
	   sprintf(buffer,"%s\\%s",stripdir(p),reqcfgname);
	else
	   strcpy(buffer,reqcfgname);
	if ((cfgfp=fopen(buffer,BREAD))==NULL) {
	   printf("! Can't open request cfgfile %s\n",buffer);
	   exit (1);
	}
	if ((idxfp=fopen(reqidxtemp,BWRITE))==NULL) {
	   printf("! Can't create temporary request idxfile %s\n",reqidxtemp);
	   fclose(cfgfp);
	   exit (1);
	}
	if ((dirfp=fopen(reqdirtemp,BWRITE))==NULL) {
	   printf("! Can't create temporary request dirfile %s\n",reqdirtemp);
	   fclose(cfgfp);
	   fclose(idxfp);
	   unlink(reqidxtemp);
	   exit (1);
	}

	reqhdr.idxnum = flags = minlevel = 0;
	latest = false;
	maxlevel = NUMREQSECLEVELS - 1;
	rsp_textptr = NULL;
	rsp_header = rsp_footer = rsp_fileinfo = NULL;
	for (i=0; i<NUMRSPCODES; i++) rsp_codestr[i] = NULL;
	filepos = 0L;
	memset(&reqhdr,0,sizeof (struct _reqhdr));
	fwrite(&reqhdr,sizeof (struct _reqhdr),1,idxfp);

	while (fgets(buffer,MAXLINE,cfgfp)) {
	      if (do_break) {
		 printf("- Aborted by operator\n");
		 fclose(cfgfp);
		 fclose(idxfp);
		 fclose(dirfp);
		 unlink(reqidxtemp);
		 unlink(reqdirtemp);
		 exit (0);
	      }

	      strcpy(rsp_buffer,buffer);
	      if (strchr(buffer,';'))
		 *strchr(buffer,';') = '\0';
	      if (!*buffer) continue;
	      strupr(buffer);
	      keyword = strtok(buffer," \t\r\n\032");
	      if (!keyword) continue;
	      parm = strtok(NULL,"\r\n\032");
	      if (parm) {
		 strip(parm);
		 for (p = parm; *p; p++)
		     if (*p == '\t') *p = ' ';
	      }
	      else
		 parm = "";

	      if (*keyword==':') {
		 keyword++;
		 if (!strcmp(keyword,"END")) {
		    flags  = 0;
		    latest = false;
		    rsp_textptr = NULL;
		 }
		 else if (!strcmp(keyword,"BRKEXACT")) flags |= REQ_BRKEXACT;
		 else if (!strcmp(keyword,"BRKHIT"))   flags |= REQ_BRKHIT;
		 else if (!strcmp(keyword,"NOWILDS"))  flags |= REQ_NOWILDS;
		 else if (!strcmp(keyword,"EXACT"))    flags |= REQ_EXACT;
		 else if (!strcmp(keyword,"NOCOUNT"))  flags |= REQ_NOCOUNT;
		 else if (!strcmp(keyword,"NOSIZE"))   flags |= REQ_NOSIZE;
		 else if (!strcmp(keyword,"NOTIMER"))  flags |= REQ_NOTIMER;
		 else if (!strcmp(keyword,"NORESP"))   flags |= REQ_NORESP;
		 else if (!strcmp(keyword,"NOEVENT"))  flags |= REQ_NOEVENT;
		 else if (!strcmp(keyword,"GROUP"))    flags |= REQ_GROUP;
		 else if (!strcmp(keyword,"MAGIC"))    flags |= REQ_MAGIC;
		 else if (!strcmp(keyword,"SERVICE"))  flags |= REQ_SERVICE;
		 else if (!strcmp(keyword,"LATEST"))   latest = true;
		 else if (!strcmp(keyword,"MAXLEVEL")) maxlevel = atoi(parm);
		 else if (!strcmp(keyword,"MINLEVEL")) minlevel = atoi(parm);
		 else if (!strcmp(keyword,"REQLEVEL")) {
		    reqlevel = atoi(parm);
		    sscanf(parm,"%*hu %hu %hu",
			   &reqhdr.reqsec[reqlevel].countlimit,
			   &reqhdr.reqsec[reqlevel].sizelimit);
		    printf("* REQLEVEL %hu: count=%hu  size=%hu\n", reqlevel,
			   reqhdr.reqsec[reqlevel].countlimit,
			   reqhdr.reqsec[reqlevel].sizelimit);
		 }
		 else if (!strcmp(keyword,"HEADER"))   rsp_textptr = &rsp_header;
		 else if (!strcmp(keyword,"FOOTER"))   rsp_textptr = &rsp_footer;
		 else if (!strcmp(keyword,"FILEINFO")) rsp_textptr = &rsp_fileinfo;
		 else if (!strcmp(keyword,"RSPCODE")) {
		    i = atoi(parm);
		    rsp_textptr = &rsp_codestr[i];
		    reqhdr.rsp_codeinfo[i].minlevel = minlevel;
		    reqhdr.rsp_codeinfo[i].maxlevel = maxlevel;
		 }
		 else if (*keyword)
		    printf("- Unknown keyword '%s' in request cfgfile\n",keyword);
	      }/*flags*/

	      else if (rsp_textptr) {
		 parm = strtok(rsp_buffer,"\r\n\032");
		 if (parm) {
		    for (p = parm; *p; p++)
			if (*p == '\t') *p = ' ';
		    if (!*parm) continue;
		 }
		 else
		    continue;

		 p = buffer;
		 while (*parm) {
		       if (*parm == '\\') {
			  parm++;
			  if (!*parm) break;
			  if (*parm == '\\')
			     *p++ = '\\';
			  else if (*parm == 'n') {
			     *p++ = '\r';
			     *p++ = '\n';
			  }
			  parm++;
		       }
		       else
			  *p++ = *parm++;
		 }
		 *p = '\0';

		 if (*rsp_textptr) {
		    *rsp_textptr = realloc(*rsp_textptr,strlen(*rsp_textptr) + strlen(buffer) + 1);
		    if (!*rsp_textptr) {
		       printf("! Not enough memory!\n");
		       reqhdr.idxnum = 0;
		       goto fini;
		    }
		    strcat(*rsp_textptr,buffer);
		 }
		 else {
		    *rsp_textptr = strdup(buffer);
		    if (!*rsp_textptr) {
		       printf("! Not enough memory!\n");
		       reqhdr.idxnum = 0;
		       goto fini;
		    }
		 }
	      }/*response*/

	      else {
		 memset(&reqidx,0,sizeof (struct _reqidx));

		 reqidx.flags	  = flags;
		 reqidx.minlevel  = minlevel;
		 reqidx.maxlevel  = maxlevel;

		 if (*keyword=='@') {
		    reqidx.flags |= REQ_MAGIC;
		    keyword++;
		 }
		 else if (*keyword=='$' || *keyword=='+') {
		    reqidx.flags |= REQ_SERVICE;
		    keyword++;
		 }

		 if (*parm=='!') {
		    for (parm++, i=0, p=reqidx.password;
			 *parm && *parm!=' ' && i<6;
			 *p++=*parm++, i++);
		    *p++='\0';
		    while (*parm && *parm!=' ') /* in case pwd longer than 6 */
			  parm++;
		    strip(parm);
		 }

		 if (reqidx.flags & REQ_MAGIC) {
		    strcpy(reqidx.filespec,keyword);
		    for (p=strtok(parm," "); p; p=strtok(NULL," ")) {
			splitpath(p,reqidx.params,work);
			printf("* MAGIC %s%s%s: %s\n",
			       reqidx.filespec,
			       *reqidx.password ? " !" : "",
			       *reqidx.password ? reqidx.password : "",
			       reqidx.params);
			reqidx.number = scandirs(p,latest);
			if (reqidx.number) {
			   reqidx.offset = filepos;
			   filepos = ftell(dirfp);
			   fwrite(&reqidx,sizeof (struct _reqidx),1,idxfp);
			   reqhdr.idxnum++;
			}
		    }
		 }

		 else if (reqidx.flags & REQ_SERVICE) {
		    strcpy(reqidx.filespec,keyword);
		    strcpy(reqidx.params,parm);
		    printf("* SERVICE %s%s%s: %s\n",
			   reqidx.filespec,
			   *reqidx.password ? " !" : "",
			   *reqidx.password ? reqidx.password : "",
			   reqidx.params);
		    fwrite(&reqidx,sizeof (struct _reqidx),1,idxfp);
		    reqhdr.idxnum++;
		 }

		 else {
		    splitpath(keyword,reqidx.params,work);
		    prepfname(reqidx.filespec,work);
		    printf("* NORMAL %-8.8s.%-3s%s%s: %s\n",
			   reqidx.filespec, reqidx.filespec+8,
			   *reqidx.password ? " !" : "",
			   *reqidx.password ? reqidx.password : "",
			   reqidx.params);
		    reqidx.number = scandirs(keyword,latest);
		    if (reqidx.number) {
		       reqidx.offset = filepos;
		       filepos = ftell(dirfp);
		       fwrite(&reqidx,sizeof (struct _reqidx),1,idxfp);
		       reqhdr.idxnum++;
		    }
		 }

		 if (verbose)
		    printf("                                                 \r");
	      }/*entry*/
	}

	if (reqhdr.idxnum)
	   printf("+ Total of %ld dir records\n",filepos / sizeof (struct _reqdir));
	printf("+ Writing response info\n");

	if (rsp_header) {
	   i = strlen(rsp_header) + 1;
	   reqhdr.rspofs_header = reqhdr.rsplen;
	   reqhdr.rsplen += i;
	   fwrite(rsp_header,i,1,idxfp);
	}
	else
	   reqhdr.rspofs_header = 0xffff;

	if (rsp_footer) {
	   i = strlen(rsp_footer) + 1;
	   reqhdr.rspofs_footer = reqhdr.rsplen;
	   reqhdr.rsplen += i;
	   fwrite(rsp_footer,i,1,idxfp);
	}
	else
	   reqhdr.rspofs_footer = 0xffff;

	if (rsp_fileinfo) {
	   i = strlen(rsp_fileinfo) + 1;
	   reqhdr.rspofs_fileinfo = reqhdr.rsplen;
	   reqhdr.rsplen += i;
	   fwrite(rsp_fileinfo,i,1,idxfp);
	}
	else
	   reqhdr.rspofs_fileinfo = 0xffff;

	for (dummy = 0; dummy < NUMRSPCODES; dummy++) {
	    if (rsp_codestr[dummy]) {
	       i = strlen(rsp_codestr[dummy]) + 1;
	       reqhdr.rsp_codeinfo[dummy].rspofs_code = reqhdr.rsplen;
	       reqhdr.rsplen += i;
	       fwrite(rsp_codestr[dummy],i,1,idxfp);
	    }
	    else
	       reqhdr.rsp_codeinfo[dummy].rspofs_code = 0xffff;
	}

fini:	fseek(idxfp,0L,0);
	fwrite(&reqhdr,sizeof (struct _reqhdr),1,idxfp);
	fclose(cfgfp);
	fclose(idxfp);
	fclose(dirfp);

	if (!reqhdr.idxnum && !reqhdr.rsplen) {
	   printf("- No request or response entries - idx & dir deleted\n");
	   unlink(reqidxtemp);
	   unlink(reqdirtemp);
	}
	else {
	   if ((!access(reqdirname,0) && unlink(reqdirname)) ||
	       (!access(reqidxname,0) && unlink(reqidxname))) {
	      printf("- Can't delete old idx & dir now; run ReqComp again later\n");
	      unlink(reqidxtemp);
	      unlink(reqdirtemp);
	   }
	   else {
	      rename(reqdirtemp,reqdirname);
	      rename(reqidxtemp,reqidxname);
	      printf("+ All done!\n");
	   }
	}

	exit (0);
}/*main()*/


/* end of reqcomp.c */
