/****************************************************************/
/*          Remove a user from the FtpServer database           */
/*                                                              */
/*      Author:       Peter Moylan (peter@ee.newcastle.edu.au)  */
/*      Started:      7 December 2000                           */
/*      Last revised: 7 December 2000                           */
/*                                                              */
/*  Usage:                                                      */
/*         remove username                                      */
/*                                                              */
/*  Installation:                                               */
/*         Put this file in the directory containing FTPD.INI   */
/*                                                              */
/****************************************************************/

CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs

PARSE ARG username
IF username = '' THEN
    DO
        SAY "Usage: remove username"
        EXIT 0
    END

/* Check the source directory, in case this command file is     */
/* run from a different directory.                              */

PARSE SOURCE rubbish rubbish SrcDir
j = LASTPOS('\', SrcDir)
IF j > 0 THEN SrcDir = LEFT(SrcDir, j-1)

IF SysIni(SrcDir'\FTPD.INI', username, 'DELETE:') \= '' THEN
    DO
        SAY "Can't delete user "username
        EXIT 1
    END

SAY "User "username" removed"
EXIT 0


