#include <stdio.h>
#include <io.h>
#include "cleanmap.h"

int main()
{
 FILE *worldfp, *in, *out;

 register int count;

 int counter = 0;
 int needmap = FALSE;
 int mapnum = 0;

 struct world_info world;
 struct plan_rec map;

 printf("Clean Map v1.0 - FREEWARE\n");
 printf("Copyright 1998, Chris Vallinga\n\n");

 if((in = fopen("map.dat", "rb")) == NULL)
 {
   printf("Unable to open file 'map.dat'.\n");
   exit(1);
 }

 if((worldfp = fopen("world.dat", "r+b")) == NULL)
 {
   printf("Unable to open file 'world.dat' for read/write.\n");
   exit(2);
 }

 if((out = fopen("temp.dat", "wb")) == NULL)
 {
   printf("Unable to create temporary data file'.\n");
   exit(3);
 }

 printf("Working...");

 fread(&world, sizeof(world), 1, worldfp);

 for(;;)
 {
  counter++;

  fread(&map, sizeof(map), 1, in);
  if(feof(in)) break;

  needmap = FALSE;

  for(count = 0; count < 1600; count++)
  {
    if(world.loc[count] == counter)
    {
       needmap = TRUE;
       break;
    }
  }

  if(needmap)
  {
    for(count = 0; count < 1600; count++)
      if(world.loc[count] == counter)
	world.loc[count] -= mapnum;

    fwrite(&map, sizeof(map), 1, out);
  }
  else
    mapnum++;
 }

 printf("done\n");
 rewind(worldfp);
 fwrite(&world, sizeof(world), 1, worldfp);

 fcloseall();

 remove("map.dat");
 rename("temp.dat", "map.dat");

 return 0;
}
