{$A+,B-,D+,E+,F-,G-,I-,L+,N-,O-,P-,Q-,R-,S+,T-,V+,X+,Y+}
{$M 16384,0,655360}
Unit InptMisc; { by John Stephenson; Copyright 1995 }

Interface
Uses Asmmisc,Boxes,Crt,Dos,KeyMisc,Mouse,StrMisc;
Type
  InputType = (Normal,Capital,Name,Secret,Number);

Type
  Colorstype = record
    Border,
    Maintext,
    HighLightedText,
    Entrytext,
    Shadow: byte;
    { This is actually the box attributes }
    Outline: byte;
    OpenSpeed,
    CloseSpeed: integer;
  end;

Const { For ExplodingMenu.AddChoice }
  None         = 0;
  Unavail      = 1;
  LineType     = 2;
  UnAccessable = 3;
  QuitType     = 4;
Const { For InputDrv handling ESC }
{ None      = 0; { No action (pre-defined constant) }
  Clear     = 1; { Clear input field, don't exit }
  ClearQuit = 2; { Clear input field, and exit }
  QuitField = 3; { Just exit field, leave untouched }

Const
  { Does not show the "0" when getlongint, etc are run }
  SuppressZeros: boolean = false;
  { Action if in GetString.. }
  EscAction: byte = ClearQuit;


Type
  pMenuChoices = ^tMenuChoices;

  pChoices = ^tChoices;
  tChoices = record
    HotKey: Char;
    Desc: ^String;
    Attr,
    HiLight: Byte;
    Next: pChoices;
  End;

  tMenuChoices = object
    TotalChoices: integer;
    Head,
    Choices: pChoices;

    Constructor Init;
    Procedure AddChoice(hk: char; ds: string; atr: byte);
    Procedure SetChoice(ctc: integer; hk: char; ds: string; atr: byte);
    Procedure GetChoice(ctc: integer; var hk: char; var ds: string; var atr: byte);
    Destructor Done;
  end;

  ExplodingMenu = object(tMenuChoices)
    StartChoices,     { Where relative to the box do the choices start }
    EndChoices: byte; { Where relative to the start do the choices end }

    Place,            { Place in scrollable menu list }
    Choice,lastchoice: integer;
    Quit,Select: boolean;

    CallOnMove: Pointer;

    StartX,StartY,LenX,LenY,
    MShadow,
    BorderColor,
    TitleColor,
    MenuColor,HighlightMenuColor,
    BarColor,HighlightBarColor: byte;
    Unavailcolor,
    Unavailbarcolor,
    CharsColor,
    IconColor: byte;
    Title: String;

    Menu: ExplodingBox;

    MoreUp,MoreDown,
    LeftChar,RightChar: char;

    { 0 for "wy" will auto size it to menu choices and start choices }
    Constructor Init(_x,_y,wx,wy: byte; tit: string);
    Procedure SetColors(borderc,titlec,menuc,himenuc,barc,hbarc,shdw: byte);
    { Normally done by ProcessInput, but acceptable to call elsewise }
    Procedure DrawBox;
    Procedure ProcessInput;
    Procedure Update;
    Procedure GoHome;
    Procedure GoEnd;
    Procedure GoUp;
    Procedure GoDown;
    Procedure GoPageUp;
    Procedure GoPageDown;
    Destructor Done;
    Private
      Procedure Check;
      Procedure IncCheck;
      Procedure DecCheck;

    Private
      BoxOnScreen: boolean;
  End;

Const
  BackSpaceChar: char = ' ';
  WriteEnter: boolean = true;
  WrapInput: boolean = false;
  { Dis/allows ESC in ExplodingMenu, getchar, and getcolor }
  AllowEsc: Boolean = true;

  DefaultColors: colorstype =
   (Border:lightblue;
    Maintext:lightcyan;
    HighLightedText:white;
    Entrytext:_lightgray+blue;
    Shadow:darkgray;
    Outline:4;
    OpenSpeed:3;
    CloseSpeed:1);

  BlueColors: colorstype =
   (Border:_blue+lightblue;
    Maintext:_blue+lightcyan;
    HighLightedText:_blue+white;
    Entrytext:_lightgray+black;
    Shadow:darkgray;
    Outline:4;
    OpenSpeed:3;
    CloseSpeed:1);

  RedColors: colorstype =
   (Border:_red+lightred;
    Maintext:_red+white;
    HighLightedText:_red+yellow;
    Entrytext:_lightgray+black;
    Shadow:darkgray;
    Outline:4;
    OpenSpeed:3;
    CloseSpeed:1);

  MagentaColors: colorstype =
   (Border:_magenta+lightmagenta;
    Maintext:_magenta+white;
    HighLightedText:_magenta+yellow;
    Entrytext:_lightgray+black;
    Shadow:darkgray;
    Outline:4;
    OpenSpeed:3;
    CloseSpeed:1);

  GreenColors: colorstype =
   (Border:_green+lightgreen;
    Maintext:_green+white;
    HighLightedText:_green+yellow;
    Entrytext:_lightgray+black;
    Shadow:darkgray;
    Outline:4;
    OpenSpeed:3;
    CloseSpeed:1);

Var
  ColorCfg: ColorsType;

Function AnyKeypressed: boolean;
Function CapInput(len: byte; default: String): String;
Function GetChar(sx,sy: byte; default: char): char;
Function GetColor(sx,sy,tattr: byte): byte;
Function GetYn(xs,ys: byte; st: String; yes: boolean): boolean;
Function NameInput(len: byte; default: String): String;
Function NormalInput(len: byte; default: String): String;
Function NumInput(len: byte; default: String): String;
Function SecretInput(len: byte; default: String): String;

Procedure WaitKey;
Procedure WaitInput(ms: integer);
Procedure GetString(y: byte; txt: String; var st: String; wlen: byte; typeinput: inputtype);
Procedure GetStringWT(y: byte; txt,help: String; var st: String; wlen: byte; typeinput: inputtype);
Procedure GetByte(y: byte; txt: String; var num: byte; low,high: byte); { byte }
Procedure GetInteger(y: byte; txt: String; var num: integer; low,high: integer); { integer }
Procedure GetLongint(y: byte; txt: String; var num: longint; low,high: longint); { longint }
Procedure GetByteWT(y: byte; txt,help: String; var num: byte; low,high: byte); { byte }
Procedure GetIntegerWT(y: byte; txt,help: String; var num: integer; low,high: integer); { integer }
Procedure GetLongintWT(y: byte; txt,help: String; var num: longint; low,high: longint);

Procedure PutMsg(xs,ys: byte; st: String);
Procedure Blip;

Implementation
Const
  Insrt: boolean = true;

Function AnyKeypressed: boolean;
Var temp: boolean;
begin
  calluserproc(kpi);
  if mouseinstalled then temp := keymisc.anykeypressed or mousepressed
  else temp := keymisc.anykeypressed;

  calluserproc(kpi);
  if temp then begin
    anykeypressed := true;
    calluserproc(kpe);
  end
  else anykeypressed := false;
end;

Procedure blip;
begin
  sound(1000);  delay(15);
  sound(2500);  delay(7);
  nosound;      delay(3);
End; { End blip }

Procedure InputDrv(var tline: string; len: byte; name,showit,allcap,numinput: boolean);
{ This procedure is not designed to be called directly, use Capinput,
  NormalInput, NameInput, and SecretInput to get input with }
var
  ch: char;
  loop,i,j,place: byte;
  temp,rtemp: String;
  Quit: Boolean;
  Cursor: word;
begin
  Getcursor(cursor);
  if insrt then setcursor(1543)
  else setcursor(8);
  Quit := False;
  touchres := touchres+tline;
  tline := '';
  place := 1; { Place of character in relation to String }
  repeat
    ch := readkey;

    if name then begin
      if place = 1 then ch := upcase(ch)
      else if tline[place - 1] = #32 then ch := upcase(ch);
    End;
    if allcap then ch := upcase(ch);
    if (numinput and (ch in [#0,#8,#13,#25,#27,'0'..'9','-','+',':','/','.',','])) or not numinput then
    case ch of
      #0: begin
        ch := readkey;
        case ch of
          _home: begin
            if place-1 <> 0 then gotoxy(wherex-(place-1),wherey);
            place := 1;
          End;
          _end: begin
            if length(tline)-place+1<>0 then gotoxy(wherex+(length(tline)-place+1),wherey);
            place := byte(tline[0])+1;
          End;
          _left: begin
            if place <> 1 then begin
              dec(place);
              gotoxy(wherex-1,wherey);
            End;
          End;
          _right: begin
            if place<byte(tline[0])+1 then begin
              inc(place);
              gotoxy(wherex+1,wherey);
            End;
          End;
          _insert: begin
            insrt := not insrt;
            if insrt then setcursor(1543)
            else setcursor(8);
          end;
          _delete: begin
            if place<byte(tline[0])+1 then begin
              Delete(tline,place,1);
              { Rewrite that part of the line + the delete character to }
              { erase the last character on the screen }
              if showit then write(copy(tline,place,255)+Backspacechar)
              else write(dup('.',byte(tline[0])-place+1)+Backspacechar);
              { Go over to the starting place, plus lone more for the now }
              { deleted character }
              gotoxy(wherex-(byte(tline[0])-place+1+1),wherey);
            End;
          End;
        End;
      End;

      #8: if place <> 1 then begin
        if place = byte(tline[0]) + 1 then begin
          dec(tline[0]);
          write(#8+Backspacechar+#8);
          dec(place);
        end
        else begin
          dec(place);
          Delete(tline,place,1);
          { Go over to where we're deleting }
          gotoxy(wherex-1,wherey);
          { Rewrite that part of the line + the delete character to }
          { erase the last character on the screen }
          if showit then write(copy(tline,place,255)+Backspacechar)
          else write(dup('.',length(copy(tline,place,255)))+Backspacechar);
          { Go over to the starting place }
          gotoxy(wherex-length(copy(tline,place,255)+Backspacechar),wherey);
        End;
      End;
      #25: if tline[0] <> #0 then begin { ClrLine }
        gotoxy(wherex-(place-1),wherey);
        write(dup(backspacechar,length(tline)));
        gotoxy(wherex-length(tline),wherey);
        tline := '';
        place := 1;
      End;
      #27: case EscAction of
        None:;
        Clear: tline := '';
        ClearQuit: begin tline := ''; quit := true; end;
        QuitField: quit := true;
      end;
      #1..#31:;
      { Normal character detected }
      else begin
        if (length(tline) <> len) or ((not insrt) and (place-1 <> len)) then begin
          { If it's at the end of the line }
          if place = length(tline)+1 then begin
            if showit then write(ch)
            else write('.');
            tline := tline + ch;
            inc(place);
          end
          { They must be half way through it then }
          else begin
            if not insrt then begin
              if showit then write(ch)
              else write('.');
              tline[place] := ch;
              inc(place);
            end
            else begin
              insert(ch,tline,place);
              if showit then write(copy(tline,place,255))
              else write(dup('.',length(copy(tline,place,255))));
              { Go over to the starting place }
              gotoxy(wherex-(length(copy(tline,place,255))-1),wherey);
              inc(place);
            End;
          End;
        end
        { End of line, and can't write any more.. }
        else begin
          if not WrapInput then blip
          { Then we should wrap it! }
          else begin
            temp[0] := #0;
            rtemp[0] := #0;
            loop := byte(tLine[0]);
            { Check for a space in the line }
            if pos(#32,tLine) <> 0 then begin
              while (tLine[loop] <> #32) do begin
                write(#8+backspacechar+#8); { Delete character }
                temp := temp + tLine[loop];
                dec(loop);
                dec(tline[0]);
              End;
              { If no space then cut the line short }
              { Reverse what's in Temp }
              if temp[0] <> #0 then for loop := byte(temp[0]) downto 1 do rtemp := rtemp + temp[loop];
            End;
            touchres := touchres + rtemp + ch;
            ch := #13;
          End;
        End;
      End;
    End; { Case structure }
  until (ch = #13) or quit;
  if writeenter then writeln('');
  Setcursor(cursor);
End; { End Inputdrv }

Function SecretInput(len: byte; default: String): String;
begin
  InputDrv(default,len,false,false,false,false);
  SecretInput := default;
End;

Function NameInput(len: byte; default: String): String;
begin
  InputDrv(default,len,true,true,false,false);
  NameInput := default;
End;

Function NormalInput(len: byte; default: String): String;
begin
  InputDrv(default,len,false,true,false,false);
  NormalInput := default;
End;

Function CapInput(len: byte; default: String): String;
begin
  InputDrv(default,len,false,true,true,false);
  CapInput := default;
End;

Function NumInput(len: byte; default: String): String;
begin
  InputDrv(default,len,false,true,false,true);
  NumInput := default;
End;

Function GetChar(sx,sy: byte; default: char): char;
var
  choicebox: explodingbox;
  quit: byte;
  ch: char;
  x,y,
  oldx,oldy: byte;
  c: char;
  cursor: word;
  button,
  mx,my,
  oldmx,oldmy,
  diffy,diffx: integer;
const
  xmax = 32;
  ymax = 8;

  Procedure Update;
  var i,j: byte; ch: char;
  begin
    if x > xmax then x := 1;
    if y > ymax then y := 1;
    if x < 1 then x := xmax;
    if y < 1 then y := ymax;

    if (oldx=x) and (oldy=y) then exit;

    { Do the arrows }
    choicebox.setattr(ColorCfg.Maintext);
    { Erase the old arrows }
    choicebox.textout(oldx+1,2,' ');
    choicebox.textout(1,2+oldy,' ');
    { Draw the new ones }
    choicebox.textout(x+1,2,#25);
    choicebox.textout(1,2+y,#26);
    oldx := x;
    oldy := y;

    { Do the list }
    c := char((x-1)+(y-1) shl 5);

    For i := 1 to 8 do
      For j := 1 to 32 do begin
        ch := char((j-1)+(i-1) shl 5);
        if ch <> c then choicebox.setattr(colorcfg.maintext)
        else choicebox.setattr(colorcfg.entrytext);
        choicebox.textout(1+j,i+2,ch);
      end;

    choicebox.setattr(colorcfg.highlightedtext);
    choicebox.textout(2,12,'Char: '+c+' ASCII: '+ljust(inttostr(byte(c)),3)+' Hex: '+inttohex(byte(c),2)+'h');
  end;

begin
  getcursor(cursor);
  cursoroff;
  with choicebox do begin
    with colorcfg do begin;
      init(sx,sy,36,14,outline,' ',border,highlightedtext,openspeed,shadow);
      textout(2,1,'Choose character from chart');
      putfooter(' Space to Select ',Maintext);
    end;

  End;

  mx := 80;
  my := 80;
  oldmy := my;
  oldmx := mx;
  if mouseinstalled then Setmousepos(mx,my);

  quit := 0;
  oldx := 0;
  oldy := 0;
  x := byte(default) mod (1 shl 5)+1;
  y := byte(default) shr 5+1;
  repeat
    update;

    if keypressed then begin
      ch := readkey;
      case ch of
        #0: begin
          ch := readkey;
          case ch of
            _home    :x:=1;
            _end     :x:=xmax;
            _up      :dec(y);
            _down    :inc(y);
            _right   :inc(x);
            _left    :dec(x);
            _pageup  :y:=1;
            _pagedown:y:=ymax;
            else blip;
          End;
        End;
        #13,#32: quit := 1;
        #27: if allowesc then quit := 2;
        else begin
          x := byte(ch) mod (1 shl 5)+1;
          y := byte(ch) shr 5+1;
        end;
      End;
    End;

    If mouseinstalled then begin
      GetMousePos(mx,my,button);
      If (mx <> oldmx) or (my <> oldmy) then begin
        calluserproc(kpe);

        { Half sensitivity per space }
        diffy := abs(integer(my) - integer(oldmy)) div 8 div 2;
        diffx := abs(integer(mx) - integer(oldmx)) div 8 div 2;
        if (diffx <> 0) or (diffy <> 0) then begin
          if my < oldmy then dec(y,diffy);
          if my > oldmy then inc(y,diffy);
          if mx < oldmx then dec(x,diffx);
          if mx > oldmx then inc(x,diffx);
          mx := 80;
          my := 80;
          Setmousepos(mx,my);
          oldmy := my;
          oldmx := mx;
        End;
      end;

      If button > 0 then begin
        calluserproc(kpe);

        If button = leftb then quit := 1
        Else if button = rightb then quit := 2
        Else begin
          blip;
          repeat until not mousepressed;
        End;
      End;
    End;

  Until (quit <> 0) and ((not mouseinstalled) or (not mousepressed));
  choicebox.done(colorcfg.closespeed);
  case quit of
    1: getchar := c;
    2: getchar := default;
  End;
  setcursor(cursor);
End;

Function GetColor(sx,sy,tattr: byte): byte;
var
  choicebox: explodingbox;
  i,j: byte;
  quit: byte;
  ch: char;
  x,y,
  oldx,oldy: byte;
  attr: byte;
  cursor: word;
  button,
  mx,my,
  oldmx,oldmy,
  diffy,diffx: integer;
const
  xmax = 32;
  ymax = 8;
begin
  getcursor(cursor);
  cursoroff;
  with choicebox do begin
    with colorcfg do begin;
      init(sx,sy,36,14,outline,' ',border,highlightedtext,openspeed,shadow);
      textout(2,1,'Choose color from chart');
      putfooter(' Space to Select ',Maintext);
    end;

    for i := 1 to 8 do begin
      for j := 1 to 16 do begin
        setattr((i-1) shl 4+(j-1));
        textout(1+j,i+2,'');
      End;
      for j := 1 to 16 do begin
        setattr((i-1) shl 4+(j-1) or $80);
        textout(1+16+j,i+2,'');
      End;
    End;
  End;

  mx := 80;
  my := 80;
  oldmy := my;
  oldmx := mx;
  if mouseinstalled then Setmousepos(mx,my);

  quit := 0;
  oldx := 0;
  oldy := 0;
  x := (tattr and $F)+1;
  if tattr and $80 = $80 then inc(x,$10);
  y := ((tattr and $7F) shr 4)+1;
  repeat
    if (x <> oldx) or (y <> oldy) then begin
      if x > xmax then x := 1;
      if y > ymax then y := 1;
      if x < 1 then x := xmax;
      if y < 1 then y := ymax;

      choicebox.setattr(ColorCfg.Maintext);
      { Erase the old arrows }
      choicebox.textout(oldx+1,2,' ');
      choicebox.textout(1,2+oldy,' ');

      { Draw the new ones }
      choicebox.textout(x+1,2,#25);
      choicebox.textout(1,2+y,#26);

      attr := ((x-1) and $F) or ((y-1) shl 4);
      if (x-1) and $10 = $10 then inc(attr,blink);
      choicebox.setattr(attr);
      choicebox.textout(2,12,ljust('Sample text',32));
      oldx := x;
      oldy := y;
    End;

    if keypressed then begin
      ch := upcase(readkey);
      case ch of
        #0: begin
          ch := readkey;
          case ch of
            _home    :x:=1;
            _end     :x:=xmax;
            _up      :dec(y);
            _down    :inc(y);
            _right   :inc(x);
            _left    :dec(x);
            _pageup  :y:=1;
            _pagedown:y:=ymax;
            else blip;
          End;
        End;
        #13,#32: quit := 1;
        #27: if allowesc then quit := 2;
        else blip;
      End;
    End;

    If mouseinstalled then begin
      GetMousePos(mx,my,button);
      If (mx <> oldmx) or (my <> oldmy) then begin
        calluserproc(kpe);

        { Half sensitivity per space }
        diffy := abs(integer(my) - integer(oldmy)) div 8 div 2;
        diffx := abs(integer(mx) - integer(oldmx)) div 8 div 2;
        if (diffx <> 0) or (diffy <> 0) then begin
          if my < oldmy then dec(y,diffy);
          if my > oldmy then inc(y,diffy);
          if mx < oldmx then dec(x,diffx);
          if mx > oldmx then inc(x,diffx);
          mx := 80;
          my := 80;
          Setmousepos(mx,my);
          oldmy := my;
          oldmx := mx;
        End;
      end;

      If button > 0 then begin
        calluserproc(kpe);

        If button = leftb then quit := 1
        Else if button = rightb then quit := 2
        Else begin
          blip;
          repeat until not mousepressed;
        End;
      End;
    End;

  Until (quit <> 0) and ((not mouseinstalled) or (not mousepressed));
  choicebox.done(colorcfg.closespeed);
  case quit of
    1: getcolor := attr;
    2: getcolor := tattr;
  End;
  setcursor(cursor);
End;

Procedure GetString(y: byte; txt: String; var st: String; wlen: byte; typeinput: inputtype);
{ To get a string of maximum length "wlen", at y position "y" with the      }
{ description "txt", into the variable "st" using the type of input         }
{ "typeinput".  And in addition center the box.. phew!                      }
Var
  Popup: explodingbox;
  Boxlen,len: integer;
  Cursor: word;
  txtattr: byte;
Begin
  txtattr := textattr;
  getcursor(cursor);
  If wlen = 0 then wlen := 255;

  { 2 is for the spaces at the sides }
  Boxlen := 4+length(txt)+wlen;

  { 2 is for the box sides }
  If boxlen+2 > maxwidth then boxlen := maxwidth-2;

  { The length of the string }
  Len := boxlen-(4+length(txt));
  If len < 0 then len := wlen;

  Cursoroff;
  with colorcfg do
    Popup.init((maxwidth div 2)-(boxlen div 2)+1,y,boxlen,3,outline,' ',border,maintext,openspeed,shadow);
  Popup.textout(2,1,txt);
  Cursoron;

  Popup.SetAttr(colorcfg.entrytext);
  SetTextAttr(Popup.GetAttr);
  Popup.FillAttr(len);

  Case typeinput of
    Name:    st := nameinput(len,st);
    Normal:  st := normalinput(len,st);
    Capital: st := capinput(len,st);
    Number:  st := numinput(len,st);
    Secret:  st := secretinput(len,st);
  End;

  Cursoroff;
  Popup.done(colorcfg.closespeed);
  Setcursor(cursor);
  SetTextAttr(txtattr);
End;

Procedure GetStringWT(y: byte; txt,help: String; var st: String; wlen: byte; typeinput: inputtype);
{ To get a string of maximum length "wlen", at y position "y" with the  }
{ description "txt", into the variable "st" using the type of input     }
{ "typeinput".  And in addition center the box.. plus add an extra line }
{ containing the help line "help"                                       }
Var
  Popup: explodingbox;
  Boxlen,len: integer;
  Cursor: word;
  txtattr: byte;
Begin
  TxtAttr := textattr;
  getcursor(cursor);
  If wlen = 0 then wlen := 255;

  { 2 is for the spaces at the sides }
  Boxlen := imax(4+length(txt)+wlen,4+length(help));

  { 2 is for the box sides }
  If boxlen+2 > maxwidth then boxlen := maxwidth-2;

  { The length of the string }
  Len := boxlen-(4+length(txt));
  if wlen<len then len := wlen
  else wlen := len;

  Cursoroff;
  with colorcfg do
    Popup.init((maxwidth div 2)-(boxlen div 2)+1,y,boxlen,4,outline,' ',border,maintext,openspeed,shadow);
  Popup.SetAttr(colorcfg.maintext);
  Popup.textout(2,2,help);
  Popup.SetAttr(colorcfg.HighLightedText);
  SetTextAttr(Popup.getattr);
  Popup.textout(2,1,txt);
  Cursoron;

  Popup.SetAttr(colorcfg.entrytext);
  SetTextAttr(Popup.GetAttr);
  Popup.FillAttr(len);

  Case typeinput of
    Name:    st := nameinput(len,st);
    Normal:  st := normalinput(len,st);
    Capital: st := capinput(len,st);
    Number:  st := numinput(len,st);
    Secret:  st := secretinput(len,st);
  End;

  Cursoroff;
  Popup.done(colorcfg.closespeed);
  Setcursor(cursor);
  SetTextAttr(TxtAttr);
End;

Procedure GetLongint(y: byte; txt: String; var num: longint; low,high: longint);
var
  numbr: String;
  temp: String;
  code: integer;
  len: byte;
begin
  str(num,numbr);
  if (low=0) and (high=0) then len := 11
  else begin
    str(high,temp);
    len := length(temp);
  end;
  repeat
    If SuppressZeros and (numbr='0') then numbr := '';
    GetString(y,txt,numbr,len,number);
    If SuppressZeros and (numbr='') then numbr := '0';
    Val(numbr,num,code);
  until (code = 0) and (((num >= low) and (num <= high)) or ((low=0) and (high=0)));
end;

Procedure GetByte(y: byte; txt: String; var num: byte; low,high: byte); { byte }
var ltemp: longint;
begin
  ltemp := num;
  GetLongint(y,txt,ltemp,low,high);
  num := ltemp;
end;

Procedure GetInteger(y: byte; txt: String; var num: integer; low,high: integer); { integer }
var ltemp: longint;
begin
  ltemp := num;
  GetLongint(y,txt,ltemp,low,high);
  num := ltemp;
end;

Procedure GetLongintWT(y: byte; txt,help: String; var num: longint; low,high: longint);
var
  numbr: String;
  temp: String;
  code: integer;
  len: byte;
begin
  str(num,numbr);
  if (low=0) and (high=0) then len := 11
  else begin
    str(high,temp);
    len := length(temp);
  end;
  repeat
    If SuppressZeros and (numbr='0') then numbr := '';
    GetStringWT(y,txt,help,numbr,len,number);
    If SuppressZeros and (numbr='') then numbr := '0';
    Val(numbr,num,code);
  until (code = 0) and (((num >= low) and (num <= high)) or ((low=0) and (high=0)));
end;

Procedure GetByteWT(y: byte; txt,help: String; var num: byte; low,high: byte); { byte }
var ltemp: longint;
begin
  ltemp := num;
  GetLongintWT(y,txt,help,ltemp,low,high);
  num := ltemp;
end;

Procedure GetIntegerWT(y: byte; txt,help: String; var num: integer; low,high: integer); { integer }
var ltemp: longint;
begin
  ltemp := num;
  GetLongintWT(y,txt,help,ltemp,low,high);
  num := ltemp;
end;

Function GetYn(xs,ys: byte; st: String;yes:boolean): boolean;
Var

  _Quit: boolean;
  Popup: explodingbox;
  _oy,_Yes: boolean;
  Ch: char;
  Cursor: word;
  Mx,My,Button: integer;
Begin
  Getcursor(cursor);
  Cursoroff;
  With popup do begin
    _Quit := false;
    _Yes := yes;
    _Oy := not _yes;
    with colorcfg do Init(xs,ys,7+length(st),3,outline,' ',border,maintext,openspeed,shadow);
    Textout(2,1,st);
    Repeat
      if _oy <> _yes then begin
        SetAttr(colorcfg.entrytext);
        If _yes then textout(length(st)+2,1,'Yes')
        Else textout(length(st)+2,1,'No ');
        _oy := _yes;
      End;

      If keypressed then begin
        Ch := upcase(readkey);
        Case ch of
          #13,#27: _quit := true;
          'Y': begin _yes := true; _quit := true; End;
          'N': begin _yes := false; _quit := true; End;
          #0:;
          Else _yes := not _yes;
        End;
      End;

      If mouseinstalled then begin
        GetMousePos(mx,my,button);
        If button <> 0 then begin
          calluserproc(kpe);
          If button = leftb then _quit := true
          Else if button = rightb then _yes := not _yes
          Else if button = middleb then _yes := not _yes
          Else blip;
        End;
        repeat until not mousepressed;
      End;
    Until _quit;
    Done(colorcfg.closespeed);
  End;

  If ch <> #27 then getyn := _yes
  Else getyn := yes;
  Setcursor(cursor);
End;

Procedure PutMsg(xs,ys: byte; st: String);
Var
  Popup: explodingbox;
  Cursor: word;
Begin
  Getcursor(cursor);
  Cursoroff;
  With popup,colorcfg do begin
    Init(xs,ys,4+length(st),5,outline,' ',border,maintext,openspeed,shadow);
    Textout(2,2,st);
    putfooter(' Press any key ',HighLightedText);
    waitkey;
    done(closespeed);
  End;
  Setcursor(cursor);
End;

Procedure WaitKey;
begin
  repeat delay(100); until anykeypressed;
  { Flush up to one key, else wait 'till the release of the next }
  if keypressed then
    begin if readkey=#0 then readkey; end
  else
    repeat
      if keypressed then if readkey=#0 then readkey;
    until not anykeypressed;
end;

Procedure WaitInput(ms: integer);
Var
  I: integer;
Begin
  I := ms div 10;
  Repeat
    Delay(10);
    Dec(i);
  Until (i=0) or anykeypressed;
  if mouseinstalled then repeat until not mousepressed;
End;

Constructor tMenuChoices.Init;
begin
  TotalChoices := 0;
  Choices := nil;
end;

Procedure tMenuChoices.AddChoice(hk: char; ds: string; atr: byte);
begin
  inc(totalchoices);
  if totalchoices = 1 then begin
    new(head);
    choices := head;
  end
  else begin
    { Get to the end }
    while choices^.next <> nil do choices := choices^.next;

    new(choices^.next);
    choices := choices^.next;
  end;

  with choices^ do begin
    hotkey := hk;
    getmem(desc,length(ds)+1);
    desc^ := ds;
    attr := atr;
    hilight := pos(hotkey,desc^);
    next := nil;
  end;
end;

Procedure tMenuChoices.SetChoice(ctc: integer; hk: char; ds: string; atr: byte);
var loop: integer;
Begin
  choices := head;
  for loop := 1 to pred(ctc) do choices := choices^.next;
  with choices^ do begin
    hotkey := hk;
    freemem(desc,length(desc^)+1);
    getmem(desc,length(ds)+1);
    desc^ := ds;
    attr := atr;
    hilight := pos(hotkey,desc^);
  end;
End;

Procedure tMenuChoices.GetChoice(ctc: integer; var hk: char; var ds: string; var atr: byte);
var loop: integer;
Begin
  choices := head;
  for loop := 1 to pred(ctc) do choices := choices^.next;
  with choices^ do begin
    hk := hotkey;
    ds := desc^;
    atr := attr;
  end;
End;

Destructor tMenuChoices.Done;
Var Temp: pchoices;
Begin
  { Dispose of the list of choices }
  choices := head;
  while choices <> nil do begin
    temp := choices^.next;
    freemem(choices^.desc,length(choices^.desc^)+1);
    dispose(choices);
    choices := temp;
  end;
end;

Constructor ExplodingMenu.Init(_x,_y,wx,wy: Byte; Tit: String);
Begin
  Inherited Init;

  Boxonscreen := false;
  StartChoices := 0;
  EndChoices := 0;
  Place := 1;
  Choice := 1;
  CallOnMove := nil;

  lenx := wx;
  leny := wy;
  startx := _x;
  starty := _y;
  title := tit;

  { The little characters on the side of the bar }
  LeftChar := #0;
  RightChar := #0;
  { The little characters saying if there's more to it than shown }
  MoreUp := #24;
  MoreDown := #25;

  { Set default colors }
  SetColors(_blue+lightblue,_blue+white,_blue+lightcyan,_blue+white,_lightgray+black,_lightgray+blue,darkgray);
  Choice := 1;
end;

Procedure ExplodingMenu.SetColors(borderc,titlec,menuc,himenuc,barc,hbarc,shdw: byte);
begin
  BorderColor := borderc;
  TitleColor := titlec;
  MenuColor := menuc;
  HighlightMenuColor := himenuc;
  BarColor := barc;
  HighlightBarColor := hbarc;
  MShadow := shdw;

  UnavailColor := MenuColor and $F0+lightgray;
  UnavailBarColor := BarColor and $F0+darkgray;
  CharsColor := BarColor and $F0+black;
  IconColor := MenuColor and $F0+yellow;
end;

Procedure ExplodingMenu.DrawBox;
Begin
  If not boxonscreen then begin
    Boxonscreen := true;
    If leny = 0 then leny := startchoices+totalchoices+2;
    Menu.init(startx,starty,lenx,leny,colorcfg.outline,' ',BorderColor,MenuColor,colorcfg.openspeed,mshadow);
    Menu.movecursor := false;
    If title <> '' then begin
      Menu.SetAttr(titlecolor);
      Menu.textout(lenx div 2-length(title) div 2,0,title);
    End;
    If leny-startchoices-2 > totalchoices then endchoices := totalchoices
    Else endchoices := leny-startchoices-2;
  End;
  Update;
End;

Procedure ExplodingMenu.Update;
var
  loop: integer;
  Temp: byte;
Begin
  Choices := head;
  for loop := 1 to pred(place) do choices := choices^.next;
  temp := totalchoices;
  if temp > endchoices then temp := endchoices;
  For loop := 1 to temp do with choices^ do begin
    Case attr of
      Linetype: begin
        menu.SetAttr(bordercolor);
        menu.hline(loop+startchoices,1);
      end;

      None,quittype: begin
        if pred(loop)+place = choice then Menu.SetAttr(barcolor)
        else menu.SetAttr(menucolor);
        menu.Textout(1,loop+StartChoices,ljust(' '+desc^,lenx-2));
        If HiLight <> 0 then begin
          If pred(loop)+place = Choice then menu.SetAttr(HighLightBarColor)
          Else menu.SetAttr(HighLightMenuColor);
          PutAttrs(menu.x+1+hilight,menu.y+loop+StartChoices,1,menu.getattr);
        End;
      End;

      Unavail,UnAccessable: begin
        If pred(loop)+place=choice then menu.SetAttr(unavailbarcolor)
        Else Menu.SetAttr(unavailcolor);
        Menu.Textout(1,loop+StartChoices,ljust(' '+desc^,lenx-2));
      End;
    End;
    { Put the scroll characters in there if needed }

    { Deal with the sides }
    if attr <> linetype then begin
      menu.SetAttr(bordercolor);
      menu.textout(0,loop+startchoices,box[menu.box_to_use].vl);
    end;

    If (loop=1) and (place > 1) and (moreup <> #0) then begin
      menu.SetAttr(iconcolor);
      menu.textout(lenx-1,loop+startchoices,MoreUp)
    end
    else if (loop=temp) and (place < totalchoices-endchoices+1) and (moredown <> #0) then begin
      menu.SetAttr(iconcolor);
      menu.textout(lenx-1,temp+startchoices,MoreDown)
    end
    { Else do the border }
    else if attr <> linetype then begin
      menu.SetAttr(bordercolor);
      menu.textout(lenx-1,loop+startchoices,box[menu.box_to_use].vl);
    end;

    if pred(loop)+place = choice then begin
      menu.SetAttr(charscolor);
      if leftchar <> #0 then menu.textout(1,loop+startchoices,leftchar);
      if rightchar <> #0 then menu.textout(lenx-2,loop+startchoices,rightchar);
    end;
    Choices := next;
  end;
End;

Procedure ExplodingMenu.Check;
begin
  if choice < 1 then choice := 1;
  if choice > totalchoices then choice := totalchoices;

  if totalchoices-endchoices >= 0 then
    if place > totalchoices-endchoices+1 then place := totalchoices-endchoices+1;

  if choice < place then place := choice;
  if choice > place+endchoices-1 then place := choice-endchoices+1;
  if place < 1 then place := 1;
  if (place+endchoices-1 > totalchoices) and (totalchoices-endchoices-1>0)
    then place := totalchoices-endchoices+1;
End;

Procedure ExplodingMenu.IncCheck;
Var loop: integer;
begin
  Check;
  choices := head;
  for loop := 1 to pred(choice) do choices := choices^.next;
  while not (choices^.attr in [none,quittype,unavail]) do begin
    Inc(Choice);
    Choices := choices^.next;
    if choice > totalchoices then begin
      choice := totalchoices;
      DecCheck;
    end;
  End;
  Check;
end;

Procedure ExplodingMenu.DecCheck;
Var loop: word;
begin
  Check;
  choices := head;
  for loop := 1 to pred(choice) do choices := choices^.next;
  while not (choices^.attr in [none,quittype,unavail]) do begin
    Dec(Choice);
    Choices := head;
    For loop := 1 to pred(choice) do choices := choices^.next;
    if choice < 1 then begin
      Choice := 1;
      IncCheck;
    end;
  End;
  Check;
end;

Procedure ExplodingMenu.GoHome;
begin
  Choice := 1;
  Place := 1;
  inccheck;
end;

Procedure ExplodingMenu.GoEnd;
begin
  Choice := TotalChoices;
  Place := Choice-(endchoices-1);
  if place < 1 then place := 1;
  deccheck;
end;

Procedure ExplodingMenu.GoUp;
begin
  dec(choice);
  deccheck;
end;

Procedure ExplodingMenu.GoDown;
begin
  inc(choice);
  inccheck;
end;

Procedure ExplodingMenu.GoPageUp;
begin
  Dec(choice,endchoices);
  Dec(place,endchoices);
  inccheck;
end;

Procedure ExplodingMenu.GoPageDown;
begin
  Inc(choice,endchoices);
  Inc(place,endchoices);
  deccheck;
end;

Procedure ExplodingMenu.ProcessInput;
Var
  Loop: byte;
  Change,Found: boolean;
  Ch: char;
  i,j: integer;
  mousex,mousey,oldmousey,button: integer;
  diff: integer;
Begin
  drawbox;
  inccheck;

  mousex := 0;
  mousey := 80;
  oldmousey := mousey;
  if mouseinstalled then Setmousepos(mousex,mousey);

  Select := false;
  Quit := false;
  LastChoice := Choice;
  CallUserProc(CallOnMove);

  Repeat
    Update;

    change := false;
    repeat
      if keypressed then begin
        change := true;
        Ch := upcase(readkey);
        case ch of
          #0: begin
            ch := readkey;
            case ch of
              _Home: GoHome;
              _End: GoEnd;
              _Up,_Left: GoUp;
              _Down,_Right: GoDown;
              _PageUp: GoPageUp;
              _PageDown: GoPageDown;
             end;
             beep(150,5);
          End;
          #13,' ': begin
            choices := head;
            for loop := 1 to pred(choice) do choices := choices^.next;
            if (choices^.attr in [none,quittype]) then Select := true;
          end;
          #27: begin
            Quit := true;
            Choice := totalchoices;
          End;
          'A'..'Z','0'..'9',' ': begin
            found := false;
            i := choice;
            choices := head;
            for loop := 1 to i do choices := choices^.next;
            repeat
              inc(i);
              found := (upcase(choices^.desc^[1]) = ch) and (choices^.attr in [quittype,none]);
              choices := choices^.next;
            until found or (i >= totalchoices);

            if not found then begin
              found := false;
              i := 0;
              choices := head;
              repeat
                inc(i);
                found := (upcase(choices^.hotkey) = ch) and (choices^.attr in [quittype,none]);
                choices := choices^.next;
              until found or (i >= totalchoices);
            end;

            if found then begin
              change := true;
              choice := i;
              choices := head;
              i := 0;
              j := 0;
              repeat
                inc(i);
                if (upcase(choices^.hotkey) = ch) and (choices^.attr in [quittype,none]) then inc(j);
                choices := choices^.next;
              until (j = 2) or (i = totalchoices);

              select := false;
              if j = 1 then select := true;
            end;
            check;
          end;
        End;
      End;

      If mouseinstalled then begin
        GetMousePos(mouseX,mouseY,button);
        If (mousey <> oldmousey) then begin
          calluserproc(kpe);
          { Half sensitivity per space }
          diff := abs(integer(mousey) - integer(oldmousey)) div 8 div 2;
          if diff <> 0 then begin
            change := true;
            if mousey < oldmousey then begin
              dec(choice,diff);
              deccheck;
            end;
            if mousey > oldmousey then begin
              inc(choice,diff);
              inccheck;
            end;
            mousex := 0;
            mousey := 80;
            Setmousepos(mousex,mousey);
            oldmousey := mousey;
            { Non-wrap around choice list for the mouse }
            if choice > totalchoices then choice := totalchoices;
            if choice < 1 then choice := 1;
          End;
        end;

        If button <> 0 then begin
          calluserproc(kpe);
          If button = leftb then begin
            choices := head;
            for loop := 1 to pred(choice) do choices := choices^.next;
            if (choices^.attr in [none,quittype]) then Select := true;
          end
          Else if button = rightb then quit := true
          Else begin
            blip;
            repeat until not mousepressed;
          End;
        End;
      End;
    Until Change or select or quit;

    If (choice <> lastchoice) then begin
      CallUserProc(CallOnMove);
      LastChoice := Choice;
    end;

  Until (Select or quit) and ((not mouseinstalled) or (not mousepressed));

  Update;

  If quit or select then begin
    choices := head;
    for loop := 1 to pred(choice) do choices := choices^.next;
    if choices^.attr and Quittype = quittype then quit := true;
  end;
End;

Destructor ExplodingMenu.Done;
Begin
  { Finish up the box }
  if boxonscreen then menu.done(colorcfg.closespeed);
  inherited done;
end;

Begin
  Touchres := '';
  ColorCfg := DefaultColors;
End.
