/*****************************************************************************
 *
 * $Id: nu-door.c,v 1.2 2003/02/23 15:03:18 mbroek Exp $
 * Purpose ...............: Message to next User door
 *
 *****************************************************************************
 * Copyright (C) 2003
 *   
 * Michiel Broek		FIDO:		2:280/2802
 * Beekmansbos 10
 * 1971 BV IJmuiden
 * the Netherlands
 *
 * This file is part of Next User door for Unix.
 *
 * This door is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Nextuser door is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MBSE BBS; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "../config.h"
#include <stdlib.h>
#include <door.h>


int	iLine = 1;

char	sFrom[81];
char	To[81];
char	Subject[81];

void	strreplace(char *s, char *, char *);
int	finish(void);
void	addlines(void);

char	*sLiNE[11];

char	*logfile = NULL;
char	*bbsname = NULL;
char	*outansi = NULL;
char	*outascii = NULL;
char	*quote = NULL;


keytab_t keytab[] = {
    {(char *)"logfile",	    door_parse_getstr,	    (char **)&logfile},
    {(char *)"bbsname",	    door_parse_getstr,	    (char **)&bbsname},
    {(char *)"outansi",	    door_parse_getstr,	    (char **)&outansi},
    {(char *)"outascii",    door_parse_getstr,	    (char **)&outascii},
    {(char *)"quote",	    door_parse_getstr,	    (char **)&quote},
    {NULL,		    NULL,		    NULL}
};



int main(int argc, char **argv)
{
    int i;

    /*
     * Initialize and load configuration.
     */
    if (argc != 2) {
	fprintf(stderr, "Usage: %s /path/to/configfile\n\n", argv[0]);
	exit(1);
    }
    if (door_parse_config(argv[1], keytab)) {
	fprintf(stderr, "Parsing configuration failed\n\n");
	exit(1);
    }
    door_loginit(logfile, (char *)"nu-door", FALSE);
    door_log(' ', "");
    door_log(' ', "NU-DOOR v%s", VERSION);

    /*
     * Now basic stuff is setup and logging is available.
     */
    if (door_load_doorsys() == FALSE) {
	exit(1);
    }

    for (i = 0; i < 11; i++)
	*(sLiNE + i) = (char *) calloc(81, sizeof(char));

    door_log('+', "User \"%s\" starts Next User Door", doorsys.username);
    addlines();
    while (TRUE) {
	if (finish() == TRUE)
	    break;
    }

    for (i = 0; i < 11; i++)
	free(*(sLiNE + i));

    door_log(' ', "NU-DOOR finished");
    door_color(LIGHTGRAY, BLACK);
    return 0;
}



void addlines(void)
{
    int	    i;

    iLine = 1;
    door_clear();

    door_cout(WHITE, BLACK, (char *)"Message to Nextuser Door");
    door_enter(2);
    door_cout(YELLOW, BLACK, (char *)"The FROM, TO and SUBJECT fields are optional.");
    door_enter(2);
    door_cout(LIGHTRED, BLACK, (char *)"   From: ");
    door_color(LIGHTBLUE, BLACK);
    fflush(stdout);
    door_getname(sFrom, 36);

    door_cout(LIGHTRED, BLACK, (char *)"     To: ");
    door_color(LIGHTBLUE, BLACK);
    fflush(stdout);
    door_getname(To, 36);

    door_cout(LIGHTRED, BLACK, (char *)"Subject: ");
    door_color(LIGHTBLUE, BLACK);
    fflush(stdout);
    door_getstr(Subject, 70);

    door_enter(2);
    door_cout(LIGHTGREEN, BLACK, (char *)"Type up to 10 lines 74 Characters per line");
    door_enter(1);

    door_color(YELLOW, BLACK);
    printf("  ");
    for (i = 0; i <= 75; i++)
	printf("");
    printf("");
    door_enter(1);

    while (TRUE) {
	door_color(LIGHTRED, BLACK);
	printf("%d: ", iLine);
	door_color(LIGHTBLUE, BLACK);
	fflush(stdout);
	door_getstr(*(sLiNE + iLine), 75);

	if ((strcmp(*(sLiNE + iLine), "")) == 0)
	    return;

	iLine++;
	if (iLine >= 11)
	    break;
    }

    door_cout(YELLOW, BLACK, (char *)"  ");
    for (i = 0; i <= 75; i++)
	printf("");
    printf("");
    door_enter(1);
}



/*
 * Find & Replace string in a string
 */
void strreplace(char *sStr, char *sFind, char *sReplace)
{
    char    sNewstr[81]="", *posStr, *posFind;
    int	    iPos, iLen, iCounter;

    posStr = sStr;
    if ((posFind = strstr(sStr, sFind)) != NULL) {
	iPos = (int)(posFind - posStr);
	strncpy(sNewstr, sStr, iPos);
	strcat(sNewstr, sReplace);
	iPos+= strlen(sFind);
	iLen = strlen(sNewstr);
	for (iCounter=0; iCounter < (strlen(sStr) - iPos); iCounter++)
	    sNewstr[iCounter + iLen] = sStr[iCounter + iPos]; 
	sNewstr[iCounter+1+iLen] = '\0';
	strcpy(sStr, sNewstr);
    }
}




/* Save Abort File */
int finish(void)
{
    FILE    *pTextFileANS, *pTextFileASC;
    int	    iStrLen, i, x, NLChk = FALSE;
    char    *temp, *temp1;

    temp  = calloc(PATH_MAX, sizeof(char));
    temp1 = calloc(PATH_MAX, sizeof(char));

    while (TRUE) {
	door_enter(1);
	door_cout(WHITE, BLACK, (char *)"Functions available:");
	door_enter(2);
	door_cout(WHITE, BLUE, (char *)"(L)ist, (R)eplace text, (E)dit line, (A)bort, (S)ave");
	door_enter(2);
  	door_cout(WHITE, BLACK, (char *)"Select: ");
	fflush(stdout);

	door_alarm_on();
	i = toupper(door_getch());
	door_color(CYAN, BLACK);
	printf("%c", i);
	door_enter(1);

	if (i == 'A') {
	    /* Aborting... */
	    door_cout(YELLOW, BLACK, (char *)"Aborting...");
	    door_enter(1);
	    door_enter(1);
	    door_color(WHITE, BLACK);
	    printf("Returning to %s ", bbsname);
	    door_enter(2);
	    sleep(2);
	    door_log('+', "User aborted message and exited door");
	    free(temp);
	    free(temp1);
	    return TRUE;
	} else if (i == 'E') {
	    printf("\n %s", (char *)"Edit which line:");
	    door_getstr(temp, 10);

	    if ((strcmp(temp, "")) == 0)
		break;

	    i = atoi(temp);
	    if( i > iLine - 1) {
		printf("%s\n", (char *)"Line does not exist.");
		break;
	    }
	    x = strlen(sLiNE[i]);
	    printf("%d : %s", i, *(sLiNE + i));           
	    fflush(stdout);
	    door_getstrp(sLiNE[i],74, x);				                                            
	} else if (i == 'L') {
	    door_color(YELLOW, BLACK);
	    printf("\n\n  ");
	    for (i = 0; i <= 75; i++)
		printf("");
	    printf("");
	    door_enter(1);

	    for (i = 1; i < iLine; i++) {
		door_color(LIGHTRED, BLACK);
		printf("%d: ", i);
		door_color(LIGHTBLUE, BLACK);
		printf("%s\n", *(sLiNE + i));
	    }

	    door_color(YELLOW, BLACK);
	    printf("  ");
	    for (i = 0; i <= 75; i++)
		printf("");
	    printf("\n");
	} else if (i == 'S') {
			
	    /* 
	     * Open TextFile for Writing NextUser Info 
	     */
	    if ((pTextFileANS = fopen(outansi, "w")) == NULL) {
		door_log('?', "$Can't open file: %s", outansi);
		return TRUE;
	    }
	    if ((pTextFileASC = fopen(outascii, "w")) == NULL) {
		door_log('?', "$Can't open file: %s", outascii);
		return TRUE;
	    }

	    fprintf(pTextFileANS, "%s%s%s%s", ANSI_CLEAR, ANSI_NORMAL, ANSI_WHITE, ANSI_BOLD);

	    if ((iStrLen = strlen(sFrom)) > 1) {
		fprintf(pTextFileANS, "%s\x1B[1;4HFrom:%s %s\n", ANSI_RED, ANSI_BLUE, sFrom);
		fprintf(pTextFileASC, "\n   From: %s\n", sFrom);
		door_log('+', "   From: %s", sFrom);
       		NLChk = TRUE;
	    }

	    if ((iStrLen = strlen(To)) > 1) {
		fprintf(pTextFileANS, "%s\x1B[2;6HTo:%s %s\n", ANSI_RED, ANSI_BLUE, To);
		fprintf(pTextFileASC, "     To: %s\n", To);
		door_log('+', "     To: %s", To);
       		NLChk = TRUE;
	    }

	    if ((iStrLen = strlen(Subject)) > 1) {
		fprintf(pTextFileANS, "%sSubject:%s %s\n\n", ANSI_RED, ANSI_BLUE, Subject);
		fprintf(pTextFileASC, "Subject: %s\n\n", Subject);
		door_log('+', "Subject: %s", Subject);
       		NLChk = TRUE;
	    }

	    if (!NLChk) {
		fprintf(pTextFileANS, "\n");
		fprintf(pTextFileASC, "\n");
	    }

	    fprintf(pTextFileANS,"%s",ANSI_YELLOW);
	    for (i = 0; i <= 75; i++) {
		fprintf(pTextFileANS,"");
		fprintf(pTextFileASC,"=");
	    }
	    fprintf(pTextFileANS,"\n");
	    fprintf(pTextFileASC,"\n");

	    for (i = 0; i < iLine; i++) {
		if ((iStrLen = strlen( *(sLiNE + i) )) > 0) {
		    fprintf(pTextFileANS, " %s%s\n", ANSI_BLUE, *(sLiNE + i));
		    fprintf(pTextFileASC, " %s\n", *(sLiNE + i));
		}
	    }

	    door_enter(2);
	    door_cout(LIGHTRED, BLACK, (char *)"Saving...");
	    fprintf(pTextFileANS,"%s",ANSI_YELLOW);
	    for (i = 0; i <= 75; i++) {
		fprintf(pTextFileANS,"");
		fprintf(pTextFileASC,"=");
	    }
	    fprintf(pTextFileANS,"\n");
	    fprintf(pTextFileASC,"\n");

	    fprintf(pTextFileANS, "%s%s", ANSI_RED, quote);
	    fprintf(pTextFileASC, "%s", quote);

	    fclose(pTextFileANS);
	    fclose(pTextFileASC);   
	    door_color(LIGHTBLUE, BLACK);
	    printf("\n%s%s\n", (char *)"Returning to ", bbsname);
	    fflush(stdout);

	    door_log('+', "User Saved Nextuser message and exited door");
	    free(temp);
	    free(temp1);
	    sleep(2);
	    return TRUE;
	} else if (i == 'R') {
	    door_color(WHITE, BLACK);
	    printf("\n%s", (char *)"Edit which line:");
	    door_getstr(temp, 80);

	    if ((strcmp(temp, "")) == 0)
		break;

	    i = atoi(temp);

	    if (i > iLine - 1) {
		printf("\n%s", (char *)"Line does not exist.");
		break;
	    }

	    door_enter(1);
	    door_color(WHITE, BLACK);
	    door_cout(WHITE, BLACK, (char *)"Line reads:");
	    door_enter(1);
	    printf("%2d: %s\n", i, *(sLiNE + i));

	    door_enter(1);
	    door_cout(WHITE, BLACK, (char *)"Text to replace:");
	    door_getstr(temp, 80);

	    if ((strcmp(temp, "")) == 0)
		break;

	    door_cout(WHITE, BLACK, (char *)"Replacement text:");
	    door_getstr(temp1, 80);

	    if ((strcmp(temp1, "")) == 0)
		break;

	    strreplace(*(sLiNE + i), temp, temp1);
	} else
	    printf("\n");
    }
    
    free(temp);
    free(temp1);
    return FALSE;
}

