/***************************************************************************/
/*                                                                         */
/* IniClear.Cmd                                                            */
/*                                                                         */
/* This command file takes a text file containing the names of your file   */
/* areas and removes the entries in your OS2.INI user file that correspond */
/* to them.                                                                */
/*                                                                         */
/* WARNING: MAKE SURE YOU HAVE A BACKUP OF YOUR OS2.INI *BEFORE* YOU RUN   */
/* THIS REXX SCRIPT.                                                       */
/*                                                                         */
/* The file that this REXX file expects as input should have ONE file area */
/* name listed per line, in the same manner as the ALLFILES.CFG that is    */
/* used for the All Files List generator code.                             */
/*                                                                         */
/***************************************************************************/
'@ECHO OFF'

/* Change this to point to the list of your file areas */
FileAreas = 'areas.lst'

/* Load the RexxUtil INI file function */
Call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'

/* If the file area file exists, hammer the INI entries */
If Stream(FileAreas, 'c', 'query exists')<>'' Then Do
    Call CharOut , 'Working...'

    Call SysIni 'USER', 'MaxFilePM', 'DELETE:'

    Do Until Lines(FileAreas)=0
        AppName = LineIn(FileAreas)
        Call SysIni 'USER', AppName, 'DELETE:'
    End

    Call Stream FileAreas, 'c', 'close'
    Say
    Say 'Done!'
End
