/*͸
   OS/2 Video API Version 1.00  04-09-96    (C) 1996 by CodeLand Australia 
   LIST.H                                              All Rights Reserved 
  ;*/

#define MAXLIST 1024

/* List item record definition */
typedef struct _listitem {
    CHAR data[64];          /* Address of selection string     */
    SHORT tagid;            /* Tag identifier                  */
} LISTITEM;
typedef LISTITEM * PLISTITEM;

/* ListBox record definition */
typedef struct _list {
    /* Set by ListBeg() */
    UCHAR srow;                  /* Starting row of list window      */
    UCHAR scol;                  /* Starting column of list window   */
    UCHAR erow;                  /* Ending row of list window        */
    UCHAR ecol;                  /* Ending column of list window     */
    UCHAR btype;                 /* List window border type          */
    UCHAR battr;                 /* List window border attribute     */
    UCHAR wattr;                 /* List window attribute            */
    VOID (*open) (VOID);         /* Address of post-opening function */
    UCHAR usecurr;               /* Will list use current window?    */
    SHORT DisplayCount;          /* Number of display rows           */
    /* Set by ListEnd() */
    UCHAR barwidth;              /* Width of list bar or zero        */
    UCHAR textpos;               /* Offset of text from start of bar */
    UCHAR textattr;              /* Attribute of list text           */
    UCHAR barattr;               /* Attribute of selection bar       */
    /* Set by ListItem() */
    SHORT ListItemNum;           /* Number of items in list          */
    PLISTITEM ListItem[MAXLIST]; /* List item array                  */
    /* Set by ListGet() */
    SHORT ListItemCur;           /* Number of current item           */
    SHORT DisplayOffset;         /* Item display offset              */
} LIST;
typedef LIST * PLIST;

/**/

SHORT ListBeg (PLIST *Plist, SHORT srow, SHORT scol, SHORT length, SHORT width,
    SHORT btype, SHORT battr, SHORT wattr, VOID (*open)(VOID));
SHORT ListBegC (PLIST *Plist, SHORT srow, SHORT scol, SHORT length, SHORT width);
SHORT ListItem (PLIST Plist, PCHAR str, SHORT tagid);
SHORT ListEnd (PLIST Plist, SHORT taginit, SHORT textattr, SHORT barattr);
SHORT ListGet (PLIST Plist);

/**/

