/*͸
   UED - the Maximus-CBCS User Base Editor  (C) 1997 by CodeLand Australia 
   UED.C Main program routines                         All Rights Reserved 
  ;*/

/* Source Files:

    UED.C                                           Top level
        EDIT.C BROWSE.C STAT.C                      Secondary level
            SEARCH.C SORT.C DESC.C                  Aux level
                CFG.C PRM.C UTIL.C USER.C           Util & API level
                    FORM.C MENU.C WIN.C VID.C       Video API

*/

/**/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <signal.h>
#include <dos.h>
#include <ctype.h>

#define INCL_DOS
#include <os2.h>

#include "md5.h"
#include "vid.h"
#include "win.h"
#include "menu.h"
#include "form.h"
#include "user.h"
#include "ued.h"

/**/

USHORT MainStat=STAT_NONE;              /* Main loop status                 */
USHORT MenuStat=MENU_NONE;              /* Popup menu status                */
PUDEF Ud;                               /* Main user file structure pointer */
SHORT CurRec;                           /* Current record pointer           */

/* Screen colours */
SHORT nattr   = BLUE  |_CYAN  ;           /* Colour - field no edit         */
SHORT battr   = WHITE |_BLUE  ;           /* Colour - window borders        */
SHORT wattr   = LCYAN |_BLUE  ;           /* Colour - window body           */
SHORT qattr   = YELLOW|_BLUE  ;           /* Colour - windows headings      */
SHORT fattr   = LGREY |_BLACK ;           /* Colour - window fields         */
SHORT hattr   = LCYAN |_BLACK ;           /* Colour - window fld highlights */
SHORT sattr   = WHITE |_BLACK ;           /* Colour - window fld special    */
SHORT selbar  = BLUE  |_LGREY ;           /* Colour - window menu bar       */
SHORT nosel   = LGREY |_BLUE  ;           /* Colour - window menu bar nosel */
SHORT battr2  = BLUE  |_LGREY ;           /* Colour - window borders        */
SHORT wattr2  = BLUE  |_LGREY ;           /* Colour - window body           */
SHORT qattr2  = LBLUE |_LGREY ;           /* Colour - windows headings      */
SHORT fattr2  = LGREY |_BLACK ;           /* Colour - window fields         */
SHORT hattr2  = LCYAN |_BLACK ;           /* Colour - window fld highlights */
SHORT sattr2  = WHITE |_BLACK ;           /* Colour - window fld special    */
SHORT selbar2 = LGREY |_BLUE  ;           /* Colour - window menu bar       */
SHORT nosel2  = BLACK |_LGREY ;           /* Colour - window menu bar nosel */
BOOL IsRegistered=FALSE;
SHORT bdr     = 0;

CHAR Yes[]="YES";
CHAR No[]=" NO";
CHAR On[]=" ON";
CHAR Off[]="OFF";

static VOID (*MainWin)(VOID);          /* Function pointer to main screen  */
static USHORT AutoSeek=0;              /* Auto seek setting                */
static CHAR UnDoPrompt[50];            /* Profile restore prompt           */

SHORT RegWriteCount = 0;

/**/

/* Used by TheMenu() */
static VOID PreCfg (VOID);
static VOID PreIndex (VOID);
static VOID Index (VOID);
static VOID ChangeDir (VOID);

/* Misc user file functions */
static SHORT PASCAL OpenUserFile (VOID);
static VOID AddRec (VOID);
static VOID Purge (VOID);
static VOID PackDesc (VOID);
static SHORT PASCAL MaxActive (VOID);
static VOID UpGrde_1 (VOID);
static VOID UpGrde_2 (VOID);
static VOID UpGrde_3 (VOID);
static VOID UpGrde_4 (VOID);
static VOID UpGrde_5 (VOID);
static VOID UpGrde_6 (VOID);
static VOID UpGrde_7 (VOID);
static VOID UpGrde_8 (VOID);
static VOID UpGrde_9 (VOID);
static VOID UpGrde_A (VOID);
static VOID UpGrde_B (VOID);
static VOID UpGrde_C (VOID);
static VOID UpGrde_D (VOID);
static VOID UpGrde_E (VOID);
static VOID UpGrde_F (VOID);
static VOID UpGrde_G (VOID);
static VOID UpGrde_R (VOID);
static VOID PASCAL GetRelDateTime (SCOMBO *pt, USHORT XpMths);

/* Util */
static SHORT PASCAL Expired (VOID);
static SHORT PASCAL Registered (VOID);
static PCHAR GetCode (PCHAR Name, PCHAR City);
VOID PASCAL SetHandler (VOID);
VOID ReleaseHandler (VOID);
VOID OS2CtrlCHandler (VOID);
VOID (_interrupt _far *OldDosCtrlCHandler) (VOID);
VOID (_interrupt _far *OldDosCtrlBHandler) (VOID);
VOID _interrupt _far DosCtrlCHandler (VOID);
VOID _interrupt _far DosCtrlBHandler (VOID);

/* Init */
static VOID PASCAL GetCmdLine (SHORT argc, PCHAR argv[]);
static VOID PASCAL SyntaxExit (VOID);

/**/

VOID main (SHORT argc, PCHAR argv[])
{
    SHORT Done=0;
    PUSHORT ScrnSave;

    GetCmdLine(argc,argv); /* Get command line & setup */

    /* Define the user file */
    if(UserDefOpen(&Ud,UedCfg.MaxPath,UedCfg.UserFile,UedCfg.AreaFile)) {
        fprintf(stderr,"\aERROR Creating API definition!\n");
        Exit(1);
    }

    /* Save screen and display background */
    ScrnSave=VidSSave(); VidHideCur(); VidcClrScrn(0xB0,WHITE|_LGREY);

    /* Set main screen */
    MainWin=UedCfg.DefaultScreen?BrowseScreen:EditScreen;

    if(OpenUserFile()) { /* Open the user file */
        /* Maximum record count check */
        if(Ud->Unum>U_MR) {
            UserClose(Ud); /* Close the user file */
            UserDefClose(Ud); /* Close main user definition */
            VidSRestore(ScrnSave); VidShowCur();
            fprintf(stderr,"\aERROR Too many records!\n");
            Exit(1);
        }

        /* Autosort option */
        if(UedCfg.SortTyp || UedCfg.SortDir) {
            SortTyp=UedCfg.SortTyp;
            SortDir=UedCfg.SortDir;
            TitleWindow(0); /* Display title window */
            Sort(9);
            WinClose();
        }

        /* Start at specific record */
        if(AutoSeek>0) CurRec=AutoSeek<Ud->Unum?AutoSeek-1:Ud->Unum-1;

        while(!Done) {
            MainStat=STAT_NONE;
            MainWin(); /* Run the display window (Edit/Browse) */
            switch(MainStat) {
                case STAT_NONE:
                case STAT_QUIT:
                    ++Done;
                    break;
                case STAT_BROW:
                    MainWin=BrowseScreen;
                    break;
                case STAT_EDIT:
                    MainWin=EditScreen;
                    break;
            }
        }

        UserClose(Ud); /* Close the user file */
    }

    /* Restore the screen and cursor */
    VidSRestore(ScrnSave); VidShowCur();

    UserDefClose(Ud); /* Close main user definition */
    StatFree();       /* Close stats if any         */
    Exit(0);
}

/**/

VOID PASCAL Exit (SHORT Status)
{
    exit(Status);
}

/**/

/*
Ŀ
 File   About   Statistics   Global   Configuration   Index     QUIT 

*/
VOID PASCAL TheMenu (VOID)
{
    CHAR sort_dir[11], schar, Sound[18], Debug[18];

    MenuStat=MENU_NONE; /* Cancel the pop-up status */

    strcpy(sort_dir,SortDir?"Reverse":"Normal ");
    schar=(CHAR)(SortDir?'R':'N');
    strcpy(Sound,UedCfg.NoSound?"Use Sound    OFF":"Use Sound     ON");
    strcpy(Debug,UedCfg.Maintenance?"Maintenance   ON":"Maintenance  OFF");

    MenuBeg(2,3,4,74,bdr,BLUE|_LGREY,LGREY|_BLUE,PreMenu);
    MenuItem( 0, 1,"File"           ,'F', 1,M_HASPD,NULL   ,0,0);
     MenuBeg(4,3,7,23,bdr,battr2,wattr2,PreMenu);
     MenuItem(0,0,"Append New Record",'A',31,M_CLALL,AddRec , 0,0);
     MenuItem(1,0,"Pack User File"   ,'P',32,M_CLALL,Purge  , 0,0);
     MenuEnd(31,M_PD|M_SAVE,99,1,wattr2,qattr2,nosel2,WHITE|_RED);
    MenuItem( 0, 8,"About"          ,'A', 2,0      ,ShowVer,0,0);
    MenuItem( 0,16,"Statistics"     ,'S', 3,M_HASPD,NULL   ,0,0);
     MenuBeg( 4,18,11,38,bdr,battr2,wattr2,PreMenu);
     MenuItem(0,0,"Global Statistics", 'S',91,0,     StatGlob,0,0);
     MenuItem(1,0,"Call Percentages",  'P',92,0,     StatPriv,0,0);
     MenuItem(2,0,"Best Ten Users",    'B',93,0,     StatBest,0,0);
     MenuItem(3,0,"Top Ten Callers",   'C',94,0,     StatCall,0,0);
     MenuItem(4,0,"Top Ten Uploaders", 'U',95,0,     StatUpld,0,0);
     MenuItem(5,0,"Top Ten Dnloaders", 'D',96,0,     StatDnld,0,0);
     MenuEnd(91,M_PD|M_SAVE,99,1,wattr2,qattr2,nosel2,WHITE|_RED);
    MenuItem( 0,29,"Global"         ,'G', 4,M_HASPD,NULL   ,0,0);
     MenuBeg( 4,31, 7,47,bdr,battr2,wattr2,PreMenu);
     MenuItem( 0, 0,"Global Delete",   'G',60,0, GlobalDelete,0,0);
     /* MenuItem( 1, 0,"Global Expiry",   'E',61,M_NOSEL, GlobalExp,0,0); */
     MenuItem( 1, 0,"Key Setting",     'K',62,0, GlobalKeys,0,0);
     /* MenuItem( 3, 0,"Credit/Debit",    'C',63,M_NOSEL, GlobalCdt,0,0); */
     MenuEnd(60,M_PD|M_SAVE,99,1,wattr2,qattr2,nosel2,WHITE|_RED);
    MenuItem( 0,38,"Configuration"  ,'C', 5,M_HASPD,NULL   ,0,0);
     MenuBeg( 4,40,17,59,bdr,battr2,wattr2,PreCfg);
     MenuItem( 0,0,"Maximus Path",    'P',41,0,       CfgPath, 0,0);
     MenuItem( 1,0,"File Names",      'F',42,0,       CfgName, 0,0);
     MenuItem( 2,0,"Date Format",     'D',43,0,       CfgDate, 0,0);
     MenuItem( 3,0,Sound,             'S',44,0,       CfgSound,0,0);
     MenuItem( 4,0,"Auto Sort",       'A',45,0,       CfgSort, 0,0);
     MenuItem( 5,0,"Initial Screen",  'I',46,0,       CfgView, 0,0);
     MenuItem( 6,0,Debug,             'M',47,0,       CfgDebug,0,0);
     MenuItem( 7,0,"Key Labels",      'K',48,0,       CfgLabel,0,0);
     MenuItem( 8,0,"Upgrade Profile", 'U',49,0,       CfgUpg,  0,0);
     MenuItem( 9,0,"Registration",    'R',50,IsRegistered?M_NOSEL:0,CfgReg,  0,0);
     MenuItem(11,0,"Save Changes",    'C',51,M_CLALL, CfgWrite,0,0);
     MenuEnd(41,M_PD|M_SAVE,99,1,wattr2,qattr2,nosel2,WHITE|_RED);
    MenuItem( 0,54,"Index"          ,'I', 6,M_HASPD,NULL   ,0,0);
     MenuBeg(4,56,22+UedCfg.Maintenance,69,bdr,BLUE|_LGREY,BLUE|_LGREY,PreIndex);
     MenuItem( 0, 0,sort_dir,schar,70,0,          ChangeDir, 0,0);
     MenuItem( 2, 0,SortStr[ 0],SortChr[ 0],71,M_CLALL, Index,  0,0);
     MenuItem( 3, 0,SortStr[ 1],SortChr[ 1],72,M_CLALL, Index,  0,0);
     MenuItem( 4, 0,SortStr[ 2],SortChr[ 2],73,M_CLALL, Index,  0,0);
     MenuItem( 5, 0,SortStr[ 3],SortChr[ 3],74,M_CLALL, Index,  0,0);
     MenuItem( 6, 0,SortStr[ 4],SortChr[ 4],75,M_CLALL, Index,  0,0);
     MenuItem( 7, 0,SortStr[ 5],SortChr[ 5],76,M_CLALL, Index,  0,0);
     MenuItem( 8, 0,SortStr[ 6],SortChr[ 6],77,M_CLALL, Index,  0,0);
     MenuItem( 9, 0,SortStr[ 7],SortChr[ 7],78,M_CLALL, Index,  0,0);
     MenuItem(10, 0,SortStr[ 8],SortChr[ 8],79,M_CLALL, Index,  0,0);
     MenuItem(11, 0,SortStr[ 9],SortChr[ 9],80,M_CLALL, Index,  0,0);
     MenuItem(12, 0,SortStr[10],SortChr[10],81,M_CLALL, Index,  0,0);
     MenuItem(13, 0,SortStr[11],SortChr[11],82,M_CLALL, Index,  0,0);
     MenuItem(14, 0,SortStr[12],SortChr[12],83,M_CLALL, Index,  0,0);
     MenuItem(15, 0,SortStr[13],SortChr[13],84,M_CLALL, Index,  0,0);
     MenuItem(16, 0,SortStr[14],SortChr[14],85,M_CLALL, Index,  0,0);
     if(UedCfg.Maintenance) MenuItem(17, 0,SortStr[15],SortChr[15],86,M_CLALL,Index,0,0);
     MenuEnd(70,M_PD|M_SAVE,99,1,wattr2,qattr2,nosel2,WHITE|_RED);
    MenuItem( 0,65,"QUIT"           ,'Q', 7,0      ,NULL   ,0,0);
    MenuEnd(7,M_HORZ|M_SAVE,0,0,LGREY|_BLUE,WHITE|_BLUE,BLACK|_BLUE,WHITE|_RED);
    if(MenuGet()==7) MenuStat=MENU_QUIT;
}

/**/

VOID ShowVer (VOID)
{
    if(TitleWindow(3)) { MenuWaitKeyT(360); WinClose(); }
}

/**/

/*
Ŀ
           UED -- the Maximus BBS User Base Editor           
                  Version 3.00 12 Jun 1995                   
                                                             
    External User Base editor for the Maximus BBS package    
                                                             
  (C) Copyright 1990-1997 by CodeLand, All Rights Reserved.  
          P.O.Box 351 Kalamunda W.A. 6076 Australia          
             Written by Colin Wheat of 3:690/613             
   Original UEDit OS/2 port by Graham J Stair of 3:711/409   
                                                             
          The Maximus Bulletin Board Package, V3.XX          
    Maximus (C) Copyright 1989-1996 by Lanius Corporation    
                                                             
                WARNING  UNREGISTERED VERSION                
     Please register, after a suitable evaluation period     

*/
SHORT PASCAL TitleWindow (SHORT offset)
{
    /* #define T_BACK _CYAN */
    #define T_BACK _CYAN

    if(!WinOpen(2+offset,8,18+offset,70,0,WHITE|T_BACK,WHITE|T_BACK)) return 0;
    WINSHADOW();
    WinCenters( 0,WHITE|T_BACK,"UED - the Maximus BBS User Base Editor");
#if defined(BETAVERSION)
    WinCenters( 1,RED|T_BACK,"** BETA VERSION " VERSION " 05 NOV 1996 **");
#else
    WinCenters( 1,RED|T_BACK,"Version " VERSION " 28 Apr 1997");
#endif
    WinCenters( 3,YELLOW|T_BACK,"External User Base Editor for the Maximus BBS package");
    WinCenters( 5,LCYAN|T_BACK,"(C) Copyright 1990-1997 by CodeLand, All Rights Reserved.");
    WinCenters( 6,LCYAN|T_BACK,"P.O.Box 351 Kalamunda W.A. 6076 Australia");
    WinCenters( 7,LCYAN|T_BACK,"Written by Colin Wheat of 3:690/613");
    WinCenters( 8,LCYAN|T_BACK,"Original UEDit OS/2 port by Graham J Stair of 3:711/409");
    WinCenters(10,BLUE|T_BACK,"The Maximus Bulletin Board Package, V3.XX");
    WinCenters(11,BLUE|T_BACK,"Maximus (C) Copyright 1989-1996 by Lanius Corporation");

    if(IsRegistered) {
        WinPrintS(13,2,BLACK|T_BACK,"Registered   :");
        WinPrintS(14,2,BLACK|T_BACK,"Version      :");
        WinPrintS(13,17,WHITE|T_BACK,UedCfg.RegName);
        WinPrintS(14,17,WHITE|T_BACK,UedCfg.RegCity);
    }
    else {
        WinCenters(13,RED|T_BACK,"WARNING  UNREGISTERED VERSION");
        WinCenters(14,RED|T_BACK,"Please register, after a suitable evaluation period");
    }

    return 1;
}

/**/

static VOID PreCfg (VOID)
{
    WINSHADOW();
    WinHLine(10,0,18,bdr,battr2);
}

/**/

static VOID PreIndex (VOID)
{
    WINSHADOW();
    WinHLine(1,0,13,bdr,battr2);
}

/**/

static VOID Index (VOID)
{
    struct _item_t *citem;

    /* Get sort type from the menu */
    citem=MenuICurr(); SortTyp=(citem->tagid)-71;
    if(SortTyp<0||SortTyp>(_SORT_NUM-2)+UedCfg.Maintenance) return;

    if(Sort(0)) MenuStat=MENU_SORT;
}

/**/

static VOID ChangeDir (VOID)
{
    struct _item_t *citem;
    CHAR *str, *sch;

    citem=MenuICurr();
    str=citem->str; sch=&(citem->schar);
    SortDir^=1;
    strcpy(str,SortDir?"Reverse":"Normal ");
    *sch=(CHAR)(SortDir?'R':'N');
    citem->redisp=1;
}

/**/

/* Returns true on success */
static SHORT PASCAL OpenUserFile (VOID)
{
    SHORT Status;

    /* Create index array */
    if(UserIdxCreate(Ud)) return 0;

    /* Open the user file */
    Status=UserOpen(Ud);
    if(Status) {
        /* Error accessing files! */
        TitleWindow(0); /* Display title window */

        switch(Status) {
            case -1: /* File Open Fail */
            case -3: /* User.Bbs Read Fail */
                if(!YesNo("User file not found, create it?",20,8,22,70)) {
                    WinClose(); return 0;
                }
                else {
                    if(UserCreate(Ud)) { WinClose(); return 0; }
                    UserDefault(Ud);
                    UserAppend(Ud);
                }
                break;
            case -2: /* Out Of Memory */
                WinClose(); return 0;
                break;
            case -4: /* User.Idx Open Fail */
                if(!YesNo("Idx file not found, create it?",20,8,22,70)) {
                    WinClose(); return 0;
                }
                else {
                    /* Create the IDX file */
                    USHORT i;

                    if(NdxCreate(Ud)) { WinClose(); return 0; }
                    NdxClose(Ud);
                    if(UserOpen(Ud)) { WinClose(); return 0; }
                    for(i=0;i<Ud->Unum;i++) {
                        UserRead(Ud,i);
                        Ud->UsrNdx->hash_name=UserHash(Ud->Usr->name);
                        Ud->UsrNdx->hash_alias=UserHash(Ud->Usr->alias);
                        NdxWrite(Ud,i);
                    }
                }
                break;
        }

        WinClose(); /* Close title screen */
    }
    else {
        if(!IsRegistered) { /* Nag unregistered user */
            TitleWindow(3);     /* Display title window */
            MenuDelay(180);      /* Force 10 second pause */
            WinCenters(14,RED|T_BACK,"             Press any key to continue             ");
            MenuWaitKeyT(180);  /* Wait for key or 10 seconds */
            MenuClearKeys();
            WinClose();
        }
    }

    CurRec=0;
    return 1;
}

/**/

/* Appends a new user record to the user file */
static VOID AddRec (VOID)
{
    if(!YesNo("Append a New Record?",11,22,13,55)) return; /* Confirm action */

    UserDefault(Ud); /* Clear record */

    Mesage("Selecting Unique LR Pointer",11,20,13,60);

    /* Append it to the user file */
    if(0==UserAppend(Ud)) {
        CurRec=Ud->Unum-1; /* Goto the new record */
        MenuStat=MENU_NEWR;
        TONEFOUND();
    }

    WinClose();
}

/**/

/* Purge the user file */
static VOID Purge (VOID)
{
    USHORT i, Usiz, Error, PurgCount;
    PUDEF Ut;         /* Temp user file structure pointer   */
    PUSHORT Parray;   /* Purge aray                         */
    CHAR buf[16];     /* String display temp buffer         */

    if(MaxActive()) {
        Mesage("Maximus Task Found Active!",11,22,13,55);
        TONEERROR(); MenuWaitKeyT(17); WinClose();
        return;
    }

    if(!YesNo("Pack the User File?",11,22,13,55)) return; /* Confirm action */

    /* Get memory for purge array */
    if((Parray=(PSHORT)malloc(sizeof(SHORT)*U_MR))==NULL) return;

    /* Define the temp user file */
    if(UserDefOpen(&Ut,UedCfg.MaxPath,"Utmp",UedCfg.AreaFile)) {
        free(Parray); return;
    }

    UserDelete(Ut); /* Delete temp file if exists */

    if(UserCreate(Ut)) {
        UserDefClose(Ut); /* Close temp user definition */
        free(Parray);
        return;
    }

    /* Set copy siz to minimum size of the two bases, for safety */
    Usiz=Ut->Usiz; if(Ud->Usiz<Usiz) Usiz=Ud->Usiz;

    /* Open the status window */
    WinOpen(11,27,13,53,bdr,WHITE|_RED,WHITE|_RED);
    WinPrintS(0,1,WHITE|_RED,"Writing Record    00001");

    for(i=0,Error=0,PurgCount=0;i<Ud->Unum;i++) {
        if(!((i+1)%10)) {
            sprintf(buf,"%05u",i+1);
            WinPrintS(0,19,WHITE|_RED,buf);
        }

        if(UserIdxRead(Ud,i)) { ++Error; break; }

        if(i==0||Ud->Usr->delflag&UFLAG_PERM||!(Ud->Usr->delflag&UFLAG_DEL)) {
            /* Save the record */
            memcpy(Ut->Usr,Ud->Usr,Usiz); /* Transfer data betwen buffers */
            /* Mark Ndx's unset to force an NDX append */
            Ut->UsrNdx->hash_name=-1L; Ut->UsrNdx->hash_alias=-1L;
            if(UserWrite(Ut,Ut->Unum)) { ++Error; break; }
            ++Ut->Unum; /* Increment temp base count */
        }
        else { 
            /* Purge the record */
            if(PurgCount<U_MR) Parray[PurgCount++]=Ud->Usr->lastread_ptr;
        }
    }

    if(Error) {
        WinClose(); /* Close stat window */
        Mesage("User file read/write error!",11,22,13,55);
        TONEERROR(); MenuWaitKeyT(17); WinClose();
        UserClose(Ut); /* Close the temp user file */
        UserDefClose(Ut); /* Close temp user definition */
        free(Parray);
        return;
    }

    StatFree(); /* Close stats if any */

    UserClose(Ut); /* Close the temp user file */

    /* Replace old user base with new base */
    UserClose(Ud); /* Close the user file */
    if(UserDelete(Ud)) { /* Delete the user file */
        WinClose(); /* Close stat window */
        free(Parray);
        return;
    }
    UserRename(Ut,UedCfg.UserFile);

    UserDefClose(Ut); /* Close temp user definition */
    OpenUserFile(); /* Reopen the base */

    /* Clean LP Pointers */
    if(PurgCount) {
        WinPrintS(0,1,WHITE|_RED," Clearing L.R. Pointers ");
        UserLrClear(Ud,&Parray,PurgCount);
    }
    free(Parray);

    PackDesc();

    /* MenuWaitKeyT(100); */ /* Debug */

    WinClose(); /* Close stat window */
    TONEFOUND(); MenuStat=MENU_PACK;
}

/**/

static VOID PackDesc (VOID)
{
}

/**/

/* Returns 1 if ACTIVE*.BBS file is found */
static SHORT PASCAL MaxActive (VOID)
{
    HDIR hdir=HDIR_SYSTEM;
    USHORT rc, usSearchCount=1;
    FILEFINDBUF findbuf;
    CHAR Fpath[80];

    /* Build file path */
    strcpy(Fpath,UedCfg.MaxPath);
    if(*Fpath&&Fpath[strlen(Fpath)-1]!='\\') strcat(Fpath,"\\");
    strcat(Fpath,"ACTIVE*.BBS");

    /* Search for ACTIVExx.BBS files */
    rc=DosFindFirst(
            Fpath,                   /* Filename to search for      */
            &hdir,                   /* Address of directory handle */
            FILE_NORMAL,             /* Type of files to search for */
            &findbuf,                /* Address of buffer           */
            sizeof(findbuf),         /* Size of buffer              */
            &usSearchCount,          /* Number of matching entries  */
            0L);                     /* Reserved                    */

    DosFindClose(hdir);

    return (rc?0:1);
}

/**/
/*
Ŀ
 UPGRADE                  Enter=UpGrade ESC=Abort 
Ĵ
                                                  
 Profile: 1 2 3 4 5 6 7 8 9 A B C D E F G Restore 
                                                  
 Title:123456789012345678901234567890123456789012 
                                                  

*/
SHORT PASCAL UpGrde (VOID)
{
    #define UNDOCOUNT 16
    typedef struct undo {
        SHORT Rec;
        USHORT Priv;
        USHORT Credit;
        UCHAR XpFlag;
        USHORT XpPriv;
        SCOMBO XpDate;
        ULONG XpMins;
        ULONG Keys;
    } UNDO;

    SHORT i, menu_choice, selflg;
    SHORT update=0;
    UCHAR tmp_flag;
    ULONG tmp_keys;
    static SHORT UnDoCount=0;
    static UNDO UnDo[UNDOCOUNT];

    if(PfPtr<0||PfPtr>=_PROFILES) PfPtr=0;
    menu_choice=PfPtr;
    selflg=(UnDoCount)?0:-1;
    if(UnDoCount) sprintf(UnDoPrompt,"Restore changes to record %d",UnDo[UnDoCount-1].Rec+1);
    else *UnDoPrompt='\0';

    if(!WinOpen(12,13,20,64,bdr,WHITE|_RED,WHITE|_RED)) return 0;
    WINSHADOW();

    WinPrintS(0, 0,WHITE|_RED," UPGRADE                  Enter=UpGrade ESC=Abort ");
    WinPrintS(0,26,LCYAN|_RED,"Enter=UpGrade ESC=Abort");
    WinHLine(1,0,50,bdr,WHITE|_RED);
    WinPrintS(3,1,YELLOW|_RED,"Profile:");
    WinPrintS(5,1,YELLOW|_RED,"Title:");

    MenuBegC();
    MenuItem(3,10, "1",      '1',  0,0, NULL, 0, 0);
    MenuIBA(UpGrde_1,NULL);
    MenuItem(3,12, "2",      '2',  1,0, NULL, 0, 0);
    MenuIBA(UpGrde_2,NULL);
    MenuItem(3,14, "3",      '3',  2,0, NULL, 0, 0);
    MenuIBA(UpGrde_3,NULL);
    MenuItem(3,16, "4",      '4',  3,0, NULL, 0, 0);
    MenuIBA(UpGrde_4,NULL);
    MenuItem(3,18, "5",      '5',  4,0, NULL, 0, 0);
    MenuIBA(UpGrde_5,NULL);
    MenuItem(3,20, "6",      '6',  5,0, NULL, 0, 0);
    MenuIBA(UpGrde_6,NULL);
    MenuItem(3,22, "7",      '7',  6,0, NULL, 0, 0);
    MenuIBA(UpGrde_7,NULL);
    MenuItem(3,24, "8",      '8',  7,0, NULL, 0, 0);
    MenuIBA(UpGrde_8,NULL);
    MenuItem(3,26, "9",      '8',  8,0, NULL, 0, 0);
    MenuIBA(UpGrde_9,NULL);
    MenuItem(3,28, "A",      'A',  9,0, NULL, 0, 0);
    MenuIBA(UpGrde_A,NULL);
    MenuItem(3,30, "B",      'B', 10,0, NULL, 0, 0);
    MenuIBA(UpGrde_B,NULL);
    MenuItem(3,32, "C",      'C', 11,0, NULL, 0, 0);
    MenuIBA(UpGrde_C,NULL);
    MenuItem(3,34, "D",      'D', 12,0, NULL, 0, 0);
    MenuIBA(UpGrde_D,NULL);
    MenuItem(3,36, "E",      'E', 13,0, NULL, 0, 0);
    MenuIBA(UpGrde_E,NULL);
    MenuItem(3,38, "F",      'F', 14,0, NULL, 0, 0);
    MenuIBA(UpGrde_F,NULL);
    MenuItem(3,40, "G",      'G', 15,0, NULL, 0, 0);
    MenuIBA(UpGrde_G,NULL);
    MenuItem(3,42, "Restore",'R', 16,selflg, NULL, 0, 0);
    MenuIBA(UpGrde_R,NULL);
    MenuEnd(menu_choice,M_HORZ,0,0,LCYAN|_RED,LCYAN|_RED,LGREY|_RED,WHITE|_CYAN);
    menu_choice=MenuGet();

    if(UserIdxRead(Ud,CurRec)) return 0; /* Load current record */

    if(menu_choice==16) { /* Restore */
        if(UnDoCount) {
            if(UnDo[UnDoCount-1].Rec!=CurRec) {
                CurRec=UnDo[UnDoCount-1].Rec;
                if(UserIdxRead(Ud,CurRec)) { /* Load current record */
                    UnDoCount=0;
                    return 0; 
                }
            }
            Ud->Usr->priv    = UnDo[UnDoCount-1].Priv;
            Ud->Usr->xp_flag = UnDo[UnDoCount-1].XpFlag;
            Ud->Usr->xp_priv = UnDo[UnDoCount-1].XpPriv;
            Ud->Usr->xp_date = UnDo[UnDoCount-1].XpDate;
            Ud->Usr->xp_mins = UnDo[UnDoCount-1].XpMins;
            Ud->Usr->credit  = UnDo[UnDoCount-1].Credit;
            Ud->Usr->xkeys   = UnDo[UnDoCount-1].Keys;
            --UnDoCount;
            update++;
        }
    }
    else { 
        if(menu_choice!=-1) { /* Upgrade */
            PfPtr=menu_choice; /* Save selection */
            if(PfPtr<0||PfPtr>=_PROFILES) PfPtr=0;

            /* Save current data to allow a restore */
            if(UnDoCount>=UNDOCOUNT) { /* Make space current restore info */
                UnDoCount=UNDOCOUNT-1;
                for(i=1;i<UNDOCOUNT;i++) {
                    UnDo[i-1].Rec    = UnDo[i].Rec   ;
                    UnDo[i-1].Priv   = UnDo[i].Priv  ;
                    UnDo[i-1].Credit = UnDo[i].Credit;
                    UnDo[i-1].XpFlag = UnDo[i].XpFlag;
                    UnDo[i-1].XpPriv = UnDo[i].XpPriv;
                    UnDo[i-1].XpDate = UnDo[i].XpDate;
                    UnDo[i-1].XpMins = UnDo[i].XpMins;
                    UnDo[i-1].Keys   = UnDo[i].Keys  ;
                }
            }
            UnDo[UnDoCount].Rec    = CurRec;
            UnDo[UnDoCount].Priv   = Ud->Usr->priv;
            UnDo[UnDoCount].XpFlag = Ud->Usr->xp_flag;
            UnDo[UnDoCount].XpPriv = Ud->Usr->xp_priv;
            UnDo[UnDoCount].XpDate = Ud->Usr->xp_date;
            UnDo[UnDoCount].XpMins = Ud->Usr->xp_mins;
            UnDo[UnDoCount].Credit = Ud->Usr->credit;
            UnDo[UnDoCount].Keys   = Ud->Usr->xkeys;
            ++UnDoCount;

            /* Upgrade the record */
            if(UedCfg.Profile[PfPtr].FlagExp) { /* Expiry */
                if(UedCfg.Profile[PfPtr].XpFlag&XFLAG_EXPDATREL) {
                    /* Do a relative date upgrade */
                
                    /* Fix the date flag */
                    tmp_flag=UedCfg.Profile[PfPtr].XpFlag;
                    tmp_flag&=~XFLAG_EXPDATREL; tmp_flag|=XFLAG_EXPDATE;
                    Ud->Usr->xp_flag=tmp_flag;
                    GetRelDateTime((SCOMBO *)&(Ud->Usr->xp_date),
                        UedCfg.Profile[PfPtr].XpMths);
                }
                else {
                    /* Normal absolute date */
                    Ud->Usr->xp_flag=UedCfg.Profile[PfPtr].XpFlag;
                    Ud->Usr->xp_date=UedCfg.Profile[PfPtr].XpDate;
                }
                Ud->Usr->xp_priv=UedCfg.Profile[PfPtr].XpPriv;
                Ud->Usr->xp_mins=UedCfg.Profile[PfPtr].XpMins;
            }

            if(UedCfg.Profile[PfPtr].FlagPriv) /* Priv */
                Ud->Usr->priv=UedCfg.Profile[PfPtr].Priv;

            if(UedCfg.Profile[PfPtr].FlagCredit) /* Credit */
                Ud->Usr->credit=UedCfg.Profile[PfPtr].Credit;

            /* Keys */
            tmp_keys=Ud->Usr->xkeys;
            for(i=0;i<16;i++) {
                switch(UedCfg.Profile[PfPtr].Keys[i]) {
                case '0': break;
                case '1': lkey(tmp_keys) &= ~(0x0001<<i); break;
                case '2': lkey(tmp_keys)|=(0x0001<<i); break;
                }
            }
            for(i=16;i<32;i++) {
                switch(UedCfg.Profile[PfPtr].Keys[i]) {
                case '0': break;
                case '1': hkey(tmp_keys) &= ~(0x0001<<(i-16)); break;
                case '2': hkey(tmp_keys)|=(0x0001<<(i-16)); break;
                }
            }
            Ud->Usr->xkeys=tmp_keys;

            update++;
        }
    }

    WinClose();

    return update;
}

/**/

static VOID UpGrde_1 (VOID)
{
    CHAR sbuf[50];

    strcpy(sbuf,UedCfg.Profile[0].Title);
    WinPrintS(5,7,LGREY|_BLACK,FormStrSetSz(sbuf,42));
}

/**/

static VOID UpGrde_2 (VOID)
{
    CHAR sbuf[50];

    strcpy(sbuf,UedCfg.Profile[1].Title);
    WinPrintS(5,7,LGREY|_BLACK,FormStrSetSz(sbuf,42));
}

/**/

static VOID UpGrde_3 (VOID)
{
    CHAR sbuf[50];

    strcpy(sbuf,UedCfg.Profile[2].Title);
    WinPrintS(5,7,LGREY|_BLACK,FormStrSetSz(sbuf,42));
}

/**/

static VOID UpGrde_4 (VOID)
{
    CHAR sbuf[50];

    strcpy(sbuf,UedCfg.Profile[3].Title);
    WinPrintS(5,7,LGREY|_BLACK,FormStrSetSz(sbuf,42));
}

/**/

static VOID UpGrde_5 (VOID)
{
    CHAR sbuf[50];

    strcpy(sbuf,UedCfg.Profile[4].Title);
    WinPrintS(5,7,LGREY|_BLACK,FormStrSetSz(sbuf,42));
}

/**/

static VOID UpGrde_6 (VOID)
{
    CHAR sbuf[50];

    strcpy(sbuf,UedCfg.Profile[5].Title);
    WinPrintS(5,7,LGREY|_BLACK,FormStrSetSz(sbuf,42));
}

/**/

static VOID UpGrde_7 (VOID)
{
    CHAR sbuf[50];

    strcpy(sbuf,UedCfg.Profile[6].Title);
    WinPrintS(5,7,LGREY|_BLACK,FormStrSetSz(sbuf,42));
}

/**/

static VOID UpGrde_8 (VOID)
{
    CHAR sbuf[50];

    strcpy(sbuf,UedCfg.Profile[7].Title);
    WinPrintS(5,7,LGREY|_BLACK,FormStrSetSz(sbuf,42));
}

/**/

static VOID UpGrde_9 (VOID)
{
    CHAR sbuf[50];

    strcpy(sbuf,UedCfg.Profile[8].Title);
    WinPrintS(5,7,LGREY|_BLACK,FormStrSetSz(sbuf,42));
}

/**/

static VOID UpGrde_A (VOID)
{
    CHAR sbuf[50];

    strcpy(sbuf,UedCfg.Profile[9].Title);
    WinPrintS(5,7,LGREY|_BLACK,FormStrSetSz(sbuf,42));
}

/**/

static VOID UpGrde_B (VOID)
{
    CHAR sbuf[50];

    strcpy(sbuf,UedCfg.Profile[10].Title);
    WinPrintS(5,7,LGREY|_BLACK,FormStrSetSz(sbuf,42));
}

/**/

static VOID UpGrde_C (VOID)
{
    CHAR sbuf[50];

    strcpy(sbuf,UedCfg.Profile[11].Title);
    WinPrintS(5,7,LGREY|_BLACK,FormStrSetSz(sbuf,42));
}

/**/

static VOID UpGrde_D (VOID)
{
    CHAR sbuf[50];

    strcpy(sbuf,UedCfg.Profile[12].Title);
    WinPrintS(5,7,LGREY|_BLACK,FormStrSetSz(sbuf,42));
}

/**/

static VOID UpGrde_E (VOID)
{
    CHAR sbuf[50];

    strcpy(sbuf,UedCfg.Profile[13].Title);
    WinPrintS(5,7,LGREY|_BLACK,FormStrSetSz(sbuf,42));
}

/**/

static VOID UpGrde_F (VOID)
{
    CHAR sbuf[50];

    strcpy(sbuf,UedCfg.Profile[14].Title);
    WinPrintS(5,7,LGREY|_BLACK,FormStrSetSz(sbuf,42));
}

/**/

static VOID UpGrde_G (VOID)
{
    CHAR sbuf[50];

    strcpy(sbuf,UedCfg.Profile[15].Title);
    WinPrintS(5,7,LGREY|_BLACK,FormStrSetSz(sbuf,42));
}

/**/

static VOID UpGrde_R (VOID)
{
    CHAR sbuf[50];

    strcpy(sbuf,UnDoPrompt);
    WinPrintS(5,7,LGREY|_BLACK,FormStrSetSz(sbuf,42));
}

/**/

static VOID PASCAL GetRelDateTime (SCOMBO *pt, USHORT XpMths)
{
    USHORT pmo;

    GetSysDateTime(pt); /* Get current date & time */

    /* Add the months */
    pmo=pt->msg_st.date.mo+XpMths;
    while(pmo>12) {
        pmo-=12;
        pt->msg_st.date.yr++;
    }
    pt->msg_st.date.mo=pmo;

    return;
}

/**/

/* Returns true if expiry date is exceeded */
static SHORT PASCAL Expired (VOID)
{
#if defined(BETAVERSION)
    DATETIME dt;
#endif

    if(Registered()) return 0; /* Don't expire registered user */

#if defined(BETAVERSION)
    if(DosGetDateTime(&dt)) return 0; /* Can't get system date :( */
    if(dt.year>EXPIRE_YEAR) return 1;
    if(dt.year==EXPIRE_YEAR && dt.month>=EXPIRE_MNTH) return 1;
#endif

    return 0; /* Ok for now */
}

/**/

static SHORT PASCAL Registered (VOID)
{
    /* Compare the codes */
    if(strcmp(UedCfg.RegCode,GetCode(UedCfg.RegName,UedCfg.RegCity))) {
        IsRegistered=FALSE;
        return 0;
    }

    IsRegistered=TRUE;
    return 1;
}

/**/

static PCHAR GetCode (PCHAR Name, PCHAR City)
{
    #define REG_LEN 10
    static CHAR Buf1[128], Buf2[128];
    PCHAR p;
    PCHAR q;
    CHAR tmp[64];
    SHORT i;

    /* Create src string */
    strcpy(Buf1,Name); strcat(Buf1,City);

    /* Get every second char */
    p=Buf1; q=Buf2;
    memset(Buf2,'\0',120);
    while(*p) {
        *q=*p;
        q++;
        p++;
        if(!*p) break;
        p++;
    }
    *q='\0';

    /* Convert to lower case */
    p=Buf2;
    while(*p) { 
        *p=(CHAR)tolower(*p);
        (*p)++;
        ++p;
    }

    /* Trim the string */
    Buf2[REG_LEN]='\0'; 

    memset(Buf1,'\0',120);
    StringToMD5(Buf2,Buf1);

    *Buf2='\0';
    for(i=0;i<REG_LEN;i++) {
        ltoa((ULONG)((UCHAR)Buf1[i]),tmp,36);
        if(!((i)%2)) strcat(Buf2,"-");
        if(strlen(tmp)<2) strcat(Buf2,"0");
        strcat(Buf2,tmp);
    }

    /* Convert to upper case */
    p=Buf2;
    while(*p) { 
        *p=(CHAR)toupper(*p);
        ++p;
    }

    return Buf2+1;
}

/**/

/* Modify CTRL+C & CTRL-BREAK behavior */
VOID PASCAL SetHandler (VOID)
{
    BYTE bMode;

    /* Check for real mode */
    DosGetMachineMode(&bMode);

    if(bMode==MODE_REAL) { /* DOS handling */
        OldDosCtrlCHandler=_dos_getvect(0x09);
        _dos_setvect(0x09,DosCtrlCHandler);
        OldDosCtrlBHandler=_dos_getvect(0x1B);
        _dos_setvect(0x1B,DosCtrlBHandler);
        atexit(ReleaseHandler); /* Activate restoration during exit */
    }
    else { /* OS2 handling */
        if(signal(SIGINT,OS2CtrlCHandler)==SIG_ERR) {
            fprintf(stderr,"\aERROR Couldn't set CTRL-C handler!\n");
            Exit(2);
        }
    }
}

/**/

/* Reset DOS CTRL+C & CTRL-BREAK behavior */
VOID ReleaseHandler (VOID)
{
    _dos_setvect(0x09,OldDosCtrlCHandler);
    _dos_setvect(0x1B,OldDosCtrlBHandler);
}

/**/

/* Handles OS/2 SIGINT (CTRL+C) interrupt */
VOID OS2CtrlCHandler (VOID)
{
    signal(SIGINT,SIG_ACK);
}

/**/

/* CTRL-C handler for DOS */
VOID _interrupt _far DosCtrlCHandler (VOID)
{
    SHORT bte;
    static SHORT flag=0;

    _enable();
    if((bte=inp(0x60))==29) flag = 1; /* Ctrl is pressed */
    if(bte==157) flag=0; /* Ctrl is released */
    if(!flag) (*OldDosCtrlCHandler)();
    else switch (bte) {
        case 46 :   /* C */
        case 70 :   /* Scroll Lock  */
        case 56 :   /* Pause (Break) */
     /* case 83 :*/ /* Keypad Del */
               bte = inp(0x61);
               outp(0x61,bte | 0x80); /* Send ACK */
               outp(0x61,bte);        /* Send ACK */
               outp(0x20,0x20);       /* Signal end of interrupt */
               break;
        default : (*OldDosCtrlCHandler)();
    }
}

/**/

/* Null CTRL-BREAK handler for DOS */
VOID _interrupt _far DosCtrlBHandler (VOID)
{
}

/**/

/* Parses the command line for valid invocation switches */
static VOID PASCAL GetCmdLine (SHORT argc, PCHAR argv[])
{
    SHORT i;
    PCHAR p;

    VidVideoInit(); CfgInit();

    /* Scan cmd line for Cfg file path&name */
    for(i=1;i<argc;i++) {
        p=argv[i];
        if(*p=='-'||*p=='/') {
            ++p;
            switch(toupper(*(p))) {
                case 'C': /* Cfg file path and name */
                          strcpy(CfgFile,++p);
                          break;
            }
        }
    }

    /* Read Ued.Ini & Max.Prm */
    CfgRead();
    if(!GetPrmInfo()) printf("Error opening PRM file!\n");

    /* Scan for cmd line overrides */
    for(i=1;i<argc;i++) {
        p=argv[i];
        if(*p=='-'||*p=='/') {
            ++p;
            switch(toupper(*(p))) {
                case 'C': break;
                case 'G': AutoSeek=atoi(++p);
                          break;
                case 'D': UedCfg.Maintenance=1;
                          break;
                case 'A': /* Map mono attributes */
                          _VidInfo.MapAttr=1;
                          break;
                case 'M': /* Maximus path */
                          strcpy(UedCfg.MaxPath,++p);
                          if(*UedCfg.MaxPath=='.') *UedCfg.MaxPath='\0';
                          break;
                case 'R': /* Registration */
                          CfgReg();
                          CfgWrite();
                          Exit(0);
                          break;
                case '?': /* Help screen */
                default:  SyntaxExit();
            }
        }
        else SyntaxExit();
    }

    if(Expired()) SyntaxExit(); /* Check expiry */

    SetHandler(); /* Modify CTRL+C & CTRL-BREAK behavior */
}

/**/

/* Syntax command line display and exit */
static VOID PASCAL SyntaxExit (VOID)
{
/*
UED V3.01 - the Maximus V3.XX Specific User Base Editor
 (C) Copyright 1990-97 by CodeLand, All Rights Reserved
*/
    printf("\nUED V" VERSION " - the Maximus V3.XX Specific User Base Editor\n"
        "    (C) Copyright 1990-97 by CodeLand, All Rights Reserved\n\n");

#if defined(BETAVERSION)
    printf("Licence to BETA test this executable expires %s\n\n",EXPIRE_STR);
#endif

    printf(   "    Syntax:  UED   [-switch -switch ... ]\n\n"
            "\t -C<name>  Configuration file path & name\n"
            "\t -G###     Start at record ###\n"
            "\t -D        Force debug/maintenance mode\n"
            "\t -A        Use monochrome attributes\n"
            "\t -M<path>  Maximus directory override\n"
            "\t -R        Edit registration details\n"
            "\t -?        Program help screen\n\n"
    );

    exit(0); /* Direct exit */
}

/**/

