/*͸
   UED Maximus User Base API                (C) 1996 by CodeLand Australia 
   USER.C Version 3.00  13-01-96                       All Rights Reserved 
  ;*/

#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#define INCL_DOS
#include <os2.h>

#include "user.h"

#include <stdio.h>
#define LRPCLENSE 1 /* Lrp clensing */

/**/

#pragma pack(1)
#define MAREA_ID        0x1a49023fL
#define ADATA_START     4L          /* The area data info starts at offset 4 */
#define MSGTYPE_SDM     0x01
#define MSGTYPE_SQUISH  0x02
#define MSGTYPE_ECHO    0x80
/* MAXIMUS MAREA.DAT RECORD STRUCTURE */
#define option USHORT
#define ZSTR   USHORT
typedef struct _netaddr {
  USHORT zone;
  USHORT net;
  USHORT node;
  USHORT point;
} NETADDR;
typedef struct _ovride {
  /* Only one of 'opt' or 'name' should be used.  If opt==0, use name.  If  *
   * name==0, use opt.                                                      */
  option opt;           /* Type of menu option to override     ...OR...     */
  UCHAR   name;         /* First letter of command to override              */
  UCHAR   rsvd1;        /* Reserved for future use                          */
  ZSTR   acs;           /* New ACS required to access option                */
  ZSTR   menuname;      /* Use this access level on the given menu only     */
} OVERRIDE;
/* Bit masks for the ma.attribs field */
#define MA_PVT      0x0001  /* Private msgs allowed */
#define MA_PUB      0x0002  /* Public msgs allowed */
#define MA_HIBIT    0x0004  /* High bit msgs allowed */
#define MA_NET      0x0008  /* Netmail area */
#define MA_ECHO     0x0010  /* Echomail area */
#define MA_CONF     0x0020  /* Conference area */
#define MA_ANON     0x0040  /* Anonymous messages are OK */
#define MA_NORNK    0x0080  /* Don't use the REALNAME kludge for this area */
#define MA_REAL     0x0100  /* Force  use of       real name for this area */
#define MA_ALIAS    0x0200  /* Force  use of alias      name for this area */
#define MA_AUDIT    0x0400  /* Use auditing (msg tracking) controls in area*/
#define MA_READONLY 0x0800  /* Area is read-only */
#define MA_HIDDN    0x1000  /* Area does not display on normal area list   */
#define MA_ATTACH   0x2000  /* Area allows local file attaches             */
#define MA_DIVBEGIN 0x4000  /* A message area division, not a real area    */
#define MA_DIVEND   0x8000  /* End of the message area division            */
#define MA2_NOMCHK  0x0001  /* Don't do personal mail check in this area   */
#define MA_SHARED   (MA_ECHO | MA_CONF)
typedef struct _msgarea {
  USHORT cbArea;        /* Length of THIS INDIVIDUAL RECORD                0*/
  USHORT num_override;  /* Number of overrides following this record       2*/
  USHORT cbHeap;        /* Length of the zstr heap following the overrides 4*/
  USHORT division;      /* Reserved for future use                         6*/
  ZSTR name;            /* String format of area's name.                   8*/
  ZSTR acs;             /* Access control string for this area            10*/
  ZSTR path;            /* Path to messages                               12*/
  ZSTR echo_tag;        /* The 'tag' of the area, for use in ECHOTOSS.LOG 14*/
  ZSTR descript;        /* The DIR.BBS-like description for msg section   16*/
  ZSTR origin;          /* The ORIGIN line for this area                  18*/
  ZSTR menuname;        /* Custom menu name                               20*/
  ZSTR menureplace;     /* Replace this menu name with menuname from above22*/
  USHORT attribs;       /* Attributes for this area                       24*/
  NETADDR primary;      /* Use as primary address for this area           26*/
  NETADDR seenby;       /* Use as address in seen-bys                     34*/
  USHORT attribs2;      /* More attributes                                42*/
  USHORT type;          /* Message base type.  MSGTYPE_SDM = *.MSG.       44*
                         * MSGTYPE_SQUISH = SquishMail.  (Constants are     *
                         * in MSGAPI.H)                                     */
  USHORT killbyage;     /* Make sure msgs are less than X days old        46*/
  USHORT killbynum;     /* Make sure there are less than X msgs           48*/
  USHORT killskip;      /* Exempt the first X msgs from this processing   50*/
  ZSTR barricade;       /* Barricade file                                 52*/
  ZSTR barricademenu;   /* Apply barricade priv while using this menu     54*/
  LONG cbPrior;         /* Seek offset from start of this area to get back56*
                         * to prior area.                                   */
  ZSTR attachpath;      /* Reserved for future use                        58*/
  ULONG rsvd4;                                                          /*60*/
} MAREA;                                                                /*64*/
/* Index structure for message/file areas */
typedef struct _mfidx {
  CHAR name[16];        /* First 15 chars of area name                      */
  ULONG name_crc;       /* CRC of full area name                            */
  ULONG ofs;            /* Offset within data file                          */
} MFIDX;
#pragma pack()

/**/

/* Local functions */
static USHORT PASCAL FindNextLastread (PUDEF Ud);
static VOID PASCAL CollectLastread (PUDEF Ud);
static VOID PASCAL BuildPath (PCHAR Dest, PCHAR Path, PCHAR Name);

/**/

/* Create a Udef definition structure - sets path and name */
SHORT _fapi UserDefOpen (PUDEF *Ud, PCHAR Mpath, PCHAR Uname, PCHAR Aname)
{
    /* Get Udef storage */
    *Ud=(PUDEF)malloc(sizeof(UDEF));
    if(*Ud==NULL) return -1;

    /* Clear the structure */
    memset(*Ud,'\0',sizeof(UDEF));

    /* Allow NULL path */
    if(!Mpath) Mpath="";

    /* Allow NULL names */
    if(!Uname) Uname="User";
    if(!Aname) Aname="Marea";

    /* Set the file paths */
    strcpy((*Ud)->Mpath,Mpath);
    strcpy((*Ud)->Uname,Uname); strcat((*Ud)->Uname,".Bbs");
    strcpy((*Ud)->Nname,Uname); strcat((*Ud)->Nname,".Idx");
    strcpy((*Ud)->Aname,Aname); strcat((*Ud)->Aname,".Dat");

    return 0;
}

/**/

/* Destroy a Udef definition structure */
VOID _fapi UserDefClose (PUDEF Ud)
{
    if(Ud) {
        /* Close the base if left open */
        if(Ud->isOpen) UserClose(Ud);

        /* Free the index if existing */
        if(Ud->Uidx) free(Ud->Uidx);

        /* Free the structure storage */
        free(Ud);
    }
}

/**/

/* Create a user file, get storage, save size&count */
SHORT _fapi UserCreate (PUDEF Ud)
{
    USHORT rc, usAction;
    /* ULONG ulNewPtr; */
    CHAR buf[160];

    /* Abort if the file is already open */
    if(Ud->isOpen) return -1;

    /* Build full path & name */
    BuildPath(buf,Ud->Mpath,Ud->Uname);

    /* Create the user file for read/write */
    rc=DosOpen(
        buf,
        &Ud->Ufh,
        &usAction,
        (ULONG)0,
        FILE_NORMAL,
        FILE_CREATE,
        OPEN_ACCESS_READWRITE|OPEN_SHARE_DENYNONE,
        (ULONG)0);
    if(rc) return -1;

    /* Get user record storage */
    Ud->Usr=(USR *)malloc(sizeof(USR));
    if(Ud->Usr==NULL) {
        DosClose(Ud->Ufh);
        return -1;
    }

    /* Set flags */
    Ud->isOpen=TRUE; Ud->SortDir=0; Ud->SortTyp=0; Ud->GotLr=0;

    /* Save the record size */
    Ud->Usiz=sizeof(USR);

    /* Create the ndx file */
    if(NdxCreate(Ud)) {
        free(Ud->Usr);
        DosClose(Ud->Ufh);
        Ud->isOpen=FALSE;
        return -1;
    }

    /* Clear the record structure */
    memset(Ud->Usr,'\0',Ud->Usiz);

    return 0;
}

/**/

/* Open an existing user file, get record storage & save size and count */
/*
Return -1 = File Open Fail
Return -2 = Out Of Memory
Return -3 = User.Bbs Read Fail
Return -4 = User.Idx Open Fail
*/
SHORT _fapi UserOpen (PUDEF Ud)
{
    USHORT rc, usAction, cbBytesRead;
    ULONG ulNewPtr;
    FILESTATUS fstsFile;
    CHAR buf[160];

    /* Abort if the file is already open */
    if(Ud->isOpen) return 0;

    /* Build full path & name */
    BuildPath(buf,Ud->Mpath,Ud->Uname);

    /* Open the user file for read/write */
    rc=DosOpen(
        buf,
        &Ud->Ufh,
        &usAction,
        (ULONG)0,
        FILE_NORMAL,
        FILE_OPEN,
        OPEN_ACCESS_READWRITE|OPEN_SHARE_DENYNONE,
        (ULONG)0);
    if(rc) return -1;

    /* Get user record storage */
    Ud->Usr=(USR *)malloc(sizeof(USR));
    if(Ud->Usr==NULL) {
        DosClose(Ud->Ufh);
        return -2;
    }

    /* Read the first record */
    rc=DosRead(Ud->Ufh,Ud->Usr,sizeof(USR),&cbBytesRead);
    if(rc||cbBytesRead!=sizeof(USR)) {
        free(Ud->Usr);
        DosClose(Ud->Ufh);
        return -3;
    }

    /* Save the record size */
    Ud->Usiz=Ud->Usr->struct_len?Ud->Usr->struct_len*20:sizeof(USR);

    /* Get the file size */
    DosQFileInfo(
        Ud->Ufh,                /* File handle                 */
        FIL_STANDARD,           /* Level of information        */
        &fstsFile,              /* Address of file-data buffer */
        sizeof(fstsFile));      /* Size of data buffer         */

    /* Save the record count */
    Ud->Unum=(USHORT)(fstsFile.cbFile/(LONG)Ud->Usiz);

    /* Fix the record storage size if necessary */
    if(Ud->Usiz!=sizeof(USR)) {
        free(Ud->Usr);
        Ud->Usr=(USR *)malloc(Ud->Usiz);
        if(Ud->Usr==NULL) {
            DosClose(Ud->Ufh);
            return -2;
        }
    }

    /* Rewind the user file */
    rc=DosChgFilePtr(Ud->Ufh,(LONG)0,FILE_BEGIN,&ulNewPtr);
    if(rc||ulNewPtr!=(ULONG)0) {
        free(Ud->Usr);
        DosClose(Ud->Ufh);
        return -3;
    }

    /* Clear the record structure */
    memset(Ud->Usr,'\0',Ud->Usiz);

    /* Open the ndx file */
    if(NdxOpen(Ud)) {
        free(Ud->Usr);
        DosClose(Ud->Ufh);
        return -4;
    }

    /* Set flags */
    Ud->isOpen=TRUE; Ud->SortDir=0; Ud->SortTyp=0; Ud->GotLr=0;

    return 0;
}

/**/

/* Close a user file and release record storage */
VOID _fapi UserClose (PUDEF Ud)
{
    /* Abort if the file isn't open */
    if(!Ud->isOpen) return;

    /* Close the file */
    DosClose(Ud->Ufh);

    /* Free the user record storage */
    free(Ud->Usr);

    /* Close the ndx file */
    NdxClose(Ud);

    /* Flag the file closed */
    Ud->isOpen=FALSE;
}

/**/

/* Read user file record Rec (zero based) */
SHORT _fapi UserRead (PUDEF Ud, USHORT Rec)
{
    USHORT rc, cbBytesRead;
    ULONG ofs, ulNewPtr;

    /* Abort if the file isn't open */
    if(!Ud->isOpen) return -1;

    /* Abort if out of range */
    if(Rec>=Ud->Unum) return -1;

    /* Seek the user file */
    ofs=(ULONG)Rec*(ULONG)Ud->Usiz;
    rc=DosChgFilePtr(Ud->Ufh,ofs,FILE_BEGIN,&ulNewPtr);
    if(rc||ulNewPtr!=ofs) return -1;

    rc=DosRead(Ud->Ufh,Ud->Usr,Ud->Usiz,&cbBytesRead);
    if(rc||cbBytesRead!=Ud->Usiz) return -1;

    /* Read ndx file */
    if(NdxRead(Ud,Rec)) return -1;

    return 0;
}

/**/

/* Write user file record Rec (zero based) */
SHORT _fapi UserWrite (PUDEF Ud, USHORT Rec)
{
    USHORT rc, cbBytesWritten;
    ULONG ofs, ulNewPtr, HashName, HashAlias;

    /* Abort if the file isn't open */
    if(!Ud->isOpen) return -1;

    /* Abort if out of range (append allowed) */
    if(Rec>Ud->Unum) return -2;

    /* Seek the user file */
    ofs=(ULONG)Rec*(ULONG)Ud->Usiz;
    rc=DosChgFilePtr(Ud->Ufh,ofs,FILE_BEGIN,&ulNewPtr);
    if(rc||ulNewPtr!=ofs) return -3;

    rc=DosWrite(Ud->Ufh,Ud->Usr,Ud->Usiz,&cbBytesWritten);
    if(rc||cbBytesWritten!=Ud->Usiz) return -4;

    /* Write ndx file if name has changed */
    HashName=UserHash(Ud->Usr->name);
    HashAlias=UserHash(Ud->Usr->alias);
    if(HashName!=Ud->UsrNdx->hash_name ||
       HashAlias!=Ud->UsrNdx->hash_alias) {
        Ud->UsrNdx->hash_name=HashName;
        Ud->UsrNdx->hash_alias=HashAlias;
        if(NdxWrite(Ud,Rec)) return -5;
    }

    return 0;
}

/**/

/* Appends a user file record */
SHORT _fapi UserAppend (PUDEF Ud)
{
    /* Abort if the file isn't open */
    if(!Ud->isOpen) return -1;

    /* Set a unique lastread pointer for the new record */
    Ud->Usr->lastread_ptr=FindNextLastread(Ud);

    if(0==UserWrite(Ud,Ud->Unum)) {
        ++Ud->Unum;
        return 0;
    }

    /* Failed the append, so cancel the new lastread pointer */
    BitOff(Ud->LrUsed,Ud->Usr->lastread_ptr);

    return -1;
}

/**/

/* Create a user file definition index array & set default index */
SHORT _fapi UserIdxCreate (PUDEF Ud)
{
    SHORT count;

    if(!Ud->Uidx) { /* Only get the storage once */
        Ud->Uidx=(USHORT *)malloc(U_MR*sizeof(USHORT));
        if(!Ud->Uidx) return -1;
    }

    /* Set default index values */
    for(count=0;count<U_MR;count++) Ud->Uidx[count]=count;

    return 0;
}

/**/

/* Indexed user file read (zero based) */
SHORT _fapi UserIdxRead (PUDEF Ud, USHORT Idx)
{
    /* Check Index exists and Idx is in range */
    if(!Ud->Uidx||Idx>=U_MR) return -1;

    return UserRead(Ud,Ud->Uidx[Idx]);
}

/**/

/* Indexed user file write (zero based) */
SHORT _fapi UserIdxWrite (PUDEF Ud, USHORT Idx)
{
    /* Check Index exists and Idx is in range */
    if(!Ud->Uidx||Idx>=U_MR) return -1;

    return UserWrite(Ud,Ud->Uidx[Idx]);
}

/**/

/* Sort a user file definition index array (excludes 1st record) */
VOID _fapi UserIdxSort (PUDEF Ud, int (*Compare)(const void *, const void *))
{
    if(!Ud->Uidx) return; /* Check Index exists */
    if(Ud->Unum>2) qsort(&(Ud->Uidx[1]),Ud->Unum-1,sizeof(USHORT),Compare);
}

/**/

/* Renames a user file */
SHORT _fapi UserRename (PUDEF Ud, PCHAR NewName)
{
    USHORT rc;
    CHAR oldname[160], newname[160];

    /* Abort if the file is open */
    if(Ud->isOpen) return -1;

    /* Build User.Bbs name full paths */
    BuildPath(oldname,Ud->Mpath,Ud->Uname);
    BuildPath(newname,Ud->Mpath,NewName); strcat(newname,".Bbs");
    /* Rename the user file */
    rc=DosMove(oldname,newname,(ULONG)0);
    if(rc) return -1;

    /* Build NDX name full paths */
    BuildPath(oldname,Ud->Mpath,Ud->Nname);
    BuildPath(newname,Ud->Mpath,NewName); strcat(newname,".Idx");
    /* Rename the NDX file */
    rc=DosMove(oldname,newname,(ULONG)0);
    if(rc) return -1;

    return 0;
}

/**/

/* Deletes a user file */
SHORT _fapi UserDelete (PUDEF Ud)
{
    USHORT rc;
    CHAR buf[160];

    /* Abort if the file is open */
    if(Ud->isOpen) return -1;

    /* Build User.Bbs full path & name */
    BuildPath(buf,Ud->Mpath,Ud->Uname);
    /* Delete the user file */
    rc=DosDelete(buf,(ULONG)0);
    if(rc) return -1;

    /* Build NDX full path & name */
    BuildPath(buf,Ud->Mpath,Ud->Nname);
    /* Delete the NDX file */
    rc=DosDelete(buf,(ULONG)0);
    if(rc) return -1;

    return 0;
}

/**/

/* Set a user structure default values */
VOID _fapi UserDefault (PUDEF Ud)
{
    SCOMBO sc;

    /* Abort if the file isn't open */
    if(!Ud->isOpen) return;

    /* Clear the structure */
    memset(Ud->Usr,'\0',Ud->Usiz);

    /* Get system date & time */
    GetSysDateTime(&sc);

    strcpy(Ud->Usr->name,"Record created by UED");
    strcpy(Ud->Usr->msg,"1"); strcpy(Ud->Usr->files,"1");

    Ud->Usr->help=NOVICE; Ud->Usr->def_proto=PROTOCOL_none;
    Ud->Usr->width=80; Ud->Usr->len=25;
    Ud->Usr->struct_len=(UCHAR)(Ud->Usiz/20);
    Ud->Usr->bits2|=BITS2_CLS;
    Ud->Usr->ludate=sc;
    Ud->Usr->date_1stcall=sc;
    Ud->Usr->date_pwd_chg=sc;

    /* Mark Ndx's unset */
    Ud->UsrNdx->hash_name=-1L;
    Ud->UsrNdx->hash_alias=-1L;
}

/**/

/* Zero multiple (M)area.dat lastread offsets */
VOID _fapi UserLrClear (PUDEF Ud, USHORT *LRarray[], USHORT LRnum)
{
    #define MAX_MAREA_HEAP 2048
    USHORT j, rc, usAction, cbBytesRead, zero=0;
    ULONG ofs, ulNewPtr, lzero=(ULONG)0;
    MAREA Ah;
    HFILE Afh, Lfh;
    CHAR *pHp, buf[160];
    LONG ID;

    /* Make Marea.Dat path */
    BuildPath(buf,Ud->Mpath,Ud->Aname);

    /* printf("DEBUG: mareadatpath %s\n",buf); */ /* DEBUG */

    /* Open the marea file for reading */
    rc=DosOpen(buf,&Afh,&usAction,(ULONG)0,FILE_NORMAL,FILE_OPEN,
        OPEN_ACCESS_READONLY|OPEN_SHARE_DENYNONE,(ULONG)0);
    if(rc) return;

    /* Allocate heap storage */
    pHp=(CHAR *)malloc(sizeof(CHAR)*MAX_MAREA_HEAP);
    if(pHp==NULL) {
        DosClose(Afh); /* Close the marea file */
        return;
    }

    /* Read the 4 byte file ID */
    rc=DosRead(Afh,&ID,4,&cbBytesRead);
    if(ID!=MAREA_ID) { DosClose(Afh); return; }

    /* Seek to start of data */
    rc=DosChgFilePtr(Afh,ADATA_START,FILE_BEGIN,&ulNewPtr);
    if(rc) { DosClose(Afh); return; }

    for(;;) {
        /* Read the marea structure */
        rc=DosRead(Afh,&Ah,sizeof(MAREA),&cbBytesRead);
        if(rc||cbBytesRead!=sizeof(MAREA)) break;
        if(Ah.cbArea!=sizeof(MAREA)) break;

        /* Skip the override(s) if any */
        if(Ah.num_override) {
            ofs=(ULONG)sizeof(OVERRIDE)*(ULONG)Ah.num_override;
            rc=DosChgFilePtr(Afh,ofs,FILE_CURRENT,&ulNewPtr);
            if(rc) break;
        }

        /* Read the heap data */
        if(!Ah.cbHeap||Ah.cbHeap>MAX_MAREA_HEAP) continue;
        rc=DosRead(Afh,pHp,sizeof(CHAR)*Ah.cbHeap,&cbBytesRead);
        if(rc||cbBytesRead!=sizeof(CHAR)*Ah.cbHeap) break;

        /* Skip divisions */
        if(Ah.attribs&MA_DIVBEGIN || Ah.attribs&MA_DIVEND) continue;

        #if defined(LRPCLENSE)
        if(Ah.type==MSGTYPE_SDM) {
            /* FTN message base */
            BuildPath(buf,pHp+Ah.path,"LASTREAD.BBS");
            if(!DosOpen(buf,&Lfh,&usAction,(ULONG)0,FILE_NORMAL,FILE_OPEN,
                OPEN_ACCESS_READWRITE|OPEN_SHARE_DENYNONE,(ULONG)0)) {
                for(j=0;j<LRnum;j++) {
                    rc=DosChgFilePtr(Lfh,(LONG)(*LRarray)[j]*sizeof(SHORT),
                        FILE_BEGIN,&ulNewPtr);
                    if(rc) break;
                    rc=DosWrite(Lfh,(CHAR *)&zero,sizeof(SHORT),&cbBytesRead);
                    if(rc) break;
                }
                DosClose(Lfh);
            }
        }
        else {
            /* Squish message base */
            strcpy(buf,pHp+Ah.path); strcat(buf,".SQL");
            if(!DosOpen(buf,&Lfh,&usAction,(ULONG)0,FILE_NORMAL,FILE_OPEN,
                OPEN_ACCESS_READWRITE|OPEN_SHARE_DENYNONE,(ULONG)0)) {
                for(j=0;j<LRnum;j++) {
                    rc=DosChgFilePtr(Lfh,(LONG)(*LRarray)[j]*sizeof(LONG),
                        FILE_BEGIN,&ulNewPtr);
                    if(rc) break;
                    rc=DosWrite(Lfh,(CHAR *)&lzero,sizeof(LONG),&cbBytesRead);
                    if(rc) break;
                }
                DosClose(Lfh);
            }
        }
        #else
        /* Debug */
        if(Ah.type==MSGTYPE_SDM) BuildPath(buf,pHp+Ah.path,"LASTREAD.BBS");
        else { strcpy(buf,pHp+Ah.path); strcat(buf,".SQL"); }
        printf("DEBUG: lrpclensepath: %s\n",buf);
        #endif

    }

    free(pHp);      /* Free heap storage    */
    DosClose(Afh);  /* Close the marea file */
}

/**/

/* Generate hash of string as used in USER.IDX */
ULONG _fapi UserHash (PUCHAR Str)
{
    ULONG hash=0, g;
    PCHAR p;

    for (p=Str;*p;p++) {
        hash=(hash<<4)+tolower(*p);
        if((g=(hash&0xf0000000L))!=0L) { hash|=g>>24; hash|=g; }
    }

    return (hash & 0X7FFFFFFFL); /* Strip off high bit */
}

/**/

/* Puts the system date & time into struct pt */
VOID _fapi GetSysDateTime (SCOMBO *pt)
{
    DATETIME dt;

    if(!pt) return;
    if(DosGetDateTime(&dt)) return;

    pt->msg_st.date.da=dt.day;             /* Day of month 1-31    */
    pt->msg_st.date.mo=dt.month;           /* Month 1-12           */
    pt->msg_st.date.yr=dt.year-1980;       /* Year since 1970      */
    pt->msg_st.time.hh=dt.hours;           /* Hour of day 0-23     */
    pt->msg_st.time.mm=dt.minutes;         /* Minute 0-59          */
    pt->msg_st.time.ss=dt.seconds>>1;      /* Seconds*2 0-29       */
}

/**/

/* Create an ndx file */
SHORT PASCAL NdxCreate (PUDEF Ud)
{
    USHORT rc, usAction;
    CHAR buf[160];

    /* Build full path & name */
    BuildPath(buf,Ud->Mpath,Ud->Nname);

    /* Create the ndx file for read/write */
    rc=DosOpen(
        buf,
        &Ud->Nfh,
        &usAction,
        (ULONG)0,
        FILE_NORMAL,
        FILE_CREATE,
        OPEN_ACCESS_READWRITE|OPEN_SHARE_DENYNONE,
        (ULONG)0);
    if(rc) return -1;

    /* Get ndx record storage */
    Ud->UsrNdx=(USRNDX *)malloc(sizeof(USRNDX));
    if(Ud->UsrNdx==NULL) {
        DosClose(Ud->Nfh);
        return -1;
    }

    /* Clear the record structure */
    memset(Ud->UsrNdx,'\0',sizeof(USRNDX));

    return 0;
}

/**/

/* Open an existing ndx file */
SHORT PASCAL NdxOpen (PUDEF Ud)
{
    USHORT rc, usAction;
    CHAR buf[160];

    /* Build full path & name */
    BuildPath(buf,Ud->Mpath,Ud->Nname);

    /* Open the ndx file for read/write */
    rc=DosOpen(
        buf,
        &Ud->Nfh,
        &usAction,
        (ULONG)0,
        FILE_NORMAL,
        FILE_OPEN,
        OPEN_ACCESS_READWRITE|OPEN_SHARE_DENYNONE,
        (ULONG)0);
    if(rc) return -1;

    /* Get ndx record storage */
    Ud->UsrNdx=(USRNDX *)malloc(sizeof(USRNDX));
    if(Ud->UsrNdx==NULL) {
        DosClose(Ud->Nfh);
        return -1;
    }

    /* Clear the record structure */
    memset(Ud->UsrNdx,'\0',sizeof(USRNDX));

    return 0;
}

/**/

/* Close a user file and release record storage */
VOID PASCAL NdxClose (PUDEF Ud)
{
    /* Close the file */
    DosClose(Ud->Nfh);

    /* Free the ndx record storage */
    free(Ud->UsrNdx);
}

/**/

/* Read ndx file record Rec (zero based) */
SHORT PASCAL NdxRead (PUDEF Ud, USHORT Rec)
{
    USHORT rc, cbBytesRead;
    ULONG ofs, ulNewPtr;

    /* Seek the ndx file */
    ofs=(ULONG)Rec*sizeof(USRNDX);
    rc=DosChgFilePtr(Ud->Nfh,ofs,FILE_BEGIN,&ulNewPtr);
    if(rc||ulNewPtr!=ofs) return -1;

    rc=DosRead(Ud->Nfh,Ud->UsrNdx,sizeof(USRNDX),&cbBytesRead);
    if(rc||cbBytesRead!=sizeof(USRNDX)) return -1;

    return 0;
}

/**/

/* Write ndx file record Rec (zero based) */
SHORT PASCAL NdxWrite (PUDEF Ud, USHORT Rec)
{
    USHORT rc, cbBytesWritten;
    ULONG ofs, ulNewPtr;

    /* Seek the user file */
    ofs=(ULONG)Rec*sizeof(USRNDX);
    rc=DosChgFilePtr(Ud->Nfh,ofs,FILE_BEGIN,&ulNewPtr);
    if(rc||ulNewPtr!=ofs) return -1;

    rc=DosWrite(Ud->Nfh,Ud->UsrNdx,sizeof(USRNDX),&cbBytesWritten);
    if(rc||cbBytesWritten!=sizeof(USRNDX)) return -1;

    return 0;
}

/**/

/* Returns first lastread pointer not used */
static USHORT PASCAL FindNextLastread (PUDEF Ud)
{
    USHORT count, limit;

    /* Collect the lastread pointers if required */
    if(!Ud->GotLr) CollectLastread(Ud);

    limit=Ud->Unum>U_MR?U_MR:Ud->Unum;

    for(count=0;count<limit;count++) if(!IsBit(Ud->LrUsed,count)) break;
    BitOn(Ud->LrUsed,count); /* Mark the new one used */

    return count;
}

/**/

/* Fills the Udef Lastread bit array by scanning all records */
static VOID PASCAL CollectLastread (PUDEF Ud)
{
    USHORT count, cbBytesRead, limit;
    ULONG ulNewPtr;
    USR *usr;

    /* Get temp Usr storage */
    usr=(USR *)malloc(Ud->Usiz);
    if(usr==NULL) return;

    /* Clear the lastread array */
    memset(Ud->LrUsed,'\0',sizeof(Ud->LrUsed));

    /* Rewind the user file */
    DosChgFilePtr(Ud->Ufh,(LONG)0,FILE_BEGIN,&ulNewPtr);

    limit=Ud->Unum>U_MR?U_MR:Ud->Unum;

    /* Read all records */
    for(count=0;count<limit;count++) {
        if(DosRead(Ud->Ufh,usr,Ud->Usiz,&cbBytesRead)) break;
        BitOn(Ud->LrUsed,usr->lastread_ptr);
    }

    free(usr);

    /* Flag the Lastread bit array as filled */
    Ud->GotLr=TRUE;
}

/**/

/* Build full path & name */
static VOID PASCAL BuildPath (PCHAR Dest, PCHAR Path, PCHAR Name)
{
    if(!Dest) return;

    strcpy(Dest,Path);
    if(*Dest&&Dest[strlen(Dest)-1]!='\\') strcat(Dest,"\\");
    strcat(Dest,Name);
}

/**/

