/*͸
   UED - the Maximus-CBCS User Base Editor  (C) 1996 by CodeLand Australia 
   UTIL.C Utility routines                             All Rights Reserved 
  ;*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>

#define INCL_DOS
#include <os2.h>

#include "vid.h"
#include "menu.h"
#include "form.h"
#include "win.h"
#include "user.h"
#include "ued.h"

/**/

struct __priv _privs[]= {
    {"Transient",TRANSIENT},
    {"Demoted"  ,  DEMOTED},
    {"Limited"  ,  LIMITED},
    {"Normal"   ,   NORMAL},
    {"Worthy"   ,   WORTHY},
    {"Privil"   ,   PRIVIL},
    {"Favored"  ,  FAVORED},
    {"Extra"    ,    EXTRA},
    {"Clerk"    ,    CLERK},
    {"AsstSysOp",ASSTSYSOP},
    {"SysOp"    ,    SYSOP},
    {"Hidden"   ,   HIDDEN}
};

struct __prot _prot[]= {
    {"None     ", PROTOCOL_none    },
    {"Xmodem   ", PROTOCOL_xmodem  },
    {"1K-Xmodem", PROTOCOL_xmodem1k},
    {"Zmodem   ", PROTOCOL_zmodem  },
    {"SEAlink  ", PROTOCOL_sealink },
    {"Ymodem   ", PROTOCOL_ymodem  },
    {"GYmodem-G", PROTOCOL_ymodemg }
};

#define _VIDEO_NUM 3
struct __video _video[]= {
    {"AVATAR  ", GRAPH_AVATAR},
    {"ANSI    ", GRAPH_ANSI},
    {"TTY     ", GRAPH_TTY}
};

struct __help _help[]= {
    {"EXPERT  ", EXPERT},
    {"REGULAR ", REGULAR},
    {"NOVICE  ", NOVICE}
};

CHAR KeyNum[32]="12345678ABCDEFGHIJKLMNOPQRSTUVWX";

/**/

/* Pops open a window and gets a Y/N response after displaying message */
/* Returns 0=Unknown, 1=Yes - ** Defaults YES ** */
SHORT PASCAL YesNo (PCHAR Msg, SHORT srow, SHORT scol, SHORT erow, SHORT ecol)
{
    SHORT ch, message_length, mline, tab;

    if(!WinOpen(srow,scol,erow,ecol,0,WHITE|_RED,WHITE|_RED)) return 0;
    WINSHADOW();

    mline=erow-srow-3; if(mline<0) mline=0;
    message_length=strlen(Msg);
    tab=(ecol-scol-message_length-2)/2;
    WinPrintS(mline,tab,WHITE|_RED,Msg);
    WinPrintS(mline,tab+message_length+1,YELLOW|_RED,"Y");
    WinGotoXY(mline,tab+message_length+1);
    MenuClearKeys(); VidShowCur();
    ch=toupper(MenuGetChF("YyNn",'Y'));

    WinClose(); VidHideCur();
    return (ch=='Y'?1:0); /* Return 1-Y, 0-N */
}

/**/

VOID PASCAL Mesage (PCHAR message, SHORT srow, SHORT scol, SHORT erow, SHORT ecol)
{
    SHORT message_length, mline, tab;

    if(!WinOpen(srow,scol,erow,ecol,bdr,WHITE|_RED,WHITE|_RED)) return;
    WINSHADOW();
    mline=erow-srow-3; if(mline<0) mline=0;
    message_length=strlen(message);
    tab=(ecol-scol-message_length-2)/2;
    WinPrintS(mline,tab,WHITE|_RED,message);
}

/**/

/*
Conversion from 2 digit field year to SCOMBO years since 1980:
Year in 2 digits:   80     99    00     79
The Year        : 1980 - 1999  2000 - 2079
SCOMBO yr field :    0     19    20     99
*/
PCHAR PASCAL ShowDate (SCOMBO *pt, PCHAR str)
{
    USHORT Year;

    if(pt->msg_st.date.da==0&&pt->msg_st.date.mo==0&&pt->msg_st.date.yr==0) {
        strcpy(str,"  -  -  ");
    }
    else {
        /* Convert from years since 1980 */
        Year=pt->msg_st.date.yr;
        if(Year<20) Year+=80;
        else Year-=20;

        switch (UedCfg.DateFormat) {
        case DATE_OZ:
            sprintf(str,"%2.2u-%2.2u-%2.2u",pt->msg_st.date.da,pt->msg_st.date.mo,Year);
            break;
        case DATE_US:
            sprintf(str,"%2.2u-%2.2u-%2.2u",pt->msg_st.date.mo,pt->msg_st.date.da,Year);
            break;
        case DATE_JP:
            sprintf(str,"%2.2u-%2.2u-%2.2u",Year,pt->msg_st.date.mo,pt->msg_st.date.da);
            break;
        }
       str[8]='\0';
    }

   return str;
}

/**/

/* Gets date from str into combo pointer pt */
VOID PASCAL GetDate (SCOMBO *pt, PCHAR str)
{
    USHORT Year;

    /* Set default values */
    pt->msg_st.date.da=0; pt->msg_st.date.mo=0; pt->msg_st.date.yr=0;

    /* Get values */
    if(strlen(str)==8) {
        switch (UedCfg.DateFormat) {
        case DATE_OZ:
            pt->msg_st.date.da=atoi(str);
            str+=3; pt->msg_st.date.mo=atoi(str);
            str+=3; Year=atoi(str);
            break;
        case DATE_US:
            pt->msg_st.date.mo=atoi(str);
            str+=3; pt->msg_st.date.da=atoi(str);
            str+=3; Year=atoi(str);
            break;
        case DATE_JP:
            Year=atoi(str);
            str+=3; pt->msg_st.date.mo=atoi(str);
            str+=3; pt->msg_st.date.da=atoi(str);
            break;
        }

        /* Convert to years since 1980 */
        if(Year>=80) Year-=80;
        else Year+=20;
        pt->msg_st.date.yr=Year;
    }

    /* Check out of range */
    if(pt->msg_st.date.da>31) pt->msg_st.date.da=31;
    if(pt->msg_st.date.mo>12) pt->msg_st.date.mo=12;
}

/**/

PCHAR PASCAL ShowDOB (UCHAR Dd, UCHAR Mm, USHORT Yy, PCHAR str)
{
    if(Dd==0&&Mm==0&&Yy==0) strcpy(str,"  -  -  ");
    else {
        switch (UedCfg.DateFormat) {
        case DATE_OZ:
            sprintf(str,"%2.2u-%2.2u-%2.2u",Dd,Mm,Yy-1900);
            break;
        case DATE_US:
            sprintf(str,"%2.2u-%2.2u-%2.2u",Mm,Dd,Yy-1900);
            break;
        case DATE_JP:
            sprintf(str,"%2.2u-%2.2u-%2.2u",Yy-1900,Mm,Dd);
            break;
        }
       str[8]='\0';
    }

   return str;
}

/**/

/* Gets DOB from str */
VOID PASCAL GetDOB (PUCHAR Dd, PUCHAR Mm, PUSHORT Yy, PCHAR str)
{
    *Dd=0; *Mm=0; *Yy=0; /* Set default values */

    /* Get values */
    if(strlen(str)==8) {
        switch (UedCfg.DateFormat) {
        case DATE_OZ:
            *Dd=(UCHAR)atoi(str);
            str+=3; *Mm=(UCHAR)atoi(str);
            str+=3; *Yy=(USHORT)atoi(str)+1900;
            break;
        case DATE_US:
            *Mm=(UCHAR)atoi(str);
            str+=3; *Dd=(UCHAR)atoi(str);
            str+=3; *Yy=(USHORT)atoi(str)+1900;
            break;
        case DATE_JP:
            *Yy=(USHORT)atoi(str)+1900;
            str+=3; *Mm=(UCHAR)atoi(str);
            str+=3; *Dd=(UCHAR)atoi(str);
            break;
        }
    }

    /* Check out of range */
    if(*Dd>31) *Dd=31;
    if(*Mm>12) *Mm=12;
}

/**/

PCHAR PASCAL ShowTime (SCOMBO *pt, PCHAR str)
{
    sprintf(str,"%2.2u:%2.2u:%2.2u",pt->msg_st.time.hh,
        pt->msg_st.time.mm,pt->msg_st.time.ss<<1);

   return str;
}

/**/

VOID PASCAL GetTime (SCOMBO *pt, PCHAR str)
{
    /* Set default values */
    pt->msg_st.time.hh=0; pt->msg_st.time.mm=0; pt->msg_st.time.ss=0;

    /* Get values from string */
    if(strlen(str)==8) {
        pt->msg_st.time.hh=atoi(str);
        str+=3; pt->msg_st.time.mm=atoi(str);
        str+=3; pt->msg_st.time.ss=atoi(str)>>1;
    }

    /* Check out of range */
    if(pt->msg_st.time.hh>23) pt->msg_st.time.hh=23;
    if(pt->msg_st.time.mm>59) pt->msg_st.time.mm=59;
    if(pt->msg_st.time.ss>29) pt->msg_st.time.ss=29;
}

/**/

PCHAR PASCAL ShowPriv (USHORT priv)
{
    SHORT i;
    static CHAR Buf[16];

    for(i=0;i<UedCfg.PrivNum;i++) {
        if(priv==UedCfg.PrivValue[i]) {
            strcpy(Buf,UedCfg.Priv[i]); FormStrSetSz(Buf,9);
            return(Buf);
        }
    }
    sprintf(Buf,"%d",priv); FormStrSetSz(Buf,9);
    return Buf;
}
/**/

/* Returns the priv index of a given value */
SHORT PASCAL GetPriv (USHORT priv)
{
    SHORT i;

    for(i=0;i<UedCfg.PrivNum;i++) if(UedCfg.PrivValue[i]==priv) return(i);
    return(UedCfg.PrivNum-1);
}

/**/

/* Select a new priv value  */
SHORT PASCAL GetXPriv (USHORT priv)
{
    SHORT val, i;

    if(!WinOpen(17-UedCfg.PrivNum,23,18,35,bdr,BLUE|_CYAN,BLUE|_CYAN)) return priv;
    WINSHADOW();
    val=GetPriv(priv); /* Get current priv index */

    MenuBegC();
    for(i=0;i<UedCfg.PrivNum;i++)
        MenuItem(i,0,UedCfg.Priv[i],*UedCfg.Priv[i],i,0,NULL,0,0);
    MenuEnd(val,M_VERT,20,1,BLUE|_CYAN,LBLUE|_CYAN,BLUE|_CYAN,WHITE|_RED);
    val=MenuGet();

    WinClose(); /* Close window */

    if(val!=-1) priv=UedCfg.PrivValue[val]; /* Get new value */
    return priv;
}

/**/

/* Returns the protocol string of a given value */
PCHAR PASCAL ShowProt (CHAR prot)
{
    SHORT i;
    static CHAR str[10];

    if(prot>=0) {
        sprintf(str,"Extern %02d",(SHORT)prot+1);
        return str;
    }
    for(i=0;i<_PROT_NUM;i++) if(prot==_prot[i].value) return(_prot[i].name);
    return "         ";
}

/**/

/* Returns the protocol index of a given value */
SHORT PASCAL GetProt (CHAR prot)
{
    SHORT i;

    for(i=0;i<_PROT_NUM;i++) if(prot==_prot[i].value) return i;
    return 0;
}

/**/

PCHAR PASCAL ShowKeys (ULONG keys)
{
    SHORT i;
    static CHAR kbuf[33];

    for(i=0;i<16;i++) kbuf[i]=(lkey(keys)&(1<<i))?KeyNum[i]:(CHAR)'.';
    for(i=16;i<32;i++) kbuf[i]=(hkey(keys)&(1<<(i-16)))?KeyNum[i]:(CHAR)'.';
    kbuf[32]='\0';

    return kbuf;
}

/**/

/* Returns the video string of a given value */
PCHAR PASCAL ShowVideo (UCHAR video)
{
    SHORT i;

    for(i=0;i<_VIDEO_NUM;i++) if(video==_video[i].value) return(_video[i].name);
    return ("        ");
}

/**/

/* Returns the video index of a given value */
SHORT PASCAL GetVideo (UCHAR video)
{
    SHORT i;

    for(i=0;i<_VIDEO_NUM;i++) if(video==_video[i].value) return i;
    return (_VIDEO_NUM-1);
}

/**/

/* Returns the help string of a given value */
PCHAR PASCAL ShowHelp (UCHAR help)
{
    SHORT i;

    for(i=0;i<_HELP_NUM;i++) if(help==_help[i].value) return(_help[i].name);
    return("        ");
}

/**/

/* Returns the help index of a given value */
SHORT PASCAL GetHelp (UCHAR help)
{
    SHORT i;

    for(i=0;i<_HELP_NUM;i++) if(help==_help[i].value) return i;
    return (_HELP_NUM-1);
}

/**/

VOID PreMenu (VOID)
{
    VidHideCur(); WINSHADOW();
}

/**/

PCHAR PASCAL RemUS (PCHAR Str)
{
    PCHAR p;

    p=Str;

    while(*p) {
        if(*p=='_') *p=' ';
        ++p;
    }

    return Str;
}

/**/

PCHAR PASCAL AddUS (PCHAR Str)
{
    PCHAR p;

    p=Str;

    while(*p) {
        if(*p==' ') *p='_';
        ++p;
    }

    return Str;
}

/**/

