Uses Cfg
Uses User

Const Version = '1.0'
Const Author  = 'Darryl Perry 2016'
Const Prog		= 'Reversi'

Const XX   = 13
Const YY   = 5
Const AA   = 43


Const EMPTY = 0
Const PLAY  = 1
Const COMP  = 2
Const HINT  = 3
Const CRSR  = 4

Const NN   = 1
Const NE   = 2
Const EE   = 3
Const SE   = 4
Const SS   = 5
Const SW   = 6
Const WW   = 7
Const NW   = 8

Type PlyrRec = Record
  Alias : String[41]
  Idx  	: Integer
  Wins  : Integer
  Loss  : Integer
  Score : Integer
  Rank  : Integer
End

Var Grid   : Array [1..8,1..8] of Integer
Var Test   : Array [1..8,1..8] of Integer
Var Temp   : Array [1..8,1..8] of Integer
Var DirX   : Array [1..8] Of Integer
Var DirY   : Array [1..8] Of Integer
Var Colr   : Array [1..19] Of Integer
Var CurX   : Integer = 1
Var CurY   : Integer = 1
Var Turn   : Integer = PLAY
Var MMMM   : Integer = PLAY
Var YYYY   : Integer = COMP
Var GameOver: Boolean = False
Var AllDone : Boolean = False
Var Plyr    : PlyrRec
Var PlyrCnt : Integer = 0

Function ReadPlyr(I:Integer):Boolean
Var Ret  : Boolean = False
Var Fptr : File
Begin
	fAssign(Fptr,CfgDataPath+'reversi.ply',66)
	fReset(Fptr)
	If IoResult = 0 Then Begin
		fSeek(Fptr,(I-1)*SizeOf(Plyr))
		If Not fEof(Fptr) Then Begin
			Ret:=True
			fReadRec(Fptr,Plyr)
		End
		fClose(Fptr)
	End
	ReadPlyr:=Ret
End

Procedure SavePlyr(I:Integer)
Var Fptr  : File
Begin
  fAssign(Fptr,CfgDataPath+'reversi.ply',66)
  fReset(Fptr)
  If IoResult = 0 Then
    fSeek(fptr,(I-1)*SizeOf(Plyr))
  Else Begin
    Plyr.Idx:=1
    fReWrite(fptr)  
  End
  fWriteRec(Fptr,Plyr)
  fClose(Fptr)
End

Function FindPlyr(S:String):Integer
Var I,Ret : Integer = 0
Var Done  : Boolean = False
Begin
  S:=Upper(S)
  I:=1
  While I <= PlyrCnt And Not Done Do Begin
		If ReadPlyr(I) Then Begin
	    If Upper(Plyr.Alias) = S Then Begin
				Ret:=Plyr.Idx
				Done:=True
	    End
		End
    I:=I+1
  End  
  FindPlyr:=Ret
End

Function NewPlyr
Begin
  PlyrCnt:=PlyrCnt+1
  Plyr.Idx:=PlyrCnt
  Plyr.Wins:=0
  Plyr.Loss:=0
  Plyr.Rank:=0
  Plyr.Alias:=StripMCI(UserAlias)
  SavePlyr(Plyr.Idx)
End


Function CountChips(I:Integer):Integer
Var Ret  : Integer = 0
Var X,Y  : Integer
Begin
  For X:=1 To 8 Do Begin
    For Y:=1 To 8 Do Begin
      If Grid[X,Y]=I Then Ret:=Ret+1
    End
  End
  CountChips:=Ret
End

Procedure XWindow(H1:String;T,X1,Y1,X2,Y2:Integer)
Var T1,A1,A2,B1,B2  : String
Begin
  A1:=Int2Str(X1)
  A2:=Int2Str(X2)
  B1:=Int2Str(Y1)
  B2:=Int2Str(Y2)
  T1:=Int2Str(T)
  Write('|#X#'+T1+'#'+H1+'#'+A1+'#'+B1+'#'+A2+'#'+B2+'#')
End

Procedure ShowSpot(X,Y:Integer)
Var C  :  Integer
Begin
  C:=Grid[X,Y]+1
  WriteXY(((X-1)*3)+XX,((Y-1)*2)+YY,Colr[C],#17+#16)
End

Procedure DrawGrid
Var X,Y  : Integer
Begin
  For X:=1 To 8 Do Begin
    For Y:=1 To 8 Do Begin
      ShowSpot(X,Y)
    End
  End
End

Function MarkValidMoves:Integer
Var Ret,X,Y,C: Integer = 0
Var NX,NY,D: Integer
Var Done   : Boolean
Var Found  : Boolean
Begin

  For X:=1 To 8 Do Begin
    For Y:=1 To 8 Do Begin
      Test[X,Y]:=0
    End
  End

  For X:=1 To 8 Do Begin
    For Y:=1 To 8 Do Begin
      C:=Grid[X,Y]
      If C = MMMM Then Begin
        For D:=1 To 8 Do Begin
          NX:=X+DirX[D]
          NY:=Y+DirY[D]
          If NX <=8 And NX >=1 And NY <=8 And NY >=1 Then Begin
            If Grid[NX,NY] = YYYY Then Begin
              Done:=False
              Found:=False
              Repeat
                NX:=NX+DirX[D]
                NY:=NY+DirY[D]
                If NX < 1 Or NX > 8 Then Done:=True  
                If NY < 1 Or NY > 8 Then Done:=True  
                If Not Done Then
                  If Grid[NX,NY] = MMMM Then 
                    Done:=True
                If Not Done Then
                  If Grid[NX,NY] = EMPTY Then Begin
                    Done:=True
                    Found:=True
                  End
              Until Done
              If Found Then Begin
                Test[NX,NY]:=-1
                Ret:=Ret+1
                End
            End
          End
        End
      End
    End
  End
  MarkValidMoves:=Ret
End

Procedure ToggleTurn
Begin
  If Turn =PLAY Then 
    Turn:=COMP 
  Else 
    Turn:=PLAY

  If Turn = PLAY Then Begin
    MMMM:=PLAY
    YYYY:=COMP
  End Else Begin
    MMMM:=COMP
    YYYY:=PLAY
  End
  MarkValidMoves
End

Function AnyValidMovesLeft:Integer
Var  Ret  : Integer = 0
Begin
  Ret:=MarkValidMoves
  ToggleTurn
  Ret:=Ret+MarkValidMoves
  ToggleTurn
  AnyValidMovesLeft:=Ret
End

Procedure ResetGame
Var X,Y  : Integer
Begin
  For X:=1 To 8 Do Begin
    For Y:=1 To 8 Do Begin
      Grid[X,Y]:=EMPTY
    End
  End

  Grid[4,4]:=COMP
  Grid[5,5]:=COMP
  Grid[4,5]:=PLAY
  Grid[5,4]:=PLAY
  
  CurX:=1
  CurY:=1
  
  ToggleTurn
  ToggleTurn

  GameOver:=False
End

Procedure ShowMe
Var C  : Integer
Begin
  C:=Grid[CurX,CurY]
  WriteXY(((CurX-1)*3)+XX,((CurY-1)*2)+YY,Colr[CRSR+1+C],#17+#16)
End

Procedure Message(S:String)
Begin
    WriteXY(AA+2,YY+6,Colr[COMP+1],PadCt(S,23,' '))
End

Procedure Move(DD:Integer)
Var NX,NY  : Integer
Var OK    : Boolean = True
Begin
  NX:=CurX+DirX[DD]
  NY:=CurY+DirY[DD]
  
  If NX > 8 Then NX:=1
  If NY > 8 Then NY:=1
  If NX < 1 Then NX:=8
  If NY < 1 Then NY:=8

  If Ok Then Begin
    ShowSpot(CurX,CurY)
    CurX:=NX
    CurY:=NY
  End
	Message('')
End

Procedure ShowTest
Var X,Y  : Integer
Begin
  For X:=1 To 8 Do Begin
    For Y:=1 To 8 Do Begin
      If Test[X,Y] > 0 Then
      WriteXY(((X-1)*3)+XX,((Y-1)*2)+YY,(16*2)+15,PadLt(Int2Str(Test[X,Y]),2,' '))
    End
  End
End

Function CountValidMoves:Integer
Var Ret,X,Y  : Integer=0
Begin
  For X:=1 To 8 Do Begin
    For Y:=1 To 8 Do Begin
      If Test[X,Y] < 0 Then Begin
        Ret:=Ret+1
      End
    End
  End
  CountValidMoves:=Ret
End

Function IsValidMove(TX,TY:Integer):Boolean
Var Ret  : Boolean = False
Begin
  If TX <= 8 And TX >=1 And TY <= 8 And TY >=1 Then
    If Test[TX,TY] <> 0  Then 
      Ret:=True
  IsValidMove:=Ret
End

Procedure GetHint
Var X,Y  : Integer
Begin
  For X:=1 To 8 Do 
    For Y:=1 To 8 Do 
      If IsValidMove(X,Y) Then
        WriteXY(((X-1)*3)+XX,((Y-1)*2)+YY,Colr[HINT+1],#17+#16)
  ReadKey
  DrawGrid
End

Function MakeMove(CX,CY:Integer):Boolean
Var NX,NY,D: Integer
Var TX,TY,C: Integer
Var Done   : Boolean
Var Found  : Boolean = False
Var Ret    : Boolean = False
Begin
  If IsValidMove(CX,CY) Then Begin
    Ret:=True
    For D:=1 To 8 Do Begin
      Done:=False
      Found:=False
      C:=1
      NX:=CX
      NY:=CY
      Repeat
        C:=C+1
        NX:=NX+DirX[D]
        NY:=NY+DirY[D]
        If C > 15 Then Done:=True
        If NX < 1 Then Done:=True
        If NY < 1 Then Done:=True
        If NX > 8 Then Done:=True
        If NY > 8 Then Done:=True
        If Not Done Then 
          If Grid[NX,NY] = EMPTY Then 
            Done:=True
        If Not Done Then Begin
          If Grid[NX,NY] = MMMM Then Begin 
            Done:=True
            Found:=True
          End
        End
      Until Done

      If Found Then Begin
        TX:=CX
        TY:=CY
        C:=1
        While (TX<>NX Or TY<>NY) And C < 12 Do Begin
          If TX <= 8 And TX > 0 And TY <= 8 And TY > 0 Then
            Grid[TX,TY]:=MMMM
          TX:=TX+DirX[D]
          TY:=TY+DirY[D]
          C:=C+1
        End
      End 
    End
  End 
  MakeMove:=Ret
End

Procedure Copy2Temp
Var X,Y  : Integer
Begin
  For X:=1 To 8 Do Begin
    For Y:=1 To 8 Do Begin
      Temp[X,Y]:=Grid[X,Y]
    End
  End
End

Procedure CopyFromTemp
Var X,Y  : Integer
Begin
  For X:=1 To 8 Do Begin
    For Y:=1 To 8 Do Begin
      Grid[X,Y]:=Temp[X,Y]
    End
  End
End

Procedure FindBestMove
Var A,X,Y  : Integer
Var NX,NY  : Integer = 0
Begin

  // Test every valid move
  For X:=1 To 8 Do Begin
    For Y:=1 To 8 Do Begin
      If Test[X,Y]=-1 Then Begin
        Copy2Temp
        If MakeMove(X,Y) Then 
          Test[X,Y]:=CountChips(MMMM)
        CopyFromTemp
      End
    End
  End
  
  // Find the move that has the highest chips
  A:=0
  For X:=1 To 8 Do Begin
    For Y:=1 To 8 Do Begin
      If Test[X,Y]>A Then Begin
        A:=Test[X,Y]
        NX:=X
        NY:=Y
      End
    End
  End

  If A > 0 Then
    If MakeMove(NX,NY) Then 
      DrawGrid
End

Procedure UpdateScore
Begin
  WriteXY(AA+2,YY+1,Colr[PLAY+1],' Player      :'+PadLt(Int2Str(CountChips(PLAY)),4,' ')+'  ')
  Write('|23|00'+#220)
  WriteXY(AA+3,YY+2,16*7,PadRt(#223,20,#223))
  WriteXY(AA+2,YY+3,Colr[COMP+1],' Computer    :'+PadLt(Int2Str(CountChips(COMP)),4,' ')+'  ')
  Write('|23|00'+#220)
  WriteXY(AA+3,YY+4,16*7,PadRt(#223,20,#223))
  WriteXY(AA+ 2,YY+08,(16*7)+5,'Wins: '+PadLt(Int2Str(Plyr.Wins),3,' ')+'   Losses: '+PadLt(Int2Str(Plyr.Loss),3,' '))
End

Procedure CompMove
Begin
  If CountValidMoves > 0 Then Begin
    FindBestMove
  End Else Begin
		Message('Computer Passes!')
  End
  UpdateScore
  ToggleTurn
End

Procedure Winning
Var P,C,X,Y  : Integer
Begin
  P:=CountChips(PLAY)
  C:=CountChips(COMP)
  If P > C Then Begin
    Write('|#B#1#10#[Game Over]#Congratulations! You WON!#')
    Plyr.Wins:=Plyr.Wins+1
    Plyr.Score:=Plyr.Score+P
  End Else Begin
    Write('|#B#1#10#[Game Over]#Sorry. You LOST!#')
    Plyr.Loss:=Plyr.Loss+1
  End
  For Y:=1 To 8 Do Begin
    For X:=1 To 8 Do Begin
      Grid[X,Y]:=EMPTY
      If P > 0 Then Begin
        Grid[X,Y]:=PLAY
        P:=P-1
      End Else Begin
        If C > 0 Then Begin
          Grid[X,Y]:=COMP
          C:=C-1
        End
      End
    End
  End  
  DrawGrid  
  ReadKey
  SavePlyr(Plyr.Idx)
End

Function Main:Boolean
Var Ch  : Char
Begin
  DrawGrid
  While Not GameOver Do Begin
    If Turn = COMP Then CompMove
    ShowMe
    Ch:=ReadKey
    If IsArrow Then Begin
      Case Ch Of
        #72: Move(NN)
        #80: Move(SS)
        #75: Move(WW)
        #77: Move(EE)
      End
    End Else Begin
      Ch:=Upper(Ch)
      Case Upper(Ch) Of
        'Q',#27: GameOver:=True
        'H': GetHint
        'R': DrawGrid
        'T': Begin
            ToggleTurn
            GetHint
            ToggleTurn
            End
        #13: Begin 
            If MakeMove(CurX,CurY) Then Begin
              DrawGrid
              UpdateScore
              ToggleTurn
            End Else Begin
							Message('Invalid Move!')
            End
          End
        'P': Begin
						Message('Player Passes!')
            ToggleTurn
          End
      End
    End
    If AnyValidMovesLeft= 0 Then Begin
      Winning
      GameOver := True
    End
  End
  Main:=GameOver
End

Procedure Init
Var X  : Integer
Begin
  GetThisUser
  DirX[NN]:=0;  DirY[NN]:=-1
  DirX[NE]:=1;  DirY[NE]:=-1
  DirX[EE]:=1;  DirY[EE]:=0
  DirX[SE]:=1;  DirY[SE]:=1
  DirX[SS]:=0;  DirY[SS]:=1
  DirX[SW]:=-1;  DirY[SW]:=1
  DirX[WW]:=-1;  DirY[WW]:=0
  DirX[NW]:=-1;  DirY[NW]:=-1

  Colr[EMPTY+1]:=(16*2)+2
  Colr[COMP+1] :=(16*2)+15
  Colr[PLAY+1] :=(16*2)
  Colr[HINT+1] :=(16*7)
  Colr[CRSR+1] :=(16*4)+10
  Colr[CRSR+1+PLAY] :=(16*3)+15
  Colr[CRSR+1+COMP] :=(16*3)

	PlyrCnt:=0
  While ReadPlyr(PlyrCnt+1) Do PlyrCnt:=PlyrCnt+1
  X:=FindPlyr(StripMCI(UserAlias))
  If X > 0 Then  ReadPlyr(X)
  Else  NewPlyr
End

Procedure MakeBoard
Var V,C,X,Y  : Integer
Var NX,NY: Integer
Begin
  V:=Random(2)+1
  V:=1
  XWindow('',V,XX-2,YY-1,XX+24,YY+15)
  C:=(16*2)+14
  For X:=1 To 8 Do Begin
    For Y:=1 To 8 Do Begin
      NX:=((X-1)*3)-1+XX
      NY:=((Y-1)*2)-1+YY
      If X > 1 And Y > 1 Then WriteXY(NX,NY,C,#197)
      If X > 1 Then WriteXY(NX,NY+1,C,#179)
      If Y > 1 Then WriteXY(NX+1,NY,C,#196+#196)
    End
  End  
  XWindow(' Reversi ',V,AA,YY-1,AA+26,YY+15)
  WriteXY(AA+ 2,YY+09,(16*7)+5,PadRt(#196,23,#196))
  WriteXY(AA+ 3,YY+10,(16*7)+5,PadRt(#016+' - Right',9,' '))
  WriteXY(AA+ 3,YY+11,(16*7)+5,PadRt(#017+' - Left',8,' '))
  WriteXY(AA+14,YY+10,(16*7)+5,PadRt(#030+' - Up',8,' '))
  WriteXY(AA+14,YY+11,(16*7)+5,PadRt(#031+' - Down',8,' '))
  WriteXY(AA+ 3,YY+12,(16*7)+5,PadRt('H - Hint',8,''))
  WriteXY(AA+14,YY+12,(16*7)+5,PadRt('Q - Quit',8,''))
  WriteXY(AA+ 2,YY+13,(16*7)+5,PadRt(#196,23,#196))
  WriteXY(AA+ 2,YY+14,(16*7)+5,PadCt('By '+Author,23,' '))
End

Procedure DoInstructions
Begin
  DispFile('reversih')
End

Procedure DoScores
Var I  : Integer
Var PPly  : PlyrRec
Var SF	: String = CfgTextPath+'reversi.ans'
Begin
  PPly:=Plyr
  I:=1
	If FileExist(SF) Then FileErase(SF)
  AppendText(SF,'|11|CL|CR')
	AppendText(SF,'|$D19 |17|09'+#219+'|$D38'+#223+#219+'|16')
  AppendText(SF,'|$D19 |17|09'+#221+' |11'+PROG+' '+Version+'     |14By '+Author+' |09'+#222+'|16')
	AppendText(SF,'|$D19 |17|09'+#219+'|$D38'+#205+#219+'|16')
  AppendText(SF,'|$D19 |17|09'+#221+' |15Player                  |10Wins  |12Losses |09'+#222+'|16')
	AppendText(SF,'|$D19 |17|09'+#219+'|$D38'+#196+#219+'|16')
  While ReadPlyr(I) Do Begin
    AppendText(SF,'|$D19 |17|09'+#221+' |15'+PadRt(Plyr.Alias,21,' ')+' |10'+PadLt(Int2Str(Plyr.Wins),6,' ')+'  |12'+PadLt(Int2Str(Plyr.Loss),6,' ')+' |09'+#222+'|16')
    I:=I+1
  End
	AppendText(SF,'|$D19 |17|09'+#219+'|$D38'+#220+#219+'|16|CR|PA')
  Plyr:=PPly
	DispFile(SF)
End

Procedure Q2BBS
Begin
  halt
End

Procedure Intro
Var Done  : Boolean = False
Begin
  While Not Done Do Begin
    DispFile('reversis')
    Write('|#V#1#30#10# Reversi #P-Play Reversi,I-Instructions,S-Scores,Q-Quit To BBS#')
    Case Upper(ReadKey) Of
      'P': Done:=True
      'I': DoInstructions
      'S': DoScores
      'Q': Q2BBS
    End
  End
End

Begin
  Init
  While Not AllDone Do Begin
    DispFile('reversis')
    Pause
    Intro
    ClrScr
    MakeBoard
    ResetGame
    UpdateScore
    Main
  End
End
