# TCR.MPS: Mystic BBS Program to use the TCR Callback Verifier
# ------------------------------------------------------------
#
# This program will allow Mystic BBS to interface with the TCR callback
# verifier door v2.00.  The TCR callback door can be found on the Mystic BBS
# web page and support BBS.
#
# Installation instructions:
#
# 1. Install TCR v2.00 according to the documentation included with the
#    program for a multi-node BBS system.
# 2. Create a batch file to run the TCR v2.00 door.  Below is a sample batch
#    file which should do the trick just as long as you change the
#    directories in the batch file to those which fit your BBS setup.
#
#    @ECHO OFF
#    CD\MYSTIC\DOORS\TCR
#    TCR /L:%1 /D:%2 /#:%3
#
# 3. Have Mystic BBS run this script at the time when you would like the user
#    to use the callback verification system.  Don't forget to use MPLC.EXE
#    to compile the script before attempting to execute it!

# START PROGRAM HERE

Var File1 String
Var File2 String

WriteLn ('|CR|14Loading callback verification...')

# The following menu command will execute a DOOR.SYS door with all the
# command line parimeters needed for TCR.  So just point it to run the batch
# file shown above, and everything should work nicely just as long as you've
# setup TCR itself correctly and changed the directories in the batch file
# to point to the TCR directory.

# For reference, the command line options for TCR v2.00 are:
# TCR.EXE /L:<Language file> /D:<Path to DOOR.SYS> /#:<Node Number>

MenuCmd ('DG', 'c:\mystic\doors\tcr.bat ENGLISH c:\mystic\temp%3\ %3')

# Change these to point to the TCR directory.  The File1 variable points to
# the path/filename of the file TCR produces after a successful verification.
# The File2 variable points to the path/filename of the file TCR produces if
# the callback is a long distance call.

File1 := 'C:\MYSTIC\DOORS\TCR\SUCCESS.'  + Int2Str(NodeNum)
File2 := 'C:\MYSTIC\DOORS\TCR\LONGDIST.' + Int2Str(NodeNum)

If FExist(File1)                       
     UpUser (20)             # Security level after successful verification
EndIf

If FExist(File2)
     UpUser (20)             # Security level for long distance callers
EndIf
