' FileName: MysEMT.Bas
' Date: 4/9/2017
' Author: Ben Ritchey
' Description: Generate Inbound Echomail Traffic Report

#COMPILER PBCC 5
#COMPILE EXE
#DIM ALL

FUNCTION PBMAIN () AS LONG
Local RC as integer
Local DateFrom, DateTo, EMTWk, EMTag, A as string
Local K, Tot, L, Cnt as long
Local Pct as double

Local PgmVer as String

' Do NOT change format of next line except x-x !!!
  PgmVer=" MysEMT v1.0.D "

Open "logs\mutil.log" for input as #1
Open "MysEMT1.txt" for output as #2
Tot=0: DateFrom="": DateTo=""

While not eof(1)
  Line input #1,A
  L=instr(A,"  Import #")
  If L>0 then
    K=instr(A," to ")
    EMTag=mid$(A,K+4)
    Print #2,EMTag;space$(37-len(EMTag));mid$(A,3,15)
    Incr Tot
    If Tot=1 then DateFrom=mid$(A,3,6)
  End if
WEnd
DateTo=mid$(A,3,6)

Close
Shell "cmd /c type MysEMT1.txt |sort >MysEMT2.txt"

Open "MysEMT2.txt" for input as #1
Open "MysEMT.Rpt" for output as #2

Print #2
Print #2,PgmVer;space$(5);"Mystic Inbound Echomail Traffic Report ";space$(10);date$
Print #2
Print #2,space$(29);"From ";DateFrom;" to ";DateTo
Print #2
L=len(command$)
Print #2,space$((80-L)/2);command$
Print #2
Print #2,string$(79,"_")
Print #2

EMTag="": Cnt=0
While not eof(1)
  Line input #1,A
  EMTWk=trim$(mid$(A,1,36))
  If EMTWk<>EMTag then
    If EMTag<>"" then
      L=len(EMTag)
      Pct=Int((Cnt/Tot)*1000)/10
      Print #2,EMTag;" ";string$(37-L,".");" : ";
      Print #2,using$("###,###",Cnt);
      If Pct>0 then 
        Print #2," ";using$("###.#",Pct);"%"
       else
        Print #2
      End if
    End if
    EMTag=EMTWk: Cnt=1
   Else
    Incr Cnt
  End if
WEnd

' Do last one!
      L=len(EMTag)
      Pct=Int((Cnt/Tot)*1000)/10
      Print #2,EMTag;" ";string$(37-L,".");" : ";
      Print #2,using$("###,###",Cnt);
      If Pct>0 then 
        Print #2," ";using$("###.#",Pct);"%"
       else
        Print #2
      End if

Print #2
Print #2,string$(79,"_")
Print #2
Print #2,"    Total Messages = ";using$("###,###",Tot)
Print #2

ENDITALL:
Close
Kill "MysEMT1.txt"
Kill "MysEMT2.txt"
End RC

END FUNCTION

