# .-------------------------.
# | GO-JUMP.MPS : RELEASE 1 |------------------------------------------------
# `-------------------------'
#  
#  This mod is written for use with Mystic BBS v1.07 under all platforms.
#
#  You may modify this program for your own personal use.  You are *NOT*
#  granted permission to distribute this file in any type of modified form.
#  You may not use this source code as a base for any mods you plan to
#  release. If you feel you've made changes which are beneficial, e-mail me
#  and I will consider either adding them or giving you permission to release
#  your modified version.  As long as this goes well, I will continue to
#  write and distribute most of my MPL addons that i've written with full
#  source code.
#
#  You can contact me at mysticbbs@geocities.com
# ---------------------------------------------------------------------------

# The three CONST variables below are now your new message reading prompts.
# Configure them to your liking, or just copy your existing prompts (115,
# 116, 213) to these variables before doing the installation steps.
 
Const
  Prompt115 = '|CR|09(A)gain, (P)revious, (N)ext, (R)eply, (D)elete, (J)ump, (Q)uit? |11',
  Prompt116 = '|CR (|&1 of |&2) Reading Messages (?/Help): |11',
  Prompt213 = '|CR|09[|&1 of |&2] Reading Messages (?/Help): |11'

Var
  Prompt  String,
  Keys    String,
  Str     String,
  Ch      Char
Begin
  Str := Upper(ParamStr(1))

  If Str = 'NORMAL' Then
    Prompt := Prompt116
    Keys   := 'AGHILNPQRTX[]?'
  ElseIf Str = 'SYSOP' Then
    Prompt := Prompt213
    Keys   := 'ADEGHILNPQRTX[]?'
  ElseIf Str = 'EMAIL' Then
    Prompt := Prompt115
    Keys   := 'ADHLNPQRX?'
  Else
    WriteLn ('G0-JMP: Invalid command option')
    Halt
  EndIf

  Write (Prompt)

  Str := ''

  Repeat
    Ch := Upper(ReadKey)

    If Ord(Ch) = 13 Then
      If Str <> '' Then
        StuffKey ('J' + Str + Chr(13))
        Halt
      Else
        StuffKey(Ch)
        Halt
      EndIf
    ElseIf Ord(Ch) > 47 And Ord(Ch) < 58 And Length(Str) < 5 Then
      Write(Ch)
      Str := Str + Ch
    ElseIf Ord(Ch) = 8 And Str <> '' Then
      Write (Chr(8) + ' ' + Chr(8))
      Str := Copy(Str, 1, Length(Str) - 1)
    ElseIf Str = '' And Pos(Ch, Keys) > 0 Then
      StuffKey(Ch)
      Halt
    EndIf
  Until False  
End
