//
// Update history
//
// Version 1.1   - Gryphon // Cyberia BBS
// Version 1.1.4 - Stackfault [sf] <phENom> // The Bottomless Abyss
//
// List of changes/fixes:
//
// v1.1.1
// - Input buffer is now unblocking, you can see received chats while typing
// - Input buffer length is maxed, with color coded character counter
// - Input buffer history still available with UP/DOWN arrow keys
// - Fixed a race condition when line cannot be word wrapped
// - Added CPU release in each loops
// - Visible heartbeat animation when server refresh is active
// - Improved responsiveness and buffer refresh rate
// - Enlarged view port, now using the full 24 lines screen height
// - Now shows connected chatters when logging in
// - Welcome text at connection
// - New /changes command
// - 100% compatible with current MRC server implementation
//
// v1.1.2
// - Various small fixes
//
// v1.1.3
// - Implemented command whitelisting around pipe codes
// - Implemented colors live switching with PgUp/PgDn
// - Implemented timestamp highlighting on nick mention
// - Various validation of string input and length checking
//
// v1.1.4
// - Show private message when sent
// - Changed mention indicator to better support present/absent clock
// - Change wrapping on multiline chats to better use available screen space
// - Added information scroller
//

//                     Installation instructions
//
// - MRC Central server is relocating, please use the address below .This
//   will ensure a painless transition from Fluph when everything is ready.
// - Thanks Skuz for hosting the server on Fluph for all this time!
//
//   ====================================================================
//                mrc.bottomlessabyss.net on port 5000
//   ====================================================================
//
// - Use a vanilla MRC 1.1 installation package and ensure it is running
//   fine on your system (it must work before installing this update).
// - Vanilla installation package can be obtained from Gryphon's Cyberia BBS
//   or other fine BBSes.
// - If your 1.1 installation does not work, please seek the help of another
//   Sysop who got this working.
// - If you have modded your installation, you will have to adapt this update
//   by yourself.
// - Once MRC is running at version 1.1, backup the original files and replace
//   the 4 files provided in this update:
//   - {themepath}/text/mrcmain.ans
//   - {themepath}/text/mrchelp.ans
//   - {themepath}/text/mrcscroll.ans
//   - {themepath}/scripts/mrc_chat.mps
// - The installation package comes with sample screens (ans) fitting to new client.
// - Compile mrc_client.mps (./mplc mrc_client.mps) from your scripts directory.
// - This should work as a direct replacement of version 1.1
// - You can also change some of the items by changing their configuration variables
//   in the customization config block below [CUST]
// - Test your update is working before attempting any modification to make
//   sure it works.
//
// - Kudos to Pequito, Ktulu, MaxMouse, Smooth and MeatLotion for the testing!
//

Uses Cfg
Uses User

Const MRCVersion = 'Mystic Relay Chat MPL v1.1.4 [sf]'
Const CLBuffer	= 25
Const InputSize = 255
Const MaxBuffer = 140  // Max input buffer limit [sf]

Type MRCRec	= Record
	FromUser	: String[30]
	FromSite	: String[30]
	FromRoom	: String[30]
	ToUser		: String[30]
	ToSite		: String[30]
	ToRoom		: String[30]
	Message		: String[InputSize]
End

Type UserRec	= Record
	RecIdx		: Integer
	PermIdx		: Integer
	EnterChatMe	: String[80]
	EnterChatRoom	: String[80]
	EnterRoomMe	: String[80]
	EnterRoomRoom 	: String[80]
	LeaveChatMe   	: String[80]
	LeaveChatRoom	: String[80]
	LeaveRoomMe	: String[80]
	LeaveRoomRoom 	: String[80]
	Name		: String[80]
	DefaultRoom	: String[80]
	Temp1		: String[80]
	Temp5		: String[80]
	Temp6		: String[80]
	Temp7		: String[80]
	NameColor	: String[16]
	LtBracket	: String[16]
	RtBracket	: String[16]
	UseClock	: Boolean
	ClockFormat	: Boolean
End

Var Plyr			: UserRec
Var WinTL, WinTT, WinBL, WinBB	: Byte

Var ChatLines		: Array [1..CLBuffer] of String[160]
Var WinAttr		: Byte
Var WinSize		: Integer
Var PromptX		: Byte
Var PromptY		: Byte
Var PromptAttr		: Byte
Var RoomX, RoomY	: Byte
Var RoomAttr		: Byte
Var TopicX, TopicY	: Byte
Var TopicAttr		: Byte
Var MyNamePrompt	: String
Var MyChatRoom		: Integer = 1
Var Loop		: Integer = 1
Var SiteTag		: String
Var UserTag		: String
Var MyRoom		: String = ''
Var MyTopic		: String = ''
Var ServFile		: MRCRec
Var BBSTempStub		: String
Var ChatLog		: String
Var PInUse		: String
Var UserFile		: String = JustPath(Progname)+'mrcusers1.dat'
Var ChatSeed		: Integer
Var TChars		: Array [1..80] of Char
Var TAttrs		: Array [1..80] of Byte
Var BufferHist		: Array [1..10] of String [160]  // Buffer history [sf]
Var BannerList		: Array [1..10] of String [160]  // Header banners [sf]
Var BannerOff		: Byte = 0 // Banner scrolling offset [sf]
Var BanIdx		: Byte = 0 // Banner index [sf]
Var ScrollWait		: Byte = 0 // Banner scrolling wait [sf]

//
// Beginning of customization variables block [CUST]
//

// Heartbeat animation sequence [sf]
Var Heartbeat	: String = Chr(176) + Chr(177) + Chr(178) + Chr(219) + Chr(178) + Chr(177)

Var HeartbeatX  : Byte = 76              // X position of HeartBeat [sf]
Var HeartbeatY  : Byte = 23              // Y position of HeartBeat [sf]
Var HeartbeatClr: Byte = 3               // Color of HeartBeat [sf]

Var CounterX1	: Byte = 60              // X position of characters counter [sf]
Var CounterY1	: Byte = 23              // X position of characters counter [sf]

Var CounterX2	: Byte = 64              // X position of max characters count [sf]
Var CounterY2	: Byte = 23              // X position of max characters count [sf]

Var InputBg	: String = Chr(250)      // Input background character [sf]
Var InputClr	: String = '|16|17|07'   // Input field color [sf]
Var CIdx,TIdx   : Byte = 7               // Chat text color index [sf]

Var MClr	: String = '|24|10'      // Mention indicator colors (background+foreground)
Var MChr	: String = Chr(175)      // Mention indicator character
Var TClr	: Byte = 8               // Timestamp color
Var BClr	: Byte = 11              // Scroller color [sf]
Var BFad1	: Byte = 3               // Scroller fader color 1 [sf]
Var BFad2	: Byte = 8               // Scroller fader color 2 [sf]
Var BannerX	: Byte = 43              // XPosition of banner [sf]
Var BannerY	: Byte = 2               // YPosition of banner [sf]
Var BannerLen	: Byte = 36              // Length of banner [sf]
Var ScrollDly	: Byte = 0               // Banner scrolling start delay

// Define banner to scroll, loaded at each banner change (for dynamic content for example)
Procedure LoadBanners
Begin
	BannerList[1] := MRCVersion
	BannerList[2] := 'Welcome to the updated MRC client, see /CHANGES for the list of changes'
	BannerList[3] := 'Do not miss the weekly Meetup in the Abyss, each Wednesday at 9PM EST'
End

//
// End of customization variables block [CUST]
//

//Include chat.inc

Function ReadPlyr(I:Integer):Boolean
Var Ret		: Boolean = False
Var Fptr	: File
Begin
	fAssign(Fptr,UserFile,66)
	fReset(Fptr)
	If IoResult = 0 Then Begin
		fSeek(Fptr,(I-1)*SizeOf(Plyr))
		If Not fEof(fptr) Then Begin
			fReadRec(Fptr,Plyr)
			Ret:=True
		End
		fClose(Fptr)
	End
	ReadPlyr:=Ret
End

Procedure SavePlyr(I:Integer)
Var Fptr	: File
Begin
	fAssign(Fptr,Userfile,66)
	fReset(Fptr)
	If IoResult = 0 Then
		fSeek(Fptr,(I-1)*SizeOf(Plyr))
	Else Begin
		Plyr.RecIdx:=1
		fReWrite(Fptr)
	End
	fWriteRec(Fptr,Plyr)
	fClose(Fptr)
End

Function FindPlyr:Integer
Var X,Ret	: Integer = 0
Var Done	: Boolean = False
Var UN		: String
Begin
	X:=1
	UN:=Upper(StripMCI(Replace(UserAlias,' ','_')))
	While ReadPlyr(X) And Not Done Do Begin
		If StripMCI(Upper(Plyr.Name)) = UN Then Begin
				Done:=True
				Ret:=X
		End
		X:=X+1
	End
	FindPlyr:=Ret
End

Procedure NewPlyr
Var I	: Integer
Begin
	I:=0
	While ReadPlyr(I+1) Do I:=I+1

	Plyr.RecIdx		:=I+1
	Plyr.PermIdx		:=UserIndex
	Plyr.EnterChatMe	:='|07- |15You have entered chat'
	Plyr.EnterChatRoom	:='|07- |11%1 |03has arrived!'
	Plyr.LeaveChatMe  	:='|07- |12You have left chat.'
	Plyr.LeaveChatRoom	:='|07- |12%1 |04has left chat.'
	Plyr.EnterRoomMe	:='|07- |11You are now in |02%3'
	Plyr.LeaveRoomRoom 	:='|07- |02%1 |10has left the room.'
	Plyr.LeaveRoomMe	:='|07- |10You have left room |02%3'
	Plyr.EnterRoomRoom	:='|07- |11%1 |03has entered the room.'
	Plyr.Defaultroom	:='lobby'
	Plyr.NameColor		:='|11'
	Plyr.LtBracket		:='|03<'
	Plyr.RtBracket		:='|03>'
	Plyr.UseClock		:=True
	Plyr.ClockFormat	:=False

	Plyr.Name:=StripMCI(Replace(UserAlias,' ','_'))

	SavePlyr(Plyr.RecIdx)
End

Procedure CleanOutTempDir
Begin
	FindFirst(CfgTempPath+'*.mrc',66)
	While DosError = 0 Do Begin
		If FileExist(CfgTempPath+DirName) Then
			FileErase(CfgTempPath+DirName)
	End
	FindClose
	If FileExist(PInUse) Then
		fileErase(PInUse)
	If FileExist(ChatLog) Then
		fileErase(ChatLog)
End

Function AmIFirst:Boolean
Var D,X	: Integer
Var Ret	: Boolean = False
Var S	: String
Begin
	D:=0
	For X:=1 To CfgTnNodes Do Begin
		S:=BBSTempStub+Int2Str(X)+PathChar+'tchat.inuse'
		If FileExist(S) And D=0 Then Begin
			D:=X
		End
	End
	If D = NodeNum Then Ret:=True
	AmIFirst:=Ret
End

Procedure UpdateScreen
Var X	: Integer
Begin
	WriteXY(RoomX,RoomY,RoomAttr,PadRt('#'+MyRoom,30,' '))
	WriteXY(TopicX,TopicY,TopicAttr,PadRt(MyTopic,40,' '))
End

Procedure ShowChat(Top:Integer)
Var C,T,L,Y,X	: Integer
Var G,V,W	: String = ''
Var N2D		: Boolean = True
Begin
	Y:=CLBuffer-WinSize-Top
	For X:=1 To WinSize+1 Do Begin
		GoToXy(1,WinTT+X-1)
		Write(ChatLines[Y]+'|16|$X80 ')
		Y:=Y+1
	End
End

Function GetPipe(C:Byte) : String
Begin
	If C < 32 Then
		GetPipe := '|' + PadLT(Int2Str(C), 2, '0')
End

Function ParseChat(S:String) : MrcREc
Var MR	: MrcRec
Begin
	MR.FromUser:=WordGet(1,S,'~')
	MR.FromSite:=WordGet(2,S,'~')
	//MR.FromRoom:=Str2Int(WordGet(3,S,'~'))
	MR.FromRoom:=WordGet(3,S,'~')
	MR.ToUser:=WordGet(4,S,'~')
	MR.ToSite:=WordGet(5,S,'~')
	//MR.ToRoom:=Str2Int(WordGet(6,S,'~'))
	MR.ToRoom:=WordGet(6,S,'~')
	MR.Message:=WordGet(7,S,'~')
	ParseChat:=MR
End

Procedure RedrawScreen
Begin
	DispFile('mrcmain')
	UpdateScreen
	ShowChat(0)
End

Procedure Add2Chat(S:String)
Var E,W,L,B,A,X	: Integer
Var DS,S1,S2,S3: String=''
Var HL : String
Begin
	// Highlight on nick mention [sf]
	HL := '|16|00.'
	If Pos(Upper(UserTag), Upper(StripMCI(Copy(S, Length(WordGet(1,S,' ')), Length(S))))) > 0 Then
		HL := MClr + MChr + '|16|07'

	If Pos(Upper(UserTag), Upper(StripMCI(Copy(S, Length(WordGet(1,S,' ')), Length(S))))) > 0 Then
		HL := MClr + MChr + '|16|07'

	S3:=' ' + Chr(28) + ' '
	If Plyr.UseClock Then Begin
	Begin
		DS:=TimeStr(DateTime,Plyr.ClockFormat)
		If Not Plyr.ClockFormat Then
			Delete(DS,6,3)
		S:=GetPipe(TClr)+DS+HL+'|16|07'+S+'|16'
		S3:=StrRep(' ', Length(DS)) + S3
	End
	Else
		S:=HL+'|16|07'+S

	S1:=S
	Repeat
		B:=Length(S1)
		A:=Length(StripMCI(S1))
		L:=79-(A-B)
		Delay(10)

		S2:=''
		W:=StrWrap(S1,S2,L)

		// Handle when word does not fit on one line [sf]
		// Normal chat should contain spaces to allow for wrapping
		// Whole line is discarded in that case
		If (Length(WordGet(2,StripMCI(S1),' ')) > 0) or
                   (S1 <> '' and S2 = '')  Then
		Begin
			For X:=2 To CLBuffer Do
				ChatLines[X-1]:=ChatLines[X]
			ChatLines[CLBuffer]:='|16'+S1
			AppendText(ChatLog,ChatLines[CLBuffer])

			S1:=S3+S2
		End
		Else
			S2:=''

	Until S2=''
End

Procedure MakeChatEntry(S:String)
Var Fil	: String = CfgDataPath+'mrc'+PathChar+Int2Str(ChatSeed)+Int2Str(Random(9))+Int2Str(Random(9))+'.mrc'
Begin
	AppendText(Fil,S)
	ChatSeed:=ChatSeed+1
End

Procedure SendOut(FU,FS,FR,TU,TS,TR,S:String)
Var TX	: String
Begin
	TX:=FU+'~'+FS+'~'+FR+'~'+TU+'~'+TS+'~'+TR+'~'+S+'~'
	MakeChatEntry(TX)
End

Procedure SendToMe(S:String)
Var Me	: String = UserTag+'~'+SiteTag+'~'+MyRoom+'~'+UserTag+'~'+SiteTag+'~'+MyRoom+'~'+S+'~'
Begin
	MakeChatEntry(Me)
End

Procedure SendToAllNotMe(S:String)
Begin
	SendOut(UserTag,SiteTag,MyRoom,'NOTME','','',S)
End

Procedure SendToRoomNotMe(S:String)
Begin
	SendOut(UserTag,SiteTag,MyRoom,'NOTME','',MyRoom,S)
End

Procedure SendToAll(S:String)
Begin
	SendOut(UserTag,SiteTag,MyRoom,'','','',S)
End

Procedure SendToRoom(S:String)
Begin
	SendOut(UserTag,SiteTag,MyRoom,'','',MyRoom,S)
End

Procedure SendToUser(U,S:String)
Begin
	SendOut(UserTag,SiteTag,MyRoom,U,'','',S)
End

Procedure SendToClient(S:String)
Begin
	SendOut(UserTag,SiteTag,MyRoom,'CLIENT',SiteTag,MyRoom,S)
End

Procedure SendToServer(S:String)
Begin
	SendOut(UserTag,SiteTag,MyRoom,'SERVER',SiteTag,MyRoom,S)
End

Procedure ProcessChat(MR:MRCRec)
Var Ok2Send : Boolean = True
Var Command,Opt1,Opt2: String
Begin
	If Pos('ROOMTOPIC',Mr.Message) > 0 Then Begin
		Command:=WordGet(1,Mr.Message,':')
		opt1:=WordGet(2,Mr.Message,':')
		opt2:=WordGet(3,Mr.Message,':')
		If Opt1 = MyRoom Then Begin
			MyTopic:=Opt2
			UpdateScreen
			Ok2Send:=False
		End
	End

	If MR.ToRoom <> '' Then
		if Upper(MR.ToRoom) <> Upper(MyRoom) Then
			Ok2Send:=False

	If MR.ToUser <> '' Then
		 If Mr.ToUser <> 'NOTME' Then
				If Length(Mr.ToUser) > 3 Then
					If Pos(Upper(MR.ToUser),Upper(UserTag))=0
						Then Ok2Send:=False
	Else
		If Mr.ToUser <> 'NOTME' Then
			If Upper(Mr.FromUser) = Upper(UserTag) Then
				Ok2Send:=False
	If Ok2Send Then
		Add2Chat(MR.Message)
End

Procedure ReadChatFiles
Var F1	: File
Var S	: String
Var Ret	: Boolean = False
Begin
	FindFirst(CfgTempPath+'*.mrc',66)
	While DOSError = 0 Do Begin
		Ret:=True
		fAssign(F1,CfgTempPath+DirName,66)
		fReset(F1)
		While Not fEof(F1) Do Begin
			fReadLn(F1,S)
			ServFile:=ParseChat(S)
			ProcessChat(ServFile)
		End
		fClose(F1)
		fileErase(CfgTempPath+DirName)
		FindNext
	End
	FindClose
	If Ret Then ShowChat(0)
End

Function UpdateStrings(S,M,U,NR,OR:String):String
Begin
	S:=Replace(S,'%1',M)
	S:=Replace(S,'%2',U)
	S:=Replace(S,'%3','#'+NR)
	S:=Replace(S,'%4','#'+OR)
	UpdateStrings:=S
End

Procedure JoinRoom(S:String;B:Boolean)
Var NewRoom,OldRoom:String
Begin
	If Length(S) > 0 Then Begin
		OldRoom:=MyRoom
		NewRoom:=lower(S)
		StripB(S,'#')
		SendToServer('NEWROOM:'+MyRoom+':'+S)
		If B Then Begin
			Delay(50)
			SendToMe(UpdateStrings(Plyr.LeaveRoomMe,Plyr.Name,'',NewRoom,OldRoom))
			Delay(50)
			SendToRoomNotMe(UpdateStrings(Plyr.LeaveRoomRoom,Plyr.Name,'',NewRoom,OldRoom))
			Delay(50)
			MyRoom:=NewRoom
			SendToMe(UpdateStrings(Plyr.EnterRoomMe,Plyr.Name,'',NewRoom,OldRoom))
			Delay(50)
			SendToRoomNotMe(UpdateStrings(Plyr.EnterRoomRoom,Plyr.Name,'',NewRoom,OldRoom))
		End
		MyRoom:=S
		SetPromptInfo(4,'#'+S)
		UpdateScreen
	End
End

// Display error message to chat window [sf]
Procedure ShowError(S:String)
Begin
	Add2Chat('|15!|12 ' + S)
	ShowChat(0)
End

Procedure ChangeNick(LRNC,N:String;Announce:Boolean)
Var ON	: String
Begin

	Case LRNC Of
//		'N':	Plyr.Name:=StripMCI(N)

		// Limit left bracket to 1 visible character [sf]
		'L':	Begin
			If Length(StripMCI(N)) > 1 Then
				ShowError('Left bracket max length is 1 char')
			Else
				Plyr.LtBracket:=N
			End

		// Limit right bracket to 8 visible character [sf]
		// Record length stays at 16 for compatibility
		'R':	Begin
			If Length(StripMCI(N)) > 8 or Length(N) > 16 Then
				ShowError('Right brackets max length is 8 chars (16 including Pipe codes)')
			Else
				Plyr.RtBracket:=N
			End

		// Make sure Nick color is a color PIPE code [sf]
		'C':	Begin
			If Length(StripMCI(N)) > 0 or Length(N) <> 3 Then
				ShowError('Only color pipe codes allowed for nick color')
			Else
				Plyr.NameColor:=N
			End
	End

	SavePlyr(Plyr.RecIdx)
	MyNamePrompt:=Plyr.LtBracket+Plyr.NameColor+StripMCI(Plyr.Name)+Plyr.RtBracket+'|16|07 '
End

Procedure Init
Var X,Y: Integer
Var K,S		: String = ''
Begin
	S:=Int2Str(NodeNum)
	For X:=1 To 3 Do
		S:=S+Int2Str(Random(9))
	ChatSeed:=Str2Int(S)
	ChatLog:=CfgTempPath+'mrcchat.log'
	PInUse:=CfgTempPath+'tchat.inuse'

	BBSTempStub:=CfgTempPath
	Y:=Pos(Int2Str(NodeNum),BBSTempStub)
	If Y > 0 Then
		Delete(BBSTempStub,Y,Length(Int2Str(NodeNum))+1)

	Y:=FindPlyr
	If Y = 0 Then NewPlyr
	Else ReadPlyr(Y)

	SiteTag:=StripMCI(Replace(MCI2Str('BN'),' ','_'))
	UserTag:=StripMCI(Replace(UserAlias,' ','_'))
	ChangeNick('N',UserTag,False)
	DispFile('mrcmain')
	GetScreenInfo(1,WinTL,WinTT,WinAttr)
	GetScreenInfo(2,WinBL,WinBB,WinAttr)
	GetScreenInfo(3,PromptX,PromptY,PromptAttr)
	GetScreenInfo(4,RoomX,RoomY,RoomAttr)
	GetScreenInfo(5,TopicX,TopicY,TopicAttr)
	WinSize:=WinBB-WinTT

	ShowChat(0)

	AppendText(PInUse,'0')
	MenuCmd('NA','Mystic Relay Chatting')
End

Procedure DoHelp
Begin
	Write('|16|11')
	DispFile('mrchelp')
	RedrawScreen
End

Procedure DoWho
Begin
	Write('|16|11')
	MenuCmd('NW','')
	RedrawScreen
End

Procedure ChangeTopic(S:String)
Var R	: String
Begin
	SendToServer('NEWTOPIC:'+MyRoom+':'+S)
	UpdateScreen
End

Procedure DoPrivateMsg(S:String)
Var M,U	: String
Var L	: Integer
Begin
	U:=Upper(WordGet(2,S,' '))
	L:=Pos(U,Upper(S))
	L:=L+Length(U)+1
	M:='|15* |08(|15'+Plyr.Name+'|08/|14PrivMsg|08) |07'+Copy(S,L,Length(S)-L+1)
	SendToUser(U,M)
	Add2Chat('|15* |08(|14PrivMsg|08->|15' + U + '|08) '+ GetPipe(CIdx) + Copy(S,L,Length(S)-L+1))
End

Procedure DoBroadcast(S:String)
Var M	: String
Begin
	M:='|15* |08(|15'+Plyr.Name+'|08/|14Broadcast|08) |07'+Copy(S,4,Length(S)-3)
	SendToAll(M)
End

Procedure DoMeAction(S:String)
Var R	: String
Begin
	R:=Copy(S,5,Length(S)-4)
	SendToRoom('|15* |13'+Plyr.Name+' ' + R)
End

// Buffer history handling [sf]
Procedure AddToBufferHistory(B:String)
Var I : Byte
Begin
	For I := 10 DownTo 2 Do
	Begin
		If Length(BufferHist[I-1]) > 0 Then
			BufferHist[I] := BufferHist[I-1]
	End
	BufferHist[2] := B
End

// Select next banner from the defined list [sf]
Procedure NextBanner
Begin
	LoadBanners
	Repeat
		BanIdx := BanIdx + 1
		If BanIdx > 10 Then BanIdx := 1
	Until Length(BannerList[BanIdx]) > 0
	ScrollWait := 0
	BannerOff := 0
End

// Display and scroll banners [sf]
Function ScrollBanner
Var BS: String = StripMCI(BannerList[BanIdx])
Begin
	// This is a scrolling banner
	If Length(BS) > BannerLen Then
	Begin
		// Add white padding for nice scroll entry/exit
		BS:=StrRep(' ', BannerLen)+BS+StrRep(' ', BannerLen)

		// Initial display before we start scrolling
		If ScrollWait = 0 Then
		Begin
			BS:='|16'+GetPipe(BClr) + Copy(BS, 1, BannerLen-2) +
				GetPipe(BFad1) + Copy(BS, BannerLen-1, 1) +
				GetPipe(BFad2) + Copy(BS, BannerLen, 1)
			BannerOff := BannerOff + 1
			GoToXy(BannerX, BannerY)
			Write(BS)
			GoToXy(HeartBeatX, HeartBeatY)
		End

		// We have made it to the end
		If BannerOff > Length(BS) - BannerLen Then
		Begin
			BS:='|16'+GetPipe(BFad2) + Copy(BS, BannerOff, 1) +
				GetPipe(BFad1) + Copy(BS, BannerOff+1, 1) +
				GetPipe(BClr) + Copy(BS, BannerOff+2, BannerLen-2)
			GoToXy(BannerX, BannerY)
			Write(BS)
			GoToXy(HeartBeatX, HeartBeatY)
			ScrollWait := 0
		End

		// Let's start the scrolling shall we
		If ScrollWait > ScrollDly Then
		Begin
			BS:='|16'+GetPipe(BFad2) + Copy(BS, BannerOff, 1) +
				GetPipe(BFad1) + Copy(BS, BannerOff+1, 1) +
				GetPipe(BClr) + Copy(BS, BannerOff+2, BannerLen-4) +
				GetPipe(BFad1) + Copy(BS, BannerOff+BannerLen-2, 1) +
				GetPipe(BFad2) + Copy(BS, BannerOff+BannerLen-1, 1)
			BannerOff := BannerOff + 1
			GoToXy(BannerX, BannerY)
			Write(BS)
			GoToXy(HeartBeatX, HeartBeatY)
		End

		// Not yet
		Else
		Begin
			ScrollWait := ScrollWait + 1
			GoToXy(HeartBeatX, HeartBeatY)
		End
	End
	Else
	Begin
		GoToXy(BannerX, BannerY)
		Write('|16'+GetPipe(BClr)+PadLT(BS, BannerLen, ' '))
		GoToXy(HeartBeatX, HeartBeatY)
		ScrollWait := 0
		BannerOff := 0
	End
End

// Buffer history seeker [sf]
Function GetBufferIndex(Idx:Byte;Dir:Integer) : Byte
Var NIdx: Byte
Begin
	NIdx := Idx + Dir
	GetBufferIndex := Idx

	If NIdx > 1 and NIdx < 10 and Length(BufferHist[NIdx]) > 0 Then
		GetBufferIndex := NIdx

	If NIdx = 1 Then
		GetBufferIndex := NIdx
End

// Color Index seeker [sf]
Function GetColorIndex(Idx:Byte;Dir:Integer) : Byte
Var MIdx: Byte
Begin
	MIdx := Idx + Dir

	// Span from Cyan...
	If MIdx < 2 Then
		MIdx := 2

	// ... to Bright White
	If MIdx > 15 Then
		MIdx := 15

	GetColorIndex := MIdx
End

Function InputLine:String
Var IX,UL	: Integer
Var Ch   : Char    = #13
Var IBuf : String    // Input buffer [sf]
Var DBuf : String    // Displayed buffer [sf]
Var RBuf : Boolean   // Refresh buffer flag [sf]
Var Done : Boolean   // Done getting input (Enter) [sf]
Var Anim : Byte = 1  // Animation step [sf]
Var BIdx : Byte = 1  // Buffer Current Idx [sf]
Var NIdx : Byte = 1  // Buffer Target Idx [sf]
Var CClr : Byte = 7  // Char counter color [sf]
Begin
	UL:=Length(StripMCI(MyNamePrompt))
	IX:=PromptX+Length(StripMCI(MyNamePrompt))

	// Init the characters counter [sf]
	WriteXY(CounterX1, CounterY1, 7, PadLt(Int2Str(Length(IBuf)), 3, '0'))
	WriteXY(CounterX2, CounterY2, 7, PadLt(Int2Str(MaxBuffer), 3, '0'))

	// Init the buffer input bar [sf]
	GoToXy(PromptX,PromptY)
	Write('|16' + MyNamePrompt + '|17' + GetPipe(CIdx) + DBuf +
		 '|25' + Chr(178) + InputClr + '|$X78' + InputBg)

	Repeat
		While Not Keypressed Do
		Begin
			// Improved polling time to keyboard [sf]
			Delay(10)

			// Read chat files every 7 cycles [sf]
			// Slightly improve file access rate
			If Loop % 7 = 0 Then
				ReadChatFiles

			If Loop > 50000 Then Loop:=1

			// Heartbeat to server every 12000 cycles
			// Maintain server heartbeat rate
			If Loop % 12000 = 0 Then Begin
				SendToServer('IAMHERE')
			End

			// Rotate custom banners [sf]
			If Loop % 2000 = 0 Then
			Begin
				NextBanner
				ScrollBanner
			End

			If Loop % 15  = 0 And Length(BannerList[BanIdx]) > BannerLen Then
				ScrollBanner

			// Animate the heartbeat animation every 50 cycles [sf]
			If Loop % 50 = 0 Then
			Begin
				Anim := Anim + 1
				If Anim > Length(HeartBeat) Then
					Anim := 1
				WriteXY(HeartBeatX, HeartBeatY, HeartBeatClr, Copy(HeartBeat, Anim, 1))
				GoToXy(HeartBeatX, HeartBeatY)
			End

			Loop:=Loop+1
		End

		// Handle arrow keys [sf]
		AllowArrow := True
		Ch := ReadKey

		// Buffer history handling [sf]
		If IsArrow Then
		Begin
			Case Ch Of
				Chr(72) : NIdx := GetBufferIndex(BIdx, 1)   // Scroll back input (Up)
				Chr(80) : NIdx := GetBufferIndex(BIdx, -1)  // Scroll forward input (Dn)
				Chr(81) : TIdx := GetColorIndex(CIdx, -1)   // Decrease color index (PgDn)
				Chr(73) : TIdx := GetColorIndex(CIdx, 1)    // Increase color index (PnUp)
			Else
				NIdx := BIdx
				TIdx := CIdx
			End

			Ch := Chr(0)

			If BIdx <> NIdx Then
			Begin
				IBuf := BufferHist[NIdx]
				BIdx := NIdx
				RBuf := True
			End
			Else
			If CIdx <> TIdx Then
			Begin
				CIdx := TIdx
				RBuf := True
			End
		End

		// PIPE codes whitelist [sf]
		If Copy(IBuf, Length(IBuf), 1) = '|' Then
		Begin
			Case Ch Of
				'0',
				'1',
				'2',
				'3',
				Chr(8),
				Chr(27)	: Ch := Ch
			Else
				Ch := Chr(0)
			End
		End

		// Send to server and add to buffer history [sf]
		If Ch = Chr(13) Then
		Begin
			InputLine := StripL(IBuf, ' ')
			AddToBufferHistory(IBuf)
			IBuf := ''
			BIdx := 1
			WriteXY(CounterX1, CounterY1, 7, PadLt(Int2Str(Length(IBuf)), 3, '0'))
			WriteXY(CounterX2, CounterY2, 7, PadLt(Int2Str(MaxBuffer), 3, '0'))
			Done := True
		End
		Else

		// Clear input buffer with ESC [sf]
		If Ch = Chr(27) Then
		Begin
			IBuf := ''
			BIdx := 1
			RBuf := True
		End
		Else
		Begin
			// Handle backspace [sf]
			If Ch = Chr(8) Then
			Begin
				Delete (IBuf, Length(IBuf), 1)
				RBuf := True
			End
			Else

			// Allow characters between #32 and #126 only [sf]
			Begin
				If Ord(Ch) > 31 and Ord(Ch) < 127 Then
				Begin
					// Limit input buffer length [sf]
					If Length(IBuf) < MaxBuffer Then
					Begin
						IBuf := IBuf + Ch
						RBuf := True
					End
				End

				// Ignore any other character [sf]
				Else
					Ch := ''
			End
		End

		// Refresh buffer only if changed [sf]
		If RBuf Then
		Begin
			// Scroll input buffer [sf]
			If Length(IBuf) > 78-PromptX-UL Then
				DBuf := Copy(IBuf, Length(IBuf) - (77-PromptX-UL), 78-PromptX-UL)
			Else
				DBuf := IBuf

			// Update input bar [sf]
			GoToXy(PromptX,PromptY)

			Write('|16' + MyNamePrompt + '|17' + GetPipe(CIdx) +
				DBuf + '|25' + Chr(178) + InputClr + '|$X78' + InputBg + '|16')

			// Handle counter color coding [sf]
			CClr := 7
			If Length(IBuf) > MaxBuffer -20 Then
				CClr := 14
			If Length(IBuf) > MaxBuffer -10 Then
				CClr := 12

			// Update characters counter [sf]
			WriteXY(CounterX1, CounterY1, CClr, PadLt(Int2Str(Length(IBuf)), 3, '0'))
			WriteXY(CounterX2, CounterY2, CClr, PadLt(Int2Str(MaxBuffer), 3, '0'))
		End
		GoToXy(PromptX,PromptY)
	Until Done
End

Procedure DoCls
Var X	: Integer
Begin
	For X:=1 To CLBuffer Do Begin
		ChatLines[X]:=''
	End
End

Procedure DoScrollBack
Begin
	MenuCmd('GV','mrcscrl;x;y;'+ChatLog)
	RedrawScreen
End

Procedure ShowWelcome
Begin
	// Welcome info text [sf]
	Add2Chat('* |10Welcome to ' + MRCVersion)
	Add2Chat('* |15ESC|10 to clear input buffer, |15UP|10/|15DN|10 arrows for buffer history')
	Add2Chat('* |15PGUP|10/|15PGDN|10 to change your chat text color')
	Add2Chat('* |10The bottom-right heartbeat indicates you are in-sync with the BBS')
	Add2Chat('* |10Your maximum message length is |15' + Int2Str(MaxBuffer)+ '|10 characters')
	ShowChat(0)
End

Procedure ShowChanges
Begin
	// Changes info text [sf]
	Add2Chat('* |15List of changes from MRC v1.1')
	Add2Chat('* |10Completely redesigned Input routine [sf]')
	Add2Chat('* |10Ability to receive chat while typing (non-blocking) [sf]')
	Add2Chat('* |10Built-in input buffer history [sf]')
	Add2Chat('* |10Chat text color changing without the use of PIPE codes [sf]')
	Add2Chat('* |10Visual indicator when your nick is mentioned [sf]')
	Add2Chat('* |10Input buffer with color coded characters counter [sf]')
	Add2Chat('* |10Server synchronization heartbeat indicator [sf]')
	Add2Chat('* |10Enlarged view port, more lines are available for the chat [sf]')
	Add2Chat('* |10Customizable information scroller [sf]')
	Add2Chat('* |10Improvement of performance and responsiveness of the interface [sf]')
	Add2Chat('* |10Fixed a race condition in some situations [sf]')
	Add2Chat('* |10Reduced CPU load [sf]')
	Add2Chat('* |10Other minor fixes [sf]')
	Add2Chat('* |10100% compatible with 1.1 server and client [sf]')
	ShowChat(0)
End


Procedure EnterChat
Begin
	ShowWelcome   // Show welcome text [sf]

	Add2Chat(UpdateStrings(Plyr.EnterChatMe,Plyr.Name,'',MyRoom,MyRoom))
	SendToAllNotMe(UpdateStrings(Plyr.EnterChatRoom,Plyr.Name,'',MyRoom,MyRoom))

	Delay(250)
	SendToServer('IAMHERE')

	// Display chatters at login [sf]
	Delay(250)
	SendtoServer('CHATTERS')
End

Procedure LeaveChat
Var Str1	: String
Begin
	Add2Chat(UpdateStrings(Plyr.LeaveChatMe,Plyr.Name,'',MyRoom,MyRoom))
	SendToAllNotMe(UpdateStrings(Plyr.LeaveChatRoom,Plyr.Name,'',MyRoom,MyRoom))
	SendToServer('LOGOFF');
End

Procedure DoSetList
Var R,S	: String
Begin
	S:='False'
	If Plyr.UseClock Then
		S:='True'

	R:='12Hour (HH:MMa or HHMMp)'
	If Not Plyr.ClockFormat Then
		R:='24Hour (HH:MM)'

	Add2Chat('|07ENTERCHATME   |08: '+Plyr.EnterChatMe)
	Add2Chat('|07ENTERCHATROOM |08: '+Plyr.EnterChatRoom)
	Add2Chat('|07ENTERROOMME   |08: '+Plyr.EnterRoomMe)
	Add2Chat('|07ENTERROOMROOM |08: '+Plyr.EnterRoomRoom)
	Add2Chat('|07LEAVECHATME   |08: '+Plyr.LeaveChatMe)
	Add2Chat('|07LEAVECHATROOM |08: '+Plyr.LeaveChatRoom)
	Add2Chat('|07LEAVEROOMME   |08: '+Plyr.LeaveRoomMe)
	Add2Chat('|07LEAVEROOMROOM |08: '+Plyr.LeaveRoomRoom)
	Add2Chat('|07DEFAULTROOM   |08: '+Plyr.DefaultRoom)
	Add2Chat('|07NICKCOLOR     |08: '+Plyr.NameColor+Plyr.Name)
	Add2Chat('|07LTBRACKET     |08: '+Plyr.LtBracket)
	Add2Chat('|07RTBRACKET     |08: '+Plyr.RtBracket)
	Add2Chat('|07USECLOCK      |08: |07'+S)
	Add2Chat('|07CLOCKFORMAT   |08: |07'+R)
	ShowChat(0)
End

Procedure DoSetHelp
Var B	: Boolean
Begin
	B:=Plyr.UseClock
	Plyr.UseClock:=False
	Add2Chat('|07/SET <tag> <text>')
	Add2Chat('|07Use SET to set various fields to your account')
//	Add2Chat('|07<tag> HELP, LIST, ENTERCHATME, ENTERCHATROOM, ENTERROOMME, ENTERROOMROOM, LEAVECHATME, LEAVECHATROOM, LEAVEROOMROOM, LEAVEROOMME, DEFAULTROOM, NAMECOLOR, LTBRACKET, RTBRACKET, USECLOCK, CLOCKFORMAT')
	Add2Chat('|07HELP            This helps message')
	Add2Chat('|07LIST            List all fields and tabs')
	Add2Chat('|07ENTERCHATME     Displayed to me when I enter chat.')
	Add2Chat('|07ENTERCHATROOM   Displayed to room  when I enter chat.')
	Add2Chat('|07ENTERROOMME     Displayed to me when I enter room.' )
	Add2Chat('|07ENTERROOMROOM   Displayed to room when I enter room.' )
	Add2Chat('|07LEAVECHATME     Displayed to me when I leave chat.' )
	Add2Chat('|07LEAVECHATROOM   Displayed to room when I leave chat.' )
	Add2Chat('|07LEAVEROOMME     Displayed to me when I leave room.')
	Add2Chat('|07LEAVEROOMROOM   Displayed to room when I leave room.')
	Add2Chat('|07DEFAULTROOM     Join this room when you join chat.')
	Add2Chat('|07NICKCOLOR       Change my nickname color (MCI Pipe codes.' )
	Add2Chat('|07LTBRACKET       Change my left bracket / color (MCI Pipe codes.' )
	Add2Chat('|07RTBRACKET       Change my right bracket / color (MCI Pipe codes.' )
	Add2Chat('|07USECLOCK        (Y/N) Use timestamp in chat')
	Add2Chat('|07CLOCKFORMAT     12 or 24 hour clock format')
	ShowChat(0)
	Plyr.UseClock:=B
End

Procedure ChangeClock(T:Integer;S:String)
Begin
	S:=StripB(Upper(S),' ')
	Case T Of
		1: Begin
				If Pos('YE',S) > 0 Or Pos('TR',S) > 0 Then Begin
					Plyr.UseClock:=True
					Add2Chat('|07CLOCKFORMAT   |08: |07True')
				End Else Begin
					If Pos('NO',S) > 0 Or Pos('FA',S) > 0 Then Begin
						Plyr.UseClock:=False
						Add2Chat('|07CLOCKFORMAT   |08: |07False')
					End Else
						Add2Chat('Usage: /SET USECLOCK YES||TRUE or /SET USECLOCK NO||FALSE')
				End
				ShowChat(0)
			 End
		2: Begin
				If S = '12' Then Begin
					Plyr.ClockFormat:=True
					Add2Chat('|07CLOCKFORMAT   |08: |0712 hour')
				End Else Begin
					If S = '24' Then Begin
						Plyr.ClockFormat:=False
						Add2Chat('|07CLOCKFORMAT   |08: |0724 hour')
					End Else
						Add2Chat('Usage: "/SET CLOCKFORMAT 12" or "/SET CLOCKFORMAT 24"')
				End
				ShowChat(0)
			 End
	End
	SavePlyr(Plyr.RecIdx)
End

Procedure DoSet(Line:String)
Var Tag,Txt	: String
Var P	: Integer
Begin
	Tag:=WordGet(1,Line,' ')
	P:=Length(Tag)+1
	Delete(Line,1,P)
	StripB(line,' ')

	Case Upper(Tag) Of
		'HELP': DoSetHelp
		'LIST': DoSetList
		'ENTERCHATME'	: Plyr.EnterChatMe:=Line
		'ENTERCHATROOM'	: Plyr.EnterChatRoom:=Line
		'ENTERROOMME'	: Plyr.EnterRoomMe:=Line
		'ENTERROOMROOM' : Plyr.EnterRoomRoom:=Line
		'LEAVECHATME'	: Plyr.LeaveChatMe:=Line
		'LEAVECHATROOM' : Plyr.LeaveChatRoom:=Line
		'LEAVEROOMROOM' : Plyr.LeaveRoomRoom:=Line
		'DEFAULTROOM' 	: Plyr.DefaultRoom:=Line
		'NICKCOLOR'	: ChangeNick('C',Line,False)
		'LTBRACKET'	: ChangeNick('L',Line,False)
		'RTBRACKET'	: ChangeNick('R',Line,False)
		'USECLOCK'	: ChangeClock(1,Line)
		'CLOCKFORMAT'	: ChangeClock(2,Line)
		''		: DoSetHelp
	End
	SavePlyr(Plyr.RecIdx)
End

Procedure DLChatLog
Var X,Y,TS,DS,TempChat	: String
Var fptr			: File
Begin
	DS:=Replace(DateStr(DateTime,1),'/','')
	TS:=Replace(TimeStr(DateTime,False),':','')
	TempChat:=CfgTempPath+'mrc_chat_'+Replace(SiteTag,' ','_')+'_'+DS+'_'+TS+'.log'
	Write('|16|11|CL')
	If InputYN('Strip MCI color codes? ') Then Begin
		fAssign(fptr,ChatLog,66)
		fReset(Fptr)
		While Not fEof(Fptr) Do Begin
			fReadLn(Fptr,X)
			Y:=StripMCI(X)
			AppendText(TempChat,Y)
		End
		fClose(Fptr)
	End Else
		FileCopy(ChatLog,TempChat)
	MenuCmd('F3',TempChat);
	FileErase(TempChat)
	RedrawScreen;
End

Procedure Main
Var Done	: Boolean = False
Var RestOfLine, W1,W2,UIL	: String
Var IL		: String
Begin
	Loop:=1
	UpdateScreen
	Repeat
		Delay(10)
		IL:=InputLine

		// Support slash commands even if prefixed with a PIPE code
		If Pos('/',StripMCI(IL)) = 1 Then Begin
			W1:=Upper(WordGet(1,StripMCI(IL),' '))
			W2:=WordGet(2,IL,' ')
			RestOfLine:=IL
			Delete(RestOfLine,1,Length(W1))
			RestOfLine:=StripB(RestOfLine,' ')

			Case W1 Of
				'/CHANGES'	: ShowChanges  // Display changes [sf]
				'/?'		: DoHelp
				'/B'		: DoBroadcast(IL)
				'/BBSES'	: SendToServer('CONNECTED')
				'/CHANNEL'	: SendToServer('CHANNEL')
				'/CHATTERS'	: SendToServer('CHATTERS')
				'/CLS'		: DoCls
				'/DLCHATLOG': DLChatLog
				'/JOIN' 	: JoinRoom(W2,True)
				'/LIST'		: SendToServer('LIST')
				'/ME'   	: DoMeAction(IL)
				'/Q','/QUIT'	: Begin LeaveChat; Done:=True; End
				'/ROOMS'	: SendToServer('LIST')
				'/SCROLL'	: DoScrollBack
				'/SET'		: DoSet(RestOfLine)
				'/TOPIC'	: ChangeTopic(RestOfLine)
				'/T','/MSG',
				'/TELL'		: DoPrivateMsg(IL)
				'/USERS'	: SendToServer('USERS')
				'/WHO'  	: DoWho
				'/WHOON'	: SendToServer('WHOON')
				'/MOTD'		: SendToServer('MOTD')
				'/VERSION'	:
						Begin
							SendToServer('VERSION')
							Add2Chat('|07- |13'+MRCVersion)
						End
			End
		End Else Begin
			If Length(IL) > 0 Then
			Begin
				SendToRoom(MyNamePrompt+GetPipe(CIdx)+IL)
			End
		End
	Until Done
End

Begin
	GetThisUser
	Init
	RedrawScreen
	EnterChat
	JoinRoom(Plyr.DefaultRoom,False)
	NextBanner
	ScrollBanner
	Main
	Write('|16|11|CL')
	CleanOutTempDir
End

