(*
   RCS Logoff
   
   Copyright 2020 Black Panther(RCS) <dan@castlerockbbs.com>
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.
     
2020-10-29  Black Panther(RCS)  <dan@castlerockbbs.com>

*)

(*
 ---------------------------------------------------------------------------
 RCSLOGOF.MPS : Logoff menu v4.2 by Black Panther
 ---------------------------------------------------------------------------
 (C) 1999 By zoob.  All Rights Reserved.
 (C) 2020 By Black Panther(RCS)
 ---------------------------------------------------------------------------
 Feel free to modify this, but give credit to me if you release it.
 ---------------------------------------------------------------------------
 Updated by Black Panther(RCS) to use with Mystic 1.12A46
*)

Uses CFG
Uses User

Const
  ProgName = 'RCS Logoff'
  ProgVer  = '4.2(RCS)'

Var 
  C     :String
  Done  :Boolean=False
  Lines :Array[1..3] of String
  fptr  :File

Procedure NowReturn
Begin
  Clrscr
  GotoXY(24,6)
  WriteLn('|09N|03ow |09R|03eturning |09T|03o |11|BN ...')
  GotoXY(25,6)
  Delay(1000)
  MenuCmd('GO','main')
  Clrscr
End

Procedure Logoff
Begin
    Clrscr
    GotoXY(6,3)
    Write('|08|07|15|07|08|07|15|07|08|07|15|07|07|07|15|07|08Ŀ')
    GotoXY(6,4)
    Write('|08                                                                   ')
    GotoXY(6,5)
    Write('|08|07|15|07|08|07|15|07|08|07|15|07|08|07|15|07|08')
    GotoXY(10,4)
    Write('     '+ProgName+' |09M|03enu |11v'+ProgVer+' |01- |09F|03rom |09B|03lack |09P|03anther|01(|11RCS|01) |01(C)2020')
    GotoXY(1,24)
    Delay(1000)
    dispfile('logoff')     //This is the name of your logoff ansi screen
    Hangup
    Done := True
End

Begin
  GetThisUser
  Repeat
    Clrscr
    DispFile('rcslogo1')     //This is the ansi screen for the menu
    DispFile('rcslogot')     //This is the ansi that contains the quote to next user
    WriteLn('')
    Write('|09L|03eaving |11|UH|03? |01[|11R|01,|11L|01,|11Q|01,|11S|01,|11M|01,|11Y|01]|11')
    Repeat
      C := Upper(ReadKey)
    Until C = 'R' or C = 'L' or C = 'Q' or C = 'S' or C = 'M' or C = 'Y' or C = 'P'
    If C = 'R' then
    Begin
      NowReturn
      Done := True
    End
    Else If C = 'L' then
    Begin
      Clrscr
      GotoXY(1, 4)
      MenuCmd('MW','/TO:Black_Panther /SUBJ:LogOff Message')   // Make sure you edit this line and put your name!
    End                                                        // Spaces are not allowed in sysop name, use the '_'
    Else If C = 'Q' then
    Begin
      DispFile('rcslogoq')            //This ansi says 'Quote of the day'
      If InputNY('                     |09D|03o |09Y|03ou |09W|03ish |09T|03o |09C|03ontinue? ') then
        WriteLn('')
        If InputYN('         |09W|03ould |09Y|03ou |09L|03ike |09T|03o |09V|03iew |09T|03he |09P|03revious |09Q|03uote? ') then
        Begin
          Clrscr
          DispFile('rcslogot')
          Delay(1000)
        End
        WriteLn('')
        If InputYN('          |09W|03ouLd |09Y|03ou |09L|03ike |09T|03o |09L|03eave |09a Q|03uote? ') then
        Begin
          Clrscr
          WriteLn('            |09Y|03ou |09H|03ave |09a M|03aximum |09o|03f |113 |09L|03ines |09T|03o |09L|03eave |09a Q|03uote')
          WriteLn(StrRep('-',79)+'|11')
          Lines[1] := Input(79, 79, 1, '')
          If Lines[1] = '' then
            NowReturn
          Else
          Begin
            Lines[2] := Input(79, 79, 1, '')
            Lines[3] := Input(79, 79, 1, '')
            WriteLn('|08'+StrRep('-',79))
            If InputYN('             |09I|03s |09t|03his |09m|03essage |09c|03orrect? ') then
            Begin
              fAssign(fptr,CfgTextPath+'rcslogot.asc',66)
              fRewrite(fptr)
              fWriteLN(fptr,'  |09Q|03uoted |09B|03y: |11'+UserAlias+'                                |09D|03ate:|11'+DateStr(dateTime,1))
              fWriteLn(fptr,'  |01'+StrRep('-',77))
              fWriteLn(fptr,'  |01'+Lines[1])
              fWriteLn(fptr,'  |01'+Lines[2])
              fWriteLn(fptr,'  |01'+Lines[3])
              fClose(fptr)
              WriteLn('')
              WriteLn('')
              WriteLn('                        |01[ |09T|03hanks |09F|03or |09T|03he |09Q|03uote! |01]')
              Delay(1000)
            end Else
              NowReturn
            End
        End Else
        NowReturn
    End
  Else If C = 'S' then
    MenuCmd('GX', 'bulletin bulletin bullet') // Run the default system bulletins
  Else If C = 'M' then
    MenuCmd('GX', 'rcsauto cyan')             // Designed to run with my Auto Message MPL
  Else If C = 'P' then
    MenuCmd('GX','dm-rr')                     // Will run dream master's Russian Roulette logoff
  Else If C = 'Y' then logoff
Until Done
End
