(*
Liked this script? Want more? Make a visit at my BBS and think of living a
donation to my Paypal account. :)

   _            _   _              ___          _    _
  /_\  _ _  ___| |_| |_  ___ _ _  |   \ _ _ ___(_)__| |               8888
 / _ \| ' \/ _ \  _| ' \/ -_) '_| | |) | '_/ _ \ / _` |            8 888888 8
/_/ \_\_||_\___/\__|_||_\___|_|   |___/|_| \___/_\__,_|            8888888888
                                                                   8888888888
         DoNt Be aNoTHeR DrOiD fOR tHe SySteM                      88 8888 88
                                                                   8888888888
    .o HaM RaDiO    .o ANSi ARt!       .o MySTiC MoDS              "88||||88"
    .o NeWS         .o WeATheR         .o FiLEs                     ""8888""
    .o GaMeS        .o TeXtFiLeS       .o PrEPardNeSS                  88
    .o TuTors       .o bOOkS/PdFs      .o SuRVaViLiSM          8 8 88888888888
    .o FsxNet       .o SurvNet         .o More...            888 8888][][][888
                                                               8 888888##88888
   TeLNeT : andr01d.zapto.org:9999 [UTC 11:00 - 20:00]         8 8888.####.888
   SySoP  : xqtr                   eMAiL: xqtr.xqtr@gmail.com  8 8888##88##888
   DoNaTe : https://paypal.me/xqtr

*)

Uses
  User;

Const
  TopScoreANS = 'joker.ans';
  HelpANS     = 'help.ans';
  CardJack    = 11;
  CardQueen   = 12;
  CardKing    = 13;
  CardAce     = 14;
  SuitClub    = 1;
  SuitSpade   = 2;
  SuitHeart   = 3;
  SuitDiamond = 4;
  //TDF
  HeaderOffset = 233;
  Menu_x       = 31;
  Menu_y       = 8;
  Menu_w       = 19;
  Menu_h       = 8;
  
Type 
  TTDFont = record
    A         : char;
    typo      : Array[1..18] of char;
    B         : char;
    fs        : array[1..4] of byte;
    NameLen   : byte;
    FontName  : array[1..12] of char;
    nouse     : array[1..4] of byte;
    FontType  : byte;
    Spacing   : byte;
    BlockSize : word;
    CharAddr  : Array[1..94] of word;
  end;
  
Type
  TMenuItem = Record
    Name : String;
    Id   : Integer;
  End;  
  
Type
  TFontChar = Record
    width     : byte;
    height    : byte;
  end;  
  
Type
  PlayerRec = Record
    UserID : LongInt;
    Name   : String[30];
    Cash   : LongInt;
    LastOn : LongInt;
    GM     : Byte;
  End;

Type
  TopTenRec = Record
    User : String[35];
    Cash : LongInt;
    Date : LongInt;
    GM   : Byte;
  End;

Type
  CardRec = Record
    Suit : Byte;
    Card : Byte;
  End;

Var
  DataPath      : String;
  Data          : Array[1..8] Of TMenuItem;
  TotalItems    : Integer = 8;
  Deck          : Array[1..52] of CardRec;
  Cards         : Array[1..5] Of CardRec;
  Player        : PlayerRec;
  PlayerNumber  : LongInt = -1;
  Player_Score  : LongInt = 0;
  LastSeen      : Integer;
  Hands         : Byte = 3;
  Slot          : Array[1..5] Of Byte;
  Hold          : Array[1..5] Of Byte;
  q             : byte;
  Font          : TTDFont;
  FontFile      : String;
  GameMode      : Byte = 0;
  
Procedure DeckSort;
// a very simple and slow method For Item sorting
Var 
  i, j: integer;
  temp1 : CardRec;
Begin
  For j:=1 To 5 Do
    For i := 2 To 5 Do
      Begin
        If Cards[i-1].Card>Cards[i].Card Then
          Begin
            temp1 := Cards[i-1];
            Cards[i-1] := Cards[i];
            Cards[i] := temp1;
          End;
      End;
End;
  
Function Evaluate:Integer;
Var
  d : Byte;
  
  Function IsFlush:Boolean;
  Begin
    IsFlush := True;
    For D := 1 To 4 Do If Cards[d].Suit <> Cards[d+1].Suit Then IsFlush:=False;
  End;
  
  Function IsStraight:Boolean;
  Begin
    IsStraight:=True;
    For D:=1 to 4 Do If Cards[d].Card + 1 <> Cards[d+1].Card Then IsStraight:=False;
  End;
  
  Function IsRoyal:Boolean;
  Begin
    IsRoyal:=False;
    If IsFlush And Cards[1].Card=10 Then IsRoyal:=True;
  End;
  
  Function IsFK:Boolean;
  Begin
    IsFK:=False;
    For D:=1 to 2 Do If (Cards[d].Card = Cards[d+1].Card) And
                        (Cards[d+1].Card = Cards[d+2].Card) And 
                        (Cards[d+2].Card = Cards[d+3].Card) Then IsFK:=True;
  End;
  
  Function IsFullHouse:Boolean;
  Begin
    IsFullHouse:=False;
    If (Cards[1].Card = Cards[2].Card) And
    (Cards[3].Card = Cards[4].Card) And 
    (Cards[4].Card = Cards[5].Card) Then IsFullHouse:=True;
    
    If (Cards[1].Card = Cards[2].Card) And
    (Cards[2].Card = Cards[3].Card) And 
    (Cards[4].Card = Cards[5].Card) Then IsFullHouse:=True;
  End;
  
  Function IsThreeKind:Boolean;
  Begin
    IsThreeKind:=False;
    For D:=1 to 3 Do If (Cards[d].Card = Cards[d+1].Card) And
                        (Cards[d+1].Card = Cards[d+2].Card) Then IsThreeKind:=True;
  End;
  
  Function IsTwoPairs:Boolean;
  Begin
    IsTwoPairs:=False;
    If (Cards[1].Card = Cards[2].Card) And (Cards[3].Card = Cards[4].Card) Then IsTwoPairs:=True;
    If (Cards[2].Card = Cards[3].Card) And (Cards[4].Card = Cards[5].Card) Then IsTwoPairs:=True;
    If (Cards[1].Card = Cards[2].Card) And (Cards[4].Card = Cards[5].Card) Then IsTwoPairs:=True;
  End;
  
  Function IsJacks:Boolean;
  Begin
    IsJacks:=False;
    For D:=1 to 4 Do
      If (Cards[d].Card = Cards[d+1].Card) And (Cards[d].Card>=11) Then IsJacks:=True;
    
  End;
  
Begin
  DeckSort;
  If IsRoyal Then Evaluate:=5000
    Else
  If IsFlush And IsStraight Then Evaluate:=2000
    Else
  If IsFK Then Evaluate:=1000
    Else
  If IsFullHouse Then Evaluate:=700
    Else
  If IsFlush Then Evaluate:=500
    Else
  If IsStraight Then Evaluate:=300
    Else
  If IsThreeKind Then Evaluate:=200
    Else
  If IsTwoPairs Then Evaluate:=100
    Else
  If IsJacks Then Evaluate:=50
    Else Evaluate:=0;
End;  
  
Procedure SetBoxDefaults (Handle: LongInt; Header: String);
Begin
  If Header <> '' Then
    BoxHeader (Handle,      // Box class handle
               0,           // Header justify (0=center, 1=left, 2=right)
               31,          // Header attribute
               Header);     // Header text

  BoxOptions (Handle,       // Box class handle
              8,            // Box frame type (1-8)
              False,        // Use "3D" box shading effect
              8,            // Box attribute
              8,            // Box 3D effect attr1 (if on)
              8,            // Box 3D effect attr2 (if on)
              8,            // Box 3D effect attr3 (if on)
              True,         // Use box shadowing
              8);         // Box shadow attribute
End;

Procedure ClearArea;
Begin
  For q:=1 to 8 Do WriteXY(1,q,15,StrRep(' ',79));
End;
  
Procedure GetTDFHeader(f:string);
Var
  fptr : file;
  i : integer;
begin
  if not fileexist(f) then begin
   writeln('Font file [ '+f+' ]does not exist');
   pause;
   halt;
  end;
  fontfile:=f;
  fassign(fptr,f,66);
  freset(fptr);
  fread(fptr,font,sizeof(font));
  fclose(fptr);
end;

Procedure TDFWriteCharBL(x,y:byte;c:char):byte;
Var
  fptr : file;
  i : integer;
  FChar : TFontChar;
  tbyte : array[1..2] of byte;
  sx,sy:byte;
  asc:byte;
begin
  if c=' ' then begin
  tdfwritecharBL:=1;
  exit;
  end;
  asc:=ord(c)-32;
  fassign(fptr,fontfile,66);
  freset(fptr);
  fseek(fptr,headeroffset+font.charaddr[asc]);
  fread(fptr,FChar,sizeof(Fchar));
  tbyte[1]:=32;
  tbyte[2]:=32;
  gotoxy(x,y);
  while tbyte[1]<>0 and not feof(fptr) do begin
  fread(fptr,tbyte[1],1);
  if tbyte[1]=13 then begin
    gotoxy(x,wherey+1);
    if wherey>25 then break;
  end
   else begin
    fread(fptr,tbyte[2],1);
    textcolor(tbyte[2] % 16 + tbyte[2] - (tbyte[2] % 16));
    write(chr(tbyte[1]));
    if wherex>79 then break
  end;
  end;
  fclose(fptr);
  tdfwritecharbl:=fchar.width;
end;

Procedure TDFWriteCharCL(x,y:byte;c:char):byte;
Var
  fptr : file;
  i : integer;
  FChar : TFontChar;
  tbyte : array[1..2] of byte;
  sx,sy:byte;
  asc:byte;
begin
  if c=' ' then begin
  tdfwritecharcl:=1;
  exit;
  end;
  asc:=ord(c)-32;
  fassign(fptr,fontfile,66);
  freset(fptr);
  fseek(fptr,headeroffset+font.charaddr[asc]);
  fread(fptr,FChar,sizeof(Fchar));
  tbyte[1]:=32;
  gotoxy(x,y);
  while tbyte[1]<>0 and not feof(fptr) do begin
  fread(fptr,tbyte[1],1);
  if tbyte[1]=13 then begin
    gotoxy(x,wherey+1);
    if wherey>25 then break;
  end
   else begin
    write(chr(tbyte[1]));
    if wherex>79 then break;
  end;
  end;
  fclose(fptr);
  tdfwritecharcl:=fchar.width;
end;

procedure TDFWrite(x,y:byte; s:string)
Var
  i:byte;
  sx,sy:byte;
begin
  gotoxy(x,y);
  sx:=x;
  sy:=y;
  case font.fonttype of
  2: begin  
      for i:=1 to length(s) do begin
      sx:=sx+tdfwritecharBL(sx,y,s[i])+font.spacing;
      end;
   end;
  1: begin  
      for i:=1 to length(s) do begin
      sx:=sx+tdfwritecharCL(sx,y,s[i])+font.spacing;
      end;
   end;
   end;
end;  
  
Procedure PrintClub(x,y:byte);
Var
  p : Byte = 0;
Begin
  p:=y;   GotoXY(x,p);Write('|07|16|00|23           |07|16 ');
  p:=p+1; GotoXY(x,p);Write('|00|23             |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23             |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23             |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23   |04   |00      |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23        |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23      |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23   |04 |00      |08|16');
  p:=p+1; GotoXY(x,p);Write('|07|00|23           |07|16 ');
End;

Procedure PrintSpade(x,y:byte);
Var
  p : Byte = 0;
Begin
  p:=y;   GotoXY(x,p);Write('|07|16|00|23           |07|16|00 ');
  p:=p+1; GotoXY(x,p);Write('|23             |16 ');
  p:=p+1; GotoXY(x,p);Write('|23             |16 ');
  p:=p+1; GotoXY(x,p);Write('|23             |16 ');
  p:=p+1; GotoXY(x,p);Write('|23       |04 |00  |16 ');
  p:=p+1; GotoXY(x,p);Write('|23      |16 ');
  p:=p+1; GotoXY(x,p);Write('|23      |16 ');
  p:=p+1; GotoXY(x,p);Write('|23       |04 |00  |16 ');
  p:=p+1; GotoXY(x,p);Write('|07|00|23           |07|16|00 ');
End;

Procedure PrintHearts(x,y:byte);
Var
  p : Byte = 0;
Begin
  p:=y;   GotoXY(x,p);Write('|07|16|00|23           |07|16 ');
  p:=p+1; GotoXY(x,p);Write('|00|23             |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23             |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23             |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23   |04   |00   |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23   |04|00   |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23   |04|00   |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23   |04    |00   |08|16');
  p:=p+1; GotoXY(x,p);Write('|07|00|23           |07|16 ');
End;

Procedure PrintDiamond(x,y:byte);
Var
  p : Byte = 0;
Begin
  p:=y;   GotoXY(x,p);Write('|07|16|00|23           |07|16 ');
  p:=p+1; GotoXY(x,p);Write('|00|23             |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23             |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23             |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23  |04 |00 |04     |00   |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23  |04 |00 |04 |00   |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23  |04 |00   |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23  |04 |00 |04   |00   |08|16');
  p:=p+1; GotoXY(x,p);Write('|07|00|23           |07|16 ');
End;

Procedure PrintScore;
Begin
  GetTDFHeader(DataPath+'files'+PathChar+'hemisphx.tdf');
  TextColor(15+7*3);
  Font.Spacing:=0;
  GotoXY(3,7);
  Write('|16|11Score:');
  TextColor(15);
  TDFWrite(30,1,PadLt(Int2Str(Player_Score),5,'0')+'$');
  GotoXY(3,2);
  If GameMode=0 Then Begin
    Write('|16|11Hands: |15'+Int2Str(Hands))
    GotoXY(3,3);
    Write('|16|11Next Image');
    GotoXY(3,4);
    Write(PadLT(Int2Str((LastSeen+1)*500),10,' '));
  End Else 
      If GameMode=2 Then Begin
        Write('|16|11Hands: |15'+Int2Str(Hands));
        GotoXY(3,3);
        Write('|11Ten Mode');
      End;
        Else Write('|16|11Free Mode')
  
End;

Procedure PrintCard(x,y:Byte; C,S:Byte);
Var
  TC : Byte;
  TS : String;
  TX : Byte;
Begin
  Case S Of
    SuitClub    : Begin PrintClub(x,y);   tc:=0; End;
    SuitSpade   : Begin PrintSpade(x,y);  tc:=0; End;
    SuitHeart   : Begin PrintHearts(x,y); tc:=4; End;
    SuitDiamond : Begin PrintDiamond(x,y);tc:=4; End; 
  End;
  Case C Of
    2..9: Begin TS:=Int2Str(C); TX:=x+4; End;
    10  : Begin TS:=Int2Str(C); TX:=x+1; End;
    11  : Begin TS:='J'; TX:=x+4; End;
    12  : Begin TS:='Q'; TX:=x+4; End;
    13  : Begin TS:='K'; TX:=x+4; End;
    14  : Begin TS:='A'; TX:=x+4; End;
  End;
  TextColor(TC+7*16);
  GetTDFHeader(DataPath+'files'+PathChar+'ansiltr4.tdf');
  TDFWrite(TX,y,TS);
End;

Procedure PrintString(x,y:Byte; Str:String;CL:Byte);
Begin
  
  ClearArea;
  TextColor(CL);
  GetTDFHeader(DataPath+'files'+PathChar+'blunder.tdf');
  Font.Spacing:=1;
  TDFWrite(x,y,Str);
End;

Procedure PrintDraw(x,y:byte);
Var
  p : Byte = 0;
Begin
  p:=y;   GotoXY(x,p);Write('|07|16  ');
  p:=p+1; GotoXY(x,p);Write('|18|08|23      |07|18');
  p:=p+1; GotoXY(x,p);Write('|08|23   |07|18');
  p:=p+1; GotoXY(x,p);Write('|16  ');
End;

Procedure PrintDrawHL(x,y:byte);
Var
  p : Byte = 0;
Begin
  p:=y;   GotoXY(x,p);Write('|07|14|16|23|16');
  p:=p+1; GotoXY(x,p);Write('|07|18|08|23 |14    |08 |07|18');
  p:=p+1; GotoXY(x,p);Write('|14|23   |07|18');
  p:=p+1; GotoXY(x,p);Write('|14|16|23|16');
End;

Procedure PrintHold(x,y:byte);
Var
  p : Byte = 0;
Begin
  p:=y;   GotoXY(x,p);Write('|07|16   ');
  p:=p+1; GotoXY(x,p);Write('|00|23   |08H O L D|00   |08|16');
  p:=p+1; GotoXY(x,p);Write('|07   ');
End;

Procedure PrintHoldHL(x,y:byte);
Var
  p : Byte = 0;
Begin
  p:=y;   GotoXY(x,p);Write('|07|14|16|23|16|07 ');
  p:=p+1; GotoXY(x,p);Write('|00|23   |14H O L D|00   |08|16');
  p:=p+1; GotoXY(x,p);Write('|14|23|16|07 ');
End;

Procedure PrintHoldAll;
Begin
  For q :=1 to 5 Do PrintHold(Slot[q],9);
End;

Procedure PrintBack1(x,y:byte);
Var
  p : Byte = 0;
Begin
  p:=y;   GotoXY(x,p);Write('|07|16|00|23 |04|00 |07|16|08 ');
  p:=p+1; GotoXY(x,p);Write('|00|23 |04|16|12|20|04|23|00 |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23 |04|16|12|20|04|23|00 |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23 |04|16|12|20|04|23|00 |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23 |04|16|12|20|04|23|00 |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23 |04|16|12|20|04|23|00 |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23 |04|16|12|20|04|23|00 |08|16');
  p:=p+1; GotoXY(x,p);Write('|00|23 |04|16|12|20|04|23|00 |08|16');
  p:=p+1; GotoXY(x,p);Write('|07|00|23 |04|00 |07|16 ');
End;

Procedure PrintBack2(x,y:byte);
Var
  p : Byte = 0;
Begin
  p:=y;   GotoXY(x,p);Write('|07|16   |00|23 |04|00 |07|16|08 |00  ');
  p:=p+1; GotoXY(x,p);Write('   |23 |04|16|12|20|04|23|00 |08|16|00');
  p:=p+1; GotoXY(x,p);Write('   |23 |04|16|12|20|04|23|00 |08|16|00');
  p:=p+1; GotoXY(x,p);Write('   |23 |04|16|12|20|04|23|00 |08|16|00');
  p:=p+1; GotoXY(x,p);Write('   |23 |04|16|12|20|04|23|00 |08|16|00');
  p:=p+1; GotoXY(x,p);Write('   |23 |04|16|12|20|04|23|00 |08|16|00');
  p:=p+1; GotoXY(x,p);Write('   |23 |04|16|12|20|04|23|00 |08|16|00');
  p:=p+1; GotoXY(x,p);Write('   |23 |04|16|12|20|04|23|00 |08|16|00');
  p:=p+1; GotoXY(x,p);Write('   |07|00|23 |04|00 |07|16 |00  ');
End;
  
Procedure XWindow(H1:String;T,X1,Y1,X2,Y2:Integer);
Var T1,A1,A2,B1,B2  : String;
Begin
  A1 := Int2Str(X1);
  A2 := Int2Str(X2);
  B1 := Int2Str(Y1);
  B2 := Int2Str(Y2);
  T1 := Int2Str(T);
  Write('|#X#'+T1+'#'+H1+'#'+A1+'#'+B1+'#'+A2+'#'+B2+'#');
End;  

Procedure Center(s:String; line:byte);
Begin
  GotoXY(40-(length(stripmci(s)) / 2),line);
  Write(s);
End;

Procedure MsgBox(x:byte; s:String);
Var
  BoxHandle : LongInt;
  b,p:Byte;
Begin
  TextColor(7);
  For B := 1 to 79 Do Begin
    For P := 1 to 8 Do Begin
      GotoXY(b,p); Write(' ');
    End;
    Delay(10);
  End;
  GetTDFHeader(DataPath+'files'+PathChar+'hobbes.tdf');
  TextColor(5);
  Font.Spacing:=1;
  TDFWrite(x,2,s);
  Delay(2200);
  ClassFree (BoxHandle); 
End;

Procedure LoadPlayer;
Var
  F : File;
  T : PlayerRec;
Begin
  GetThisUser;

  PlayerNumber  := -1;

  Player.UserID := UserIndex;
  Player.Cash   := 0;

  fAssign (F, DataPath + 'videopokerx.dat', 66);
  fReset  (F);

  If IoResult <> 0 Then fReWrite(F);

  While Not fEof(F) Do Begin
    fReadRec (F, T);

    If T.UserID = UserIndex Then Begin
      Player       := T;
      PlayerNumber := fPos(F) / SizeOf(Player);
      Break;
    End;
  End;

  fClose (F);

  Player.LastOn := DateTime;
  Player.Name   := UserAlias;
End;

Procedure SavePlayer;
Var
  F : File;
Begin
  fAssign (F, DataPath + 'videopokerx.dat', 66);
  fReset  (F);

  If PlayerNumber <> -1 Then
    fSeek (F, SizeOf(Player) * (PlayerNumber - 1));
  Else
    fSeek (F, fSize(F));

  fWriteRec (F, Player);
  fClose    (F);
End;

Procedure ExecuteTopTen;
Var
  TopList   : Array[1..10] of TopTenRec;
  Count1    : Byte;
  Count2    : Byte;
  Count3    : Byte;
  F         : File;
  BoxHandle : LongInt;
  OnePerson : PlayerRec;
  
  Function GM2Str(g:Byte):String;
  Begin
    Case g Of
      0: GM2Str:='Arcade';
      1: GM2Str:='Free';
      2: GM2Str:='Ten';
    End;
  End;
Begin
  Write ('|16|CL|10Sorting top scores...');

  For Count1 := 1 to 10 Do Begin
    TopList[Count1].User := 'None';
    TopList[Count1].Cash := 0;
    TopList[Count1].Date := 0;
  End;

  fAssign (F, DataPath + 'videopokerx.dat', 66);
  fReset  (F);

  If IoResult = 0 Then
    While Not fEof(F) Do Begin
      fReadRec (F, OnePerson);

      For Count2 := 1 to 10 Do
        If TopList[Count2].Cash <= OnePerson.Cash Then Begin
          For Count3 := 10 DownTo Count2 + 1 Do
            TopList[Count3] := TopList[Count3 - 1]

          TopList[Count2].Cash := OnePerson.Cash;
          TopList[Count2].User := OnePerson.Name;
          TopList[Count2].Date := OnePerson.LastOn;
          TopList[Count2].GM := OnePerson.GM;

          Break;
        End;
    End;

  TextColor(7+16);
  ClrScr;
  MenuCMD('GD','@115000@false@'+ DataPath +'files'+PathChar+ TopScoreANS);

  ClassCreate (BoxHandle, 'box');
  BoxOpen (BoxHandle, 5, 3, 75, 20);  
  
  Center(' |23|15Top Scorers ',3);

  GotoXY (8, 6);
  Write  ('|08##  User                      Date        Mode               Cash');

  GotoXY (8, 7);
  Write  ('|00' + strRep(#196, 65) + '|15');

  For Count1 := 1 to 10 Do Begin
    GotoXY (8, 7 + Count1);
    Write  (PadLT(Int2Str(Count1), 2, ' '));

    GotoXY (12, 7 + Count1);
    Write  (TopList[Count1].User);

    GotoXY (38, 7 + Count1);
    Write  (DateStr(TopList[Count1].Date, 1));
    
    GotoXY (50, 7 + Count1);
    Write  (GM2Str(TopList[Count1].GM));

    GotoXY (64, 7 + Count1);
    Write  (PadLT(strComma(TopList[Count1].Cash), 9, ' '));
  End;

  GotoXY (8, 18);
  Write  ('|00' + strRep(#196, 65));

  GotoXY (26, 23);
  Write  ('|17|14Press [|15ENTER|14] to continue|PN');
End;

Procedure DeckCreate;
Var
  Suits,
  Numbers,
  Index    : Byte;
Begin
  Index := 1;

  For Suits := 1 to 4 Do
    For Numbers := 2 to CardAce Do Begin
      Deck[Index].Suit := Suits;
      Deck[Index].Card := Numbers;
      Index            := Index + 1;
    End;
End;

Function GetCardNumber (Num: Byte) : String;
Var
  Res,
  Color : String[3];
Begin
  Case Deck[Num].Card of
    1..10     : Res := PadLT(Int2Str(Deck[Num].Card), 2, ' ');
    CardJack  : Res := ' J';
    CardQueen : Res := ' Q';
    CardKing  : Res := ' K';
    CardAce   : Res := ' A';
  End;

  Case Deck[Num].Suit of
    SuitClub    : GetCardNumber := '|08' + Res + #05;
    SuitSpade   : GetCardNumber := '|08' + Res + #06;
    SuitHeart   : GetCardNumber := '|04' + Res + #03;
    SuitDiamond : GetCardNumber := '|04' + Res + #04;
  End
End

Procedure DeckShuffle;
Var
  OneCard   : CardRec;
  Shuffle,
  CardNum1,
  CardNum2  : Byte;
Begin
  For Shuffle := 1 to 200 Do Begin
    CardNum1       := Random(51) + 1;
    CardNum2       := Random(51) + 1;
    OneCard        := Deck[CardNum1];
    Deck[CardNum1] := Deck[CardNum2];
    Deck[CardNum2] := OneCard;
  End;
End;

Procedure Init;
Begin
  Slot[1] := 6;
  Slot[2] := 20;
  Slot[3] := 34;
  Slot[4] := 48;
  Slot[5] := 62;
  For q := 1 To 5 Do Hold[q]:=0;
  
End;

Procedure AnimateCards;
Begin
  For q := 1 to 5 Do 
    If Hold[q]=0 Then
    Begin
      PrintBack2(Slot[q],12);
      Delay(100);
      PrintBack1(Slot[q],12);
      Delay(100);
    End;
End;

Procedure InitScreen;
Begin
  TextColor(7);
  ClrScr;
  PrintHoldAll;
  AnimateCards;
End;

Function Menu:Integer;
Var
  Ch : Char;
  Ch2: Char;
  baronc : string = '|15|21';
  baroffc : string = '|08|23';
  TopPage   :byte;
  BarPos    :byte;
  More      :byte;
  LastMore  :byte;
  Temp      :byte;
  Temp2     :byte;
  Done      : Boolean;
  TotalAreas:Byte;
  morecol   : String = '|08|16'
  
  
Procedure BarON;
Var
  d : Byte;
begin
  d := Length(Data[Barpos].Name) - Length(StripMCI(Data[BarPos].Name));
  WriteXYPipe(Menu_x, Menu_y + BarPos - TopPage,7,Menu_w,baronc+PadRT(Data[BarPos].Name, Menu_w + d, ' '));
end;

Procedure BarOFF;
Var
  d : Byte;
begin
  d := Length(Data[Barpos].Name) - Length(StripMCI(Data[BarPos].Name));
  WriteXYPipe(Menu_x, Menu_y + BarPos - TopPage,7,Menu_w,baroffc+PadRT(Data[BarPos].Name, Menu_w + d, ' '));
end;
  
Procedure DrawPage;
begin
  Temp2 := BarPos;
  For Temp := 0 to Menu_h-1 do begin 
    BarPos := TopPage + Temp;
    BarOFF;
  end;
  BarPos := Temp2;
  BarON;
end   
  
Begin
  TopPage  := 1;
  BarPos   := 1;
  Done     := False;
  More     := 0;
  LastMore := 0;
  TotalAreas:=TotalItems;
  DrawPage;
  Menu := -1;
 
  
  Repeat
    More := 0;
    Ch   := ' ';
    Ch2  := ' ';
    

    If TopPage > 1 Then begin
      More := 1;
      Ch   := Chr(244);
    End;

    If TopPage + Menu_h-1 < TotalAreas Then begin
      Ch2  := Chr(245);
      More := More + 2;
    End;

    If More <> LastMore Then begin
      LastMore := More;
      GotoXY (35, 22);
      //Write (morecol+' (' + Ch + Ch2 + ' more) ');
    End;    
    
    Ch := ReadKey;
    If IsArrow Then begin
	//HOME key
      if ch = chr(71) then begin

        TopPage := 1;
        BarPos  := 1;
        drawpage;
        end;
	//END Key
      if ch = chr(79) then begin

        if TotalAreas > Menu_h then begin
          TopPage := TotalAreas - Menu_h+1;
          BarPos  := TotalAreas;
        end else begin
          BarPos  := TotalAreas ;
        end;
        drawpage;
        end;
  
      If Ch = Chr(72) Then begin

        If BarPos > TopPage Then begin
          BarOFF;
          BarPos := BarPos - 1;
          BarON;
          end;
        Else
        If TopPage > 1 Then begin
          TopPage := TopPage - 1;
          BarPos  := BarPos  - 1;
          DrawPage;
        End;
      end;
  
      If Ch = Chr(73) Then begin

        If TopPage - Menu_h > 0 Then begin
          TopPage := TopPage - Menu_h;
          BarPos  := BarPos  - Menu_h;
          DrawPage;
          end
        Else begin
          TopPage := 1;
          BarPos  := 1;
          DrawPage;
        End;
      end;
  
    If Ch = Chr(80) Then begin

      If BarPos < TotalAreas Then
        If BarPos < TopPage + Menu_h-1 Then begin
          BarOFF;
          BarPos := BarPos + 1;
          BarON;
          end
        Else
        If BarPos < TotalAreas Then begin
          TopPage := TopPage + 1;
          BarPos  := BarPos  + 1;
          DrawPage;
        End;
      End;
  
      If Ch = Chr(81) Then begin

        If TotalAreas > Menu_h Then
          If TopPage + Menu_h < TotalAreas - Menu_h+1 Then begin
            TopPage := TopPage + Menu_h-1;
            BarPos  := BarPos  + Menu_h-1;
            DrawPage;
            end
          Else
          begin
            TopPage := TotalAreas - Menu_h+1;
            BarPos  := TotalAreas;
            DrawPage;
          End
        Else
        begin
          BarOFF;
          BarPos := TotalAreas;
          BarON;
        End;
    End;
  //ch:=#0
  end else
    If Ch = Chr(27) Then Begin
        Menu := -2;
        Done := True;
      End
      Else
        If Ch = Chr(13) Then Begin
            Menu := BarPos;
            Done := True;
          End;
  Until Done;
End;

Procedure Play;
Var
  DeckPos : Byte = 1;
  Ch      : Char;
  CPos    : Byte = 1;
  InDraw  : Boolean = False;
  TP      : Byte = 1;
  TScore  : Integer;
  NOP     : Byte = 0;
  GameEnds: Boolean = False;
  tmp     : Integer;
  tmp1    : Integer;
  
  Procedure DrawHold;
  Begin
    PrintHoldAll;
    For Q := 1 To 5 Do If Hold[q]<>0 Then PrintHoldHL(Slot[q],9);
    
    If InDraw = False Then Begin
      PrintHoldHL(Slot[CPos],9);
      If Hold[Cpos]=0 Then WriteXY(Slot[CPos]+3,10,08+7*16,'H O L D') Else
        WriteXY(Slot[CPos]+3,10,10+7*16,'H O L D');
    End;
  End;
  
  Procedure Reset;
  Begin
    For q := 1 To 5 Do Begin
      Hold[q]:=0;    
    End;
    NOP := 0;
  End;
  
  Procedure DrawCards;
  Begin
    For q := 1 To 5 Do 
      If Hold[q]=0 Then Begin
        Cards[q].Suit:=Deck[DeckPos+q-1].Suit;
        Cards[q].Card:=Deck[DeckPos+q-1].Card;
        DeckPos:=DeckPos + Random(5)+1;
        PrintBack2(Slot[q],12);
        Delay(100);
        PrintCard(Slot[q],12,Cards[q].Card,Cards[q].Suit);
        Delay(100);
      End;
  End;
  
  Procedure EvalGameEnd;
  Begin
    GameEnds:=False;
    If (GameMode=0) And (Hands <=0) Then GameEnds:=True;
    If (GameMode=2) And (Hands <=0) Then GameEnds:=True;
    If (GameMode=1) Then GameEnds:=False;
  End;
  
Begin
  If GameMode=2 Then Hands := 10 Else Hands := 5;
  Player_Score:=0;
  LastSeen:=0;
  DeckCreate;
  DeckShuffle;
  InitScreen;
  ClearArea;
  Reset;
  DrawCards;
  PrintScore;
  PrintDraw(29,21);
  CPos:=1;
  InDraw:=False;
  DrawHold;
  PrintHoldHl(Slot[1],9);
  Repeat
      
    Ch:=ReadKey;
    If IsArrow Then Begin
      If Ch=chr(71) And (InDraw = False ) Then Begin
        CPos := 1;
        DrawHold;
      End;
      If Ch=chr(79) And (InDraw = False ) Then Begin
        CPos := 5;
        DrawHold;
      End;
      If Ch=chr(75) And (InDraw = False ) Then Begin
        CPos := CPos - 1;
        If Cpos < 1 Then CPos := 5;
        DrawHold;
      End;
      If Ch=chr(77) And (InDraw = False ) Then Begin
        CPos := CPos + 1;
        If CPos > 5 Then CPos := 1;
        DrawHold;
      End;
      If Ch=chr(72) Then Begin
        InDraw := False;
        DrawHold;
        PrintDraw(29,21);
      End;
      If Ch=chr(80) Then Begin
        InDraw := True;
        DrawHold;
        PrintDrawHL(29,21);
      End;
      
    End;
    If Ch=chr(27) Then Begin
      ClearArea;
      GetTDFHeader(DataPath+'files'+PathChar+'hobbes.tdf');
      Font.Spacing:=1;
      TextColor(5);
      TDFWrite(2,1,'Are you sure? (Y/N)');
      Ch:=Readkey;
      If Upper(Ch)='Y' Then Hands:=255;
      ClearArea;
      PrintScore;
    End;
    If (Ch=Chr(32) Or Ch=Chr(13) )And (InDraw = False ) Then Begin
      If Hold[CPos] = 0 Then Hold[CPos] := 1 Else Hold[CPos] := 0;
      DrawHold;
    End;
    If (Ch=Chr(32) Or Ch=Chr(13) )And (InDraw = True ) Then Begin
      DrawCards;
      NOP := NOP + 1;
      TScore:=Evaluate;
      Player_Score:=Player_Score + TScore;
      //If TScore<>0 Then Hands:=Hands+1;
      Case TScore Of
        5000 : MsgBox(4,'Royal Flush!');
        2000 : MsgBox(4,'Straight FLush');
        1000 : MsgBox(14,'Four Of a Kind');
         700 : MsgBox(22,'Full House');
         500 : MsgBox(30,'Flush');
         300 : MsgBox(22,'Straight');
         200 : MsgBox(10,'Three Of a Kind');
         100 : MsgBox(23,'Two Pairs');
          50 : MsgBox(10,'Jacks Or Better');
           0 : Begin 
                  If GameMode<>1 Then Hands:=Hands-1; 
                  MsgBox(19,'You Loose!'); 
               End;
      End;
      Delay(1000);
      tmp:= ((LastSeen+1) * 500);
      
      If Player_Score >= tmp Then Begin
        tmp:=Player_Score / 500;
        For q := LastSeen+1 To tmp Do Begin
          tmp1:=q;
          Hands:=Hands+3;
          LastSeen:=LastSeen+1;
          If FileExist(DataPath+'images'+PathChar+Int2Str(q)+'.ans') Then
            Begin
              TextColor(7);
              ClrScr;
              MenuCMD('GD','@30000@false@'+DataPath+'files'+PathChar+'ready.ans@');
              Delay(1000);
              TextColor(7);
              ClrScr;
              MenuCMD('GD','@38600@false@'+DataPath+'images'+PathChar+Int2Str(q)+'.ans@');
              Delay(1000);
              
            End;
        
        End;
          
      End;
      If Hands>0 Then Begin
        DeckCreate;
        DeckPos := 1;
        DeckShuffle;
        InitScreen;
        ClearArea;
        Reset;
        DrawCards;
        PrintScore;
        PrintDraw(29,21);
        CPos:=1;
        InDraw:=False;
        DrawHold;
      End;
      //GotoXY(50,25);Write('|15'+int2str(lastseen)+'/tmp'+int2str(tmp)+'/q'+int2str(q));
      //PrintHoldHl(Slot[1],9);
      EvalGameEnd;
    End;
  Until (GameEnds=True) Or (Hands=255;)
  
  If Player_Score > Player.Cash Then Player.Cash:=Player_Score;
  If GameMode<>1 Then Begin
    Player.GM:=GameMode;
    SavePlayer;
  End;
  Reset;
End;


Procedure MainMenu;
Var
  BoxHandle : LongInt;
  m         : Integer;
  
  Procedure DisplayFile(FN:String);
  Begin
    TextColor(7);
    ClrScr;
    MenuCMD('GD','@115000@false@'+ FN +'@');
    GotoXY(79,24);
    Write('|PN');
  End;
  
Begin
  Data[1].Name := ' Play Arcade';
  Data[1].ID   := 1;
  Data[2].Name := ' Play Free';
  Data[2].ID   := 2;
  Data[3].Name := ' Play Ten';
  Data[3].ID   := 3;
  Data[4].Name := ' Help';
  Data[4].ID   := 4;
  Data[5].Name := ' Cards';
  Data[5].ID   := 5;
  Data[6].Name := ' Top Scores';
  Data[6].ID   := 6;
  Data[7].Name := ' About';
  Data[7].ID   := 7;
  Data[8].Name := ' Exit';
  Data[8].ID   := 8;
  
  Repeat
    InitScreen;
    ClearArea;
    PrintString(6,2,'Video Poker X',13+5*16);
    ClassCreate (BoxHandle, 'box');
    BoxOpen (BoxHandle, 30, 7, 50, 7);    
    Delay(100);
    BoxOpen (BoxHandle, 30, 7, 50, 12);
    Delay(100);
    BoxOpen (BoxHandle, 30, 7, 50, 16);
    ClassFree (BoxHandle);
    TextColor(5+7*16);
    Center(' Main Menu ',7);
    m := Menu
    Case m Of
      1: Begin GameMode := 0; Play; End;
      2: Begin GameMode := 1; Play; End;
      3: Begin GameMode := 2; Play; End;
      4: DisplayFile(DataPath +'files'+PathChar+'help.ans');
      5: DisplayFile(DataPath +'files'+PathChar+'cards.ans');
      7: DisplayFile(DataPath +'files'+PathChar+'about.ans');
      6: ExecuteTopTen;
    End;
  Until m = 8;

  TextColor(7);
  ClrScr;
  
End;

Var
  Ch      : Char;
  GoForIt : Boolean;
Begin
  ClrScr;

  If Graphics = 0 Then Begin
    WriteLn ('Sorry, this game requires ANSI graphics.|CR|PA');
    Halt;
  End;

  DataPath := JustPath(ProgName);

  If Upper(ParamStr(1)) = 'TOP10' Then Begin
    ExecuteTopTen;
    Halt;
  End;

  If Upper(ParamStr(1)) = 'RESET' Then Begin
    If InputYN('|CR|12Reset scores? ') Then Begin
      FileErase(DataPath + 'videopokerx.dat');
      
      WriteLn ('|CRScores have been reset|CR|CR|PA');
    End;

    Halt;
  End;

  Randomize;
  DeckCreate;
  DeckShuffle;
  LoadPlayer;
  Player.Cash := 0;
  ClrScr;
  If Upper(ParamStr(1))<>'NOLOGO' Then Begin
    MenuCMD('GD','@115000@false@'+ DataPath +'files'+PathChar+'parental.ans');
    Delay(1000);
    ClrScr;
    MenuCMD('GD','@115000@false@'+ DataPath +'files'+PathChar+'logo.ans');
    Delay(1000);
  End;
   
  Init;
  MainMenu;
End.

