(*

Day Template

The info below describes how a configuration file for a specific day is encoded.
First line must always be like this: 

                        <ansi_file>;x;y

<ansi_file>  : An .ans file inside the xq-bbscal directory
x            : X Position of the calendar
y            : Y Position of the calendar

After that you can add as many lines you want in the following format:

                        x;y;<fontfile>;<color>;<text>

x            : X Position of text to display
y            : Y Position of text to display
<font_file>  : The filename of the font file inside the xq-bbscal directory
<color>      : Text color
<text>       : Text to display. Can include Pipe codes ex. |PA
*)


Uses Cfg
Uses User

Const Script_Dir   = 'xq-bbscal';
Const HeaderOffset = 233;
Const CCalX        = 32; // Constant for X Position When No image
Const CCalY        = 13; // Constant for Y Position When No image
Const TimeDelay    = 1000;  // Delay when No Pausing

Type 
  TTDFont = record
    A         : char;
    typo      : Array[1..18] of char;
    B         : char;
    fs        : array[1..4] of byte;
    NameLen   : byte;
    FontName  : array[1..12] of char;
    nouse     : array[1..4] of byte;
    FontType  : byte;
    Spacing   : byte;
    BlockSize : word;
    CharAddr  : Array[1..94] of word;
  end;
  
Type
  TFontChar = Record
    width     : byte;
    height    : byte;
  end;
   
  Var font        : TTDFont;
  var Datapath    : string;
  var FontFile    : String;
  Var CalX        : Byte;
  Var CalY        : Byte;
  Var ShowImage   : Boolean;
  Var DoPause     : Boolean; 
  Var ii          : Byte;
  Var Day,Month   : String[2];

Procedure Center(s:String; line:byte);
Begin
  GotoXY(40-(length(stripmci(s)) / 2),line);
  Write(s);
End;

Procedure Draw_Cal(x,y:byte);
Begin
  WriteXY(x,y,7,'[2C[37m[10C');
  WriteXY(x,y+1,7,'[31;41m  [37m[31m          [37m[31m  [1;30;40m[0m');
  WriteXY(x,y+2,7,'[31;41m [1;37m   [30m        [0;31;41m    [1;30;40m[0m');
  WriteXY(x,y+3,7,'[41m[1;30;40m[0m');
  WriteXY(x,y+4,7,'[47m                [1;30;40m[0m');
  WriteXY(x,y+5,7,'[47m                [1;30;40m[0m');
  WriteXY(x,y+6,7,'[47m                [1;30;40m[0m');
  WriteXY(x,y+7,7,'[47m                [1;30;40m[0m');
  WriteXY(x,y+8,7,'[47m                [1;30;40m[0m');
  WriteXY(x,y+9,7,'[1;30;47m[40m[0m');
End;

Procedure GetTDFHeader(f:string);
Var
  fptr : file;
  i : integer;
begin
  if not fileexist(f) then begin
   writeln('Font file [ '+f+' ]does not exist');
   pause;
   halt;
  end;
  fontfile:=f;
  fassign(fptr,f,66);
  freset(fptr);
  fread(fptr,font,sizeof(font));
  fclose(fptr);
end;

Procedure TDFWriteCharBL(x,y:byte;c:char):byte;
Var
  fptr : file;
  i : integer;
  FChar : TFontChar;
  tbyte : array[1..2] of byte;
  sx,sy:byte;
  asc:byte;
begin
  if c=' ' then begin
  tdfwritecharBL:=1;
  exit;
  end;
  asc:=ord(c)-32;
  fassign(fptr,fontfile,66);
  freset(fptr);
  fseek(fptr,headeroffset+font.charaddr[asc]);
  fread(fptr,FChar,sizeof(Fchar));
  tbyte[1]:=32;
  tbyte[2]:=32;
  gotoxy(x,y);
  while tbyte[1]<>0 and not feof(fptr) do begin
  fread(fptr,tbyte[1],1);
  if tbyte[1]=13 then begin
    gotoxy(x,wherey+1);
    if wherey>25 then break;
  end
   else begin
    fread(fptr,tbyte[2],1);
    textcolor(tbyte[2] % 16 + tbyte[2] - (tbyte[2] % 16));
    write(chr(tbyte[1]));
    if wherex>79 then break
  end;
  end;
  fclose(fptr);
  tdfwritecharbl:=fchar.width;
end;

Procedure TDFWriteCharCL(x,y:byte;c:char):byte;
Var
  fptr : file;
  i : integer;
  FChar : TFontChar;
  tbyte : array[1..2] of byte;
  sx,sy:byte;
  asc:byte;
begin
  if c=' ' then begin
  tdfwritecharcl:=1;
  exit;
  end;
  asc:=ord(c)-32;
  fassign(fptr,fontfile,66);
  freset(fptr);
  fseek(fptr,headeroffset+font.charaddr[asc]);
  fread(fptr,FChar,sizeof(Fchar));
  tbyte[1]:=32;
  gotoxy(x,y);
  while tbyte[1]<>0 and not feof(fptr) do begin
  fread(fptr,tbyte[1],1);
  if tbyte[1]=13 then begin
    gotoxy(x,wherey+1);
    if wherey>25 then break;
  end
   else begin
    write(chr(tbyte[1]));
    if wherex>79 then break;
  end;
  end;
  fclose(fptr);
  tdfwritecharcl:=fchar.width;
end;

procedure TDFWrite(x,y:byte; s:string)
Var
  i:byte;
  sx,sy:byte;
begin
  gotoxy(x,y);
  sx:=x;
  sy:=y;
  case font.fonttype of
  2: begin  
      for i:=1 to length(s) do begin
      sx:=sx+tdfwritecharBL(sx,y,s[i])+font.spacing;
      end;
   end;
  1: begin  
      for i:=1 to length(s) do begin
      sx:=sx+tdfwritecharCL(sx,y,s[i])+font.spacing;
      end;
   end;
   end;
end;

Procedure Display_Cal(x,y:Byte);
Var
  mon : Byte;
  mons : String;
  
Begin
  Draw_Cal(x,y);
  mon := Str2Int(Copy(DateStr(Datetime,1),1,2));
  Case mon Of
    1 : mons := 'JAN';
    2 : mons := 'FEB';
    3 : mons := 'MAR';
    4 : mons := 'APR';
    5 : mons := 'MAY';
    6 : mons := 'JUN';
    7 : mons := 'JUL';
    8 : mons := 'AUG';
    9 : mons := 'SEP';
    10 : mons := 'OCT';
    11 : mons := 'NOV';
    12 : mons := 'DEC';
  End;
  WriteXY(x+4,y+2,15+4*16,mons+' '+Copy(DateStr(Datetime,4),7,4));
  GetTDFHeader(Datapath+Script_Dir+Pathchar+'hobbes.tdf');
  TextColor(15+7*16);
  TDFWrite(x+3,y+4,Copy(DateStr(Datetime,1),4,2));
End;

Procedure Display_File;
Var
  fpt         : File;
  S,S1        : String;
  i           : byte;
  sx,sy       : Byte;
  ffile       : String[30];
  fg,bg       : Byte;
Begin
  If Day='' Then Day := Copy(DateStr(Datetime,1),1,2);
  If Month = '' Then Month := Copy(DateStr(Datetime,1),4,2);
  
  If Fileexist(Datapath+Script_Dir+PathChar+Month+'-'+Day+'.txt') Then Begin
    fAssign(fpt, Datapath+Script_Dir+PathChar+Month+'-'+Day+'.txt',66);
    fReset(fpt);
    fReadLn(fpt,S);
    CalX  := Str2Int(WordGet(2,S,';'));
    CalY  := Str2Int(WordGet(3,S,';'));

    If ShowImage Then MenuCMD('GD','@55600@false@'+Datapath+Script_Dir+Pathchar+WordGet(1,S,';'));
    Display_Cal(CalX,CalY);
    i := 0;
    While Not fEOf(fpt) Do Begin
      fReadLn(fpt,S1);
      if S1<>'' Then Begin
        sx := Str2Int(WordGet(1,S1,';'));
        sy := Str2Int(WordGet(2,S1,';'));
        ffile := WordGet(3,S1,';');
        if Upper(ffile) = 'NULL' Then begin
        fg := Str2Int(WordGet(4,S1,';')) % 16;
        bg := Str2Int(WordGet(4,S1,';')) / 16;
        s  := WordGet(5,S1,';');
          if sx = 255 then 
            WriteXY(40-(length(stripmci(s))) / 2,sy,fg+bg*16,s);
          else WriteXYPipe(sx,sy,fg,bg,WordGet(5,S1,';'));
        End else Begin
          GetTDFHeader(Datapath+Script_Dir+Pathchar+ffile);
          TextColor(Str2Int(WordGet(4,S1,';')))
          TDFWrite(sx,sy,WordGet(5,S1,';'));
        End;
      End;
      i := i + 1;
    End;
    fClose(fpt);
  End Else Begin
    If ShowImage Then MenuCMD('GD','@55600@false@'+Datapath+Script_Dir+Pathchar+Copy(DateStr(Datetime,1),1,2)+'.ans');
    Display_Cal(CCalX,CCalY);
  End;
End;


// Main Block

Begin

  If Graphics = 0 Then begin
    writeln('|16|15No Graphics support. Exiting... |PA');
    Halt;
  End;
  
  ShowImage := True;
  DoPause := True;
  Day := '';
  Month := '';
  
  For ii := 0 To ParamCount Do Begin 
    If Upper(ParamStr(ii)) = '-NOIMAGE' Then ShowImage := false;
    If Upper(ParamStr(ii)) = '-NOPAUSE' Then DoPause := false;
    If Pos('-D',Upper(ParamStr(ii)))>0 Then Day := Copy(ParamStr(ii),3,2);
    If Pos('-M',Upper(ParamStr(ii)))>0 Then Month := Copy(ParamStr(ii),3,2);
  End;
  
  GetThisUser;
  clrscr;
  Datapath := addslash(cfgmpepath);
  Display_File;
  
  Gotoxy(1,25);
  If DoPause Then Write('|PA')
    else Delay(TimeDelay);
  Textcolor(0);
  ClrScr;

End;
