PAGE  80,132
TITLE CHRINSL  String Insert Left Routine, Ver 6.20

; CHRINSL.ASM - ChrInsL
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine adds repeated characters on the LEFT of a string.
; Length will truncate at 255.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrInsL
        EXTRN   RepStosBRev: NEAR
        EXTRN   RepMovsBRev: NEAR

S            EQU     DWORD PTR ss:[bx+8]
Fill         EQU     BYTE  PTR ss:[bx+6]
Count        EQU     BYTE  PTR ss:[bx+4]

; ChrAddL - Add repeated characters on the LEFT of a string.
; procedure ChrInsL (VAR S: string; Fill: char; Count: byte);

ChrInsL      PROC FAR
       mov   bx,sp            ; Set up stack base
; -- Test Fill count --
       xor   ax,ax            ; Set AX=0
       add   al,Count         ; Get proposed Count length
       jz    Exit             ;   yes, quit if no count
; -- Get S length --
       push  ds               ; Save Pascal's DS
       mov   dx,ax            ; Save Count in DX
       lds   si,S             ; Point to source string
       mov   al,[si]          ; Load S[0] in AL
       mov   cx,ds            ; Move DS into ...
       mov   es,cx            ;  ... ES
       mov   cx,ax            ; Save length in CX
; -- Check new length --
       add   al,dl            ; New length>255?
       jc    Cut              ;   yes, have to truncate string
; -- Save new length --
Save:  std                    ; Set DF to decrement
       mov   [si],al          ; Set new length
; -- Shift string --
       mov   di,si            ; At S[0]
       add   si,cx            ; At S[L]
       add   di,ax            ; At S[NewLen]
       call  RepMovsBRev      ; Do fast move of bytes
; -- Add leading chars --
       mov   al,Fill          ; Set AL to filling char
       mov   cl,dl            ; Set string count
       call  RepStosBRev      ; Fast fill of leading chars
       pop   ds               ; Restore Pascal's DS
Exit:  ret   8                ; Clear all parameters

Cut:   mov   cx,dx            ; Get fill length
       not   cl               ; 255-(fill length) = Max string length
       mov   al,255           ; Set to Max length
       jmp   SHORT Save       ;
ChrInsL      ENDP

CODE   ENDS

       END
