PAGE  80,132
TITLE CHRPOSLI  Character Count and Position Routines - Ignore case, Ver 6.20

; CHRPOSLI.ASM - ChrPosLI, ChrQtyI
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrPosLI
        EXTRN   ChrSrchI: NEAR

; ChrPosLI - Position of Nth occurrence of Find.
; This routine finds the position of Nth occurrence of a given character
; starting from the LEFT ignoring case.
; function ChrPosLI (S: string; Find: char; Nth: byte): byte;

S            EQU     DWORD PTR ss:[bx+8]
Find         EQU     BYTE  PTR ss:[bx+6]
Nth          EQU     BYTE  PTR ss:[bx+4]

ChrPosLI     PROC FAR
       mov   bx,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
; -- Point to string --
       xor   ax,ax            ; Set AX=0
       cwd                    ; Set DX=0
       lds   si,S             ; Point to dest string
; -- Check for Nth --
       add   dl,Nth           ; Get count
       jz    Exit1            ; Exit if 0 (AX=0)
; -- Evaluate string length --
       cld                    ; Set DF to increment
       lodsb                  ; Get length
       mov   cx,ax            ; Set length
       jcxz  Exit1            ; Quit if null string
; -- Search for Find --
       call  ChrSrchI         ; Search for Find
       xchg  ax,cx            ; Set AX=0 if ZF=0
       jne   Exit1            ; Nth not found (ZF=0 and AL=0)
; -- Calculate position --
       mov   ax,si            ; Get final offset (ZF=1)
       sub   ax,bx            ; Calc position
Exit1: pop   ds               ; Restore Pascal's DS
       ret   8                ; Clear all parameters
ChrPosLI     ENDP

CODE   ENDS

       END
