PAGE  80,132
TITLE WRDL  Parse the Nth word from the LEFT, Ver 6.20

; WRDL.ASM - WrdL
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine extracts the Nth word from a string delimited by spaces.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  WrdL
        EXTRN   RepMovsB: NEAR

Dest         EQU     DWORD PTR SS:[bx+10]
S            EQU     DWORD PTR SS:[bx+6]
Nth          EQU     BYTE  PTR SS:[bx+4]

; WrdL - Parse the Nth word in a string.
; procedure WrdL (VAR Dest: string; S: string; Nth: byte);

WrdL         PROC FAR
       mov   bx,sp            ; Set up stack base
       xor   cx,cx            ; Set CX=0
       mov   dx,cx            ; Set DX=0
; -- Evalute Nth --
       add   dl,Nth           ; Get Nth, Nth=0?
       jz    Null             ;   yes, return null
; -- Point to string to be scanned (not Dest) --
       les   di,S             ; Point to source string
       mov   cl,es:[di]       ; Get length
       jcxz  Null             ; Exit if null string
; -- Set up constants --
       mov   al,' '           ; Get Space char to scan
       inc   di               ; Start at S[1]
       cld                    ; Set DF to increment
       EVEN                   ; Align for speed
L1:    repe  scasb            ; Scan for non-space
       je    Null             ; All spaces
       dec   dx               ; Word found, dec count
       jz    Found            ; Exit if Nth word found
       repne scasb            ; Scan for space
       je    L1               ;   space found, look for next word
       jmp   SHORT Null       ; Word not found.  CX=0
Found: mov   si,di            ; Save as source SI
       dec   si               ; Set SI to first char
       repne scasb            ; Scan for end of word
       jne   Dec0             ;   no space
       dec   di               ; Set on space
Dec0:  mov   cx,di            ; Get final offset
       sub   cx,si            ; Word length in CX
; -- Reset pointers --
       mov   dx,es            ; Save ES
Null:  mov   ax,cx            ; Set length in AX
       les   di,Dest          ; Set up destination
       stosb                  ; Save length
       mov   bx,ds            ; Save Pascal's DS
       mov   ds,dx            ; Set source seg
       call  RepMovsB         ; Do fast move of bytes (Skip if CX=0)
       mov   ds,bx            ; Restore Pascal's DS
       ret   10               ; Clear all parameters

WrdL         ENDP

CODE   ENDS

       END
