{
 $Id$
}
{*******************************************************************************
 *
 * Purpose ...............: File Area Descriptions
 *  Also see . . . . FM_desc2 for OS/2 version but written in C
 *
 * vbc - 11/02/08 - Replaced filebone.na for filegate.zxx, former no longer used
 *                  for v1.21
 *
 *******************************************************************************
 * Copyright (C) 1994-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}


program fm_desc;

uses dos, crt, fm_list, s_string, fm_struct;

var
   x   : integer;
   t   : text;
   tmp : string;
   tel : word;

function find_in_area(name:string) : Boolean;
var y     : integer;
    found : boolean;
    tt    : string;
begin
  if list_amount > 0 then
    begin
      found := false;
      y := 1;
      repeat
        tt := get_from_list(y);
        if extractwords(1,1,upper(tt)) = upper(name) then found := true;
        inc(y);
      until (y > list_amount) or found;
      if found then
        begin
          find_in_area := true;
          tmp := extractwords(2,wordcnt(tt)-1,tt);
        end else find_in_area := false;
    end else find_in_area := false;
end;


begin
  TextAttr := 7;
  Clrscr;
  TextAttr := 14;
  Writeln(#10#13+'FM_DESC v1.21 - Update area descriptions from filegate.zxx file.');
  TextAttr := 11;
  Writeln('Copyright (c) Vince Coen / Ron Huiskes., 1994 - 2008. All Rights Reserved.'+#10#13);
  TextAttr := 7;

  systempath := getenv('FILEMGR');
  if systempath <> '' then
    if last(1,systempath) <> '\' then
      systempath := systempath + '\';
  if systempath <> '' then writeln('Using '+systempath+#10#13);

  assign (afx, systempath + 'AREAFILE.FMX');
  {$I-} reset (afx,1); {$I+}
  if ioresult <> 0 then
    begin
      writeln('Cannot open '+systempath+'AREAFILE.FMX');
      halt;
    end;

  assign(af, systempath + 'AREAFILE.FM');
  {$I-} reset(af,1); {$I+}
  if ioresult <> 0 then
    begin
      writeln('Cannot open '+systempath+'AREAFILE.FM');
      halt;
    end;

  If paramcount > 0 then
    begin
      assign(t,paramstr(1));
      {$I-} reset(t); {$I+}
      if ioresult <> 0 then
        begin
          assign(t,systempath+paramstr(1));
          {$I-} reset(t); {$I+}
          if ioresult <> 0 then
            begin
              writeln('Cannot find '+upper(paramstr(1))+' file');
              halt;
            end;
        end;
    end else
    begin
      assign(t,'FILEGATE.ZXX');
      {$I-} reset(t); {$I+}
      if ioresult <> 0 then
        begin
          assign(t,systempath+'FILEGATE.ZXX');
          {$I-} reset(t); {$I+}
          if ioresult <> 0 then
            begin
              writeln('Cannot find FILEGATE.ZXX file');
              halt;
            end;
        end;
    end;

  If MaxAvail < SizeOf(Afxt^) then
    Begin
      Writeln('Not enough memory left for area index');
      Halt;
    End Else New(Afxt);

  For AreaIdx := 1 to 2000 do FillChar(Afxt^[areaidx],sizeof(afxt^[areaidx]),0);
  AreaIdx := 0;
  BlockRead(Afx,AFXt^,2000*sizeof(areaindextype),areaIdx);
  Close(Afx);
  AreaIdx := AreaIdx div Sizeof(areaindextype);

  create_list;

  if paramcount > 0 then
    writeln(' Reading '+upper(paramstr(1))+' file') else
      writeln(' Reading FILEGATE.ZXX file');
  while not eof(t) do
    begin
      readln(t,tmp);
      if (first(1,tmp) <> '%') and (strip('B',' ',tmp) <> '') then
        begin
          if wordcnt(tmp) > 5 then
            begin
              add_to_list(extractwords(2,1,tmp)+' '+extractwords(5,wordcnt(tmp)-4,tmp));
            end else
              writeln(#13,'! Invalid line: '+tmp);
        end;
    end;


  writeln(#13,' Updating area descriptions');
  tel := 0;

  for x := 1 to areaidx do
    begin
      Write(AFXT^[x].tag);

      Seek (AF, AFXt^[X].AreaRec);
      BlockRead (AF, AREA, SizeOf(AREA));

      if find_in_area(afxt^[x].tag) then
        begin
          write(' -> '+tmp);
          area.name := tmp;

          inc(tel);

          Seek (AF, AFXt^[X].AreaRec);
          BlockWrite (AF, AREA, SizeOf(AREA));
        end;

       write(#13+replicate(79,' ')+#13);
    end;

  writeln(' ',tel,' FILEGATE areas found and changed');
  close(af);
  remove_list;
end.
