{
 $Id$
}
{*****************************************************************************
 *
 * Purpose ...............: setup FileFind
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}
Unit Fm_7;

{$O+}

Interface

Uses Dos, Crt,
     M_Window, F_Fast, S_String, S_Screen, F_File,
     Fm_Div, Fm_Exec;

Procedure FileFindLoop;

Implementation


{$F+} Procedure FileFindMiscHelp ( Welke : Byte ); {$F-}
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
   1 : writeat(1,25,7,0,'Maximum no of ''?'' wildcards allowed in request.');
   2 : writeat(1,25,7,0,'Expand a ''*'' wildcard to how many ''?'' wildcards?');
   3 : writeat(1,25,7,0,'Minimum length of a filesearch keyword.');
   4 : writeat(1,25,7,0,'Maximum number of files that FileMgr should report.');
   5 : writeat(1,25,7,0,'Should FileMgr respond to messages from your own system?');
   6 : writeat(1,25,7,0,'The maximum size of the message body in kilobytes.');
  End;
End;


Procedure FileFindMisc;
Var
  Ar  : Array[1..6] of String[19];
  Ge  : Integer;
  Tmp : String;

  Procedure WriteMiscData;
  Begin
    Writeat(49,12,foreentry,backentry,expand(int_to_str(setup.FFone),3));
    Writeat(49,13,foreentry,backentry,expand(int_to_str(setup.FFstar),3));
    Writeat(49,14,foreentry,backentry,expand(int_to_str(setup.FFkeylen),3));
    Writeat(49,15,foreentry,backentry,expand(int_to_str(setup.ffmax),3));
    if setup.ffloc then Writeat(49,16,foreentry,backentry,'Yes ') else writeat(49,16,foreentry,backentry,'No ');
    Writeat(49,17,foreentry,backentry,expand(int_to_str(setup.ffmaxsize),3));
  End;

Begin
  with mwin[3] do
    begin
      x1 := 26;
      x2 := 10;
      y1 := 55;
      y2 := 19;
      st := '';
    end;
  create_window(3);

  ar[1] := 'Maximum no of ''?''';
  ar[2] := 'Expand ''*'' to ''?''';
  ar[3] := 'Min. keyword length';
  ar[4] := 'Maximum no of files';
  ar[5] := 'Local requests     ';
  ar[6] := 'Maximum msg size   ';

  ge := 1;
  while ge <> 0 do
    begin
      writemiscdata;
      choosehook := filefindmischelp;
      decwin(3);
      ge := select_window(3,6,19,@ar,ge,false);
      incwin(3);
      case ge of
        1 : begin
              tmp := int_to_str(setup.ffone);
              read_string(49,12,5,3,tmp,c_all);
              setup.ffone := str_to_int(tmp);
            end;
        2 : begin
              tmp := int_to_str(setup.ffstar);
              read_string(49,13,5,3,tmp,c_all);
              setup.ffstar := str_to_int(tmp);
            end;
        3 : begin
              tmp := int_to_str(setup.ffkeylen);
              read_string(49,14,5,3,tmp,c_all);
              setup.ffkeylen := str_to_int(tmp);
            end;
        4 : begin
              tmp := int_to_str(setup.ffmax);
              read_string(49,15,5,3,tmp,c_all);
              setup.ffmax := str_to_int(tmp);
            end;
        5 : setup.ffloc := not setup.ffloc;
        6 : begin
              tmp := int_to_str(setup.ffmaxsize);
              read_string(49,17,5,3,tmp,c_all);
              setup.ffmaxsize := str_to_int(tmp);
              if setup.ffmaxsize > 16 then setup.ffmaxsize := 16;
            end;
      end;
    end;
  remove_window(3);
End;


Procedure FileFindMsg;
Var
  Ch    : Char;
  Ge, X : Word;
  Sabak : file of scanareatype;

  Procedure WriteThem(welke:byte);
  Begin
    writeat(9,4 ,7,0,' Message name ');
    Writeat(9,6 ,7,0,' Message base ');
    Case scanarea.msgbaseid of
     'S' : Writeat(9,7,7,0,' Msgbase Name ');
     'H' : Writeat(9,7,7,0,' Board Number            Msgbase Path ');
     'F' : Writeat(9,7,7,0,' Msgbase Path ');
     'J' : Writeat(9,7,7,0,' Msgbase Name ');
     'E' : Writeat(9,7,7,0,' Board Number            Msgbase Path ');
    End;

    Writeat(9,9 ,7,0,' Reply base   ');
    Case scanarea.replybaseid of
     'S' : Writeat(9,10,7,0,' Msgbase Name ');
     'H' : Writeat(9,10,7,0,' Board Number            Msgbase Path ');
     'F' : Writeat(9,10,7,0,' Msgbase Path ');
     'J' : Writeat(9,10,7,0,' Msgbase Name ');
     'E' : Writeat(9,10,7,0,' Board Number            Msgbase Path ');
    End;
    Writeat(9,11,7,0,' Attributes   ');
    Writeat(9,13,7,0,' Header       ');
    Writeat(9,14,7,0,' Footer       ');
    Writeat(9,15,7,0,' File entry   ');
    Writeat(9,16,7,0,' Block header ');
    Writeat(9,17,7,0,' Block footer ');
    Writeat(9,19,7,0,' Program ID   ');
    Writeat(9,20,7,0,' Originline   ');
    Writeat(9,21,7,0,' Origin Aka   ');

    Case welke of
      1 : writeat(9,4 ,kl4,kl5,' Message name ');
      2 : Writeat(9,6 ,kl4,kl5,' Message base ');
      3 : begin
            Case scanarea.msgbaseid of
              'S' : Writeat(9,7,kl4,kl5,' Msgbase Name ');
              'H' : Writeat(9,7,kl4,kl5,' Board Number ');
              'F' : Writeat(9,7,kl4,kl5,' Msgbase Path ');
              'J' : Writeat(9,7,kl4,kl5,' Msgbase Name ');
              'E' : Writeat(9,7,kl4,kl5,' Board Number ');
            End;
          end;
      4 : Writeat(9,9 ,kl4,kl5,' Reply base   ');
      5 : begin
            Case scanarea.replybaseid of
              'S' : Writeat(9,10,kl4,kl5,' Msgbase Name ');
              'H' : Writeat(9,10,kl4,kl5,' Board Number ');
              'F' : Writeat(9,10,kl4,kl5,' Msgbase Path ');
              'J' : Writeat(9,10,kl4,kl5,' Msgbase Name ');
              'E' : Writeat(9,10,kl4,kl5,' Board Number ');
            End;
          end;
      6 : Writeat(9,11,kl4,kl5,' Attributes   ');

      7 : Writeat(9,13,kl4,kl5,' Header       ');
      8 : Writeat(9,14,kl4,kl5,' Footer       ');
      9 : Writeat(9,15,kl4,kl5,' File entry   ');
     10 : Writeat(9,16,kl4,kl5,' Block header ');
     11 : Writeat(9,17,kl4,kl5,' Block footer ');

     12 : Writeat(9,19,kl4,kl5,' Program ID   ');
     13 : Writeat(9,20,kl4,kl5,' Originline   ');
     14 : Writeat(9,21,kl4,kl5,' Origin Aka   ');
    End;
  End;

  Procedure WriteIt;
  Var Tmp : String;
  Begin
    writeat(24,4,foreentry,backentry,expand(scanarea.IdName,48));
    If Net in scanarea.status then
      tmp := ', Netmail' else
        tmp := ', Echomail';

    If scanarea.msgbaseid <> #0 then
      Begin
        Case scanarea.msgbaseid of
          'S' : begin
                  Writeat(24,6,foreentry,backentry,expand('Squish'+tmp,20));
                  Writeat(24,7,foreentry,backentry,expand(scanarea.msgbaseidstr,48));
                end;
          'H' : begin
                  Writeat(24,6,foreentry,backentry,expand('Hudson'+tmp,20));
                  Writeat(24,7,foreentry,backentry,expand(int_to_str(str_to_int(first(3,scanarea.msgbaseidstr))),4));
                  Writeat(47,7,foreentry,backentry,expand(last(length(scanarea.msgbaseidstr)-3,scanarea.msgbaseidstr),25));
                end;
          'F' : begin
                  Writeat(24,6,foreentry,backentry,expand('Fido'+tmp,20));
                  Writeat(24,7,foreentry,backentry,expand(scanarea.msgbaseidstr,48));
                end;
          'J' : begin
                  Writeat(24,6,foreentry,backentry,expand('Jam'+tmp,20));
                  Writeat(24,7,foreentry,backentry,expand(scanarea.msgbaseidstr,48));
                end;
          'E' : begin
                  Writeat(24,6,foreentry,backentry,expand('Ezycom'+tmp,20));
                  Writeat(24,7,foreentry,backentry,expand(int_to_str(str_to_int(first(4,scanarea.msgbaseidstr))),4));
                  Writeat(47,7,foreentry,backentry,expand(last(length(scanarea.msgbaseidstr)-4,scanarea.msgbaseidstr),25));
                end;
        End;
      End Else
      Begin
        Writeat(24,6,foreentry,backentry,expand(' ',20));
        Writeat(24,7,foreentry,backentry,expand(' ',48));
      End;

    If Net in scanarea.replystatus then
      tmp := ', Netmail' else
        tmp := ', Echomail';
    If scanarea.replybaseid <> #0 then
      Begin
        Case scanarea.replybaseid of
          'S' : begin
                  Writeat(24,9,foreentry,backentry,expand('Squish'+tmp,20));
                  Writeat(24,10,foreentry,backentry,expand(scanarea.replybaseidstr,48));
                end;
          'H' : begin
                  Writeat(24,9,foreentry,backentry,expand('Hudson'+tmp,20));
                  Writeat(24,10,foreentry,backentry,expand(int_to_str(str_to_int(first(3,scanarea.replybaseidstr))),4));
                  Writeat(47,10,foreentry,backentry,expand(last(length(scanarea.replybaseidstr)-3,
                   scanarea.replybaseidstr),25));
                end;
          'F' : begin
                  Writeat(24,9,foreentry,backentry,expand('Fido'+tmp,20));
                  Writeat(24,10,foreentry,backentry,expand(scanarea.replybaseidstr,48));
                end;
          'J' : begin
                  Writeat(24,9,foreentry,backentry,expand('Jam'+tmp,20));
                  Writeat(24,10,foreentry,backentry,expand(scanarea.replybaseidstr,48));
                end;
          'E' : begin
                  Writeat(24,9,foreentry,backentry,expand('Ezycom'+tmp,20));
                  Writeat(24,10,foreentry,backentry,expand(int_to_str(str_to_int(first(4,scanarea.replybaseidstr))),4));
                  Writeat(47,10,foreentry,backentry,expand(last(length(scanarea.replybaseidstr)-4,
                    scanarea.replybaseidstr),25));
                end;
        End;
      End Else
      Begin
        Writeat(24,9,foreentry,backentry,expand(' ',20));
        Writeat(24,10,foreentry,backentry,expand(' ',48));
      End;
    Writeattribs(24,11,72,scanarea.msgattr,net in scanarea.replystatus); {attribs}

    Writeat(24,13,foreentry,backentry,expand(scanarea.headertpl,12));
    Writeat(24,14,foreentry,backentry,expand(scanarea.footertpl,12));
    Writeat(24,15,foreentry,backentry,expand(scanarea.entrytpl,12));
    Writeat(24,16,foreentry,backentry,expand(scanarea.blockhdrtpl,12));
    Writeat(24,17,foreentry,backentry,expand(scanarea.blockftrtpl,12));

    If tearline in scanarea.status then
      Writeat(24,19,foreentry,backentry,'Tearline') else
        Writeat(24,19,foreentry,backentry,'^APID   ');

    If scanarea.origin <> 0 then
      Writeat(24,20,foreentry,backentry,expand(setup.origline[scanarea.origin],48)) else
        Writeat(24,20,foreentry,backentry,expand('Random',48));

    writeat(24,21,foreentry,backentry,expand(node2str(setup.address[scanarea.aka]),24));
  End;

  Procedure EditIt(we:byte);
  Var Tmp, Tmp1 : String;
  Begin
    Case we of
      1 : begin
            tmp := scanarea.IdName;
            read_string(24,4,48,50,tmp,c_all);
            scanarea.idname := tmp;
          end;
      2 : begin
            tmp := scanarea.msgbaseidstr;
            select_messagebase(4,scanarea.msgbaseid,scanarea.status,tmp,tmp,false);
            scanarea.msgbaseidstr := tmp;
          end;
      3 : begin
            case scanarea.msgbaseid of
              'S' : Begin
                      Tmp := scanarea.msgbaseidstr;
                      read_string(24,7,48,49,tmp,c_all);
                      scanarea.msgbaseidstr := tmp;
                    End;
              'H' : Begin
                      Tmp := first(3,scanarea.msgbaseidstr);
                      read_String(24,7,3,3,tmp,c_numbers);
                      Tmp1 := last(length(scanarea.msgbaseidstr)-3,scanarea.msgbaseidstr);
                      read_string(47,7,25,39,tmp1,c_all);
                      checkpath(tmp1);
                      while length(tmp) < 3 do tmp := '0' + tmp;
                      scanarea.msgbaseidstr := tmp + tmp1;
                    End;
              'F' : Begin
                      Tmp := scanarea.msgbaseidstr;
                      read_string(24,7,48,49,tmp,c_all);
                      checkpath(tmp);
                      scanarea.msgbaseidstr := tmp;
                    End;
              'J' : Begin
                      Tmp := scanarea.msgbaseidstr;
                      read_string(24,7,48,49,tmp,c_all);
                      scanarea.msgbaseidstr := tmp;
                    End;
              'E' : Begin
                      Tmp := first(4,scanarea.msgbaseidstr);
                      read_String(24,7,4,4,tmp,c_numbers);
                      Tmp1 := last(length(scanarea.msgbaseidstr)-4,scanarea.msgbaseidstr);
                      read_string(47,7,25,39,tmp1,c_all);
                      checkpath(tmp1);
                      while length(tmp) < 4 do tmp := '0' + tmp;
                      scanarea.msgbaseidstr := tmp + tmp1;
                    End;
            end;
          end;
      4 : begin
            tmp := scanarea.replybaseidstr;
            select_messagebase(4,scanarea.replybaseid,scanarea.replystatus,tmp,tmp,false);
            scanarea.replybaseidstr := tmp;
          end;
      5 : begin
            case scanarea.replybaseid of
              'S' : Begin
                      Tmp := scanarea.replybaseidstr;
                      read_string(24,10,48,49,tmp,c_all);
                      scanarea.replybaseidstr := tmp;
                    End;
              'H' : Begin
                      Tmp := first(3,scanarea.replybaseidstr);
                      read_String(24,10,3,3,tmp,c_numbers);
                      Tmp1 := last(length(scanarea.replybaseidstr)-3,scanarea.replybaseidstr);
                      read_string(47,10,25,39,tmp1,c_all);
                      checkpath(tmp1);
                      while length(tmp) < 3 do tmp := '0' + tmp;
                      scanarea.replybaseidstr := tmp + tmp1;
                    End;
              'F' : Begin
                      Tmp := scanarea.replybaseidstr;
                      read_string(24,10,48,49,tmp,c_all);
                      checkpath(tmp);
                      scanarea.replybaseidstr := tmp;
                    End;
              'J' : Begin
                      Tmp := scanarea.replybaseidstr;
                      read_string(24,10,48,49,tmp,c_all);
                      scanarea.replybaseidstr := tmp;
                    End;
              'E' : Begin
                      Tmp := first(4,scanarea.replybaseidstr);
                      read_String(24,10,4,4,tmp,c_numbers);
                      Tmp1 := last(length(scanarea.replybaseidstr)-4,scanarea.replybaseidstr);
                      read_string(47,10,25,39,tmp1,c_all);
                      checkpath(tmp1);
                      while length(tmp) < 4 do tmp := '0' + tmp;
                      scanarea.replybaseidstr := tmp + tmp1;
                    End;
            end;
          end;
      6 : Select_Attribs(4,scanarea.msgattr,net in scanarea.replystatus);
      7 : scanarea.headertpl := Select_Tpl(4,scanarea.headertpl,false);
      8 : scanarea.footertpl := Select_Tpl(4,scanarea.footertpl,false);
      9 : scanarea.entrytpl := select_tpl(4,scanarea.entrytpl,false);
     10 : scanarea.blockhdrtpl := select_tpl(4,scanarea.blockhdrtpl,false);
     11 : scanarea.blockftrtpl := select_tpl(4,scanarea.blockftrtpl,false);
     12 : begin
            if tearline in scanarea.status then
              scanarea.status := scanarea.status - [tearline] else
                scanarea.status := scanarea.status + [tearline];
          end;
     13 : scanarea.origin := select_origin(4,scanarea.origin);
     14 : scanarea.aka := select_address(4,scanarea.aka,false);
    End;
  End;

  procedure edithelp(w:byte);
  begin
    case w of
      1 : writeat(1,25,7,0,expand('The name of this filefind message area',80));
      2 : writeat(1,25,7,0,expand('The message base to search for filefind msg''s',80));
      3 : writeat(1,25,7,0,expand('The message base path',80));
      4 : writeat(1,25,7,0,expand('The message base to post the filefind replies in',80));
      5 : writeat(1,25,7,0,expand('The message base path',80));
      6 : writeat(1,25,7,0,expand('The message attributes to use',80));
      7 : writeat(1,25,7,0,expand('The header tpl file to use',80));
      8 : writeat(1,25,7,0,expand('The footer tpl file to use',80));
      9 : writeat(1,25,7,0,expand('The entry tpl file to use',80));
     10 : writeat(1,25,7,0,expand('The blockheader tpl file to use',80));
     11 : writeat(1,25,7,0,expand('The blockfooter tpl file to use',80));
     12 : writeat(1,25,7,0,expand('If a tearline or PID kludge should be used',80));
     13 : writeat(1,25,7,0,expand('The originline to use',80));
     14 : writeat(1,25,7,0,expand('The aka to use',80));
    end;
    if setup.exteditor <> '' then
      begin
        if (w > 6) and (w < 12) then
          writeat(64,25,14,0,'Press F2 to edit');
      end;
  end;

  procedure editf2(w:byte);
  var res : word;
  begin
    if (setup.exteditor <> '') and (setup.tplpath <> '') then
      begin
        cursor_on;
        savescreen;
        case w of
          7 : res := fmExec(setup.exteditor,setup.tplpath+scanarea.headertpl, setup.SwapMethode, $ffff, false, false);
          8 : res := fmExec(setup.exteditor,setup.tplpath+scanarea.footertpl, setup.SwapMethode, $ffff, false, false);
          9 : res := fmExec(setup.exteditor,setup.tplpath+scanarea.entrytpl, setup.SwapMethode, $ffff, false, false);
         10 : res := fmExec(setup.exteditor,setup.tplpath+scanarea.blockhdrtpl, setup.SwapMethode, $ffff, false, false);
         11 : res := fmExec(setup.exteditor,setup.tplpath+scanarea.blockftrtpl, setup.SwapMethode, $ffff, false, false);
        end;
        restorescreen;
        cursor_off;
      end;
  end;

  Procedure EditThem(nieuw:boolean);
  Var
    Ch      : char;
    We      : byte;
    Scanbak : ScanAreaType;                                   { filefind.fm }
  Begin
    We := 1;
    Repeat
      WriteThem(we);
      Edithelp(we);
      WriteIt;
      Ch := Readkey;
      Case ch of
       #0 : begin
              ch := readkey;
              case ch of
                #72 : {up}   if we > 1 then dec(we) else we := 14;
                #80 : {down} if we < 14 then inc(we) else we := 1;
                #67 : {f9}   begin ch := #27; {move(msg,message,sizeof(message));} end;
                #68 : {f10}  ch := #27;
                #60 : editf2(we);
              end;
            end;
       #9 : infoscreen;
       #26: dosshell;
       #13: begin
              editit(we);
            end;
      End;
    Until Ch = #27;
    if not samerec(scanbak,scanarea,sizeof(scanarea)) then
      begin
        If askwindow('Changes have been made','Save changes?','(Y/N)',['y','Y','n','N']) in ['y','Y'] then
          begin
            If nieuw then ge := filesize(sa)+1;
            seek(sa,ge-1);
            write(sa,scanarea);
          end;
      end;
  End;


Begin
  With Mwin[3] do
    begin
      x1 := 8;
      x2 := 2;
      y1 := 72;
      y2 := 23;
      st := ' FileFind ';
    end;

  assign(sa,systempath+'filefind.fm');
  {$I-} reset(sa); {$I+}
  If ioresult <> 0 then
    begin
      askwindow('','Cannot open FILEFIND.FM','',[#13,#32,#27]);
      exit;
    end;

  create_window(3);

  ge := 1;
  repeat
    if filesize(sa) < 1 then
      begin
        writecolor(25,7,15,0,'^INS^-new ^ESC^-exit');
        writeat(10,2,11,0,replicate(14,''));
      end else
      begin
        WriteColor(25,7,15,0,'^INS^-new ^DEL^-delete ^ENTER^-edit ^ESC^-exit');
        writeat(10,2,11,0,' '+int_to_str(ge)+' of '+int_to_str(filesize(sa))+' ');
        seek(sa,ge-1);
        read(sa,scanarea);
      end;

      writethem(0);
      writeit;
      ch := readkey;
      case ch of
        #0  : begin
                ch := readkey;
                case ch of
                  #82 : begin {ins}
                          fillchar(scanarea,sizeof(scanarea),#0);
                          scanarea.msgbaseid := 'H';
                          scanarea.replybaseid := 'H';
                          scanarea.headertpl := 'FFHEADER.TPL';
                          scanarea.footertpl := 'FOOTER.TPL';
                          scanarea.entrytpl := 'ENTRY.TPL';
                          scanarea.blockhdrtpl := 'FFBLKHDR.TPL';
                          scanarea.blockftrtpl := 'BLOCKFTR.TPL';
                          scanarea.aka := 1;
                          scanarea.replystatus := [net];
                          scanarea.status := [echo];
                          editthem(true);
                        end;
                  #83 : begin
                          if askwindow('Delete entry '+int_to_str(ge),'Are you sure?','(Y/N)',['y','Y','n','N',#27])
                          in ['y','Y'] then
                            begin
                              assign(sabak,systempath+'filefind.new');
                              rewrite(sabak);
                              x := 0;
                              seek(sa,0);
                              while not eof(sa) do
                                begin
                                  inc(x);
                                  read(sa,scanarea);
                                  if x <> ge then write(sabak,scanarea);
                                end;
                              close(sabak);
                              close(sa);
                              erase(sa);
                              rename(sabak,systempath+'filefind.fm');
                              assign(sa,systempath+'filefind.fm');
                              reset(sa);
                              ge := filesize(sa);
                              if ge < 1 then
                                begin
                                  ge := 1;
                                  fillchar(scanarea,sizeof(scanarea),#0);
                                end;
                            end;
                        end; {del}
                  #63 : ; {f5}
                  #79 : begin
                          ge := filesize(sa);  {end}
                        end;
                  #71 : begin
                          ge := 1; {home}
                        end;
                  #75 : begin
                          if ge > 1 then dec(ge) else write(#7); {left}
                        end;
                  #77 : begin
                          if ge < filesize(sa) then inc(ge) else write(#7); {rght}
                        end;
                end;
              end;
        #9  : infoscreen;
        #13 : editthem(false);
        #26 : dosshell;
      end;
  Until ch = #27;

  Remove_window(3);
  Close(sa);
End;


Procedure FileFindDoor;
Var
  Tmp : String;
  Ch  : Char;
  We  : Byte;

  Procedure WriteIt(we:byte);
  Begin
    Writeat(21,8 ,7,0,' Read messages hotkey ');
    Writeat(21,9 ,7,0,' Scan messages hotkey ');
    Writeat(21,10,7,0,' Yell sysop hotkey    ');
    Writeat(21,11,7,0,' Help file hotkey     ');
    Writeat(21,12,7,0,' Enter request hotkey ');
    Writeat(21,13,7,0,' Quit door hotkey     ');
    Writeat(21,14,7,0,' Logoff BBS hotkey    ');
    Writeat(21,16,7,0,' Yell time      ');
    Writeat(21,17,7,0,' Log file       ');
    Writeat(21,19,7,0,' Main menu file ');
    Writeat(21,20,7,0,' Help info file ');
    Writeat(21,21,7,0,' Logoff file    ');

    Case we of
      1 : Writeat(21,8 ,kl4,kl5,' Read messages hotkey ');
      2 : Writeat(21,9 ,kl4,kl5,' Scan messages hotkey ');
      3 : Writeat(21,10,kl4,kl5,' Yell sysop hotkey    ');
      4 : Writeat(21,11,kl4,kl5,' Help file hotkey     ');
      5 : Writeat(21,12,kl4,kl5,' Enter request hotkey ');
      6 : Writeat(21,13,kl4,kl5,' Quit door hotkey     ');
      7 : Writeat(21,14,kl4,kl5,' Logoff BBS hotkey    ');
      8 : Writeat(21,16,kl4,kl5,' Yell time      ');
      9 : Writeat(21,17,kl4,kl5,' Log file       ');
     10 : Writeat(21,19,kl4,kl5,' Main menu file ');
     11 : Writeat(21,20,kl4,kl5,' Help info file ');
     12 : Writeat(21,21,kl4,kl5,' Logoff file    ');
    End;
  End;

  Procedure WriteThem;
  Begin
    Writeat(44,8 ,foreentry,backentry,setup.readkey);
    Writeat(44,9 ,foreentry,backentry,setup.scankey);
    Writeat(44,10,foreentry,backentry,setup.yellkey);
    Writeat(44,11,foreentry,backentry,setup.helpkey);
    Writeat(44,12,foreentry,backentry,setup.enterkey);
    Writeat(44,13,foreentry,backentry,setup.quitkey);
    Writeat(44,14,foreentry,backentry,setup.logoffkey);

    Writeat(38,16,foreentry,backentry,expand(int_to_str(setup.yelltime),3));
    Writeat(38,17,foreentry,backentry,expand(setup.fflogfile,20));
    Writeat(38,19,foreentry,backentry,expand(setup.mainfile,12));
    Writeat(38,20,foreentry,backentry,expand(setup.helpfile,12));
    Writeat(38,21,foreentry,backentry,expand(setup.logofffile,12));
  End;

Begin
  With mwin[3] do
   Begin
     x1 := 20;
     x2 := 6;
     y1 := 60;
     y2 := 23;
     st := ' FileFind door ';
   End;
  Create_Window(3);
  We := 1;
  Repeat
    WriteIt(we);
    WriteThem;

    Ch := Readkey;
    Case Ch of
      #0 : Begin
             Ch := readkey;
             Case ch of
               #72 : {up}   if we > 1 then dec(we) else we := 12;
               #80 : {down} if we < 12 then inc(we) else we := 1;
             End;
           End;
      #9 : infoscreen;
      #26: dosshell;
      #13: Begin
             Case we of
               1 : Begin
                     Tmp := setup.readkey;
                     read_string(44,8,1,1,tmp,c_all);
                     setup.readkey := upcase(tmp[1]);
                   End;
               2 : Begin
                     Tmp := setup.scankey;
                     read_string(44,9,1,1,tmp,c_all);
                     setup.scankey := upcase(tmp[1]);
                   End;
               3 : Begin
                     Tmp := setup.yellkey;
                     read_string(44,10,1,1,tmp,c_all);
                     setup.yellkey := upcase(tmp[1]);
                   End;
               4 : Begin
                     Tmp := setup.helpkey;
                     read_string(44,11,1,1,tmp,c_all);
                     setup.helpkey := upcase(tmp[1]);
                   End;
               5 : Begin
                     Tmp := setup.enterkey;
                     read_string(44,12,1,1,tmp,c_all);
                     setup.enterkey := upcase(tmp[1]);
                   End;
               6 : Begin
                     Tmp := setup.quitkey;
                     read_string(44,13,1,1,tmp,c_all);
                     setup.quitkey := upcase(tmp[1]);
                   End;
               7 : Begin
                     Tmp := setup.logoffkey;
                     read_string(44,14,1,1,tmp,c_all);
                     setup.logoffkey := upcase(tmp[1]);
                   End;
               8 : Begin
                     tmp := int_to_str(setup.yelltime);
                     read_string(38,16,3,3,tmp,c_all);
                     setup.yelltime := str_to_int(tmp);
                   End;
               9 : Begin
                     tmp := setup.fflogfile;
                     read_string(38,17,20,80,tmp,c_all);
                     setup.fflogfile := upper(tmp);
                   End;
              10 : Begin
                     tmp := setup.mainfile;
                     read_string(38,19,20,12,tmp,c_all);
                     setup.mainfile := upper(tmp);
                   End;
              11 : Begin
                     tmp := setup.helpfile;
                     read_string(38,20,20,12,tmp,c_all);
                     setup.helpfile := upper(tmp);
                   End;
              12 : Begin
                     tmp := setup.logofffile;
                     read_string(38,21,20,12,tmp,c_all);
                     setup.logofffile := upper(tmp);
                   End;
             End;
           End;
    End;
  Until Ch = #27;
  Remove_Window(3);
End;


{$F+} Procedure FileFindHelp ( Welke : Byte ); {$F-}
Begin
  Writeat(1,25,7,0,replicate(80,' '));
  Case Welke of
    1 : Writeat(1,25,7,0,'Toggle file-areas to be scanned by the FileFind function.');
    2 : Writeat(1,25,7,0,'Define message-areas to scan for FileFind requests.');
    3 : Writeat(1,25,7,0,'General FileFind parameters.');
    4 : Writeat(1,25,7,0,'FileMgr''s filefind door settings.');
  End;
End;


Procedure FileFindLoop;
Var
  Ar : Array[1..4] of String[13];
  Ge : Integer;
Begin
  with mwin[2] do
    begin
      x1 := 30;
      x2 := 9;
      y1 := 46;
      y2 := 16;
      st := '';
    end;
  create_window(2);

  ar[1] := 'File areas';
  ar[2] := 'Message areas';
  ar[3] := 'Miscellaneous';
  ar[4] := 'FileFind door';

  ge := 1;
  while ge <> 0 do
    begin
      choosehook := filefindhelp;
      decwin(2);
      ge := select_window(2,4,13,@ar,ge,false);
      incwin(2);
      case ge of
        1 : Select_FileAreas(3,false,0);
        2 : filefindmsg;
        3 : filefindmisc;
        4 : filefinddoor;
      end;
    end;
  remove_window(2);
End;

END.
