	.386


  extrn	DOS32FLATDS: abs


_BSS	segment dword public use16 'BSS'
  extrn	DEVHLP: dword
_BSS	ends

DGROUP	group _BSS



_TEXT	segment dword public use16 'CODE'

	assume	cs: _TEXT
	assume	ds: DGROUP

	public	VMVIRTTOFLAT
	public	VMALLOC
	public	VMFREE
	public	VMREADUCHAR
	public	VMREADUSHORT
	public	VMREADBLK
	public	VMWRITEBLK
	public	VMREAD
	public	VMWRITE
	public	VMCOPY


;-----------------------------------------------------------------------------
; FLAT _pascal VMVirtToFlat (void *p);
;-----------------------------------------------------------------------------

VMVIRTTOFLAT	proc near
	push	bp
	mov	bp, sp
	push	si

	movzx	esi, word ptr [bp+4]	; offset of p
	mov	ax, word ptr [bp+6]	; selector of p
	mov	dl, 5Bh			; DevHlp_VirtToLin
	call	[DEVHLP]
	jnc	vvtf_end
	xor	eax, eax
vvtf_end:

	shld	edx, eax, 16
	pop	si
	pop	bp
	ret	4
VMVIRTTOFLAT	endp




;-----------------------------------------------------------------------------
; FLAT _pascal VMAlloc (ULONG cbSize);
;-----------------------------------------------------------------------------

VMALLOC	proc near
	push	bp
	mov	bp, sp

	mov	ecx, [bp+4]		; cbSize
	mov	eax, 00000004h		; flags
	mov	dl, 57h			; DevHlp_VMAlloc
	call	[DEVHLP]
	jnc	va_end
	xor	eax, eax
va_end:

	shld	edx, eax, 16
	pop	bp
	ret	4
VMALLOC	endp




;-----------------------------------------------------------------------------
; void _pascal VMFree (FLAT flatBlock);
;-----------------------------------------------------------------------------

VMFREE	proc near
	push	bp
	mov	bp, sp

	mov	eax, [bp+4]		; flatBlock
	mov	dl, 58h			; DevHlp_VMFree
	call	[DEVHLP]
	jnc	vf_end
	int	3
vf_end:
	pop	bp
	ret     4
VMFREE	endp




;-----------------------------------------------------------------------------
; UCHAR _pascal VMReadUChar (FLAT flatSrc);
;-----------------------------------------------------------------------------

VMREADUCHAR	proc near
	push	bp
	mov	bp, sp
	mov	ax, DOS32FLATDS
	mov	es, ax

	mov	eax, [bp+4]		; flatSrc
	mov	al, es:[eax]

	pop	bp
	ret	4
VMREADUCHAR	endp




;-----------------------------------------------------------------------------
; USHORT _pascal VMReadUShort (FLAT flatSrc);
;-----------------------------------------------------------------------------

VMREADUSHORT	proc near
	push	bp
	mov	bp, sp
	mov	ax, DOS32FLATDS
	mov	es, ax

	mov	eax, [bp+4]		; flatSrc
	mov	ax, es:[eax]

	pop	bp
	ret	4
VMREADUSHORT	endp




;-----------------------------------------------------------------------------
; void _pascal VMReadBlk (BLOCK _ss *pBlk, FLAT flatBlk);
;-----------------------------------------------------------------------------

VMREADBLK	proc near
	push	bp
	mov	bp, sp
	mov	ax, DOS32FLATDS
	mov	es, ax

	mov	ebx, [bp+4]		; flatBlk
	mov	eax, es:[ebx+0]
	mov	edx, es:[ebx+4]
	mov	bx, [bp+8]		; pBlk
	mov	ss:[bx+0], eax
	mov	ss:[bx+4], edx

	pop	bp
	ret	6
VMREADBLK	endp




;-----------------------------------------------------------------------------
; void _pascal VMWriteBlk (FLAT flatBlk, BLOCK _ss *pBlk);
;-----------------------------------------------------------------------------

VMWRITEBLK	proc near
	push	bp
	mov	bp, sp
	mov	ax, DOS32FLATDS
	mov	es, ax

	mov	bx, [bp+4]		; pBlk
	mov	eax, ss:[bx+0]
	mov	edx, ss:[bx+4]
	mov	ebx, [bp+6]		; flatBlk
	mov	es:[ebx+0], eax
	mov	es:[ebx+4], edx

	pop	bp
	ret	6
VMWRITEBLK	endp




;-----------------------------------------------------------------------------
; void _pascal VMRead (void *pDest, FLAT flatSrc, USHORT cbLen);
;-----------------------------------------------------------------------------

VMREAD	proc near
	push	bp
	mov	bp, sp
	push    si
	push	di
	push	ds
	mov	ax, DOS32FLATDS
	mov	ds, ax

	mov	esi, [bp+6]		; flatSrc
	xor	edi, edi
	les	di, [bp+10]		; pDest
	xor	ecx, ecx
	mov	cx, word ptr [bp+4]	; cbLen
	mov	dx, cx
	shr	cx, 2
	cld
	rep	movs dword ptr es:[edi], dword ptr ds:[esi]
	mov	cx, dx
	and	cx, 0003h
	rep	movs byte ptr es:[edi], byte ptr ds:[esi]

	pop	ds
	pop	di
	pop	si
	pop	bp
	ret	10
VMREAD	endp




;-----------------------------------------------------------------------------
; void _pascal VMWrite (FLAT flatDest, void *pSrc, USHORT cbLen);
;-----------------------------------------------------------------------------

VMWRITE	proc near
	push	bp
	mov	bp, sp
	push	si
	push	di
	push	ds
	mov	ax, DOS32FLATDS
	mov	es, ax

	mov	edi, [bp+10]		; flatDest
	xor	esi, esi
	lds	si, [bp+6]		; pSrc
	xor	ecx, ecx
	mov	cx, word ptr [bp+4]	; cbLen
	mov	dx, cx
	shr	cx, 2
	cld
	rep	movs dword ptr es:[edi], dword ptr ds:[esi]
	mov	cx, dx
	and	cx, 0003h
	rep	movs byte ptr es:[edi], byte ptr ds:[esi]

	pop	ds
	pop	di
	pop	si
	pop	bp
	ret     10
VMWRITE	endp




;-----------------------------------------------------------------------------
; void _pascal VMCopy (FLAT flatDest, FLAT flatSrc, ULONG cbLen);
;-----------------------------------------------------------------------------

VMCOPY	proc near
	push	bp
	mov	bp, sp
	push	si
	push	di
	mov	ax, DOS32FLATDS
	mov	es, ax

	mov	edi, [bp+12]		; flatDest
	mov	esi, [bp+8]		; flatSrc
	mov	ecx, [bp+4]     	; cbLen
	mov	edx, ecx
	cmp	edi, esi
	je	vc_end
	ja	vc_backwards

	; move forwards
	shr	ecx, 2
	cld
	rep	movs dword ptr es:[edi], dword ptr es:[esi]
	mov	ecx, edx
	and	ecx, 0003h
	rep	movs byte ptr es:[edi], byte ptr es:[esi]
	jmp	vc_end

vc_backwards:
	; move backwards
	lea	esi, [esi+ecx-1]
	lea	edi, [edi+ecx-1]
	and	ecx, 0003h
	std
	rep	movs byte ptr es:[edi], byte ptr es:[esi]
	sub	esi, 3
	sub	edi, 3
	mov	ecx, edx
	shr	ecx, 2
	rep	movs dword ptr es:[edi], dword ptr es:[esi]
	cld

vc_end:
	pop	di
	pop	si
	pop	bp
	ret	12
VMCOPY	endp



_TEXT	ends

	end
