/*:VRX         Main
*/
/*  EPMProto.ERX

    Invoke the VX-REXX code generation dialogs from within the
    Enhanced Editor (EPM).

    To use this macro you must set the VXREXX environment variable
    to the VX-REXX root directory (e.g. C:\VXREXX).
*/
Main:
    epmWindow = VRMethod( "Screen", "GetActiveWindow" )
    call VRMethod "Application", "PutVar", "epmWindow"
    vrxpath = value( "VXREXX",,"OS2ENVIRONMENT" )
    if( vrxpath = "" ) then do        
        call VRMessage , "The VXREXX environment variable is not set.", , "E"
        signal Done
    end
    if( Stream( vrxpath || "\VRXEDIT.EXE", 'c', 'query exists' ) = "" ) then do
        vredisp = '"\VREDisp.VRM"'
    end
    else do
        vredisp = '"' || VRXPath || '\VREDisp.VRM"'
    end

    call VRMethod "Application", "PutClipboard", ""
    interpret 'codeString =' vredisp || '( "", "", "CLIPBOARD" )'
    if( codeString = "" ) then do
        signal Done
    end

    parse VAR codeString "0d0a"x codeString
    if( codeString = "" ) then do
        "PASTE C"
    end
    else do
        "PASTE B"
    end

Done:
    drop vrxpath vredisp codeString
return

