/*
  Program   CHKMAIL
  Author    Peter Bloemendaal
            Brainbox systems +31-70-3523661
  Purpose   Check some message areas for new personal mail
  Usage     As a PEX in Proboard with message areas as parameter(s)

  $Header: C:\PROGRAMS\TC\PEX\RCS\chkmail.cpv 1.2 1994/07/19 14:08:30 BRAINBOX Exp $
  $Log: chkmail.cpv $
// Revision 1.2  1994/07/19  14:08:30  BRAINBOX
// 1. Checking only not received msgs bug removed
// 2. Press any key...... added when no msgs were found
//
// Revision 1.1  1994/07/19  13:04:08  BRAINBOX
// Initial revision
//
*/

#include "pb_sdk.h"


int markMail(int area)
{
   MSGAREA ma ;
   MESSAGE msg ;
   bool    result ;
   int     found ;


   found = 0 ;
   if(ReadMsgArea(area,&ma))        // Check if this mail area really exists
   {
      printf("\3Searching through area %s  \6#%d\n",ma.name, ma.areaNum) ;
      result = FirstMessage(&msg, area,1,1) ;
      while (result)             // While there area msgs in this area
      {
         if (strcmp(msg.to, CurUser->name) == 0 && !(msg.attr & MSGATTR_RECEIVED) )
         {                          // This mail is addressed to the user
            found++ ;
            MarkMessage(msg.area, msg.id) ;
            printf("  \6From \2%-30s \6Subj \3%-35s\n",msg.from, msg.subj) ;
         }
         result = NextMessage(&msg,area,1) ;
      }
   }
   return found ;
}


void main(int argc, char *argv[])
{
   int i, found ;


   found = 0 ;
   MenuFunction(MENU_SHOWANSASC,"CHKMAIL") ;
   if (argc <= 1)                   // No areas specified. Check lastArea
      found = markMail(CurUser->msgArea) ;
   else
      for (i = 1 ; i < argc ; i++)  // Check specified area(s)
         found += markMail(atoi(argv[i])) ;
   if (found == 0)                  // No mail found
   {
      printf("Your mail box is empty.\n") ;
      printf("\7Press any key to continue.\n") ;
      WaitKey() ;
   }
   else                             // Some message(s) found!
   {
      printf("\3%i message(s) found!\nAction: [R/Enter] Read - [C] Continue ?  ",found) ;
      if (WaitKeys("CR\r") == 'C')
      {
         printf("\nMessages marked for later retrieval.\n") ;
         printf("\7Press any key to continue.\n") ;
         WaitKey() ;
      }
      else
      {
         printf("\n") ;
         ReadMarkedMessages() ;
      }
   }
}