/***********************************************************************
*                                                                      *
*  Definition file for EDIT.HPP                                        *
*                                                                      *
*  Purpose : Defines global functions                                  *
*                                                                      *
*  Author  : Peter Bloemendaal                                         *
*            Brainbox systems +31-70-3523661                           *
*  eMail   : internet -> bloemendaal@rullf2.LeidenUniv.nl              *
*            fidonet  -> 2:281/908                                     *
*                                                                      *
*----------------------------------------------------------------------*
*                                                                      *
*                                                                      *
* $Log: edit_glb.v $
 * Revision 1.7  1994/09/08  08:03:51  BRAINBOX
 * 1. Bounce checked by I_A
 *                                                   *
* Revision 1.6  1994/08/24  19:27:23  BRAINBOX                         *
* 1. Bug in ansi colors fixed. Now always reset colors                 *
*                                                                      *
* Revision 1.5  1994/08/20  13:32:32  BRAINBOX                         *
* 1. fastFilelength implemented                                        *
*                                                                      *
* Revision 1.4  1994/08/12  13:37:51  BRAINBOX                         *
* 1. Added NONE definitions                                            *
*                                                                      *
* Revision 1.3  1994/08/11  22:33:26  BRAINBOX                         *
* 1. Ansi color                                                        *
* 2. Ansi gotoxy                                                       *
*                                                                      *
* Revision 1.2  1994/08/10  20:22:48  BRAINBOX                         *
* 1. Added definition for several colors. Exactly the same as in TC,   *
*    but functionaly different from pb_sdk.h                           *
*                                                                      *
* Revision 1.1  1994/08/08  14:53:05  BRAINBOX                         *
* Initial revision                                                     *
*                                                                      *
*                                                                      *
*                                                                      *
************************************************************************
*/

#ifndef _EDIT_GLB_H
#define _EDIT_GLB_H



// Ammount memory for reserve
#define _BLOCK    1024
// Mean characters / line, savest number is 1 !!
#define _BLKPRT   10
// Reserve
#define _RESERVE  4096

#ifndef _PB_SDK_H
   typedef unsigned char  bool;
   #define TRUE      1
   #define FALSE     0
   #include <dos.h>
#endif

#if 1
#define MAXINT    32767
#else
#define MAXINT    0x6789
#endif


#define STRTCOLS_START        256 /* array starts with this size */
#define STRTCOLS_INCREMENT      32    /* and is increment using this */



#define C_BLACK          0
#define C_BLUE           1
#define C_GREEN          2
#define C_CYAN           3
#define C_RED            4
#define C_MAGENTA        5
#define C_BROWN          6
#define C_LIGHTGRAY      7
#define C_DARKGRAY       8
#define C_LIGHTBLUE      9
#define C_LIGHTGREEN    10
#define C_LIGHTCYAN     11
#define C_LIGHTRED      12
#define C_LIGHTMAGENTA  13
#define C_YELLOW        14
#define C_WHITE         15


// Lowest line on the screen. Used for ASCII control
#define _LOWEST_LINE    80

int max(int value1, int value2)
{
   return ( (value1 > value2) ? value1 : value2);
}

int min(int value1, int value2)
{
	 return ( (value1 < value2) ? value1: value2) ;
}


void ColorAnsi(int color,char *code)
{
	 unsigned char forcol, backcol;
#if 0
	 unsigned char blink ;
#endif
#if 0
	 char    blinkst[3] ; // I_A: was '2' before but ";5" below is 3 wide(!)
#else
	 char *blinkst; // I_A: much better!
#endif
#if 0
	 unsigned int conversion[8]  ;

	 // Stupid way to fill an array due to pex making for proboard.
	 conversion[0]=0 ;
	 conversion[1]=4 ;
	 conversion[2]=2 ;
	 conversion[3]=6 ;
	 conversion[4]=1 ;
	 conversion[5]=5 ;
	 conversion[6]=3 ;
	 conversion[7]=7 ;
#else
	static unsigned int conversion[8] =
	 {
	 0, 4, 2, 6, 1, 5, 3, 7
	 };
#endif


	 forcol  = color & 15 ;
	 backcol = (color >> 4) & 7 ;
#if 0
	 blink   = color & 128 ;
#endif

#if 0
	 if (blink)
			strcpy(blinkst,";5")  ;
	 else
			strcpy(blinkst,"") ; ; // I_A: why the second ';' ????????
#else
	 blinkst = "";
	 if (color & 128)
			blinkst = ";5";
#endif

#if 1
   if (forcol > 7)
{
      sprintf(code,"\x1b[0;%i;%i;1%sm",conversion[forcol - 8] + 30, conversion[backcol] + 40, blinkst) ;
}
   else
      sprintf(code,"\x1b[0;%i;%i;2%sm",conversion[forcol] + 30, conversion[backcol] + 40, blinkst) ;
#else
      strcpy(code, "\x1b[0;34;47;2m");
#endif
}


void GotoAnsi(int x, int y, char *code)
{
   sprintf(code,"\x1b[%i;%iH",y,x) ;
}


long fastFilelength(char *fileName)
{

   struct find_t ffblk;
   int done;

   done = _dos_findfirst(fileName,_A_NORMAL,&ffblk);
   if (done)
      return 0L ;
   else
      return ffblk.size ;

}

#endif

