/*
 fls MS-DOS Standard Executable
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of the fls.

 fls is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 fls is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with fls; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined( __STRUCTS_H )
#define __STRUCTS_H

typedef unsigned short ushort;
typedef unsigned char  byte;
typedef byte bool;

typedef struct{
	char name[80];       /* Name of file area                           */
	char listpath[80];   /* Path for file-list                          */
	char filepath[80];   /* Path for files                              */
	int level;           /* Level needed to access file area            */
	long flags;          /* Flags needed to access file area            */
	bool cdrom;          /* TRUE = CDROM File listing type              */
	int maxfiles;        /* Max files per day in this area downloadable */
	int maxkb;           /* Max Kbytes per day in this area             */
	bool notops;         /* Set to TRUE if not to appear in TOPFILES.A* */
	bool free;           /* If TRUE, this area is free                  */
	byte groups[4];      /* Groups belonging to                         */
	bool allGroups;      /* Belongs to all groups                       */
	byte minAge;         /* Minimum age                                 */
	long flagsNot;       /* Access flags                                */
	char extra[3];       /* Currently unused (reserved space)           */
} FILEAREA;

#endif
