
FileNav							User's Manual					FileNav
						Last revision date: June 30, 1995

NAME
	File Library Navigator - easy access to your file base.

SYNOPSIS
	filenav [-agcu] [-f <path>] [-n <num>]

DESCRIPTION
	FileNav is a comprehensive filebase navigator that packs most of
	the required functions into one unit that is very intuitive and easy
	to use. The default behavior (with the default INI file provided
	or without any configuration file at all) is to present the user
	with a list of all available groups, and then areas. Users can use
	the arrow keys to move in the lists, tag areas, search for text,
	files, keywords. Upload and download files.

GROUP AND AREA MODE COMMON KEYS
	To navigate through the lists, use the arrow keys.

	Up and Down
		move the selection bar to the previous and next group/area on
		the current page.
	Home and End
		move the selection bar to the first and last group/area	on
		the current page.
	Left and Right
		display the previous and next group/area page.
	Enter
		selects the current group or area for processing.
	Escape
		quits FileNav and returns to the BBS
	H
		requests the online help (stored in the FILENAV.HLP file)

GROUP MODE COMMANDS
	When started in group mode, the user can choose a group or 'Ignore'.
	If 'Ignore' is chosen, all areas will be shown, regardless of their
	group association. If a group is selected, only areas that belong
	to it will be shown and processed.

AREA MODE COMMANDS
	Space toggles the tag on the current area.

	Groups will return to the Group Mode, if applicable (i.e. if the
	program hasn't been started with the '-a' or '-n' option s).

	Search will let the user choose any of the available searches:
		Area
			this search lets you look for text in the area names. On
			match, you can tag or untag the area.
		Filename
			this search lets you look for files in the index file. You
			will be prompted to limit the search scope if you want. See
			the Search Scope description.
		Keyword
			this search lets you look for a keyword in the file listings.
			You will be prompted to limit the search scope if you want.
			See the Search Scope description.

	Transfer will let you upload and download files.
		Upload
			this lets the user send a file to your system.
		Download
			this lets the user get a file from your system. You will be
			prompted to limit the search scope if you want. See Search
			Scope description.

	Edit will let you edit the tagged files list.

	Search Scope (for searches, downloading) lets you limit the scope
	of the next command.
		Ignore
			no limit of scope, search the entire filebase.
		Area
			limit the search to the selected area only.
		Group
			limit the search to the selected group only.
		Tagged
			limit the search to the tagged areas only.

CONFIGURATION FILE FORMAT
	FileNav has the capability to execute external programs to do the
	file listing, filename and keyword searches, the tagged files editing,
	file uploads and downloads. For more information on that, see the
	'EXTERNAL HOOKS' section.

	The configuration file provides the optional hooks for external program
	support. Each of the entries has a 'Function' entry. This is an integer
	that specifies the ProBoard function number to execute. You can assign
	whatever number you want there (and the FileNav won't care). For PEX
	files, choose 60. Next, you have the 'Data' entry. This one specifies
	the optional parameters to pass to the function. For PEX files, place
	the name of the PEX file there, together with its command-line options,
	if any. The last one (not all entries have it), 'NoParam' is a boolean
	type variable. If set to True, FileNav will not append area data to the
	command line. The default action, False, will cause FileNav to append
	the area data to the command line before executing it. The area data
	is compatible with ProBoard's function 32 <area selection> definition.

	There are 7 categories of definitions. 'List' is the set to execute
	when a listing of an area is selected. 'Keyword' is the set to execute
	when a keyword search is selected. 'Filename' is the set to execute
	when a filename search is selected. 'EditTags' will edit the tagged
	files. 'Send' and 'Receive' transfer files. 'Colors' lets you define
	the display colors.

EXTERNAL HOOKS
	To be considered FileNav-compatible, external programs must accept
	area numbers as per ProBoard specification. Note that FileNav will
	always expand group/tagged lists and present the application with
	a string consisting of "+area1 +area2 ... +arean" that list all the
	areas. Note that the SDK currently has a bug that will not allow more
	that 10 parameters to be passed to the PEX file. I don't have a
	solution for this right now, as I am waiting for the release of the
	new SDK. If the problem persists, an alternative will be proposed.

	The default definitions will hook in the internal ProBoard functions
	to do the job. This will be adequate for most needs. You can always
	use the program as a simple changer and let other external PEXes do
	the job. There are plans on releasing software to replace all the
	internal functions for those hooks.

OPTIONS
	All options can be either lowercase or uppercase. The option switch
	is a dash '-'. You can group options under one switch except in the
	case when the option takes a parameter, in which case it must have
	its separate '-' or be the last in the group. Options are separated
	by whitespace. Options that take arguments will accept them even if
	the argument is not separated from the option by whitespace.

	-a
		ignore all group designations. Use this if you don't have any
		groups defined or if you want to display all areas without
		giving access to groups.

	-g
		groups only. Don't show any areas. The use of this option is
		very limited, it will force use of the '-c' option and act
		like a regular changer.

	-c
		act like a changer, when (Enter) is pressed, set the new area
		(and group, if applicable) and exit. It is suggested that you
		see the full power of FileNav before resorting to this.

	-u
		create a UserDoes-compatible drop file.

	-f path
		use an alternative configuration file. You have to specify the
		complete file path to it. The default has the same name as the
		executable, but with the extension '.INI'.

	-n num
		list only areas belonging to group 'num'.

EXAMPLES
	filenav
		simplest usage, do groups and areas, no userdoes file
	filenav -a
		do areas only, no groups
	filenav -un 20
		create a userdoes file, list ares belonging to group 20
	filenav -n12 -fc:\pb\alt\filenav.cfg
		list areas for group 12, use an alternate configuration file

FILES
	FILENAV.PEX : the executable
	FILENAV.INI : the default configuration file
	FILENAV.HLP : the default help file (straight ANSI)

IDENTIFICATION
	Author: Branislav L. Slantchev
	Revision Number: 2.00
	Release Date: June 30, 1995
	Copyright (C) 1995 by Branislav L. Slantchev

CHANGES
	2.00 total rewrite, new interface, all source is completely new
	1.25 first public release

LIMITS
	Memory. Since FileNav constructs lists of your groups and areas (and
	thus eliminates the frequent access that PB does), you might run out
	of memory if you have 10000 areas. Actually, it is quite possible that
	you never see this.

	Future plans: include a new files search option.

LEGAL
	FileNav was compiled using the following products:

	BCC 3.1, TLIB 3.02, TLINK 5.22b, MAKE 3.6, copyright by Borland Int'l.
	ProBoard SDK 2.00, copyright by Philippe Leybaert

	FileNav (all executables, source and documentation files)
	are Copyright (C) 1995 by Branislav L. Slantchev.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	If you find this program useful, drop me a post card at the mail
	address (see file SUPPORT). I will really appreciate that.

SEE ALSO
	README for quick installation
