
GRAFFITI						User's Manual					GRAFFITI
						Last revision date: May 09, 1995


NAME
	GRAFFITI - Physical Graffiti, a multi-color one liner for ProBoard

SYNOPSIS
	GRAFFITI <num> </NL> </NU>

VERSION
	GRAFFITI version 1.01

DESCRIPTION
	GRAFFITI - "Physical Graffiti" is a one-liner graffiti wall for
	ProBoard 2.0x. It keeps up to 9 lines. Users can view, add and
	(optionally) delete lines from the database. When the wall is
	full, the bottom line is dropped to make space for the new one.
	Users can select from up to 18 different color combinations to
	display their quotes. Those combinations are configurable via the
	MKCOL utility included in the package. A default set is provided.
	Refer to the file MKCOL.MAN for more information. Also, users
	can sign their lines with whatever name they choose or they may
	leave them anonymously. The date and time of writing are posted
	automatically. Users can enter as many lines a day as they wish.

	Supports USERDOES-compatible dropfiles. This does not constitute
	endorsing by Eddie Van Loon (author of UserDoes) nor does it
	recommend that shareware utility. It seems to be popular and this
	is the only reason why this program supports it. This can be
	disabled. (This section applies to the PEX version only.)

OPTIONS
	num		this is a plain integer and signifies the level needed to
			allow deletion of entries. Any user with security level
			equal or above that number will be allowed to delete
			entries. (PEX only, the EXE always allows deletion)

			NOTE: 	even though the default for that level is 32000,
					you	will have to specify it if you're using any
					of the two other parameters, and it should be the
					first one on the line.

	/NL		will not log anything to ProBoard's log file. (PEX only)

	/NU		will not create a USERDOES-compatible drop file. (PEX only)

EXAMPLES
	GRAFFITI 500

		This command line will cause everybody with security level
		equal or above 500 to be able to delete lines. If no level
		is specified, GRAFFITI will default to 32000.

	GRAFFITI 250 /NL

		Level for deletion is 250 or above, don't log usage.

	GRAFFITI 16000 /NL /NG

		Level for deletion is 16000 or above, don't log, don't create
		the USERDOES-compatible dropfile.

FILES
	GRAFFITI.PEX	The executable (an offline EXE is provided too).
	GRAFFITI.DAT	The database (maintained internally)
	GRAFFITI.DEF	The color definitions (see MKCOL.MAN)

DIAGNOSTICS
	GRAFFITI will log entry and exits into the ProBoard LOG file.
	This can be disabled with the /NL command switch (PEX only).

	GRAFFITI will create a USERDOES-compatible dropfile. This can
	be disabled with the /NU command switch (PEX only).

ERRORS
	All errors are of the form graffiti: message.

	graffiti: File IO error writing record 'num'

		An error occurred while writing the line num to the data file.

	graffiti: Could not create the grafitti wall file

		Some disk problem prevents creating the data file. Full?

	graffiti: Could not locate data file 'name'

		Self explanatory. This should not occur since a default file
		will be created if none exists. Strange if you get this one.
		However, this may also refer to the color definition file in
		which case you'll have to pay attention. Note the path and
		see if you have the required file there.

	graffiti: File IO error reading record '%d'

		An error occured reading from data file. This may be due to
		corrupted wall or color definition files. Delete the wall file
		and try again. If that doesn't help, reinstall the definition
		file. Otherwise, I don't know.

IDENTIFICATION
	Author: Branislav L. Slantchev
	Revision Number: 1.01
	Release Date: June 21, 1995
	Copyright (C) 1995 by Branislav L. Slantchev

LIMITS
	Well, only 18 color selections are available and they must be
	predefined via the MKCOL utility.

	Requires user to have ANSI on in order to run at all. (PEX only)

BUGS
	Do not try to edit the data file with an editor. This is a binary
	file and doing so will certainly corrupt it and crash GRAFFITI
	when its run. Same goes for the color definition file. You can
	create yours with the MKCOL utility.

LEGALITIES
	GRAFFITI is Copyright 1995 by Branislav L. Slantchev.
	USERDOES is Copyright 1994, 1995 by Eddie Van Loon.

	Compiled with Borland C++ 3.1 and ProBoard's SDK 2.01.

	GRAFFITI (all executables, source and documentation files) are
	copyrighted material of Branislav L. Slantchev.

	This program is free software. You can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation, version 2. This
	software is released under the terms of that license. Please
	read the included file COPYING for the full text.

	You should have received a copy of the GNU General Public License
	along with this program (file COPYING). If not, write to the Free
	Software Foundation, Inc., 675 Mass Ave, Campbridge, MA 02139, USA.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	Branislav L. Slantchev will not be liable for any special, incidental,
	consequential, indirect or similar damages due to loss of data or
	any other reason.

	If you find this program useful, drop me a post card at the mail
	address (see file SUPPORT). I will really appreciate that.


SEE ALSO
	README			Quick installation instructions
	MKCOL.MAN		Create custom color definitions

