#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "c_darr.hxx"

typedef unsigned uint;
typedef unsigned long ulong;
typedef unsigned char byte;
typedef unsigned long accessflags;
typedef unsigned char combinedboards[125];
typedef unsigned char bool;
typedef unsigned char Time[3];
typedef unsigned char Date[3];

typedef struct _MSG_AREA
  {
   int  area;                 /* # of message area (1-10000)                 */
   char name[31];             /* Name of message areas                       */
   byte msgtype;              /* Type of messages                            */
   byte msgkind;              /* Kind of message area                        */
   byte msgbasetype;          /* 0 = hudson , 1 = squish , 2 = *.MSG         */
   char path[80];             /* Path/Directory for Squish/*.MSG             */
   byte flags;                /* Alias allowed/forced/prohibited             */
   uint readlevel;            /* Minimum level needed to read msgs           */
   accessflags readflags;     /* flags needed to read msgs                   */
   uint writelevel;           /* Minimum level needed to write msgs          */
   accessflags writeflags;    /* flags needed to write msgs                  */
   uint sysoplevel;           /* Minimum level needed to change msgs         */
   accessflags sysopflags;    /* flags needed to change msgs                 */
   char origin[62];           /* Origin line                                 */
   int aka;                   /* AKA                                         */
   int rcv_kill_days;         /* Kill received after xx days                 */
   int msg_kill_days;         /* Kill after xx days                          */
   int max_msgs;              /* Max # msgs                                  */
   char sysop[36];            /* Area Sysop                                  */
   int  replyboard;           /* Reply area # (0=here)                       */
   char echotag[21];          /* Echomail Tag Name                           */
   char qwktag[13];           /* QWK Area Name                               */

   char extra[23];

  } MSG_AREA;


#define MSGTYPE_BOTH     0 /* Private/Public */
#define MSGTYPE_PVT      1 /* Private Only   */
#define MSGTYPE_PUBLIC   2 /* Public Only    */
#define MSGTYPE_TOALL    3 /* To All         */

#define MSGKIND_LOCAL    0 /* Local          */
#define MSGKIND_NET      1 /* NetMail        */
#define MSGKIND_ECHO     2 /* EchoMail       */
#define MSGKIND_PVTECHO  3 /* Pvt EchoMail   */

#define MSGBASE_HUDSON   0
#define MSGBASE_SQUISH   1
#define MSGBASE_SDM      2

// Globale Variable:
//==================

char *flagarr = "ABCDEFGHIJKLMNOPQRSTUVWXYZ123456";

void usage(void)
{
    printf("Usage:");
    printf("\n\n");
    printf("MSGCVT <COMMAND>\n");
    printf("================\n\n");
    printf("COMMAND must be one of the following:\n");
    printf("-------------------------------------\n\n");
    printf("  EXPORT  Read MSGAREAS.PB and create a text file MSGAREAS.TXT.\n\n");
    printf("  IMPORT  Read text file MSGAREAS.TXT and create the new MSGAREAS.PB.\n\n");
}


void import(char *pb_path)
{

    DynArray *arr;
    MSG_AREA faa;
    MSG_AREA *fa;
    MSG_AREA *f;
    char buf[501];
    char cmd[501];
    FILE *f1;
    int status;
    int line;
    char *ptr;
    long i, j, area;
    long size, maxarea;
    long flags;
    unsigned long bit;

    printf("Converting MSGAREAS.TXT ---> MSGAREAS.PB\n\n");

    strcpy(buf, pb_path);
    if (buf[strlen(buf)-1] == 92)
    {
        buf[strlen(buf)-1] = '\0';
    }
    strcat(buf, "\\");
    strcat(buf, "MSGAREAS.TXT");

    f1 = fopen(buf, "r");
    if (!f1)
    {
        printf("\n\nError: unable to open %s.\n", buf);
        exit(5);
    }

    status = 0;
    line = 0;
    arr = new DynArray;

    while (fgets(buf, 500, f1))
    {
        ++line;
        if (*buf == '-' || *buf == ' ' || *buf == ';')
        {
            continue;
        }
        ptr = strchr(buf, ':');
        if (!ptr)
        {
            printf("Error line %d: ':' expected", line);
            fclose(f1);
            exit(1);
        }
        ++ptr;
        while (isspace(*ptr))
        {
            ++ptr;
        }

        if (ptr[strlen(ptr)-1] == 10)
        {
            ptr[strlen(ptr)-1] = '\0';
        }

        switch (status)
        {
            case 0:
                // Get area number:
                //-----------------

                fa = new MSG_AREA;
                arr->neu(fa);
                memset(fa, 0, sizeof(MSG_AREA));

                if (*ptr == '\0')
                {
                    printf("Error line %d: no data after ':'", line);
                    fclose(f1);
                    exit(1);
                }

                fa->area = area = atol(ptr);
                if (area == 0)
                {
                    printf("Error line %d: Area number expected (greater than 0)!", line);
                    fclose(f1);
                    exit(1);
                }
                if (area > 10000)
                {
                    printf("Error line %d: Area number expected (less than 10000)!", line);
                    fclose(f1);
                    exit(1);
                }
                ++status;
                break;
            case 1:
                // Get area name:
                //---------------

                strcpy(fa->name, ptr);
                ++status;
                break;
            case 2:

                if (stricmp(ptr, "PRIVATE/PUBLIC") == 0)
                {
                    fa->msgtype = MSGTYPE_BOTH;
                }
                else if (stricmp(ptr, "PRIVATE") == 0)
                {
                    fa->msgtype = MSGTYPE_PVT;
                }
                else if (stricmp(ptr, "PUBLIC") == 0)
                {
                    fa->msgtype = MSGTYPE_PUBLIC;
                }
                else if (stricmp(ptr, "TOALL") == 0)
                {
                    fa->msgtype = MSGTYPE_TOALL;
                }
                else
                {
                    printf("Error line %d: PRIVATE/PUBLIC, PRIVATE, PUBLIC or TOALL expected!", line);
                    fclose(f1);
                    exit(1);
                }
                ++status;
                break;
            case 3:

                if (stricmp(ptr, "LOCAL") == 0)
                {
                    fa->msgkind = MSGKIND_LOCAL;
                }
                else if (stricmp(ptr, "NET") == 0)
                {
                    fa->msgkind = MSGKIND_NET;
                }
                else if (stricmp(ptr, "ECHO") == 0)
                {
                    fa->msgkind = MSGKIND_ECHO;
                }
                else if (stricmp(ptr, "PVTECHO") == 0)
                {
                    fa->msgkind = MSGKIND_PVTECHO;
                }
                else
                {
                    printf("Error line %d: LOCAL, NET, ECHO or PVTECHO expected!", line);
                    fclose(f1);
                    exit(1);
                }
                ++status;
                break;
            case 4:

                if (stricmp(ptr, "HUDSON") == 0)
                {
                    fa->msgbasetype = MSGBASE_HUDSON;
                }
                else if (stricmp(ptr, "SQUISH") == 0)
                {
                    fa->msgbasetype = MSGBASE_SQUISH;
                }
                else if (stricmp(ptr, "MSG") == 0)
                {
                    fa->msgbasetype = MSGBASE_SDM;
                }
                else
                {
                    printf("Error line %d: HUDSON, SQUISH or MSG expected!", line);
                    fclose(f1);
                    exit(1);
                }
                ++status;
                break;

            case 5:

                if ((fa->msgbasetype == MSGBASE_SQUISH) || (fa->msgbasetype == MSGBASE_SDM))
                {
                    if (*ptr == '\0')
                    {
                        printf("Error line %d: Path expected for SQUISH/MSG\n", line);
                        fclose(f1);
                        exit(1);
                    }
                    strcpy(fa->path, ptr);
                }
                ++status;
                break;

            case 6:

                if (stricmp(ptr, "REALNAME") == 0)
                {
                    fa->flags = 0;
                }
                else if (stricmp(ptr, "FREEALIAS") == 0)
                {
                    fa->flags = 1;
                }
                else if (stricmp(ptr, "FORCEDALIAS") == 0)
                {
                    fa->flags = 2;
                }
                else
                {
                    printf("Error line %d: REALNAME, FREEALIAS or FORCEDALIAS expected!", line);
                    fclose(f1);
                    exit(1);
                }

                ++status;
                break;

            case 7:

                if (*ptr == '\0')
                {
                    printf("Error line %d: no data after ':'", line);
                    fclose(f1);
                    exit(1);
                }
                fa->readlevel = atol(ptr);

                ++status;
                break;

            case 8:

                bit = 1L<<31L;
                for (j=0L; j<32; ++j)
                {
                    if (ptr[j] == flagarr[j])
                    {
                        fa->readflags += bit;
                    }
                    else if (ptr[j] == '_')
                    {
                        ;
                    }
                    else
                    {
                        printf("Error line %d: Wrong flags!", line);
                        fclose(f1);
                        exit(1);
                    }
                    bit /= 2L;
                }

                ++status;
                break;

            case 9:

                if (*ptr == '\0')
                {
                    printf("Error line %d: no data after ':'", line);
                    fclose(f1);
                    exit(1);
                }
                fa->writelevel = atol(ptr);

                ++status;
                break;

            case 10:

                bit = 1L<<31L;
                for (j=0L; j<32; ++j)
                {
                    if (ptr[j] == flagarr[j])
                    {
                        fa->writeflags += bit;
                    }
                    else if (ptr[j] == '_')
                    {
                        ;
                    }
                    else
                    {
                        printf("Error line %d: Wrong flags!", line);
                        fclose(f1);
                        exit(1);
                    }
                    bit /= 2L;
                }

            case 11:

                if (*ptr == '\0')
                {
                    printf("Error line %d: no data after ':'", line);
                    fclose(f1);
                    exit(1);
                }
                fa->sysoplevel = atol(ptr);

                ++status;
                break;

            case 12:

                bit = 1L<<31L;
                for (j=0L; j<32; ++j)
                {
                    if (ptr[j] == flagarr[j])
                    {
                        fa->sysopflags += bit;
                    }
                    else if (ptr[j] == '_')
                    {
                        ;
                    }
                    else
                    {
                        printf("Error line %d: Wrong flags!", line);
                        fclose(f1);
                        exit(1);
                    }
                    bit /= 2L;
                }

                ++status;
                break;

            case 13:

                strcpy(fa->origin, ptr);
                ++status;
                break;

            case 14:

                if (*ptr == '\0')
                {
                    printf("Error line %d: no data after ':'", line);
                    fclose(f1);
                    exit(1);
                }

                fa->aka = atol(ptr);
                ++status;
                break;

            case 15:

                if (*ptr == '\0')
                {
                    printf("Error line %d: no data after ':'", line);
                    fclose(f1);
                    exit(1);
                }

                fa->rcv_kill_days = atol(ptr);
                ++status;
                break;

            case 16:

                if (*ptr == '\0')
                {
                    printf("Error line %d: no data after ':'", line);
                    fclose(f1);
                    exit(1);
                }

                fa->msg_kill_days = atol(ptr);
                ++status;
                break;

            case 17:

                if (*ptr == '\0')
                {
                    printf("Error line %d: no data after ':'", line);
                    fclose(f1);
                    exit(1);
                }

                fa->max_msgs = atol(ptr);
                ++status;
                break;

            case 18:

                strcpy(fa->sysop, ptr);
                ++status;
                break;

            case 19:

                if (*ptr == '\0')
                {
                    printf("Error line %d: no data after ':'", line);
                    fclose(f1);
                    exit(1);
                }

                fa->replyboard = atol(ptr);
                ++status;
                break;

            case 20:

                strcpy(fa->echotag, ptr);
                ++status;
                break;

            case 21:

                strcpy(fa->qwktag, ptr);
                status = 0;
                break;

            default:
                printf("\n\nStatus = %ld\n\n", (long) status);
                break;
        }
    }
    fclose(f1);

    // Sicherungskopie von MSGAREAS.PB anlegen:
    //-----------------------------------------

    strcpy(buf, pb_path);
    if (buf[strlen(buf)-1] == 92)
    {
        buf[strlen(buf)-1] = '\0';
    }
    strcat(buf, "\\");

    sprintf(cmd, "copy %s%s %s%s > NUL", buf, "MSGAREAS.PB", buf, "MSGAREAS.BAK");
    system(cmd);

    // Groesste Areanummer ermitteln:
    //-------------------------------

    maxarea = 0L;
    for (i=0L; i<arr->anzahl(); ++i)
    {
        f = (MSG_AREA *) arr->get(i);
        if (f->area > maxarea)
        {
            maxarea = f->area;
        }
    }

    // Auf doppelte Areanummern pruefen:
    //----------------------------------

    for (i=0L; i<arr->anzahl(); ++i)
    {
        f = (MSG_AREA *) arr->get(i);
        area = f->area;
        for (j=0L; j<arr->anzahl(); ++j)
        {
            if (i != j)
            {
                f = (MSG_AREA *) arr->get(j);
                if (area == f->area)
                {
                    printf("Error: Duplicate Area number: %ld\n", area);
                    exit(1);
                }
            }
        }
    }

    // Write new MSGAREAS.PB:
    //------------------------

    strcpy(buf, pb_path);
    if (buf[strlen(buf)-1] == 92)
    {
        buf[strlen(buf)-1] = '\0';
    }
    strcat(buf, "\\");
    strcat(buf, "MSGAREAS.PB");

    f1 = fopen(buf, "wb");
    if (!f1)
    {
        printf("\n\nError: unable to open %s.\n", buf);
        exit(4);
    }

    memset(&faa, 0, sizeof(MSG_AREA));
    for (i=0L; i<maxarea; ++i)
    {
        if (fwrite(&faa, (long)sizeof(MSG_AREA), 1L, f1) != 1L)
        {
            fclose(f1);
            printf("\nError writing MSGAREAS.PB\n");
            exit(6);
        }
    }

    for (i=0L; i<arr->anzahl(); ++i)
    {
        f = (MSG_AREA *) arr->get(i);
        fseek(f1, (long)(f->area-1)*(long)sizeof(MSG_AREA), SEEK_SET);
        if (fwrite(f, (long)sizeof(MSG_AREA), 1L, f1) != 1L)
        {
            fclose(f1);
            printf("\nError writing MSGAREAS.PB\n");
            exit(6);
        }
    }

    fclose(f1);
}

void export(char *pb_path)
{
    MSG_AREA fa;
    char buf[301];
    FILE *f1, *f2;
    long size, maxarea;
    long i, j, flags;
    unsigned long bit;

    printf("Converting MSGAREAS.PB ---> MSGAREAS.TXT\n\n");

    strcpy(buf, pb_path);
    if (buf[strlen(buf)-1] == 92)
    {
        buf[strlen(buf)-1] = '\0';
    }
    strcat(buf, "\\");
    strcat(buf, "MSGAREAS.PB");

    f1 = fopen(buf, "rb");
    if (!f1)
    {
        printf("\n\nError: unable to open %s.\n", buf);
        exit(4);
    }

    strcpy(buf, pb_path);
    if (buf[strlen(buf)-1] == 92)
    {
        buf[strlen(buf)-1] = '\0';
    }
    strcat(buf, "\\");
    strcat(buf, "MSGAREAS.TXT");

    f2 = fopen(buf, "w");
    if (!f2)
    {
        printf("\n\nError: unable to create %s.\n", buf);
        fclose(f1);
        exit(5);
    }

    // Bestimmen der Filegroesse:
    //===========================

    fseek(f1, 0L, SEEK_END);
    size = ftell(f1);
    maxarea = size/sizeof(MSG_AREA);
    fseek(f1, 0L, SEEK_SET);

    printf("Greatest area number: %ld\n", maxarea);

    for (i=0L; i<maxarea; ++i)
    {
        if (fread(&fa, (long)sizeof(MSG_AREA), 1L, f1) != 1L)
        {
            fclose(f1);
            fclose(f2);
            printf("\nError reading FILECFG.PRO\n");
            exit(6);
        }
        if (*(fa.name))
        {
            fprintf(f2, "Message area number: %d\n", fa.area);
            fprintf(f2, "Area name: %s\n", fa.name);
            fprintf(f2, "Message type: ");
            switch (fa.msgtype)
            {
                case MSGTYPE_BOTH:
                    fprintf(f2, "PRIVATE/PUBLIC");
                    break;
                case MSGTYPE_PVT:
                    fprintf(f2, "PRIVATE");
                    break;
                case MSGTYPE_PUBLIC:
                    fprintf(f2, "PUBLIC");
                    break;
                case MSGTYPE_TOALL:
                    fprintf(f2, "TOALL");
                    break;
                default:
                    fclose(f1);
                    fclose(f2);
                    printf("\nError: Area %d: Unknown message type!\n", fa.area);
                    exit(6);
            }
            fprintf(f2, "\n");

            fprintf(f2, "Message kind: ");
            switch (fa.msgkind)
            {
                case MSGKIND_LOCAL:
                    fprintf(f2, "LOCAL");
                    break;
                case MSGKIND_NET:
                    fprintf(f2, "NET");
                    break;
                case MSGKIND_ECHO:
                    fprintf(f2, "ECHO");
                    break;
                case MSGKIND_PVTECHO:
                    fprintf(f2, "PVTECHO");
                    break;
                default:
                    fclose(f1);
                    fclose(f2);
                    printf("\nError: Area %d: Unknown message kind!\n", fa.area);
                    exit(6);
            }
            fprintf(f2, "\n");

            fprintf(f2, "Message base type: ");
            switch (fa.msgbasetype)
            {
                case MSGBASE_HUDSON:
                    fprintf(f2, "HUDSON");
                    break;
                case MSGBASE_SQUISH:
                    fprintf(f2, "SQUISH");
                    break;
                case MSGBASE_SDM:
                    fprintf(f2, "MSG");
                    break;
                default:
                    fclose(f1);
                    fclose(f2);
                    printf("\nError: Area %d: Unknown message base type!\n", fa.area);
                    exit(6);
            }
            fprintf(f2, "\n");
            fprintf(f2, "Path: %s\n", fa.path);
            fprintf(f2, "Name flags: ");
            switch (fa.flags)
            {
                case 0:
                    fprintf(f2, "REALNAME");
                    break;
                case 1:
                    fprintf(f2, "FREEALIAS");
                    break;
                case 2:
                    fprintf(f2, "FORCEDALIAS");
                    break;
                default:
                    fclose(f1);
                    fclose(f2);
                    printf("\nError: Area %d: Unknown name flags!\n", fa.area);
                    exit(6);
            }
            fprintf(f2, "\n");

            fprintf(f2, "Read level:  %u\n", fa.readlevel);

            fprintf(f2, "Read flags:  ");
            flags = fa.readflags;
            bit = 1L<<31L;
            for (j=0L; j<32; ++j)
            {
                if (flags & bit)
                {
                    fprintf(f2, "%c", flagarr[j]);
                }
                else
                {
                    fprintf(f2, "_");
                }
                bit /= 2L;
            }
            fprintf(f2, "\n");

            fprintf(f2, "Write level: %u\n", fa.writelevel);

            fprintf(f2, "Write flags: ");
            flags = fa.writeflags;
            bit = 1L<<31L;
            for (j=0L; j<32; ++j)
            {
                if (flags & bit)
                {
                    fprintf(f2, "%c", flagarr[j]);
                }
                else
                {
                    fprintf(f2, "_");
                }
                bit /= 2;
            }
            fprintf(f2, "\n");

            fprintf(f2, "Sysop level: %u\n", fa.sysoplevel);

            fprintf(f2, "Sysop flags: ");
            flags = fa.sysopflags;
            bit = 1L<<31L;
            for (j=0L; j<32; ++j)
            {
                if (flags & bit)
                {
                    fprintf(f2, "%c", flagarr[j]);
                }
                else
                {
                    fprintf(f2, "_");
                }
                bit /= 2L;
            }
            fprintf(f2, "\n");

            fprintf(f2, "Origin: %s\n", fa.origin);

            fprintf(f2, "Index of used AKA: %d\n", fa.aka);

            fprintf(f2, "Kill received after days: %d\n", fa.rcv_kill_days);

            fprintf(f2, "Kill after days: %d\n", fa.msg_kill_days);

            fprintf(f2, "Max number messages: %d\n", fa.max_msgs);

            fprintf(f2, "Area sysop: %s\n", fa.sysop);

            fprintf(f2, "Reply area number (0=here): %d\n", fa.replyboard);

            fprintf(f2, "Echotag: %s\n", fa.echotag);

            fprintf(f2, "QWKtag: %s\n", fa.qwktag);

            fprintf(f2, "-------------------------------------------------------------------------------\n");
        }
    }

    fclose(f1);
    fclose(f2);
    printf("%s created.\n\n", buf);
}

void main(int argc, char** argv)
{
    char *pb_path;

    printf("\nMSGCVT: Import/Export ProBoards MSGAREAS.PB to/from a text file.\n");
    printf("        Freeware, written by Norbert Luksch\n\n");

    if (argc != 2)
    {
        usage();
        exit(1);
    }

    pb_path = getenv("PB");
    if (!pb_path)
    {
        printf("\n\nSorry, PB environment variable not set... exiting.\n\n");
        exit(3);
    }

    if (stricmp(argv[1], "EXPORT") == 0)
    {
        export(pb_path);
        exit(0);
    }
    else if (stricmp(argv[1], "IMPORT") == 0)
    {
        import(pb_path);
        exit(0);
    }
    else
    {
        usage();
        exit(2);
    }
    exit(0);
}

