/*
**  lastcall.h (InterMail)
**
**  Copyright 1989-1994 InterZone Software, Inc. All rights reserved.
**
**  Record format for LASTCALL.IM, LASTCALL.002, etc. 
**  (Last in/outbound call, recent activity)
**
**  -------------------------------------------------------------------------
**  This information is not necessarily final and is subject to change at any
**  given time without further notice
**  -------------------------------------------------------------------------
*/

/*
**  Recent activity (statistics) definitions.
*/
typedef struct
    {
    word    inbound,                        /* Inbound mail calls */
            outbound,                       /* Outbound mail calls */
            humans,                         /* Inbound BBS callers */
            filesin,                        /* Inbound files */
            filesout,                       /* Outbound files */
            goodsess,                       /* Good sessions */
            badsess,                        /* Failed sessions */
            requests;                       /* Inbound file requests */
    dword   date,                           /* UNIX-style timestamp */
            bytesin,                        /* Inbound (rcvd) bytes */
            bytesout;                       /* Outbound (sent) bytes */
    }
    STATREC, *STATRECPTR;

/*
**  Note that the two char[] arrays are Borland Pascal style strings. The 
**  first byte is the length byte. The actual string starts at [1] and 
**  the string is NOT NUL terminated. In pascal they would be 
**  declared as string[30] and string[40].
**
**  Mail server #1 uses LASTCALL.IM, #2 uses LASTCALL.002, etc.
*/
typedef struct
    {
    char    system_name[31],
            location[41];
    word    zone,net,node,point;
    dword   time;                           /* UNIX-style timestamp */
    }
    LASTCALL, *LASTCALLPTR;

/*
**  The LASTCALL.IM file contains four records, two STATREC and two
**  LASTCALL. Today's activity is moved to Yesterday's activity as soon
**  as IM runs its 'after-midnight' internal event.
*/
typedef struct
    {
    LASTCALL    lastin,                     /* Last inbound mail call */
                lastout;                    /* Last outbound mail call */
    STATREC     today_act,                  /* Today's activity */
                yesterday_act;              /* Yesterday's activity */
    }
    ACTIVITY, *ACTIVITYPTR;

/* end of file "lastcall.h" */

