/***********************************************************************
*                                                                      *
*   Program  BORDER                                                    *
*   Author   Peter Bloemendaal                                         *
*            Brainbox systems +31-70-3523661                           *
*   eMail  : internet -> bloemendaal@rullf2.LeidenUniv.nl              *
*            fidonet  -> 2:281/908                                     *
*                                                                      *
*   Purpose  Draws borders AROUND specified area                       *
*                                                                      *
*----------------------------------------------------------------------*
*                                                                      *
*   This source is copyrighted and distributed under the GNU license   *
*                                                                      *
*   If you use parts of this source and distribute compiled versions   *
*   of it, you have to make your source available!!!                   *
*                                                                      *
*                                                                      *
*----------------------------------------------------------------------*
*  $Log: border.hpv $
// Revision 1.1  1994/08/20  13:32:59  BRAINBOX
// Initial revision
//                                                               *
*                                                                      *
************************************************************************
*/


#ifndef _BORDER_HPP
#define _BORDER_HPP

#ifdef _PB_SDK_H
#include "pb_mbh.h"
#else

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#endif
#include "edit_glb.h"


class Border
{
   private:
      int  w_x, w_y, w_width, w_heigth ;
      int  border ;
      int  topColor, botColor ;
      bool doubleWidth ;
      char *w_label ;

   public:
      Border(int x, int y, int x2, int y2) ;

      void setTopColor(unsigned char col) ;
      void setBotColor(unsigned char col) ;
      void open(void) ;
} ;


Border::Border(int x, int y, int x2, int y2)
{
   w_x = x ;
   w_y = y ;
   w_width  = x2 - x  ;
   w_heigth = y2 - y  ;

   doubleWidth = TRUE ;
   border = 1 ;
   topColor =  ( 7 << 4 ) | 15 ;
   botColor =  ( 7 << 4 ) | 8  ;
}


void Border::setTopColor(unsigned char col)
{
   topColor = col ;
}


void Border::setBotColor(unsigned char col)
{
   botColor = col ;
}


void Border::open(void)
{
   int i ;
   char vertline[7][8] ;

   char *st ;

   st = (char*) malloc(w_width+2) ;
   memset(st,' ',w_width+1) ;
   st[w_width+1] = '\0' ;

   strcpy(vertline[0],"ڰ") ;
   strcpy(vertline[1],"") ;
   strcpy(vertline[2],"") ;
   strcpy(vertline[3],"") ;
   strcpy(vertline[4],"İ") ;
   strcpy(vertline[5],"ٰ") ;


   // Draw top
   textattr(topColor) ;
   if (doubleWidth)
   {
      gotoxy(w_x - 2,w_y - 1) ;
      cprintf(" %c",vertline[0][border]) ;
   }
   else
   {
      gotoxy(w_x - 1,w_y - 1) ;
      cprintf("%c",vertline[0][border]) ;
   }
   for (i = w_x ; i <= w_x + w_width ; i++)
      cprintf("%c",vertline[4][border]) ;
   textattr(botColor) ;
   if (doubleWidth)
   {
      gotoxy(w_width + w_x + 1,w_y - 1) ;
      cprintf("%c ",vertline[3][border]) ;
   }
   else
   {
      gotoxy(w_width + w_x + 1,w_y - 1) ;
      cprintf("%c",vertline[3][border]) ;
   }

   // Draw body
   for (i = w_y  ; i <= w_heigth + w_y  ; i++)
      if (doubleWidth)
      {
         textattr(topColor) ;
         gotoxy(w_x - 2,i) ;
         cprintf(" %c",vertline[1][border]) ;
         cprintf("%s",st) ;
         textattr(botColor) ;
         gotoxy(w_x + w_width + 1,i) ;
         cprintf("%c ",vertline[1][border]) ;
      }
      else
      {
         textattr(topColor) ;
         gotoxy(w_x - 1,i) ;
         cprintf("%c",vertline[1][border]) ;
         cprintf("%s",st) ;
         textattr(botColor) ;
         gotoxy(w_x + w_width + 1,i) ;
         cprintf("%c",vertline[1][border]) ;
      }

   // Draw bottom
   textattr(topColor) ;
   if (doubleWidth)
   {
      gotoxy(w_x - 2,w_y +w_heigth + 1) ;
      cprintf(" %c",vertline[2][border]) ;
   }
   else
   {
      gotoxy(w_x - 1,w_y +w_heigth + 1) ;
      cprintf("%c",vertline[2][border]) ;
   }
   textattr(botColor) ;
   for (i = w_x ; i <= w_x + w_width ; i++)
      cprintf("%c",vertline[4][border]) ;
   if (doubleWidth)
   {
      gotoxy(w_width + w_x + 1,w_y + w_heigth + 1) ;
      cprintf("%c ",vertline[5][border]) ;
   }
   else
   {
      gotoxy(w_width + w_x + 1,w_y + w_heigth + 1) ;
      cprintf("%c",vertline[5][border]) ;
   }

}


#endif