/*
 * This file is part of VizPak (PEX)
 *
 * Copyright (C) 1995-1997 by Branislav L. Slantchev
 * A Product of Silicon Creations, Inc.
 *
 * This file is distributed under the terms and conditions of the GNU
 * General Public License. For more information, refer to the file
 * Copying.Doc which is included in the archive.
*/
#include "vizpak.h"
#include "pblsdk.h"

#ifndef PB_SDK
	#include <conio.h>
	#include <dos.h>
#else
	#include "pblibc.h"
#endif

Glisten::Glisten(int argc, char *argv[], char *argv0)
	:AbstractViz(argc, argv, argv0, AbstractViz::forceFancy,
				 AbstractViz::okToCenter)
{
	if( m_nDelay == DEFAULTDELAY ) m_nDelay = 12;
}

void
Glisten::effect()
{
	int x;

	// use second color for initial display (ignore first)
	textattr(m_palette[1]);
	gotoxy(m_bounds.a.x, m_bounds.a.y);
	cprintf(m_text);

	for( ;; )
	{
		/* just skip first three characters... no big deal */
		for( int i = 3; i < m_nTextSize; ++i )
		{
			x = m_bounds.a.x + i;

			gotoxy(x, m_bounds.a.y);
			textattr(m_palette[2]);
			putch(m_text[i]);
			delay(m_nDelay);

			gotoxy(x - 1, m_bounds.a.y);
			textattr(m_palette[3]);
			putch(m_text[i - 1]);
			delay(m_nDelay);

			gotoxy(x - 2, m_bounds.a.y);
			textattr(m_palette[4]);
			putch(m_text[i - 2]);
			delay(m_nDelay);

			gotoxy(x - 3, m_bounds.a.y);
			textattr(m_palette[5]);
			putch(m_text[i - 3]);
			delay(m_nDelay);

			if( 0 != (m_exitCode = PeekChar()) ) return;
		}

		/* set last three characters to trailing color */
		textattr(m_palette[1] );
		gotoxy(m_bounds.a.x + m_nTextSize - 3, m_bounds.a.y);
		cprintf(&m_text[m_nTextSize - 3] );

		if( m_flags & once ) return;
	}
}

