/*
 WHO CALLED ProBoard PEX Version and MS-DOS EXE
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of WHO CALLED.

 WHO CALLED is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 WHO CALLED is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with WHO CALLED; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined( __RASTRUCT_H )
#define __RASTRUCT_H

#if !defined( __PBINC_H )
	#include <pbinc.h>
#endif
/*
 ***************************************************************************
				 RA-compatible structures for USERS.BBS, et al.
 ***************************************************************************
*/

/*
	NOTES
		1.  Strings are Pascal-style, i.e. first byte == length,
			and there's no NUL-terminator;
		2.  Time format is HH:MM, this is a Pascal string too.
		3.  Date format is MM-DD-YY, this is a Pascal string too.
		4.  Flags for attribute? are defined in this file too.
*/

/*
 * Masks for the attribute? variables in RA_USERS.
*/
#define RAF1_DELETED       0x01    /* User is deleted                    */
#define RAF1_CLEAR         0x02    /* Clear screen                       */
#define RAF1_PAUSE         0x04    /* More prompt                        */
#define RAF1_ANSI          0x08    /* ANSI                               */
#define RAF1_NOKILL        0x10    /* No kill                            */
#define RAF1_IGNORE        0x20    /* Transfer priority                  */
#define RAF1_FSED          0x40    /* Full-screen editor                 */
#define RAF1_QUIET         0x80    /* Quiet mode                         */
#define RAF2_HOTKEYS       0x01    /* Hot-keys                           */
#define RAF2_AVATAR        0x02    /* AVATAR/0                           */
#define RAF2_FSVIEW        0x04    /* Full-screen message viewer (n/a)   */
#define RAF2_HIDDEN        0x08    /* Hide activity                      */
#define RAF2_PAGEPRI       0x10    /* Page priority                      */
#define RAF2_NOECHOMAIL    0x20    /* No echo mail when checked  (n/a)   */
#define RAF2_GUEST         0x40    /* Guest account                      */
#define RAF2_POSTBILL      0x80    /* Post bill                  (n/a)   */

/*
 * Structure of USERS.BBS file record.
*/
typedef struct{
	char  name[36];             /* User's name                            */
	char  city[26];             /* User's home city                       */
	char  company[51];          /* User's company                         */
	char  address1[51];         /* Address, first line                    */
	char  address2[51];         /* Address, second line                   */
	char  address3[51];         /* Address, third line                    */
	char  alias[36];            /* Alias/Handle                           */
	char  comment[81];          /* Comment                                */
	dword passWordCRC;          /* CRC of the password                    */
	char  dataPhone[16];        /* Data phone                             */
	char  voicePhone[16];       /* Voice phone                            */
	char  lastTime[6];          /* Last login time (hh:mm)                */
	char  lastDate[9];          /* Last login date (MM-DD-YY)             */
	byte  attribute1;           /* Flags: see RAF1_???                    */
	byte  attribute2;           /* Flags: see RAF2_???                    */
	byte  aFlags[4];            /* User flags (not a dword!)              */
	dword credit;               /* Netmail credit                         */
	dword pending;              /* Pending credit                         */
	word  msgsPosted;           /* Number of posted messages              */
	word  level;                /* User's security level                  */
	dword highMsgRead;          /* Last message read                      */
	dword timesCalled;          /* Total number of calls                  */
	dword numUploads;           /* Total number of uploads                */
	dword numDownloads;         /* Total number of downloads              */
	dword kbUploaded;           /* Total KBytes uploaded                  */
	dword kbDownloaded;         /* Total KBytes downloaded                */
	dword kbToday;              /* KBytes downloaded today                */
	word  timeUsed;             /* Time used today (minutes)              */
	int   screenLength;         /* User's screen length (# of lines)      */
	byte  lastPwdChange;        /* ??? Last password change               */
	word  group;                /* ???                                    */
	int   combinedBoards[200];  /* ??? Combined boards                    */
	char  firstDate[9];         /* Date of first login (MM-DD-YY)         */
	char  birthDate[9];         /* User's birthdate (MM-DD-YY)            */
	char  subDate[9];           /* ??? additional date                    */
	byte  screenWidth;          /* User's screen width (# of columns)     */
	byte  language;             /* ??? Language                           */
	byte  dateFormat;           /* Date format                            */
	char  forwardTo[36];        /* Forward messages to                    */
	word  msgArea;              /* Last message area used                 */
	word  fileArea;             /* Last file area used                    */
	byte  defaultProtocol;      /* Default transfer protocol              */
	int   fileGroup;            /* Last file group used                   */
	byte  lastDOBCheck;         /* ??? Last date of birth check           */
	byte  sex;                  /* Sex - 0: Unknown, 1: Male, 2: Female   */
	dword USERSXIrec;           /* Number of record in USERSXI.BBS        */
	int   msgGroup;             /* Last message group used                */
	char  extra[48];
} RA_USERSBBS;

/*
 * Structure of USERSIDX.BBS record
*/
typedef struct{
	dword nameCRC32;            /* 32-bit CRC of user's name              */
	dword aliasCRC32;           /* 32-bit CRC of user's alias             */
} USERSIDX_BBS;

/*
 * Structure of USERSXI.BBS record
*/
typedef struct{
	char unused[200];           /* Currently unused space                 */
} USERSXI_BBS;

/*
 * Structure of LASTREAD.BBS record
*/
typedef struct{
	word unused[200];	  	   /* Currently unused space (Hudson only?)   */
} LASTREAD_BBS;

/*
 * Structure of USERSLST.BBS record
*/
typedef struct{
	char res[1346];            /* Don't know for now what this is         */
} USERSLST_BBS;

#endif
