/*
 WHO CALLED ProBoard PEX Version and MS-DOS EXE
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of WHO CALLED.

 WHO CALLED is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 WHO CALLED is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with WHO CALLED; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined( __USERSIDX_H )
	#include "usersidx.h"
#endif

#if !defined( PB_SDK ) && !defined( __PBCONFIG_H )
	#include "pbconfig.h"
#endif

#if !defined( __UTILS_H )
	#include "utils.h"
#endif

static FILE *_openUsersIDX( const char *mode );

/*
 * Returns number of users in the USERSIDX.BBS file (same as NumUsersBBS)
*/
	int
NumUsersIDX( void )
{
	FILE *fp;
	long ofs;

	fp = _openUsersIDX( "rb" );
	if( !fp ) return -1;

	fseek( fp, 0L, SEEK_END );
	ofs = ftell(fp);
	fclose(fp);

	return (int)l_div( ofs, (long)sizeof(USERSIDX_BBS) );
}


/*
 * Opens the USERSIDX.BBS file in the desired mode
*/
	FILE*
_openUsersIDX( const char *mode )
{
	char path[MAXPATH];

#if !defined( PB_SDK )
	CONFIG cfg;
	CONFIG *Config = &cfg;
	if( -1 == ReadConfig( &cfg ) ) return NULL;
#endif
	sprintf( path, "%s\\USERSIDX.BBS", Config->msgpath );

	return fopen( path, mode );
}

/*
 * Returns the record number of user
*/
	int
_numRec( const char *name, bool isAlias )
{
	char  *nameBuf;
	USERSIDX_BBS rec;
	dword nameCRC;
	FILE  *fp;
	 int  retval;

	/* calculate the CRC of the name, must be uppercase */
	nameBuf = strdup( name );
	if( !nameBuf ) return -1;

	/* due to a bug in Philippe's implementation, we negate the value */
	nameCRC = ~bufCRC32( strupr(nameBuf), strlen(nameBuf) );
	free( nameBuf );

	fp = _openUsersIDX( "rb" );
	if( !fp ) return -1;

	for( ;; ){
		if( 1 != fread( &rec, sizeof(USERSIDX_BBS), 1, fp ) ){
			retval = -1;
			break;
		}
		if( nameCRC == ((TRUE == isAlias) ? rec.aliasCRC32 : rec.nameCRC32) ){

			/* the user number is the offset of the record into the file */
			/* the way it stands now, we return the record 1-based!      */

			retval = (int)l_div(ftell(fp), (long)sizeof(USERSIDX_BBS));
			break;
		}
	}
	fclose(fp);
	return retval;
}


/*
 * Returns record number by name
*/
	int
NumUserName( const char *name )
{
	return _numRec( name, FALSE );
}

/*
 * Returns record number by alias
*/
	int
NumUserAlias( const char *alias )
{
	return _numRec( alias, TRUE );
}

/*
 * writes a record to the index file
*/
	int
WriteUsersIDX( int num, USERSIDX_BBS *rec )
{
	FILE *fp;
	 int  retval = 0;

	fp = _openUsersIDX( "r+b" );
	if( !fp ) return -1;

	fseek( fp, l_mul( (long)(num - 1), (long)sizeof(USERSIDX_BBS) ), SEEK_SET);
	if( 1 != fwrite(rec, sizeof(USERSIDX_BBS), 1, fp) ) retval = -1;

	fclose(fp);
	return retval;
}
