/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.collection;

import [Ljava.lang.String;;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ckkloverdos.collection.IL;
import org.ckkloverdos.collection.L;
import org.ckkloverdos.filter.IFilter;
import org.ckkloverdos.log.StdLog;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static List toList(Object[] array) {
        return null == array ? new ArrayList() : Arrays.asList(array);
    }

    public static List toList(Enumeration en) {
        ArrayList list = new ArrayList();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        return list;
    }

    public static Object toArray(Collection collection, Class componentType) {
        if (null == collection) {
            return Array.newInstance(componentType, 0);
        }
        Object[] array = (Object[])Array.newInstance(componentType, collection.size());
        int i = 0;
        Iterator cItems = collection.iterator();
        while (cItems.hasNext()) {
            array[i] = cItems.next();
            ++i;
        }
        return array;
    }

    public static String[] toStringArray(Collection collection) {
        return (String[])CollectionUtil.toArray(collection, String.class);
    }

    public static Set union(Set a, Set b) {
        return new L(a).union(new L(b)).toSet();
    }

    public static Set intersect(Set a, Set b) {
        return new L(a).intersect(new L(b)).toSet();
    }

    public static Set minus(Set a, Set b) {
        return new L(a).minus(new L(b)).toSet();
    }

    public static IL filterKeys(Map map, IFilter filter, Object hints) {
        return new L(map.keySet()).filter(filter, hints);
    }

    public static Map filterMap(Map map, IL keys) {
        Map r = CollectionUtil.newLike(map);
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (!map.containsKey(key)) continue;
            r.put(key, map.get(key));
        }
        return r;
    }

    public static Collection newCollectionLike(IL il) {
        if (il.isCollection()) {
            Collection collection = il.toCollection();
            try {
                return (Collection)collection.getClass().newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ArrayList();
    }

    public static List newListLike(IL il) {
        if (il.isList()) {
            List list = il.toList();
            try {
                return (List)list.getClass().newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ArrayList();
    }

    public static Set newSetLike(IL il) {
        if (il.isSet()) {
            Set set = il.toSet();
            try {
                return (Set)set.getClass().newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new HashSet();
    }

    public static Map newLike(Map map) {
        try {
            return (Map)map.getClass().newInstance();
        }
        catch (Exception e) {
            StdLog.error(e);
            return new HashMap();
        }
    }

    public static Map filterMap(Map map, IFilter filter, Object hints) {
        Map filtered = CollectionUtil.newLike(map);
        Iterator iKeys = map.keySet().iterator();
        while (iKeys.hasNext()) {
            Object o = iKeys.next();
            if (!filter.accept(o, hints)) continue;
            filtered.put(o, map.get(o));
        }
        return filtered;
    }

    public static void main(String[] args) {
        L a = new L(new L(new String[]{"one", "two", "ten"}).toSet());
        L b = new L(new L(new String[]{"one", "three"}).toSet());
        L c = new L(new String[]{"nine", "eleven", "twenty"});
        System.out.println("a = " + a);
        System.out.println("b = " + b);
        System.out.println("union        = " + a.union(b));
        System.out.println("sorted union = " + a.union(b).sort().toCollection());
        System.out.println("intersection = " + a.intersect(b));
        System.out.println("difference   = " + a.minus(b));
        System.out.println("a.get(0) = " + a.get(0));
        System.out.println("a.get(2) = " + a.get(2));
        System.out.println("");
        System.out.println(a.toArray());
        System.out.println(a.toArray(String;.class));
        System.out.println(c.toArray(String;.class));
    }
}

