/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.ckkloverdos.resource.IResource;
import org.ckkloverdos.string.IToStringAware;
import org.ckkloverdos.string.ToString;

public class FileResource
implements IResource,
IToStringAware {
    private File file;

    public FileResource(File file) {
        this.file = file;
    }

    public FileResource(String name) {
        this.file = new File(name);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public boolean isFile() {
        return true;
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.file.getName();
    }

    public URL getURL() {
        try {
            return this.file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public String toString() {
        ToString ts = new ToString(this);
        this.toStringAware(ts);
        return ts.toString();
    }

    public void toStringAware(ToString ts) {
        ts.add(this.file);
    }
}

