/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.resource;

import java.io.File;
import org.ckkloverdos.resource.EmptyResource;
import org.ckkloverdos.resource.FileResource;
import org.ckkloverdos.resource.IResource;
import org.ckkloverdos.resource.IResourceContext;
import org.ckkloverdos.resource.ResourseContextSkeleton;
import org.ckkloverdos.string.IToStringAware;
import org.ckkloverdos.string.ToString;

public class FileResourceContext
extends ResourseContextSkeleton
implements IToStringAware {
    private File[] roots;

    public FileResourceContext(File[] roots, IResourceContext parent) {
        super(parent);
        this.roots = roots;
    }

    public FileResourceContext(File[] roots) {
        this(roots, null);
    }

    public FileResourceContext(File root, IResourceContext parent) {
        this(new File[]{root}, parent);
    }

    public FileResourceContext(File root) {
        this(root, null);
    }

    public FileResourceContext(String root) {
        this(new File(root), null);
    }

    public IResource getLocalResource(String name) {
        name = this.normalize(name);
        for (int i = 0; i < this.roots.length; ++i) {
            File file = new File(this.roots[i], name);
            if (!file.exists()) continue;
            return new FileResource(file);
        }
        return EmptyResource.INSTANCE;
    }

    public String toString() {
        ToString ts = new ToString(this);
        this.toStringAware(ts);
        return ts.toString();
    }

    public void toStringAware(ToString ts) {
        ToString ts2 = ts.save();
        ts.add(this.roots).restore(ts2);
    }
}

