/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.resource;

import org.ckkloverdos.log.StdLog;
import org.ckkloverdos.resource.ClassLoaderResourceContext;
import org.ckkloverdos.resource.CompositeResourceContext;
import org.ckkloverdos.resource.EmptyResource;
import org.ckkloverdos.resource.FileResourceContext;
import org.ckkloverdos.resource.IResource;
import org.ckkloverdos.resource.IResourceContext;
import org.ckkloverdos.string.KVToString;
import org.ckkloverdos.util.ClassUtil;
import org.ckkloverdos.util.Util;

public final class RcUtil {
    private RcUtil() {
    }

    public static IResource safe(IResource rc) {
        return null != rc ? rc : EmptyResource.INSTANCE;
    }

    public static String normalize(String name) {
        String suffix = null;
        int dotPos = name.lastIndexOf(46);
        if (dotPos >= 0) {
            suffix = name.substring(dotPos);
            name = name.substring(0, dotPos);
        }
        name = name.replace('.', '/');
        if (dotPos >= 0) {
            name = name + suffix;
        }
        return name;
    }

    public static FileResourceContext getUserDirResourceContext() {
        return new FileResourceContext(Util.getProperty("user.dir"));
    }

    public static String nameUnderPackage(String name, Class c) {
        return RcUtil.nameUnderPackage(name, c.getPackage());
    }

    public static String nameUnderPackage(String name, Package p) {
        return p.getName() + '.' + name;
    }

    public static ClassLoaderResourceContext getThreadClassLoaderContext() {
        return new ClassLoaderResourceContext(ClassUtil.getContextClassLoader());
    }

    private static void resolve(IResourceContext ctx, String name) {
        StdLog.log("<****> " + name);
        IResource rc = ctx.getResource(name);
        StdLog.log("rc = " + rc);
    }

    public static void main(String[] args) {
        String fileName = RcUtil.nameUnderPackage("test.txt", RcUtil.class);
        FileResourceContext fileCtx = new FileResourceContext(".");
        StdLog.log(new KVToString("fileName", fileName));
        ClassLoaderResourceContext cpCtx = RcUtil.getThreadClassLoaderContext();
        CompositeResourceContext ctx = new CompositeResourceContext(fileCtx, (IResourceContext)cpCtx);
        RcUtil.resolve(ctx, "java.lang.String.class");
        RcUtil.resolve(ctx, "classes\\production\\ckkl-Core\\com\\ckkloverdos\\resource\\test.txt");
    }
}

