/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.source;

public class SourceType {
    private String name;
    private boolean textOverride;

    public SourceType(String name) {
        if (null == name) {
            throw new NullPointerException("Null name for SourceType");
        }
        this.name = name;
    }

    public boolean is(SourceType other) {
        return this.equals(other);
    }

    public boolean isContentType(SourceType other) {
        return this.getContentType().equals(other.getContentType());
    }

    public boolean isContentType(String other) {
        return this.getContentType().equals(other);
    }

    public boolean isContentSubtype(SourceType other) {
        return this.getContentSubtype().equals(other.getContentSubtype());
    }

    public boolean isContentSubtype(String other) {
        return this.getContentSubtype().equals(other);
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        int pos = this.name.indexOf(47);
        if (-1 != pos) {
            return this.name.substring(0, pos);
        }
        return this.name;
    }

    public String getContentSubtype() {
        int pos = this.name.indexOf(47);
        if (-1 != pos) {
            return this.name.substring(pos + 1);
        }
        return this.name;
    }

    public boolean isText() {
        return this.textOverride || "text".equals(this.getContentType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceType that = (SourceType)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isTextOverride() {
        return this.textOverride;
    }

    public SourceType setTextOverride() {
        this.textOverride = true;
        return this;
    }
}

