/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.time;

import org.ckkloverdos.time.TimeUtil;

public class SimpleTimeCounter {
    private long start;
    private long stop;

    public SimpleTimeCounter() {
        this.start = System.currentTimeMillis();
        this.stop = -1L;
    }

    public SimpleTimeCounter(boolean start) {
        this.start = start ? System.currentTimeMillis() : -1L;
        this.stop = -1L;
    }

    public void start() {
        this.start = System.currentTimeMillis();
        this.stop = -1L;
    }

    public long stop() {
        this.stop = System.currentTimeMillis();
        return this.stop - this.start;
    }

    public long restart() {
        long time = this.stop();
        this.start();
        return time;
    }

    public long millis() {
        if (-1L == this.start) {
            return 0L;
        }
        long stop = -1L == this.stop ? System.currentTimeMillis() : this.stop;
        return stop - this.start;
    }

    public double seconds() {
        return (double)this.millis() / 1000.0;
    }

    public String secondsInfo() {
        return this.seconds() + " sec.";
    }

    public String millisInfo() {
        return this.millis() + " ms.";
    }

    public String timeInfo() {
        return TimeUtil.timeInfo(this.millis());
    }

    public String toString() {
        return this.timeInfo();
    }

    public String unitsPerSec(int units, String unitsname) {
        return (double)units / this.seconds() + " " + unitsname + "/sec";
    }

    public String unitsPerMillis(int units, String unitsname) {
        return (double)units / (double)this.millis() + " " + unitsname + "/ms";
    }
}

