/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.type.java;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.ckkloverdos.collection.L;
import org.ckkloverdos.filter.IFilter;
import org.ckkloverdos.function.IProcedure;
import org.ckkloverdos.string.IToStringAware;
import org.ckkloverdos.string.ToString;
import org.ckkloverdos.type.java.JavaType;
import org.ckkloverdos.util.Util;

public class JavaTypeRegistry
implements IToStringAware {
    private Map class2type = new HashMap();
    private Map alias2class = new HashMap();
    private Map representatives = new HashMap();

    public void setRepresentative(Class original, Class representative) {
        this.representatives.put(original, representative);
    }

    public void setRepresentative(Class original, JavaType representativeType) {
        this.representatives.put(original, representativeType.getJavaClass());
    }

    public Class getRepresentative(Class what) {
        Class repr = (Class)this.representatives.get(what);
        if (null == repr) {
            repr = what;
        }
        return repr;
    }

    public Map getRepresentatives() {
        return this.representatives;
    }

    public JavaType register(Class c) {
        JavaType type = this.getTypeByClass(c);
        if (null == type) {
            type = this.setTypeByClass(c, new JavaType(c));
        }
        return type;
    }

    public JavaType register(JavaType javaType) {
        Class c = javaType.getJavaClass();
        c = this.getRepresentative(c);
        return this.setTypeByClass(c, javaType);
    }

    public JavaType register(String alias, Class c) {
        c = this.getRepresentative(c);
        this.setClassByAlias(alias, c);
        JavaType type = this.getTypeByClass(c);
        if (null == type) {
            type = new JavaType(c);
        }
        if (!this.class2type.containsKey(c)) {
            this.setTypeByClass(c, type);
        }
        return type;
    }

    public JavaType register(String alias, JavaType type) {
        return this.register(alias, type.getJavaClass());
    }

    public JavaType getByClass(Class c) {
        return this.getTypeByClass(c);
    }

    public JavaType getByName(String name) {
        Class c = this.getClassByAlias(name);
        if (null != c) {
            return this.getTypeByClass(c);
        }
        return null;
    }

    public JavaTypeRegistry copy() {
        JavaTypeRegistry r = new JavaTypeRegistry();
        r.class2type.putAll(this.class2type);
        r.alias2class.putAll(this.alias2class);
        r.representatives.putAll(this.representatives);
        return r;
    }

    public String toString() {
        ToString ts = new ToString(this, true);
        this.toStringAware(ts);
        return ts.toString();
    }

    public void toStringAware(ToString ts) {
        ToString _ts0 = ts.save();
        final ToString _ts = _ts0.setMultiline();
        new L(this.class2type.values()).sort(new Comparator(){

            public int compare(Object o1, Object o2) {
                JavaType a = (JavaType)o1;
                JavaType b = (JavaType)o2;
                return a.getName().compareTo(b.getName());
            }
        }).forEach(new IProcedure(){

            public void process(Object o, Object hints) {
                String typeFullName;
                JavaType type = (JavaType)o;
                String typeName = type.getName();
                if (!typeName.equals(typeFullName = type.getFullName())) {
                    _ts.add(typeName, typeFullName);
                } else {
                    _ts.add(typeName);
                }
                String[] aliases = JavaTypeRegistry.this.getAliases(type.getJavaClass());
                if (0 != aliases.length) {
                    ToString tsa = _ts.save();
                    _ts.setUsingTypeNames(false).setUsingIndices(false).setMultiline(false).setStringQuoted(false);
                    _ts.add(aliases);
                    _ts.restore(tsa);
                }
            }
        });
        ts.restore(_ts0);
    }

    public boolean is(JavaType a, JavaType b) {
        return this.register(a).equals(this.register(b));
    }

    public boolean is(JavaType a, String b) {
        return this.register(a).equals(this.getByName(b));
    }

    public boolean is(Class a, JavaType b) {
        return this.register(a).equals(this.register(b));
    }

    public boolean is(Class a, Class b) {
        return this.register(a).equals(this.register(b));
    }

    public boolean is(Class a, String b) {
        return this.register(a).equals(this.getByName(b));
    }

    private JavaType getTypeByClass(Class c) {
        Class actual = (Class)this.representatives.get(c);
        if (null == actual) {
            actual = c;
        }
        return (JavaType)this.class2type.get(actual);
    }

    private Class getClassByAlias(String name) {
        return (Class)this.alias2class.get(name);
    }

    private void setClassByAlias(String alias, Class c) {
        this.alias2class.put(alias, c);
    }

    private JavaType setTypeByClass(Class c, JavaType type) {
        this.class2type.put(c, type);
        return type;
    }

    private String[] getAliases(Class c) {
        final Class _c = c;
        return new L(this.alias2class.keySet()).filter(new IFilter(){

            public boolean accept(Object object, Object hints) {
                return Util.equalSafe(JavaTypeRegistry.this.alias2class.get(object), _c);
            }
        }).toStringArray();
    }
}

