/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.type.java;

import java.util.Date;
import org.ckkloverdos.type.java.JavaType;
import org.ckkloverdos.type.java.JavaTypeRegistry;

public final class ObjectJavaTypes {
    private static final JavaTypeRegistry r = new JavaTypeRegistry();
    public static final JavaType BOOLEAN = r.register("BOOLEAN", Boolean.class);
    public static final JavaType BYTE = r.register("BYTE", Byte.class);
    public static final JavaType CHAR = r.register("CHAR", Character.class);
    public static final JavaType DOUBLE = r.register("DOUBLE", Double.class);
    public static final JavaType FLOAT = r.register("FLOAT", Float.class);
    public static final JavaType INTEGER = r.register("INTEGER", Integer.class);
    public static final JavaType LONG = r.register("LONG", Long.class);
    public static final JavaType SHORT = r.register("SHORT", Short.class);
    public static final JavaType STRING;
    public static final JavaType DATE;

    private ObjectJavaTypes() {
    }

    public static JavaType register(Class c) {
        return r.register(c);
    }

    public static JavaType register(String aliasName, Class c) {
        return r.register(aliasName, c);
    }

    public static JavaType register(String aliasName, JavaType aliasType) {
        return r.register(aliasName, aliasType);
    }

    public static JavaType getByClass(Class c) {
        return r.getByClass(c);
    }

    public static JavaType getByName(String name) {
        return r.getByName(name);
    }

    public static JavaTypeRegistry getRegistry() {
        return r.copy();
    }

    public static void main(String[] args) {
        System.out.println(ObjectJavaTypes.getRegistry().is(Integer.TYPE, Integer.class));
        System.out.println(ObjectJavaTypes.getRegistry().is(Integer.TYPE, INTEGER));
        System.out.println(ObjectJavaTypes.getRegistry().is(Integer.class, "INTEGER"));
    }

    static {
        r.setRepresentative(Boolean.TYPE, BOOLEAN);
        r.setRepresentative(Byte.TYPE, BYTE);
        r.setRepresentative(Character.TYPE, CHAR);
        r.setRepresentative(Double.TYPE, DOUBLE);
        r.setRepresentative(Float.TYPE, FLOAT);
        r.setRepresentative(Integer.TYPE, INTEGER);
        r.setRepresentative(Long.TYPE, LONG);
        r.setRepresentative(Short.TYPE, SHORT);
        STRING = r.register("STRING", String.class);
        DATE = r.register("DATE", Date.class);
    }
}

