/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.collection;

import java.util.Iterator;

/**
 * Implementation of the {@link Iterator} interface for generic {@link Object}[] arrays.
 * 
 * @author Christos KK Loverdos
 */
public class ArrayIterator implements Iterator
{
    private Object[] a;
    private int index;

    public ArrayIterator(Object[] a)
    {
        this.a = a;
    }
    
    public void remove()
    {
        throw new UnsupportedOperationException(getClass().getName() + ".remove");
    }

    public boolean hasNext()
    {
        return index < a.length;
    }

    public Object next()
    {
        return a[index++];
    }
}
