/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.hint;

import org.ckkloverdos.tuple.Pair;

/**
 * Default implementation for a {@link org.ckkloverdos.hint.IHint} represented
 * by two objects.
 * 
 * @author Christos KK Loverdos
 */
public class BinaryHint extends Pair implements IHint
{
    public BinaryHint(Object hintA, Object hintB)
    {
        super(hintA, hintB);
    }

    public Object getHintA()
    {
        return a;
    }

    public void setHintA(Object hintA)
    {
        this.a = hintA;
    }

    public Object getHintB()
    {
        return b;
    }

    public void setHintB(Object hintB)
    {
        this.b = hintB;
    }

    public boolean isNullA()
    {
        return null == a;
    }

    public boolean isNullB()
    {
        return null == b;
    }

    public static final BinaryHint fromHint(Object hints)
    {
        Object hintA = hints;
        Object hintB = hints;
        if(hints instanceof BinaryHint)
        {
            BinaryHint bhint = (BinaryHint) hints;
            hintA = bhint.getHintA();
            hintB = bhint.getHintB();
        }
        return new BinaryHint(hintA, hintB);
    }
}
