/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;

/**
 * A JavaBeans property reflective accessor, based on the defined class method.
 * @author Christos KK Loverdos
 */
public class MethodReflectiveAccessor implements IReflectiveAccessor
{
    private Method method;

    public MethodReflectiveAccessor(Method m)
    {
        method = m;
    }

    /**
     * Returns the value of the JavaBeans property for the given <code>clientObject</code>, by calling
     * the underlying method.
     * @param clientObject
     */
    public Object get(Object clientObject)
    {
        try
        {
            return method.invoke(clientObject, null);
        }
        catch(IllegalAccessException e)
        {
            throw new RuntimeException(e);
        }
        catch(InvocationTargetException e)
        {
            throw new RuntimeException(e);
        }
    }

    public String toString()
    {
        return "MethodReflectiveAccessor(" + method.getName() + ")";
    }

    public boolean equals(Object o)
    {
        if(this == o)
        {
            return true;
        }
        if(o == null || getClass() != o.getClass())
        {
            return false;
        }

        MethodReflectiveAccessor that = (MethodReflectiveAccessor) o;

        if(!method.equals(that.method))
        {
            return false;
        }

        return true;
    }

    public int hashCode()
    {
        return method.hashCode();
    }
}
