/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.resource;

/**
 * A partial {@link org.ckkloverdos.resource.IResourceContext} implementation.
 * @author Christos KK Loverdos
 */
public abstract class ResourseContextSkeleton implements IResourceContext
{
    private IResourceContext parent;

    /**
     * Constructs a new resource context with the given parent.
     * @param parent
     */
    protected ResourseContextSkeleton(IResourceContext parent)
    {
        this.parent = parent;
    }

    /**
     * Returns the resource with the given name. First, the resource is
     * resolved locally, and if this doesnot succeed, the parent context
     * is consulted.
     * @param name
     * @return the resource if found or {@link org.ckkloverdos.resource.EmptyResource#INSTANCE} otherwise.
     */
    public IResource getResource(String name)
    {
        IResource rc = RcUtil.safe(getLocalResource(name));
        if(!rc.exists() && null != parent)
        {
            return RcUtil.safe(parent.getResource(name));
        }
        return rc;
    }

    /**
     * Returns the parent context.
     */
    public IResourceContext getParent()
    {
        return parent;
    }

    /**
     * Utility method to be overriden by subclasses that normalizes a resource name
     * before the actual resource lookup is performed.
     * @param name
     */
    protected String normalize(String name)
    {
        return RcUtil.normalize(name);
    }
}
