UNIT Hunter;
INTERFACE
	USES Crt;
	FUNCTION IAllCase(TextStr: String): String;
	FUNCTION ICase(TextStr: String): String;
	PROCEDURE PressKey;
	FUNCTION LCase(TextStr: String): String;
	FUNCTION UCase(TextStr: String): String;
	FUNCTION ECase(TextStr: String; CaseType: Integer): String;
	PROCEDURE Cls;
IMPLEMENTATION
	FUNCTION IAllCase(TextStr: String): String;
	VAR X: Integer;
	BEGIN
		TextStr[1] := UpCase(TextStr[1]);
		FOR X := 2 TO Length(TextStr) DO
			IF TextStr[X - 1] = ' ' THEN
				TextStr[X] := UpCase(TextStr[X])
			ELSE
				TextStr[X] := TextStr[X];
		IAllCase := TextStr;
	END;

	FUNCTION ICase(TextStr: String): String;
	VAR X: Integer;
	BEGIN
		TextStr[1] := UpCase(TextStr[1]);
		FOR X := 2 TO Length(TextStr) DO
			IF TextStr[X - 2] = '.' THEN BEGIN
				WHILE TextStr[X] = ' ' DO BEGIN
					TextStr[X] := TextStr[X];
					X := X + 1;
				END;
				TextStr[X] := UpCase(TextStr[X])
			END ELSE
				TextStr[X] := TextStr[X];
		ICase := TextStr;
	END;

	PROCEDURE PressKey;
	VAR Ch: Char;
	BEGIN
		WriteLn;
		TextColor(8); Write('[ ');
		TextColor(9); Write('press any key');
		TextColor(8); Write(' ]');
		Ch := ReadKey;
	END;

	FUNCTION LCase(TextStr: String): String;
	VAR X: Integer;
	BEGIN
		FOR X := 1 TO Length(TextStr) DO
			IF (Ord(TextStr[X]) >= 65) AND (Ord(TextStr[X]) <= 90) THEN
				TextStr[X] := Chr(Ord(TextStr[X]) + 32)
			ELSE
				TextStr[X] := TextStr[X];
	LCase := TextStr;
	END;

	FUNCTION UCase(TextStr: String): String;
	VAR X: Integer;
	BEGIN
		FOR X := 1 TO Length(TextStr) DO
			TextStr[X] := UpCase(TextStr[X]);
		UCase := TextStr;
	END;

	FUNCTION ECase(TextStr: String; CaseType: Integer): String;
	VAR X: Integer;
	BEGIN
		IF CaseType = 1 THEN
			FOR X := 1 TO Length(TextStr) DO
				IF X MOD 2 <> 0 THEN
					TextStr[X] := UpCase(TextStr[X])
				ELSE
					TextStr[X] := TextStr[X]
		ELSE IF CaseType = 2 THEN
			FOR X := 1 TO Length(TextStr) DO BEGIN
				TextStr[X] := UpCase(TextStr[X]);
				CASE TextStr[X] OF
					'A', 'E', 'I', 'O', 'U', 'Y':
						TextStr[X] := Chr(Ord(TextStr[X]) + 32);
					ELSE
						TextStr[X] := UpCase(TextStr[X]);
				END;
			END
		ELSE
			FOR X := 1 TO Length(TextStr) DO BEGIN
				TextStr[X] := UpCase(TextStr[X]);
				CASE TextStr[X] OF
					'E':
						TextStr[X] := '3';
					'T':
						TextStr[X] := '7';
					'A':
						TextStr[X] := '4';
					'O':
						TextStr[X] := '0';
					'L':
						TextStr[X] := '1'
					ELSE
						TextStr[X] := TextStr[X];
					END;
				END;
		ECase := TextStr;
	END;
	PROCEDURE Cls;
	BEGIN
		Inline($B8/$03/$00/$CD/$10);
	END;

END.
